# L3C

L3C provides variant environments facilitating In-Context Learning, featured in the following assets:
- Vast amounts of diversified tasks with minimal inductive bias
- Lifelong In-Context Learning
- Generative and Interactive

# Environments Updating

- [AnyMDP](l3c/anymdp): Procedurally generated unlimited general-purpose Markov Decision Processes (MDP)

- [MetaLanguage](l3c/metalang): Pseudo-language generated from randomized neural networks

- [MazeWorld](l3c/mazeworld): Procedurally generated mazes with diverse maze structures, navigation goals to benchmark object navigation

- [L3C_Baselines](https://github.com/FutureAGI/L3C_Baselines): An implementation of the baseline solutions to the above tasks

# Installation

```bash
pip install l3c
```

# Reference
Cite this work with

```bibtex
@article{wang2024benchmarking,
  title={Benchmarking General Purpose In-Context Learning},
  author={Wang, Fan and Lin, Chuan and Cao, Yang and Kang, Yu},
  journal={arXiv preprint arXiv:2405.17234},
  year={2024}
}
```
