"""The module `llogic` contains functions that deal with logic operations on
lists. All functions have a `__doc__` attribute with usage instructions.

Recommended import procedure is:

from listools import llogic

This library is published under the MIT License.
"""

from .difference import difference
from .intersection import intersection
from .is_ascending import is_ascending
from .is_contained import is_contained
from .is_descending import is_descending
from .mixed_type import mixed_type
from .single_type import single_type
from .symmetric_difference import symmetric_difference
from .union import union
