# micromagneticmodel
Marijan Beg<sup>1,2</sup> and Hans Fangohr<sup>1,2</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*  
<sup>2</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  

| Description | Badge |
| --- | --- |
| Releases | [![PyPI version](https://badge.fury.io/py/micromagneticmodel.svg)](https://badge.fury.io/py/micromagneticmodel) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/micromagneticmodel/badges/version.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| Builds | [![Build Status](https://travis-ci.org/ubermag/micromagneticmodel.svg?branch=master)](https://travis-ci.org/ubermag/micromagneticmodel) |
|       | [![Build status](https://ci.appveyor.com/api/projects/status/qhi1comhtaja0073?svg=true)](https://ci.appveyor.com/project/marijanbeg/micromagneticmodel) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/micromagneticmodel/branch/master/graph/badge.svg)](https://codecov.io/gh/ubermag/micromagneticmodel) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/micromagneticmodel/badge/?version=latest)](https://micromagneticmodel.readthedocs.io/en/latest/?badge=latest) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/micromagneticmodel/master?urlpath=lab/tree/docs/ipynb/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/micromagneticmodel/badges/platforms.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/micromagneticmodel/badges/downloads.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3539480.svg)](https://doi.org/10.5281/zenodo.3539480) |

## About

`micromagneticmodel` is a Python package that provides:

- Domain-specific language for defining micromagnetic models.

It is available on Windows, MacOS, and Linux. It requires Python 3.6+.

## Documentation

APIs and tutorials are available in documentation. To access them, use the documentation badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the Binder badge in the table above.

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

If you use this package, please cite it as:

1. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025 (2017)](http://aip.scitation.org/doi/10.1063/1.4977225).

2. M. Beg, T. Kluyver, and H. Fangohr. ubermag/micromagneticmodel: Python domain-specific language for defining micromagnetic models. Zenodo. DOI: [10.5281/zenodo.3539480](http://doi.org/10.5281/zenodo.3539480) (2020).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1).
