# Generated by Django 3.2.5 on 2021-07-29 17:27

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import medux.core.fields
import medux.core.models.common
import medux.core.models.fhir
import medux.core.models.geo
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('street', models.CharField(blank=True, max_length=255)),
                ('aux_street', models.CharField(blank=True, help_text='hints like postal box directions in CA, or c/o, etc.', max_length=255)),
                ('number', models.CharField(blank=True, help_text='Street number, evtl. with additions like stair number, etc.', max_length=50)),
                ('subunit', models.CharField(blank=True, max_length=255)),
                ('postcode', models.CharField(blank=True, max_length=10)),
                ('city', models.CharField(blank=True, max_length=255)),
                ('addendum', models.CharField(blank=True, help_text='Any additional information that did not fit anywhere else', max_length=255)),
                ('location', models.CharField(blank=True, help_text='The exact location of this address in latitude-longtitude', max_length=255)),
                ('period', medux.core.fields.PeriodField(default=medux.core.models.fhir.ongoing_period)),
                ('weight', models.PositiveIntegerField(default=1)),
            ],
            options={
                'verbose_name_plural': 'Addresses',
                'ordering': ['weight'],
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='AddressMapper',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address_id', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.address')),
            ],
        ),
        migrations.CreateModel(
            name='AddressType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='AdministrativeGender',
            fields=[
                ('tag', models.CharField(max_length=2, primary_key=True, serialize=False)),
                ('label', models.CharField(max_length=50)),
                ('sort_weight', models.IntegerField(default=0)),
                ('comment', models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='ContactPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('system', models.CharField(choices=[('phone', 'Telefon'), ('fax', 'Fax'), ('email', 'E-Mail-Adresse'), ('pager', 'Pager'), ('url', 'URL'), ('sms', 'SMS'), ('other', 'Andere')], max_length=20)),
                ('value', models.CharField(blank=True, max_length=255)),
                ('use', models.CharField(blank=True, choices=[('home', 'Wohnsitz'), ('work', 'Arbeit'), ('temp', 'Termporär'), ('old', 'Veraltet'), ('mobile', 'Mobil')], max_length=20)),
                ('weight', models.PositiveIntegerField(blank=True, default=1)),
                ('period', medux.core.fields.PeriodField(default=medux.core.models.fhir.ongoing_period)),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(help_text='ISO 3166-1 code', max_length=2, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='Official English short name', max_length=255)),
                ('flag', models.CharField(blank=True, max_length=5)),
            ],
            options={
                'verbose_name_plural': 'Countries',
            },
            bases=(medux.core.models.geo.UpperCodeMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Encounter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('date', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='EpisodeOfCare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='EpisodeStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(max_length=50)),
                ('display', models.CharField(max_length=50)),
                ('definition', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name_plural': 'Episode Statuses',
            },
        ),
        migrations.CreateModel(
            name='Firstname',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('name', models.CharField(max_length=50)),
                ('sex', models.CharField(choices=[('M', 'Male'), ('1M', 'male if first part of name, otherwise mostly female'), ('?M', 'mostly male'), ('F', 'Female'), ('1F', 'female if first part of name, otherwise mostly male'), ('?F', 'mostly female'), ('?', 'unisex')], max_length=2)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Ingredient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(help_text='ISO 639-1 language code', max_length=2, primary_key=True, serialize=False)),
                ('name', models.CharField(help_text='ISO 639-1 English language name', max_length=50)),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.geo.UpperCodeMixin, models.Model),
        ),
        migrations.CreateModel(
            name='MedicationForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='MedicationRoute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(max_length=50)),
                ('display', models.CharField(max_length=50)),
                ('definition', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name_plural': 'Medication Statuses',
            },
        ),
        migrations.CreateModel(
            name='MedicationTerminologySystem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Name',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lastname', models.CharField(max_length=255)),
                ('firstname', models.CharField(max_length=255)),
                ('preferred', models.CharField(blank=True, help_text='preferred first name, the name a person is usually called (nickname)', max_length=255, null=True)),
                ('comment', models.CharField(blank=True, help_text="a comment regarding this name, useful in things like 'name before marriage' etc.", max_length=255, null=True)),
                ('weight', models.PositiveIntegerField(default=1)),
            ],
            options={
                'ordering': ['weight'],
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='NarrativeType',
            fields=[
                ('shortcut', models.CharField(max_length=2, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('active', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=255)),
                ('alias', medux.core.fields.StringListField(blank=True)),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.address')),
                ('telecom', models.ManyToManyField(blank=True, to='core.ContactPoint')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrganizationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(max_length=50)),
                ('display', models.CharField(max_length=50)),
                ('definition', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('title', models.CharField(blank=True, help_text='Academic title', max_length=50, null=True)),
                ('birth_date', models.DateTimeField(verbose_name='Date/time of birth')),
                ('birth_date_is_estimated', models.BooleanField(default=False)),
                ('deceased', models.DateTimeField(blank=True, null=True, verbose_name='Date/Time of death')),
                ('deceased_is_estimated', models.BooleanField(default=False)),
                ('photo', models.ImageField(blank=True, upload_to='')),
                ('active', models.BooleanField(default=True, help_text="Whether this person's record is in active use.")),
                ('addresses', models.ManyToManyField(through='core.AddressMapper', to='core.Address')),
                ('country_of_birth', models.ForeignKey(help_text='ISO code of Country of Birth', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.country')),
                ('gender', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='core.administrativegender')),
                ('names', models.ManyToManyField(to='core.Name')),
                ('telecom', models.ManyToManyField(help_text='A contact detail for the person, e.g. a telephone number or an email address', to='core.ContactPoint')),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Problem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='RelationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Specialty',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ZipCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', models.CharField(max_length=10)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('organization_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.organization')),
            ],
            options={
                'verbose_name_plural': 'Companies',
            },
            bases=('core.organization',),
        ),
        migrations.CreateModel(
            name='HealthServiceProvider',
            fields=[
                ('organization_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.organization')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.organization',),
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, parent_link=True, primary_key=True, related_name='+', serialize=False, to='core.person')),
                ('marital_status', models.CharField(blank=True, choices=[('A', 'Annulled'), ('D', 'Divorced'), ('I', 'Interlocutory'), ('L', 'Legally Separated'), ('M', 'Married'), ('P', 'Polygamous'), ('S', 'Never Married'), ('T', 'Domestic partner'), ('U', 'Unmarried'), ('W', 'Widowed'), ('UNK', 'Unknown')], max_length=3, null=True)),
                ('emergency_contact_freetext', models.CharField(blank=True, max_length=255, null=True)),
                ('comment', models.CharField(blank=True, help_text='Generic comment for this patient', max_length=255, null=True)),
                ('emergency_contact', models.ManyToManyField(blank=True, help_text='Persons who should be contacted in case of an emergency', related_name='_core_patient_emergency_contact_+', to='core.Person')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.person',),
        ),
        migrations.CreateModel(
            name='Narrative',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('narrative', models.TextField()),
                ('encounter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.encounter')),
                ('problem', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.problem')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.narrativetype')),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('code', medux.core.fields.CodeField(choices=[], help_text='The medication code within this coding system', multi=False, terminology_binding='MedicationTerminologySystem')),
                ('amount_value', models.DecimalField(decimal_places=3, help_text='Amount of drug in package', max_digits=10)),
                ('amount_unit', models.CharField(help_text='Unit representation', max_length=25)),
                ('amount_unit_code', medux.core.fields.CodeField(choices=[], multi=False, terminology_binding=None)),
                ('batch_lot_number', models.CharField(blank=True, help_text='Identifier assigned to batch', max_length=255)),
                ('batch_expiration_date', models.DateField(blank=True, help_text='When batch will expire')),
                ('code_system', models.ForeignKey(help_text='The defining coding system', on_delete=django.db.models.deletion.PROTECT, to='core.medicationterminologysystem')),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.medicationform')),
                ('ingredients', models.ManyToManyField(to='core.Ingredient')),
                ('status', models.ForeignKey(default=0, on_delete=django.db.models.deletion.PROTECT, to='core.medicationstatus')),
                ('manufacturer', models.ForeignKey(help_text='Manufacturer of the medication product. Not the distributor.', on_delete=django.db.models.deletion.PROTECT, to='core.healthserviceprovider')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EpisodeStatusHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('period', medux.core.fields.PeriodField(default=medux.core.models.fhir.ongoing_period)),
                ('episode', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.episodeofcare')),
                ('status', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.episodestatus')),
            ],
            options={
                'verbose_name_plural': 'Episode Status Histories',
            },
        ),
        migrations.AddField(
            model_name='episodeofcare',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.episodestatus'),
        ),
        migrations.AddField(
            model_name='episodeofcare',
            name='status_history',
            field=models.ManyToManyField(through='core.EpisodeStatusHistory', to='core.EpisodeStatus'),
        ),
        migrations.CreateModel(
            name='Dosage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(help_text="Free text dosage instructions e.g. '1x/day'", max_length=255)),
                ('additionalInstruction', models.CharField(help_text="Supplemental instruction or warnings to the patient - e.g. 'with meals', 'may cause drowsiness'", max_length=255)),
                ('patientInstructions', models.CharField(help_text='Instructions in terms that are understood by the patient', max_length=255)),
                ('route', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.medicationroute')),
            ],
        ),
        migrations.CreateModel(
            name='DataPack',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('name', models.CharField(help_text='Name for this data pack (computer friendly)', max_length=100)),
                ('title', models.CharField(help_text='Name for this data pack (human friendly)', max_length=255)),
                ('description', medux.core.fields.MarkdownField(help_text='Natural description, in MarkDown', max_length=255)),
                ('license', models.CharField(max_length=20)),
                ('version', models.CharField(max_length=25)),
                ('experimental', models.BooleanField(default=False)),
                ('publisher', models.CharField(blank=True, max_length=255)),
                ('model', models.CharField(max_length=255)),
                ('downloaded', models.BooleanField(default=False)),
                ('installed', models.BooleanField(default=False)),
                ('data_file', models.FileField(upload_to='datapacks')),
                ('language', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.language')),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.AddField(
            model_name='country',
            name='default_language',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='core.language'),
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('name', models.CharField(max_length=100)),
                ('zipcodes', models.ManyToManyField(to='core.ZipCode')),
            ],
            options={
                'verbose_name_plural': 'Cities',
            },
        ),
        migrations.AddField(
            model_name='addressmapper',
            name='address_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.addresstype'),
        ),
        migrations.AddField(
            model_name='addressmapper',
            name='person_id',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.person'),
        ),
        migrations.AddField(
            model_name='address',
            name='state',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='core.country'),
        ),
        migrations.CreateModel(
            name='Hospital',
            fields=[
                ('healthserviceprovider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.healthserviceprovider')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.healthserviceprovider',),
        ),
        migrations.CreateModel(
            name='InsuranceCompany',
            fields=[
                ('company_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.company')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.company',),
        ),
        migrations.CreateModel(
            name='Relationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('relation_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.relationtype')),
                ('from_patient_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.patient')),
                ('to_patient_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.patient')),
            ],
        ),
        migrations.AddField(
            model_name='patient',
            name='related_persons',
            field=models.ManyToManyField(related_name='_core_patient_related_persons_+', through='core.Relationship', to='core.Patient'),
        ),
        migrations.CreateModel(
            name='MedicationStatement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted_at', models.DateTimeField(blank=True, default=None, editable=False, null=True)),
                ('row_version', models.PositiveIntegerField(default=0, editable=False)),
                ('note', models.TextField()),
                ('encounter', models.ForeignKey(help_text='Encounter associated with MedicationStatement', on_delete=django.db.models.deletion.PROTECT, to='core.encounter')),
                ('episode', models.ForeignKey(help_text='EpisodeOfCare associated with MedicationStatement', on_delete=django.db.models.deletion.PROTECT, to='core.episodeofcare')),
                ('medication', models.ManyToManyField(to='core.Medication')),
                ('status', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.medicationstatus')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.patient')),
            ],
            options={
                'abstract': False,
            },
            bases=(medux.core.models.common.CreatedModifiedMixin, models.Model),
        ),
        migrations.AddField(
            model_name='encounter',
            name='provider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.healthserviceprovider'),
        ),
        migrations.AlterUniqueTogether(
            name='address',
            unique_together={('street', 'number', 'postcode', 'city', 'state')},
        ),
        migrations.CreateModel(
            name='Physician',
            fields=[
                ('healthserviceprovider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.healthserviceprovider')),
                ('personal_salutation', models.CharField(blank=True, help_text="if you know this physician personally, you can choose to customize his salutation, like 'Dear Thomas,'", max_length=100)),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.person')),
                ('speciality', models.ForeignKey(help_text='Medical field', on_delete=django.db.models.deletion.PROTECT, related_name='physicians', to='core.specialty')),
            ],
            options={
                'abstract': False,
            },
            bases=('core.healthserviceprovider',),
        ),
        migrations.AddField(
            model_name='patient',
            name='general_practitioner',
            field=models.ForeignKey(blank=True, help_text="The patient's general practitioner", null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.physician'),
        ),
        migrations.AddField(
            model_name='patient',
            name='physicians',
            field=models.ManyToManyField(blank=True, help_text='Physicians the patient consults regularly', related_name='_core_patient_physicians_+', to='core.Physician'),
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('maintainer', models.SmallIntegerField(choices=[(1, 'User'), (10, 'Admin'), (99, 'Vendor')], default=99)),
                ('name', models.CharField(max_length=255)),
                ('telecom', models.ManyToManyField(to='core.ContactPoint')),
                ('hospital', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='departments', to='core.hospital')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
