function(target_link_libraries_system target)
  set(libs ${ARGN})
  foreach(lib ${libs})
    get_target_property(lib_include_dirs ${lib} INTERFACE_INCLUDE_DIRECTORIES)
    target_include_directories(${target} SYSTEM PRIVATE ${lib_include_dirs})
    target_link_libraries(${target} ${lib})
  endforeach(lib)
endfunction(target_link_libraries_system)

# This is not used anymore, using FetchContent now....
macro(add_subdirectory_if_not_exists LIBRARY SUB_DIR)
  if(NOT TARGET ${LIBRARY})
      message("-- INFO - Trying to add ${LIBRARY} from thirdparty submodule")
      add_subdirectory("${CMAKE_CURRENT_SOURCE_DIR}/${SUB_DIR}")
  else()
      message("-- INFO - Skipping add_subdirectory(${LIBRARY}) because it has already been added")
  endif()
endmacro(add_subdirectory_if_not_exists)
