# Generated by Django 2.2.16 on 2020-11-12 09:59

from django.db import migrations, models


def make_pulp2repos_m2m(apps, schema_editor):
    """
    Add many2many relation between pulp2repo and pulp2dist.
    """
    Pulp2Distributor = apps.get_model('pulp_2to3_migration', 'Pulp2Distributor')
    pulp2_dists_qs = Pulp2Distributor.objects.all()

    for dist in pulp2_dists_qs.iterator():
        if dist.pulp2_repository:
            dist.pulp2_repos.add(dist.pulp2_repository)


class Migration(migrations.Migration):

    dependencies = [
        ('pulp_2to3_migration', '0017_pulp2debpackage'),
    ]

    operations = [
        migrations.AddField(
            model_name='pulp2distributor',
            name='pulp2_repos',
            field=models.ManyToManyField(related_name='pulp2_dists', to='pulp_2to3_migration.Pulp2Repository'),
        ),
        migrations.RunPython(make_pulp2repos_m2m),
    ]
