# Generated by Django 2.2.10 on 2020-03-24 15:49

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('pulp_2to3_migration', '0005_pulp2distribution'),
    ]

    operations = [
        migrations.CreateModel(
            name='Pulp2PackageLangpacks',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('matches', django.contrib.postgres.fields.jsonb.JSONField()),
                ('repo_id', models.TextField()),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='package_langpacks_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'package_langpacks_detail_model',
                'unique_together': {('repo_id', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2PackageGroup',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('package_group_id', models.TextField()),
                ('repo_id', models.TextField()),
                ('default', models.BooleanField()),
                ('user_visible', models.BooleanField()),
                ('display_order', models.IntegerField(null=True)),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('packages', django.contrib.postgres.fields.jsonb.JSONField()),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('biarch_only', models.BooleanField(default=False)),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='package_group_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'package_group_detail_model',
                'unique_together': {('repo_id', 'package_group_id', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2PackageEnvironment',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('package_environment_id', models.TextField()),
                ('repo_id', models.TextField()),
                ('display_order', models.IntegerField(null=True)),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('group_ids', django.contrib.postgres.fields.jsonb.JSONField()),
                ('option_ids', django.contrib.postgres.fields.jsonb.JSONField()),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='package_environment_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'package_environment_detail_model',
                'unique_together': {('repo_id', 'package_environment_id', 'pulp2content')},
            },
        ),
        migrations.CreateModel(
            name='Pulp2PackageCategory',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('package_category_id', models.TextField()),
                ('repo_id', models.TextField()),
                ('display_order', models.IntegerField(null=True)),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('packagegroupids', django.contrib.postgres.fields.jsonb.JSONField()),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(verbose_name=dict)),
                ('pulp2content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='package_category_detail_model', to='pulp_2to3_migration.Pulp2Content')),
            ],
            options={
                'default_related_name': 'package_category_detail_model',
                'unique_together': {('repo_id', 'package_category_id', 'pulp2content')},
            },
        ),
    ]
