/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.Alignment;
import java.util.Arrays;
import java.util.TreeSet;

public class RYcodingAlignment
extends Alignment {
    private final char[] character = new char[]{'R', 'Y', 'N', 'X', '?', '-'};
    private final int R = 0;
    private final int Y = 1;
    private double[] freq;
    private double total;
    private TreeSet<Character> alphabet = new TreeSet();
    private int i = -1;
    private StringBuffer sb;

    public RYcodingAlignment() {
        while (++this.i < this.character.length) {
            this.alphabet.add(new Character(this.character[this.i]));
        }
    }

    private String Filter(String string) {
        this.sb = new StringBuffer(string);
        this.i = -1;
        while (++this.i < this.sb.length()) {
            if (this.alphabet.contains(new Character(this.sb.charAt(this.i)))) continue;
            this.sb.setCharAt(this.i, new Character('X').charValue());
        }
        return this.sb.toString();
    }

    @Override
    public boolean add(String string) {
        return super.add(this.Filter(string));
    }

    @Override
    public boolean add(String string, String string2) {
        return super.add(this.Filter(string), string2);
    }

    @Override
    public boolean add(int n, String string) {
        return super.add(n, this.Filter(string));
    }

    @Override
    public boolean add(int n, String string, String string2) {
        return super.add(n, this.Filter(string), string2);
    }

    @Override
    public boolean set(int n, String string) {
        return super.set(n, this.Filter(string));
    }

    @Override
    public boolean set(int n, String string, String string2) {
        return super.set(n, this.Filter(string), string2);
    }

    @Override
    public boolean setCharAt(int n, int n2, char c) {
        if (!this.alphabet.contains(new Character(c))) {
            return false;
        }
        return super.setCharAt(n, n2, c);
    }

    @Override
    public int getAlphabetSize() {
        return 2;
    }

    @Override
    public double[] getFrequencies(int n) {
        this.freq = new double[this.getAlphabetSize()];
        Arrays.fill(this.freq, 0.0);
        this.total = 0.0;
        this.i = -1;
        block5: while (++this.i < super.size()) {
            this.total += 1.0;
            switch (super.getSequence(this.i).charAt(n)) {
                case 'R': {
                    this.freq[0] = this.freq[0] + 1.0;
                    continue block5;
                }
                case 'Y': {
                    this.freq[1] = this.freq[1] + 1.0;
                    continue block5;
                }
                case '?': 
                case 'N': 
                case 'X': {
                    this.freq[0] = this.freq[0] + 0.5;
                    this.freq[1] = this.freq[1] + 0.5;
                    continue block5;
                }
            }
            this.total -= 1.0;
        }
        this.freq[0] = this.freq[0] / this.total;
        this.freq[1] = this.freq[1] / this.total;
        return this.freq;
    }
}

