/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;
import simplenlg.test.SimplenlgTest;

public class VPTest
extends SimplenlgTest {
    public VPTest(String name) {
        super(name);
    }

    @Test
    public void testVerbParticle() {
        Verb v = new Verb("fall down");
        Assert.assertEquals((String)"down", (String)v.getParticle());
        Assert.assertEquals((String)"fall down", (String)v.getBaseForm());
        Assert.assertEquals((String)"fell down", (String)v.getPast(Person.THIRD, NumberAgr.PLURAL));
        Assert.assertEquals((String)"fallen down", (String)v.getPastParticiple());
    }

    @Test
    public void testSimplePast() {
        this.fallDown.setTense(Tense.PAST);
        Assert.assertEquals((String)"fell down", (String)this.realiser.realise(this.fallDown));
    }

    @Test
    public void testTenseAspect() {
        this.fallDown.setTense(Tense.PAST);
        this.fallDown.setPerfect(true);
        Assert.assertEquals((String)"had fallen down", (String)this.realiser.realise(this.fallDown));
        this.fallDown.setProgressive(true);
        Assert.assertEquals((String)"had been falling down", (String)this.realiser.realise(this.fallDown));
        this.kick.setPassive(true);
        this.kick.setPerfect(true);
        this.kick.setTense(Tense.FUTURE);
        Assert.assertEquals((String)"will have been kicked", (String)this.realiser.realise(this.kick));
        this.kick.setProgressive(true);
        Assert.assertEquals((String)"will have been being kicked", (String)this.realiser.realise(this.kick));
        this.kick.setNegated(true);
        Assert.assertEquals((String)"will not have been being kicked", (String)this.realiser.realise(this.kick));
        this.kick.setComplement(this.man);
        Assert.assertEquals((String)"will not have been being kicked", (String)this.realiser.realise(this.kick));
        this.kick.setPassive(false);
        Assert.assertEquals((String)"will not have been kicking the man", (String)this.realiser.realise(this.kick));
        this.kick.setTense(Tense.PRESENT);
        Assert.assertEquals((String)"has not been kicking the man", (String)this.realiser.realise(this.kick));
    }

    @Test
    public void testComplementation() {
        NPPhraseSpec mary = new NPPhraseSpec("Mary");
        mary.setDiscourseFunction(DiscourseFunction.OBJECT);
        this.kiss.setComplement(mary);
        this.kiss.setProgressive(true);
        this.kiss.setTense(Tense.PAST);
        Assert.assertEquals((String)"was kissing Mary", (String)this.realiser.realise(this.kiss));
        mary = mary.coordinate(new Phrase[]{new NPPhraseSpec("Susan")});
        this.kiss.setComplement(mary);
        Assert.assertEquals((String)"was kissing Mary and Susan", (String)this.realiser.realise(this.kiss));
        this.kiss.setPassive(true);
        Assert.assertEquals((String)"was being kissed", (String)this.realiser.realise(this.kiss));
        this.kiss.setNumber(NumberAgr.PLURAL);
        Assert.assertEquals((String)"were being kissed", (String)this.realiser.realise(this.kiss));
        this.kiss.addPostmodifier(this.inTheRoom);
        this.kiss.setPassive(false);
        this.kiss.setNumber(NumberAgr.SINGULAR);
        Assert.assertEquals((String)"was kissing Mary and Susan in the room", (String)this.realiser.realise(this.kiss));
        this.kiss.setPassive(true);
        this.kiss.setNumber(NumberAgr.PLURAL);
        Assert.assertEquals((String)"were being kissed in the room", (String)this.realiser.realise(this.kiss));
    }

    @Test
    public void testComplementation2() {
        this.woman.setDiscourseFunction(DiscourseFunction.INDIRECT_OBJECT);
        this.dog.setDiscourseFunction(DiscourseFunction.OBJECT);
        this.give.addComplement(this.dog, DiscourseFunction.OBJECT);
        this.give.addComplement(this.woman, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"gives the woman the dog", (String)this.realiser.realise(this.give));
        this.give.addPremodifier("slowly");
        this.give.addPostmodifier(this.behindTheCurtain);
        this.give.addPostmodifier(this.inTheRoom);
        Assert.assertEquals((String)"slowly gives the woman the dog behind the curtain in the room", (String)this.realiser.realise(this.give));
        this.give.setComplement(this.dog, DiscourseFunction.OBJECT);
        this.give.setComplement(this.woman.coordinate(new Phrase[]{this.boy}), DiscourseFunction.INDIRECT_OBJECT);
        this.give.setPassive(false);
        Assert.assertEquals((String)"slowly gives the woman and the boy the dog behind the curtain in the room", (String)this.realiser.realise(this.give));
        this.give.setComplement(this.woman.coordinate(new Phrase[]{this.boy}), DiscourseFunction.INDIRECT_OBJECT);
        List<Phrase> indirects = this.give.getComplements(DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((int)1, (int)indirects.size());
        Assert.assertEquals((String)"slowly gives the woman and the boy the dog behind the curtain in the room", (String)this.realiser.realise(this.give));
    }

    @Test
    public void testPassiveComplement() {
        this.give.addComplement(this.dog, DiscourseFunction.OBJECT);
        this.give.addComplement(this.woman, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"gives the woman the dog", (String)this.realiser.realise(this.give));
        this.give.addPremodifier("slowly");
        this.give.addPostmodifier(this.behindTheCurtain);
        this.give.addPostmodifier(this.inTheRoom);
        Assert.assertEquals((String)"slowly gives the woman the dog behind the curtain in the room", (String)this.realiser.realise(this.give));
        this.give.setPassive(true);
        Assert.assertEquals((String)"is slowly given the woman behind the curtain in the room", (String)this.realiser.realise(this.give));
    }

    @Test
    public void testSententialComp() {
        SPhraseSpec s = new SPhraseSpec();
        s.setSubject(new NPPhraseSpec("John"));
        NPPhraseSpec maryAndSusan = new NPPhraseSpec("Mary").coordinate(new Phrase[]{new NPPhraseSpec("Susan")});
        this.kiss.setComplement(maryAndSusan);
        s.setVerbPhrase(this.kiss);
        s.setProgressive(true);
        s.setTense(Tense.PAST);
        s.addPostmodifier(this.inTheRoom);
        Assert.assertEquals((String)"John was kissing Mary and Susan in the room.", (String)this.realiser.realise(s));
        this.say.setTense(Tense.PAST);
        Assert.assertEquals((String)"said", (String)this.realiser.realise(this.say));
        this.say.addComplement(s);
        Assert.assertEquals((String)"said that John was kissing Mary and Susan in the room", (String)this.realiser.realise(this.say));
        this.say.addPostmodifier(this.behindTheCurtain);
        Assert.assertEquals((String)"said that John was kissing Mary and Susan in the room behind the curtain", (String)this.realiser.realise(this.say));
        SPhraseSpec s2 = new SPhraseSpec(new NPPhraseSpec("all"), new Verb("be"), new AdjPhraseSpec("fine"));
        s2.setTense(Tense.FUTURE);
        Assert.assertEquals((String)"All will be fine.", (String)this.realiser.realise(s2));
        s = s.coordinate(new Phrase[]{s2});
        this.say.setComplement(s);
        ((CoordinateSPhraseSpec)s).suppressComplementiser(false);
        Assert.assertEquals((String)"said that John was kissing Mary and Susan in the room and all will be fine behind the curtain", (String)this.realiser.realise(this.say));
        ((CoordinateSPhraseSpec)s).suppressComplementiser(true);
        Assert.assertEquals((String)"said that John was kissing Mary and Susan in the room and that all will be fine behind the curtain", (String)this.realiser.realise(this.say));
    }

    @Test
    public void testCoordination() {
        this.kiss.setComplement(this.dog);
        this.kick.setComplement(this.boy);
        VPPhraseSpec coord1 = this.kiss.coordinate(new Phrase[]{this.kick});
        coord1.setPerson(Person.THIRD);
        coord1.setTense(Tense.PAST);
        Assert.assertEquals((String)"kissed the dog and kicked the boy", (String)this.realiser.realise(coord1));
        ((CoordinateVPPhraseSpec)coord1).setNegated(true);
        Assert.assertEquals((String)"did not kiss the dog and did not kick the boy", (String)this.realiser.realise(coord1));
        coord1.setModal("could");
        Assert.assertEquals((String)"could not have kissed the dog and could not have kicked the boy", (String)this.realiser.realise(coord1));
        coord1.setPerfect(true);
        coord1.setProgressive(true);
        Assert.assertEquals((String)"could not have been kissing the dog and could not have been kicking the boy", (String)this.realiser.realise(coord1));
        ((CoordinateVPPhraseSpec)coord1).aggregateAuxiliary(true);
        Assert.assertEquals((String)"could not have been kissing the dog and kicking the boy", (String)this.realiser.realise(coord1));
    }
}

