/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Test;
import simplenlg.features.Form;
import simplenlg.features.Tense;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.TextSpec;
import simplenlg.test.SimplenlgTest;

public class TextSpecTest
extends SimplenlgTest {
    public TextSpecTest(String name) {
        super(name);
    }

    @Test
    public void testBasics() {
        SPhraseSpec p1 = new SPhraseSpec("You", "be", "happy");
        SPhraseSpec p2 = new SPhraseSpec("I", "be", "sad");
        SPhraseSpec p3 = new SPhraseSpec("they", "be", "nervous");
        TextSpec t = new TextSpec(p1, p2, p3);
        Assert.assertEquals((String)"You are happy, I am sad and they are nervous.", (String)this.realiser.realise(t));
        TextSpec t2 = new TextSpec(new TextSpec(p1), new TextSpec(p2), new TextSpec(p3));
        Assert.assertEquals((String)"You are happy. I am sad. They are nervous.", (String)this.realiser.realise(t2));
    }

    @Test
    public void testGerund() {
        NPPhraseSpec comp = new NPPhraseSpec("the", "baby");
        SPhraseSpec p1 = new SPhraseSpec();
        p1.setHead("give");
        p1.addComplement(comp);
        p1.setPassive(true);
        p1.addIndirectObject("50mg of morphine");
        p1.setCuePhrase("after");
        p1.setForm(Form.GERUND);
        Assert.assertEquals((String)"After the baby's being given 50mg of morphine.", (String)this.realiser.realise(p1));
        SPhraseSpec p2 = new SPhraseSpec();
        p2.setHead("intubate");
        p2.addComplement("the baby");
        p2.setPassive(true);
        p2.setTense(Tense.PAST);
        TextSpec t1 = new TextSpec(p1, p2);
        Assert.assertEquals((String)"After the baby's being given 50mg of morphine, the baby was intubated.", (String)this.realiser.realise(t1));
    }

    @Test
    public void testSections() {
        TextSpec doc = new TextSpec();
        doc.setDocument();
        doc.setHeading("Test Document");
        TextSpec section = new TextSpec();
        section.setDocStructure(DocStructure.SECTION);
        section.setHeading("Test Section");
        doc.addSpec(section);
        TextSpec subsection = new TextSpec();
        subsection.setDocStructure(DocStructure.SUBSECTION);
        subsection.setHeading("Test Subsection");
        section.addSpec(subsection);
        TextSpec list = new TextSpec();
        list.setDocStructure(DocStructure.PARAGRAPHSET);
        list.setIndentedList(true);
        subsection.addSpec(list);
        TextSpec para1 = new TextSpec();
        para1.setParagraph();
        para1.addChild("This is the first test paragraph.");
        list.addSpec(para1);
        TextSpec para2 = new TextSpec();
        para2.setParagraph();
        para2.addChild("This is the second test paragraph.");
        list.addSpec(para2);
        Assert.assertEquals((String)"Test Document\r\n\r\nTest Section\r\n\r\nTest Subsection\r\n\r\n * This is the first test paragraph.\r\n\r\n * This is the second test paragraph.\r\n", (String)this.realiser.realise(doc));
        Realiser htmlRealiser = new Realiser();
        htmlRealiser.setHTML(true);
        Assert.assertEquals((String)"<BODY><H1>Test Document</H1>\r\n<H2>Test Section</H2>\r\n<H3>Test Subsection</H3>\r\n<UL><LI>This is the first test paragraph.</LI>\r\n<LI>This is the second test paragraph.</LI>\r\n</UL>\r\n</BODY>\r\n", (String)htmlRealiser.realise(doc));
        doc = new TextSpec();
        doc.setDocument();
        doc.setHeading("Test Document2");
        section = new TextSpec();
        section.setDocStructure(DocStructure.SECTION);
        doc.addSpec(section);
        subsection = new TextSpec();
        subsection.setDocStructure(DocStructure.SUBSECTION);
        section.addSpec(subsection);
        subsection.addChild(list);
        list.setIndentedList(false);
        Assert.assertEquals((String)"Test Document2\r\n\r\nThis is the first test paragraph.\r\n\r\nThis is the second test paragraph.\r\n", (String)this.realiser.realise(doc));
        Assert.assertEquals((String)"<BODY><H1>Test Document2</H1>\r\n<P>This is the first test paragraph.</P>\r\n<P>This is the second test paragraph.</P>\r\n</BODY>\r\n", (String)htmlRealiser.realise(doc));
    }
}

