/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.SModifierPosition;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.test.SimplenlgTest;

public class STest
extends SimplenlgTest {
    SPhraseSpec s1;
    SPhraseSpec s2;
    SPhraseSpec s3;
    SPhraseSpec s4;

    public STest(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() {
        super.setUp();
        this.s1 = new SPhraseSpec();
        this.s1.setSubject(this.woman);
        this.s1.setVerbPhrase(this.kiss);
        this.s1.setComplement(this.man);
        this.s2 = new SPhraseSpec();
        this.s2.setSubject("there");
        this.s2.setHead("be");
        this.s2.setComplement(this.dog);
        this.s2.setModifier(SModifierPosition.POST_VERB, this.onTheRock);
        this.s3 = new SPhraseSpec();
        this.s3.setSubject(this.man);
        this.s3.setVerbPhrase(this.give);
        NPPhraseSpec flower = new NPPhraseSpec("flower");
        NPPhraseSpec john = new NPPhraseSpec("John");
        john.setPossessive(true);
        flower.setSpecifier(john);
        flower.setDiscourseFunction(DiscourseFunction.OBJECT);
        this.s3.addComplement(flower);
        this.s3.addComplement(DiscourseFunction.INDIRECT_OBJECT, this.woman);
        this.s4 = new SPhraseSpec();
        this.s4.setCuePhrase("however,");
        this.s4.addFrontModifier("tomorrow");
        NPPhraseSpec subject = new NPPhraseSpec("Jane").coordinate(new Phrase[]{new NPPhraseSpec("Andrew")});
        this.s4.addSubject(subject);
        this.s4.setHead("pick");
        this.s4.setVerbParticle("up");
        this.s4.addComplement("the balls");
        this.s4.addModifier("in the shop");
        this.s4.setTense(Tense.FUTURE);
    }

    @Test
    public void testBasic() {
        Assert.assertEquals((String)"The woman kisses the man.", (String)this.realiser.realise(this.s1));
        Assert.assertEquals((String)"There is the dog on the rock.", (String)this.realiser.realise(this.s2));
        Assert.assertEquals((String)"The man gives the woman John's flower.", (String)this.realiser.realise(this.s3));
        Assert.assertEquals((String)"However, tomorrow Jane and Andrew will pick up the balls in the shop.", (String)this.realiser.realise(this.s4));
    }

    public void testPronounArguments() {
        Phrase subj = this.s2.getSubjects().get(0);
        Assert.assertTrue((boolean)(subj instanceof NPPhraseSpec));
        Assert.assertTrue((boolean)((NPPhraseSpec)subj).isPronominal());
    }

    @Test
    public void testTenses() {
        this.s3.setTense(Tense.PAST);
        Assert.assertEquals((String)"The man gave the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setPerfect(true);
        Assert.assertEquals((String)"The man had given the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setNegated(true);
        Assert.assertEquals((String)"The man had not given the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setProgressive(true);
        Assert.assertEquals((String)"The man had not been giving the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setPassive(true);
        Assert.assertEquals((String)"John's flower had not been being given the woman by the man.", (String)this.realiser.realise(this.s3));
    }

    @Test
    public void testSubordination() {
        this.say.setComplement(this.s3);
        Assert.assertTrue((boolean)this.s3.isSubordinateClause());
        Assert.assertEquals((String)"says that the man gives the woman John's flower", (String)this.realiser.realise(this.say));
    }

    @Test
    public void testForm() {
        Assert.assertEquals((Object)this.s1.getForm(), (Object)Form.NORMAL);
        this.s1.setForm(Form.INFINITIVE);
        Assert.assertEquals((String)"To kiss the man.", (String)this.realiser.realise(this.s1));
        this.s2.setForm(Form.GERUND);
        Assert.assertEquals((String)"There being the dog on the rock.", (String)this.realiser.realise(this.s2));
        this.s3.setForm(Form.GERUND);
        Assert.assertEquals((String)"The man's giving the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setForm(Form.IMPERATIVE);
        Assert.assertEquals((String)"Give the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.say.setComplement(this.s3);
        Assert.assertEquals((String)"says to give the woman John's flower", (String)this.realiser.realise(this.say));
        this.s4.setForm(Form.IMPERATIVE);
        Assert.assertEquals((String)"However, tomorrow pick up the balls in the shop.", (String)this.realiser.realise(this.s4));
        this.s4.setForm(Form.INFINITIVE);
        Assert.assertEquals((String)"However, to pick up the balls in the shop tomorrow.", (String)this.realiser.realise(this.s4));
    }

    public void testForm2() {
        SPhraseSpec temp = new SPhraseSpec(this.s4, "is", "recommended");
        Assert.assertEquals((Object)Form.GERUND, (Object)this.s4.getForm());
        Assert.assertEquals((String)"However, tomorrow Jane and Andrew's picking up the balls in the shop is recommended.", (String)this.realiser.realise(temp));
        SPhraseSpec temp2 = new SPhraseSpec("I", "tell", temp);
        temp2.setTense(Tense.FUTURE);
        temp2.addIndirectObject("John");
        Assert.assertEquals((String)"I will tell John that however, tomorrow Jane and Andrew's picking up the balls in the shop is recommended.", (String)this.realiser.realise(temp2));
        this.s4.setForm(Form.IMPERATIVE);
        temp2 = new SPhraseSpec("I", "tell", this.s4);
        temp2.addIndirectObject("John");
        temp2.setTense(Tense.FUTURE);
        Assert.assertEquals((String)"I will tell John however, to pick up the balls in the shop tomorrow.", (String)this.realiser.realise(temp2));
    }

    @Test
    public void testGerundsubject() {
        SPhraseSpec s4 = new SPhraseSpec();
        s4.setHead(new Verb("upset"));
        s4.setTense(Tense.PAST);
        s4.setComplement(new NPPhraseSpec("Peter"));
        this.s3.setPerfect(true);
        s4.setSubject(this.s3);
        this.s3.suppressGenitiveInGerund(true);
        Assert.assertTrue((boolean)this.s3.isSubordinateClause());
        Assert.assertTrue((boolean)this.s3.getForm().equals(Form.GERUND));
        Assert.assertEquals((String)"The man having given the woman John's flower upset Peter.", (String)this.realiser.realise(s4));
    }

    @Test
    public void testComplexSentence1() {
        SPhraseSpec complexS = new SPhraseSpec();
        complexS.setHead(new Verb("upset"));
        complexS.setTense(Tense.PAST);
        complexS.setComplement(new NPPhraseSpec("Peter"));
        this.s3.setPerfect(true);
        complexS.setSubject(this.s3);
        Assert.assertTrue((boolean)this.s3.isSubordinateClause());
        Assert.assertTrue((boolean)this.s3.getForm().equals(Form.GERUND));
        Assert.assertEquals((String)"The man's having given the woman John's flower upset Peter.", (String)this.realiser.realise(complexS));
        SPhraseSpec s5 = new SPhraseSpec();
        s5.setSubject(new NPPhraseSpec("some", "person"));
        s5.setHead("stroke");
        s5.setComplement(new NPPhraseSpec("the", "cat"));
        SPhraseSpec coord = this.s3.coordinate(new Phrase[]{s5});
        complexS.setSubject(coord);
        Assert.assertEquals((String)"The man's having given the woman John's flower and some person's stroking the cat upset Peter.", (String)this.realiser.realise(complexS));
        SPhraseSpec s6 = new SPhraseSpec();
        s6.setHead("tell");
        s6.setTense(Tense.PAST);
        s6.setSubject(new NPPhraseSpec("the", "boy"));
        s6.addComplement(DiscourseFunction.INDIRECT_OBJECT, new NPPhraseSpec("every", "girl"));
        s6.addComplement(DiscourseFunction.OBJECT, complexS);
        Assert.assertEquals((String)"The boy told every girl that the man's having given the woman John's flower and some person's stroking the cat upset Peter.", (String)this.realiser.realise(s6));
        Assert.assertEquals((boolean)true, (boolean)complexS.isSubordinateClause());
    }

    @Test
    public void testComplexSentence3() {
        SPhraseSpec coord2 = this.s1.coordinate(new Phrase[]{this.s3});
        coord2.setTense(Tense.PAST);
        Assert.assertEquals((String)"The woman kissed the man and the man gave the woman John's flower.", (String)this.realiser.realise(coord2));
    }

    @Test
    public void testStringRecognition() {
        SPhraseSpec s1 = new SPhraseSpec("my cat", "is", "sad");
        Assert.assertEquals((String)"My cat is sad.", (String)this.realiser.realise(s1));
        SPhraseSpec s2 = new SPhraseSpec("I", "want", "Mary");
        Assert.assertEquals((String)"I want Mary.", (String)this.realiser.realise(s2));
        NPPhraseSpec subject = new NPPhraseSpec("dog");
        subject.setSpecifier("a");
        subject.addPostmodifier("from next door");
        NPPhraseSpec object = new NPPhraseSpec("I");
        SPhraseSpec s = new SPhraseSpec(subject, "chase", object);
        s.setProgressive(true);
        Assert.assertEquals((String)"A dog from next door is chasing me.", (String)this.realiser.realise(s));
    }

    @Test
    public void testAgreement() {
        NPPhraseSpec np = new NPPhraseSpec("dog");
        np.setSpecifier("the");
        np.addPremodifier("angry");
        SPhraseSpec s1 = new SPhraseSpec(np, "chase", "John");
        Assert.assertEquals((String)"The angry dog chases John.", (String)this.realiser.realise(s1));
        np.setPlural(true);
        Assert.assertEquals((String)"The angry dogs chase John.", (String)this.realiser.realise(s1));
        np.setPlural(false);
        np.setSpecifier("a");
        SPhraseSpec s2 = new SPhraseSpec("there", "be", np);
        Assert.assertEquals((String)"There is an angry dog.", (String)this.realiser.realise(s2));
        np.setPlural(true);
        Assert.assertEquals((String)"There are some angry dogs.", (String)this.realiser.realise(s2));
    }

    @Test
    public void testPassive() {
        SPhraseSpec s1 = new SPhraseSpec();
        s1.setHead("intubate");
        s1.addComplement("the baby");
        s1.setPassive(true);
        Assert.assertEquals((String)"The baby is intubated.", (String)this.realiser.realise(s1));
        s1.addSubject("the nurse");
        Assert.assertEquals((String)"The baby is intubated by the nurse.", (String)this.realiser.realise(s1));
        SPhraseSpec s2 = new SPhraseSpec();
        s2.setHead("give");
        s2.addComplement("the baby");
        s2.addIndirectObject("50ug of morphine");
        s2.setPassive(true);
        Assert.assertEquals((String)"The baby is given 50ug of morphine.", (String)this.realiser.realise(s2));
        s2.addSubject("the nurse");
        Assert.assertEquals((String)"The baby is given 50ug of morphine by the nurse.", (String)this.realiser.realise(s2));
        SPhraseSpec s3 = new SPhraseSpec();
        s3.addSubject("my dog");
        s3.addSubject("your cat");
        s3.setHead("chase");
        s3.addComplement("George");
        s3.setTense(Tense.PAST);
        s3.addFrontModifier("yesterday");
        Assert.assertEquals((String)"Yesterday, my dog and your cat chased George.", (String)this.realiser.realise(s3));
        s3.setPassive(true);
        Assert.assertEquals((String)"Yesterday, George was chased by my dog and your cat.", (String)this.realiser.realise(s3));
        SPhraseSpec s4 = new SPhraseSpec("he", "chase", "me");
        Assert.assertEquals((String)"He chases me.", (String)this.realiser.realise(s4));
        s4.setPassive(true);
        Assert.assertEquals((String)"I am chased by him.", (String)this.realiser.realise(s4));
        SPhraseSpec s5 = new SPhraseSpec("him", "chase", "me");
        Assert.assertEquals((String)"He chases me.", (String)this.realiser.realise(s5));
        s5.setPassive(true);
        Assert.assertEquals((String)"I am chased by him.", (String)this.realiser.realise(s5));
    }

    public void testModal() {
        this.s3.setModal("should");
        Assert.assertEquals((String)"The man should give the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setTense(Tense.FUTURE);
        Assert.assertEquals((String)"The man should give the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setModal("should");
        this.s3.setProgressive(true);
        Assert.assertEquals((String)"The man should be giving the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setTense(Tense.PAST);
        this.s3.setProgressive(false);
        Assert.assertEquals((String)"The man should have given the woman John's flower.", (String)this.realiser.realise(this.s3));
        this.s3.setProgressive(true);
        Assert.assertEquals((String)"The man should have been giving the woman John's flower.", (String)this.realiser.realise(this.s3));
    }
}

