/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Test;
import simplenlg.realiser.CoordinatePPPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.test.SimplenlgTest;

public class PPTest
extends SimplenlgTest {
    public PPTest(String name) {
        super(name);
    }

    @Test
    public void testBasic() {
        Assert.assertEquals((String)"in the room", (String)this.realiser.realise(this.inTheRoom));
        Assert.assertEquals((String)"behind the curtain", (String)this.realiser.realise(this.behindTheCurtain));
        Assert.assertEquals((String)"on the rock", (String)this.realiser.realise(this.onTheRock));
    }

    @Test
    public void testComplementation() {
        this.inTheRoom.setComplement(new NPPhraseSpec("the", "room").coordinate(new Phrase[]{new NPPhraseSpec("a", "car")}));
        Assert.assertEquals((String)"in the room and a car", (String)this.realiser.realise(this.inTheRoom));
    }

    public void testCoordination() {
        CoordinatePPPhraseSpec coord1 = (CoordinatePPPhraseSpec)this.inTheRoom.coordinate(new Phrase[]{this.behindTheCurtain});
        Assert.assertEquals((String)"in the room and behind the curtain", (String)this.realiser.realise(coord1));
        coord1.setConjunction("or");
        Assert.assertEquals((String)"in the room or behind the curtain", (String)this.realiser.realise(coord1));
        CoordinatePPPhraseSpec coord2 = (CoordinatePPPhraseSpec)this.onTheRock.coordinate(new Phrase[]{this.underTheTable});
        coord2.setConjunction("or");
        Assert.assertEquals((String)"on the rock or under the table", (String)this.realiser.realise(coord2));
        CoordinatePPPhraseSpec coord3 = (CoordinatePPPhraseSpec)coord1.coordinate(new Phrase[]{coord2});
        String text = this.realiser.realise(coord3);
        Assert.assertEquals((String)"in the room or behind the curtain and on the rock or under the table", (String)text);
    }
}

