/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Test;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.test.SimplenlgTest;

public class NPTest
extends SimplenlgTest {
    public NPTest(String name) {
        super(name);
    }

    @Test
    public void testPlural() {
        this.np4.setPlural(true);
        Assert.assertEquals((String)"the rocks", (String)this.realiser.realise(this.np4));
        this.np5.setPlural(true);
        Assert.assertEquals((String)"the curtains", (String)this.realiser.realise(this.np5));
        this.np5.setPlural(false);
        Assert.assertEquals((Object)NumberAgr.SINGULAR, (Object)this.np5.getNumber());
        Assert.assertEquals((String)"the curtain", (String)this.realiser.realise(this.np5));
        this.np5.setPlural(true);
        Assert.assertEquals((String)"the curtains", (String)this.realiser.realise(this.np5));
    }

    @Test
    public void testPronominalisation() {
        this.proTest1.setGender(Gender.FEMININE);
        this.proTest1.setPronominal(true);
        Assert.assertEquals((String)"she", (String)this.realiser.realise(this.proTest1));
        this.proTest1.setPossessive(true);
        Assert.assertEquals((String)"her", (String)this.realiser.realise(this.proTest1));
        this.proTest2.setPlural(true);
        this.proTest2.setPronominal(true);
        Assert.assertEquals((String)"they", (String)this.realiser.realise(this.proTest2));
        this.proTest2.setDiscourseFunction(DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"them", (String)this.realiser.realise(this.proTest2));
        this.proTest1.setDiscourseFunction(DiscourseFunction.PREP_OBJECT);
        Assert.assertEquals((String)"hers", (String)this.realiser.realise(this.proTest1));
    }

    @Test
    public void testPremodification() {
        this.man.setPremodifier(this.salacious);
        Assert.assertEquals((String)"the salacious man", (String)this.realiser.realise(this.man));
        this.woman.setPremodifier(this.beautiful);
        Assert.assertEquals((String)"the beautiful woman", (String)this.realiser.realise(this.woman));
        this.dog.setPremodifier(this.stunning);
        Assert.assertEquals((String)"the stunning dog", (String)this.realiser.realise(this.dog));
    }

    @Test
    public void testPostmodification() {
        this.man.setComplement(this.onTheRock);
        Assert.assertEquals((String)"the man on the rock", (String)this.realiser.realise(this.man));
        this.woman.setComplement(this.behindTheCurtain);
        Assert.assertEquals((String)"the woman behind the curtain", (String)this.realiser.realise(this.woman));
    }

    @Test
    public void testPossessive() {
        NPPhraseSpec possNP = new NPPhraseSpec("a", "man");
        possNP.setPossessive(true);
        Assert.assertEquals((String)"a man's", (String)this.realiser.realise(possNP));
        this.dog.setSpecifier(possNP);
        Assert.assertEquals((String)"a man's dog", (String)this.realiser.realise(this.dog));
        possNP.setGender(Gender.MASCULINE);
        possNP.setPronominal(true);
        this.dog.setSpecifier(possNP);
        Assert.assertEquals((String)"his dog", (String)this.realiser.realise(this.dog));
        this.dog.setPossessive(true);
        this.np4.setSpecifier(this.dog);
        Assert.assertEquals((String)"his dog's rock", (String)this.realiser.realise(this.np4));
    }

    @Test
    public void testCoordination() {
        CoordinateNPPhraseSpec cnp1 = (CoordinateNPPhraseSpec)this.dog.coordinate(new Phrase[]{this.woman});
        Assert.assertEquals((String)"the dog and the woman", (String)this.realiser.realise(cnp1));
        cnp1.setComplement(this.behindTheCurtain);
        Assert.assertEquals((String)"the dog and the woman behind the curtain", (String)this.realiser.realise(cnp1));
        Assert.assertEquals((boolean)true, (boolean)cnp1.raiseSpecifier());
    }

    @Test
    public void testCoordination2() {
        this.dog.setComplement(this.onTheRock);
        this.woman.setComplement(this.behindTheCurtain);
        CoordinateNPPhraseSpec cnp2 = (CoordinateNPPhraseSpec)this.dog.coordinate(new Phrase[]{this.woman});
        Assert.assertEquals((String)"the dog on the rock and the woman behind the curtain", (String)this.realiser.realise(cnp2));
        cnp2.setPostmodifier(this.inTheRoom);
        Assert.assertEquals((String)"the dog on the rock and the woman behind the curtain in the room", (String)this.realiser.realise(cnp2));
        Assert.assertTrue((boolean)cnp2.setSpecifier(new Determiner("every")));
        Assert.assertTrue((boolean)cnp2.hasSpecifier());
        Assert.assertEquals((String)"every dog on the rock and every woman behind the curtain in the room", (String)this.realiser.realise(cnp2));
        this.dog.setPronominal(true);
        Assert.assertTrue((boolean)cnp2.raiseSpecifier());
        Assert.assertEquals((String)"it and every woman behind the curtain in the room", (String)this.realiser.realise(cnp2));
    }

    @Test
    public void testPossessiveCoordinate() {
        CoordinateNPPhraseSpec cnp2 = (CoordinateNPPhraseSpec)this.dog.coordinate(new Phrase[]{this.woman});
        Assert.assertEquals((String)"the dog and the woman", (String)this.realiser.realise(cnp2));
        cnp2.setPossessive(true);
        Assert.assertEquals((String)"the dog and the woman's", (String)this.realiser.realise(cnp2));
        this.dog.setPronominal(true);
        this.dog.setPossessive(true);
        cnp2.setPossessive(true);
        Assert.assertEquals((String)"its and the woman's", (String)this.realiser.realise(cnp2));
    }

    @Test
    public void testAAn() {
        NPPhraseSpec dog = new NPPhraseSpec("a", "dog");
        Assert.assertEquals((String)"a dog", (String)this.realiser.realise(dog));
        dog.addPremodifier("enormous");
        Assert.assertEquals((String)"an enormous dog", (String)this.realiser.realise(dog));
        NPPhraseSpec elephant = new NPPhraseSpec("a", "elephant");
        Assert.assertEquals((String)"an elephant", (String)this.realiser.realise(elephant));
        elephant.addPremodifier("big");
        Assert.assertEquals((String)"a big elephant", (String)this.realiser.realise(elephant));
        dog.setPlural(true);
        Assert.assertEquals((String)"some enormous dogs", (String)this.realiser.realise(dog));
    }

    @Test
    public void testModifier() {
        NPPhraseSpec dog = new NPPhraseSpec("a", "dog");
        dog.addModifier("angry");
        Assert.assertEquals((String)"an angry dog", (String)this.realiser.realise(dog));
        dog.addModifier("in the park");
        Assert.assertEquals((String)"an angry dog in the park", (String)this.realiser.realise(dog));
        NPPhraseSpec cat = new NPPhraseSpec("a", "cat");
        cat.addModifier(new AdjPhraseSpec("angry"));
        Assert.assertEquals((String)"an angry cat", (String)this.realiser.realise(cat));
        cat.addModifier(new PPPhraseSpec("in", "the park"));
        Assert.assertEquals((String)"an angry cat in the park", (String)this.realiser.realise(cat));
    }
}

