/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.AdjectivePosition;
import simplenlg.features.AdverbPosition;
import simplenlg.features.AdverbType;
import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Deixis;
import simplenlg.features.Polarity;
import simplenlg.features.Quantification;
import simplenlg.features.Reflexivity;
import simplenlg.features.VerbType;
import simplenlg.lexicon.DBLexicon;
import simplenlg.lexicon.db.SQLAccessor;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Adverb;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Verb;

public class NIHFeatureTests
extends TestCase {
    SQLAccessor accessor;
    DBLexicon lexicon;
    LexicalItem lex1;
    LexicalItem lex2;
    LexicalItem lex3;
    LexicalItem lex4;
    LexicalItem lex5;
    LexicalItem lex6;
    LexicalItem lex7;
    LexicalItem lex8;
    LexicalItem lex9;
    LexicalItem lex10;
    Noun n1;
    Noun n2;
    Noun n3;
    Noun n4;
    Noun n5;
    Verb v1;
    Verb v2;
    Verb v3;
    Verb v4;
    Verb v5;
    Adverb a1;
    Adverb a2;
    Adverb a3;
    Adjective a4;
    Adjective a5;
    Adjective a6;
    Adjective a7;
    Conjunction c1;
    Conjunction c2;
    Pronoun p1;
    Pronoun p2;
    Pronoun p3;
    Pronoun p4;
    Pronoun p5;
    static String DRIVER = "com.mysql.jdbc.Driver";
    static String DBURL = "jdbc:mysql://shallot.csd.abdn.ac.uk:3306/lexicon";
    static String USER = "simplenlg";
    static String PASS = "simplenlg";

    @Before
    public void setUp() throws Exception {
        this.accessor = new SQLAccessor(DRIVER, DBURL, USER, PASS);
        this.lexicon = new DBLexicon();
        this.lexicon.setAccessor(this.accessor);
        this.lex1 = this.lexicon.getItemByID("E0544846");
        this.lex2 = this.lexicon.getItemByID("E0216084");
        this.lex3 = this.lexicon.getItemByID("E0064931");
        this.lex4 = this.lexicon.getItemByID("E0037847");
        this.lex5 = this.lexicon.getItemByID("E0023033");
        this.lex6 = this.lexicon.getItemByID("E0415904");
        this.lex7 = this.lexicon.getItemByID("E0052498");
        this.lex8 = this.lexicon.getItemByID("E0566408");
        this.lex9 = this.lexicon.getItemByID("E0229545");
        this.lex10 = this.lexicon.getItemByID("E0053384");
        this.n1 = (Noun)this.lexicon.getItemByID("E0025687");
        this.n2 = (Noun)this.lexicon.getItemByID("E0060502");
        this.n3 = (Noun)this.lexicon.getItemByID("E0011159");
        this.n4 = (Noun)this.lexicon.getItemByID("E0009846");
        this.n5 = (Noun)this.lexicon.getItemByID("E0553347");
        this.v1 = (Verb)this.lexicon.getItemByID("E0059806");
        this.v2 = (Verb)this.lexicon.getItemByID("E0057049");
        this.v3 = (Verb)this.lexicon.getItemByID("E0012152");
        this.v4 = (Verb)this.lexicon.getItemByID("E0044483");
        this.a1 = (Adverb)this.lexicon.getItemByID("E0045835");
        this.a2 = (Adverb)this.lexicon.getItemByID("E0551601");
        this.a3 = (Adverb)this.lexicon.getItemByID("E0573565");
        this.a4 = (Adjective)this.lexicon.getItemByID("E0571412");
        this.a5 = (Adjective)this.lexicon.getItemByID("E0331100");
        this.a6 = (Adjective)this.lexicon.getItemByID("E0558554");
        this.a7 = (Adjective)this.lexicon.getItemByID("E0011464");
        this.c1 = (Conjunction)this.lexicon.getItemByID("E0007709");
        this.c2 = (Conjunction)this.lexicon.getItemByID("E0008914");
        this.p1 = (Pronoun)this.lexicon.getItemByID("E0008090");
        this.p2 = (Pronoun)this.lexicon.getItemByID("E0056729");
        this.p3 = (Pronoun)this.lexicon.getItemByID("E0031461");
        this.p4 = (Pronoun)this.lexicon.getItemByID("E0042156");
        this.p5 = (Pronoun)this.lexicon.getItemByID("E0060481");
    }

    @Test
    public void testInflectionTypes() {
        Assert.assertTrue((boolean)this.lex1.isRegular());
        Assert.assertTrue((boolean)this.lex2.isRegular());
        Assert.assertFalse((boolean)this.lex1.isDLRegular());
        Assert.assertFalse((boolean)this.lex2.isGLRegular());
        Assert.assertTrue((boolean)this.lex3.isGLRegular());
        Assert.assertTrue((boolean)this.lex4.isGLRegular());
        Assert.assertFalse((boolean)this.lex4.isRegular());
        Assert.assertFalse((boolean)this.lex3.isRegular());
        Assert.assertTrue((boolean)this.lex5.isDLRegular());
        Assert.assertTrue((boolean)this.lex6.isDLRegular());
        Assert.assertTrue((boolean)this.lex7.isInvariant());
        Assert.assertTrue((boolean)this.lex8.isInvariant());
        Assert.assertFalse((boolean)this.lex9.isRegular());
        Assert.assertFalse((boolean)this.lex10.isRegular());
        Assert.assertTrue((boolean)this.a1.isPeriphrastic());
    }

    @Test
    public void testAgreement() {
        Assert.assertEquals((Object)this.n1.getAgreement(), (Object)Agreement.MASS);
        Assert.assertEquals((Object)this.n2.getAgreement(), (Object)Agreement.FIXED_PLUR);
        Assert.assertEquals((Object)this.n3.getAgreement(), (Object)Agreement.GROUP);
        Assert.assertEquals((Object)this.n4.getAgreement(), (Object)Agreement.FIXED_SING);
        Assert.assertEquals((Object)this.n5.getAgreement(), (Object)Agreement.COUNT);
    }

    @Test
    public void testVerbType() {
        Assert.assertEquals((Object)this.v1.getVerbType(), (Object)VerbType.MAIN);
        Assert.assertEquals((Object)this.v2.getVerbType(), (Object)VerbType.MAIN);
        Assert.assertEquals((Object)this.v3.getVerbType(), (Object)VerbType.AUX);
        Assert.assertEquals((Object)this.v4.getVerbType(), (Object)VerbType.MODAL);
    }

    @Test
    public void testTransitivity() {
        Assert.assertEquals((int)this.v1.getNumComplements(), (int)11);
        Assert.assertTrue((boolean)this.v1.isComplextransitive());
        Assert.assertTrue((boolean)this.v1.isLinkingVerb());
        Assert.assertTrue((boolean)this.v1.isMonotransitive());
        Assert.assertTrue((boolean)this.v2.isIntransitive());
        Assert.assertTrue((boolean)this.v1.allowsPassiveRaising());
        Assert.assertFalse((boolean)this.v1.allowsDativeShift());
    }

    @Test
    public void testAdjectivePosition() {
        Assert.assertTrue((boolean)this.a4.hasPosition(AdjectivePosition.ATTRIB_1));
        Assert.assertTrue((boolean)this.a4.hasPosition(AdjectivePosition.ATTRIB_2));
        Assert.assertTrue((boolean)this.a4.hasPosition(AdjectivePosition.PREDICATIVE));
        Assert.assertTrue((boolean)this.a5.hasPosition(AdjectivePosition.ATTRIB_3));
        Assert.assertTrue((boolean)this.a6.hasPosition(AdjectivePosition.PREDICATIVE));
        Assert.assertTrue((boolean)this.a6.hasPosition(AdjectivePosition.ATTRIB_3));
    }

    public void testAdjectiveType() {
        Assert.assertTrue((boolean)this.a4.isStative());
        Assert.assertTrue((boolean)this.a5.isStative());
        Assert.assertTrue((boolean)this.a6.isStative());
        Assert.assertFalse((boolean)this.a7.isStative());
    }

    public void testAdverbType() {
        Assert.assertTrue((boolean)this.a1.hasType(AdverbType.INTENSIFIER));
        Assert.assertTrue((boolean)this.a2.hasType(AdverbType.MANNER));
        Assert.assertTrue((boolean)this.a3.hasType(AdverbType.TEMPORAL));
    }

    public void testAdverbPosition() {
        Assert.assertFalse((boolean)this.a1.hasPosition(AdverbPosition.SENTENTIAL));
        Assert.assertFalse((boolean)this.a1.hasPosition(AdverbPosition.VERB_PARTICLE));
        Assert.assertTrue((boolean)this.a1.hasPosition(AdverbPosition.VERBAL));
        Assert.assertTrue((boolean)this.a2.hasPosition(AdverbPosition.VERBAL));
        Assert.assertTrue((boolean)this.a3.hasPosition(AdverbPosition.VERBAL));
    }

    public void testConjunctionType() {
        Assert.assertTrue((boolean)this.c1.isSubordinating());
        Assert.assertTrue((boolean)this.c2.isCoordinating());
    }

    public void testDeixis() {
        Assert.assertFalse((boolean)this.p1.getDeixis().equals(Deixis.DEMONSTRATIVE));
        Assert.assertEquals((Object)this.p5.getDeixis(), (Object)Deixis.DEMONSTRATIVE);
    }

    public void testCase() {
        Assert.assertEquals((Object)this.p1.getCaseValue(), (Object)Case.NOM_ACC);
        Assert.assertEquals((Object)this.p2.getCaseValue(), (Object)Case.NOM_ACC);
        Assert.assertEquals((Object)this.p3.getCaseValue(), (Object)Case.ACCUSATIVE);
    }

    public void testPossession() {
    }

    public void testPolarity() {
        Assert.assertEquals((Object)this.p4.getPolarity(), (Object)Polarity.NEGATIVE);
    }

    public void testReflexivity() {
        Assert.assertEquals((Object)this.p3.getReflexivity(), (Object)Reflexivity.REFLEXIVE);
    }

    public void testQuantification() {
        Assert.assertEquals((Object)this.p1.getQuantification(), (Object)Quantification.UNIVERSAL);
        Assert.assertEquals((Object)this.p2.getQuantification(), (Object)Quantification.INDEF_ASSERT);
    }
}

