/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.Category;
import simplenlg.lexicon.DBLexicon;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;

public class NIHBasicTest
extends TestCase {
    Lexicon lexicon;

    public NIHBasicTest(String name) {
        super(name);
    }

    @Before
    protected void setUp() {
        this.lexicon = new DBLexicon("com.mysql.jdbc.Driver", "jdbc:mysql://shallot.csd.abdn.ac.uk:3306/lexicon", "simplenlg", "simplenlg");
    }

    @Test
    public void testMouse() {
        Noun mouse = (Noun)this.lexicon.getItem(Category.NOUN, "mouse");
        Assert.assertEquals((String)mouse.getPlural(), (String)"mice");
        Assert.assertTrue((boolean)mouse.isCountNoun());
    }

    @Test
    public void testSimpleRealiser() {
        NPPhraseSpec np = new NPPhraseSpec("the", "dog");
        np.setPlural(true);
        SPhraseSpec sent = new SPhraseSpec("John", "chase", np);
        Realiser r = new Realiser(this.lexicon);
        String text = r.realise(sent);
        Assert.assertEquals((String)text, (String)"John chases the dogs.");
    }
}

