/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.InterrogativeType;
import simplenlg.features.SModifierPosition;
import simplenlg.features.Tense;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;
import simplenlg.test.SimplenlgTest;

public class InterrogativeTest
extends SimplenlgTest {
    SPhraseSpec s1;
    SPhraseSpec s2;
    SPhraseSpec s3;
    SPhraseSpec s4;
    SPhraseSpec s5;

    public InterrogativeTest(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() {
        super.setUp();
        this.s1 = new SPhraseSpec();
        this.s1.setSubject(this.woman);
        this.s1.setVerbPhrase(this.kiss);
        this.s1.setComplement(this.man, DiscourseFunction.OBJECT);
        this.s2 = new SPhraseSpec();
        this.s2.setSubject("there");
        this.s2.setHead("be");
        this.s2.setComplement(this.dog);
        this.s2.addModifier(SModifierPosition.POST_VERB, this.onTheRock);
        this.s3 = new SPhraseSpec();
        this.s3.setSubject(this.man);
        this.s3.setVerbPhrase(this.give);
        NPPhraseSpec flower = new NPPhraseSpec("flower");
        NPPhraseSpec john = new NPPhraseSpec("John");
        john.setPossessive(true);
        flower.setSpecifier(john);
        flower.setDiscourseFunction(DiscourseFunction.OBJECT);
        this.s3.addComplement(flower);
        this.s3.addComplement(DiscourseFunction.INDIRECT_OBJECT, this.woman);
        this.s4 = new SPhraseSpec();
        this.s4.setCuePhrase("however,");
        this.s4.addFrontModifier("tomorrow");
        NPPhraseSpec subject = new NPPhraseSpec("Jane").coordinate(new Phrase[]{new NPPhraseSpec("Andrew")});
        this.s4.addSubject(subject);
        this.s4.setHead("pick");
        this.s4.setVerbParticle("up");
        this.s4.addComplement("the balls");
        this.s4.addModifier("in the shop");
        this.s4.setTense(Tense.FUTURE);
        this.s5 = new SPhraseSpec();
        this.s5.setSubject(new NPPhraseSpec("the", "dog"));
        this.s5.setHead("be");
        this.s5.setComplement(new NPPhraseSpec("the", "rock"), DiscourseFunction.OBJECT);
    }

    @Test
    public void testSimpleQuestions() {
        this.s1.setTense(Tense.PRESENT);
        this.s1.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Does the woman kiss the man?", (String)this.realiser.realise(this.s1));
        this.s1.setTense(Tense.PAST);
        this.s1.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Did the woman kiss the man?", (String)this.realiser.realise(this.s1));
        this.s1.setInterrogative(null);
        Assert.assertEquals((String)"The woman kissed the man.", (String)this.realiser.realise(this.s1));
        this.s2.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Is there the dog on the rock?", (String)this.realiser.realise(this.s2));
        this.s2.setPerfect(true);
        Assert.assertEquals((String)"Has there been the dog on the rock?", (String)this.realiser.realise(this.s2));
        this.s3.setTense(Tense.PAST);
        this.s3.setProgressive(true);
        this.s3.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Was the man giving the woman John's flower?", (String)this.realiser.realise(this.s3));
        this.s3.setProgressive(false);
        this.s3.setModal("should");
        this.s3.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Should the man have given the woman John's flower?", (String)this.realiser.realise(this.s3));
        this.s4.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"However, will Jane and Andrew pick up the balls in the shop tomorrow?", (String)this.realiser.realise(this.s4));
    }

    @Test
    public void testNegatedQuestions() {
        this.s1.setTense(Tense.PAST);
        this.s1.setNegated(true);
        this.s1.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Did the woman not kiss the man?", (String)this.realiser.realise(this.s1));
        this.s4.setNegated(true);
        this.s4.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"However, will Jane and Andrew not pick up the balls in the shop tomorrow?", (String)this.realiser.realise(this.s4));
    }

    @Test
    public void testCoordinateVPQuestions() {
        this.kiss.setComplement(this.dog);
        this.walk.setComplement(this.inTheRoom);
        VPPhraseSpec complex = this.kiss.coordinate(new Phrase[]{this.walk});
        this.s4.setVerbPhrase(complex);
        String text = this.realiser.realise(this.s4);
        System.out.println(text);
        Assert.assertEquals((String)"However, tomorrow Jane and Andrew will kiss the dog and will walk in the room.", (String)text);
        this.s4.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"However, will Jane and Andrew kiss the dog and walk in the room tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setPerfect(true);
        Assert.assertEquals((String)"However, will Jane and Andrew have kissed the dog and walked in the room tomorrow?", (String)this.realiser.realise(this.s4));
    }

    @Test
    public void testSimpleQuestions2() {
        SPhraseSpec s = new SPhraseSpec("the woman", "kiss", "the man");
        s.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Does the woman kiss the man?", (String)this.realiser.realise(s));
        s.setPassive(true);
        Assert.assertEquals((String)"Is the man kissed by the woman?", (String)this.realiser.realise(s));
        s.setPassive(false);
        s.setInterrogative(InterrogativeType.WHO, DiscourseFunction.SUBJECT);
        Assert.assertEquals((String)"Who kisses the man?", (String)this.realiser.realise(s));
        s.setInterrogative(InterrogativeType.WHO, DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"Who does the woman kiss?", (String)this.realiser.realise(s));
        s.setPassive(true);
        s.setInterrogative(InterrogativeType.WHO, DiscourseFunction.SUBJECT);
        Assert.assertEquals((String)"Who is the man kissed by?", (String)this.realiser.realise(s));
    }

    @Test
    public void testWHQuestions() {
        this.s4.setInterrogative(InterrogativeType.WHO, DiscourseFunction.SUBJECT);
        Assert.assertEquals((String)"However, who will pick up the balls in the shop tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setPassive(true);
        Assert.assertEquals((String)"However, who will the balls be picked up in the shop by tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setPassive(false);
        this.s4.setInterrogative(InterrogativeType.WHAT, DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"However, what will Jane and Andrew pick up in the shop tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setPassive(true);
        this.s4.setInterrogative(InterrogativeType.WHAT, DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"However, what will be picked up in the shop by Jane and Andrew tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setInterrogative(InterrogativeType.HOW);
        Assert.assertEquals((String)"However, how will the balls be picked up in the shop by Jane and Andrew tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setInterrogative(InterrogativeType.WHY);
        Assert.assertEquals((String)"However, why will the balls be picked up in the shop by Jane and Andrew tomorrow?", (String)this.realiser.realise(this.s4));
        this.s4.setModal("should");
        this.s4.setInterrogative(InterrogativeType.HOW);
        Assert.assertEquals((String)"However, how should the balls be picked up in the shop by Jane and Andrew tomorrow?", (String)this.realiser.realise(this.s4));
        this.s3.setInterrogative(InterrogativeType.WHO, DiscourseFunction.INDIRECT_OBJECT);
        Assert.assertEquals((String)"Who does the man give John's flower?", (String)this.realiser.realise(this.s3));
    }

    @Test
    public void testTutorialQuestions() {
        SPhraseSpec p = new SPhraseSpec();
        p.setSubject("Mary");
        p.setHead("chase");
        p.addComplement("George");
        p.setInterrogative(InterrogativeType.YES_NO);
        Assert.assertEquals((String)"Does Mary chase George?", (String)this.realiser.realise(p));
        p = new SPhraseSpec();
        p.setSubject("Mary");
        p.setHead("chase");
        p.addComplement("George");
        p.setInterrogative(InterrogativeType.WHO, DiscourseFunction.OBJECT);
        Assert.assertEquals((String)"Who does Mary chase?", (String)this.realiser.realise(p));
    }
}

