/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import simplenlg.features.Case;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Pronoun;

public class InflectionTest
extends TestCase {
    public static String nounFile = "testData\\nounForms.csv";
    public static String verbFile = "testData\\verbForms.csv";
    private Lexicon lex;
    Map<String, String> plurals;
    Map<String, List<String>> verbs;

    @Before
    public void setUp() {
        this.lex = new Lexicon();
        this.plurals = new HashMap<String, String>();
        this.verbs = new HashMap<String, List<String>>();
        String workingDir = System.getProperty("user.dir");
        this.loadNouns(new File(workingDir, nounFile));
        this.loadVerbs(new File(workingDir, verbFile));
    }

    private void loadNouns(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while (reader.ready()) {
                String nextLine = reader.readLine();
                if (nextLine.startsWith("//")) continue;
                StringTokenizer tok = new StringTokenizer(nextLine, ",");
                int i = -1;
                String head = null;
                while (tok.hasMoreTokens()) {
                    String word = tok.nextToken().trim();
                    if (++i == 0) {
                        head = word;
                        continue;
                    }
                    this.plurals.put(head, word);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            System.exit(-1);
        }
    }

    private void loadVerbs(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while (reader.ready()) {
                String nextLine = reader.readLine().trim();
                if (nextLine.startsWith("//")) continue;
                StringTokenizer tok = new StringTokenizer(nextLine, ",");
                int i = -1;
                String head = null;
                while (tok.hasMoreTokens()) {
                    String word = tok.nextToken().trim();
                    if (++i == 0) {
                        this.verbs.put(word, new ArrayList());
                        head = word;
                        continue;
                    }
                    this.verbs.get(head).add(word);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            System.exit(-1);
        }
    }

    @Test
    public void testNouns() {
        for (String noun : this.plurals.keySet()) {
            String filePlural = this.plurals.get(noun).toLowerCase();
            String lexPlural = this.lex.getPlural(noun).toLowerCase();
            Assert.assertEquals((String)filePlural, (String)lexPlural);
        }
    }

    @Test
    public void testVerbs() {
        for (String verb : this.verbs.keySet()) {
            List<String> fileForms = this.verbs.get(verb);
            List<String> lexForms = Arrays.asList(this.lex.getPast(verb), this.lex.getPastParticiple(verb), this.lex.getPresentParticiple(verb), this.lex.getPresent3SG(verb));
            Assert.assertEquals(fileForms, lexForms);
        }
    }

    public void testPronouns() {
        Pronoun we = Constants.getPronoun(Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER, Case.NOMINATIVE, false);
        Assert.assertEquals((String)we.getBaseForm(), (String)"we");
        Pronoun our = Constants.getPronoun(Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER, Case.NOMINATIVE, true);
        Assert.assertEquals((String)our.getBaseForm(), (String)"our");
        Pronoun ours = Constants.getPronoun(Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER, Case.NOM_ACC, true);
        Assert.assertEquals((String)ours.getBaseForm(), (String)"ours");
    }
}

