/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.test;

import junit.framework.Assert;
import org.junit.Test;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.realiser.AdvPhraseSpec;
import simplenlg.realiser.CoordinateAdjPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.test.SimplenlgTest;

public class AdjPTest
extends SimplenlgTest {
    public AdjPTest(String name) {
        super(name);
    }

    @Test
    public void testAdj() {
        this.salacious.addPremodifier("incredibly");
        Assert.assertEquals((String)"incredibly salacious", (String)this.realiser.realise(this.salacious));
        this.beautiful.addPremodifier("amazingly");
        Assert.assertEquals((String)"amazingly beautiful", (String)this.realiser.realise(this.beautiful));
        CoordinateAdjPhraseSpec coordap = (CoordinateAdjPhraseSpec)this.salacious.coordinate(new Phrase[]{this.beautiful});
        Assert.assertEquals((String)"incredibly salacious and amazingly beautiful", (String)this.realiser.realise(coordap));
        coordap.setConjunction(Constants.OR);
        Assert.assertEquals((String)"incredibly salacious or amazingly beautiful", (String)this.realiser.realise(coordap));
        CoordinateAdjPhraseSpec coord2 = (CoordinateAdjPhraseSpec)coordap.coordinate(new Phrase[]{this.stunning});
        Assert.assertEquals((String)"incredibly salacious or amazingly beautiful and stunning", (String)this.realiser.realise(coord2));
        StringPhraseSpec preMod = new StringPhraseSpec("seriously").coordinate(new Phrase[]{new StringPhraseSpec("undeniably")});
        coord2.addPremodifier(preMod);
        Assert.assertEquals((String)"seriously and undeniably incredibly salacious or amazingly beautiful and stunning", (String)this.realiser.realise(coord2));
        coordap.addCoordinates(this.stunning);
        Assert.assertEquals((String)"incredibly salacious, amazingly beautiful or stunning", (String)this.realiser.realise(coordap));
    }

    @Test
    public void testAdv() {
        SPhraseSpec sent = new SPhraseSpec("John", "eat");
        AdvPhraseSpec adv = new AdvPhraseSpec("quickly");
        sent.addPremodifier(adv);
        Assert.assertEquals((String)"John quickly eats.", (String)this.realiser.realise(sent));
        adv.addPremodifier("very");
        Assert.assertEquals((String)"John very quickly eats.", (String)this.realiser.realise(sent));
    }
}

