/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.List;
import simplenlg.exception.SimplenlgException;
import simplenlg.formatter.Formatter;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.Spec;
import simplenlg.realiser.StringPhraseSpec;

public class TextSpec
extends Spec {
    private List<Spec> children = new ArrayList<Spec>();
    private DocStructure docStructure = DocStructure.SENTENCE;
    private String listConjunct = null;
    private boolean indentedList;
    private PhraseSpec heading;
    private boolean defaultCaps = true;

    public TextSpec() {
    }

    public TextSpec(Object ... specs) {
        this();
        Object[] objectArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            Object spec = objectArray[n2];
            if (spec instanceof DocStructure) {
                this.setDocStructure((DocStructure)((Object)spec));
            } else {
                this.addSpec(spec);
            }
            ++n2;
        }
    }

    public void setDocStructure(DocStructure docStructure) {
        this.docStructure = docStructure;
    }

    public DocStructure getDocStructure() {
        return this.docStructure;
    }

    public void setSentence() {
        this.setDocStructure(DocStructure.SENTENCE);
    }

    public void setParagraph() {
        this.setDocStructure(DocStructure.PARAGRAPH);
    }

    public void setDocument() {
        this.setDocStructure(DocStructure.DOCUMENT);
    }

    public void setListConjunct(String listConjunct) {
        this.listConjunct = listConjunct;
    }

    public String getListConjunct() {
        return this.listConjunct;
    }

    public boolean isIndentedList() {
        return this.indentedList;
    }

    public void setIndentedList(boolean indentedList) {
        this.indentedList = indentedList;
    }

    public void setDefaultCaps(boolean caps) {
        this.defaultCaps = caps;
    }

    public boolean hasDefaultCaps() {
        return this.defaultCaps;
    }

    public PhraseSpec getHeading() {
        return this.heading;
    }

    public boolean hasHeading() {
        return this.heading != null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setHeading(Object heading) {
        this.heading = (PhraseSpec)this.convertToSpec(heading);
    }

    public List<Spec> getChildren() {
        return this.children;
    }

    public void setChildren(List<Spec> children) {
        this.children = children;
    }

    public void addChild(Object spec) {
        this.addSpec(spec);
    }

    public void removeChild(Object child) {
        this.children.remove(child);
    }

    public void addSpec(Object spec) {
        Spec pspec = this.convertToSpec(spec);
        pspec.setParentSpec(this);
        this.children.add(pspec);
    }

    private Spec convertToSpec(Object spec) {
        if (spec instanceof Spec) {
            return (Spec)spec;
        }
        if (spec instanceof String) {
            return new StringPhraseSpec((String)spec);
        }
        throw new SimplenlgException("addSpec: spec must be a PhraseSpec, TextSpec, or String");
    }

    @Override
    public String realise(Realiser r) {
        this.docStructure = this.docStructure.max(this.maxDSChildren().lowestParent());
        List<Spec> promotedChildren = this.children;
        if (!this.docStructure.isSentenceOrLower()) {
            promotedChildren = new ArrayList<Spec>();
            for (Spec child : this.children) {
                promotedChildren.add(child.promote(DocStructure.SENTENCE));
            }
        }
        String result = "";
        result = this.listConjunct != null ? r.realiseConjunctList(promotedChildren, this.listConjunct) : (this.docStructure.isSentenceOrLower() ? (!this.hasCuePhrase() ? r.realiseAndList(promotedChildren) : r.realiseConjunctList(promotedChildren, ",")) : (this.indentedList ? r.realiseIndentedList(promotedChildren) : r.realiseList(promotedChildren)));
        if (this.docStructure.isSentence()) {
            Spec childSpec;
            int terminator = 46;
            if (this.children != null && this.children.size() > 0 && (childSpec = this.children.get(0)) != null && childSpec instanceof SPhraseSpec && ((SPhraseSpec)childSpec).isInterrogative()) {
                terminator = 63;
            }
            result = r.applySentenceOrthography(result, (char)terminator, this.defaultCaps);
        }
        if (this.docStructure.isParagraph()) {
            result = r.applyParagraphOrthography(result);
        }
        String header = null;
        if (this.heading != null) {
            header = r.realise(this.heading);
        }
        Formatter formatter = r.getFormatter();
        switch (this.docStructure) {
            case SENTENCE: {
                result = r.applySentenceOrthography(result, '.', this.defaultCaps);
                break;
            }
            case PARAGRAPH: {
                result = r.applyParagraphOrthography(formatter.addParagraphMarkup(result));
                break;
            }
            case SUBSECTION: {
                result = formatter.addSubSectionMarkup(result, header);
                break;
            }
            case SECTION: {
                result = formatter.addSectionMarkup(result, header);
                break;
            }
            case DOCUMENT: {
                result = r.applyDocumentOrthography(formatter.addDocumentMarkup(result, header));
                break;
            }
        }
        return result;
    }

    public int size() {
        return this.children.size();
    }

    private boolean hasCuePhrase() {
        for (Spec spec : this.children) {
            if (spec instanceof SPhraseSpec && ((SPhraseSpec)spec).hasCuePhrase()) {
                return true;
            }
            if (!(spec instanceof TextSpec) || !((TextSpec)spec).hasCuePhrase()) continue;
            return true;
        }
        return false;
    }

    private DocStructure maxDSChildren() {
        DocStructure maxDSvalue = DocStructure.PHRASE;
        for (Spec child : this.children) {
            if (!(child instanceof TextSpec)) continue;
            maxDSvalue = maxDSvalue.max(((TextSpec)child).maxDS());
        }
        return maxDSvalue;
    }

    private DocStructure maxDS() {
        return this.getDocStructure().max(this.maxDSChildren());
    }

    @Override
    public TextSpec promote(DocStructure level) {
        if (this.docStructure.compareTo(level) >= 0) {
            return this;
        }
        TextSpec newts = new TextSpec(new Object[]{this.docStructure.next(), this});
        return newts.promote(level);
    }

    public String toString() {
        return this.toString("", new Realiser());
    }

    private String toString(String indent, Realiser r) {
        String result = String.valueOf(indent) + (Object)((Object)this.docStructure) + ": ";
        result = this.listConjunct != null ? String.valueOf(result) + "TextSpec-List " + this.listConjunct : String.valueOf(result) + "TextSpec";
        if (this.children.size() == 1 && !(this.children.get(0) instanceof TextSpec)) {
            result = String.valueOf(result) + " -- " + r.realise(this.children.get(0)) + "\n";
        } else {
            result = String.valueOf(result) + "\n";
            for (Spec child : this.children) {
                result = child instanceof TextSpec ? String.valueOf(result) + ((TextSpec)child).toString(String.valueOf(indent) + "+", r) : String.valueOf(result) + indent + "+" + r.realise(child) + "\n";
            }
        }
        return result;
    }
}

