/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.List;
import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.SModifierPosition;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.realiser.TextSpec;
import simplenlg.realiser.VPPhraseSpec;

public class SPhraseSpec
extends HeadedPhraseSpec<Verb> {
    Phrase cuePhrase = null;
    List<Phrase> subjects;
    List<Phrase> frontModifiers;
    VPPhraseSpec verbPhrase = new VPPhraseSpec();
    PPPhraseSpec passiveComplement;
    CoordinatePhraseSet<Phrase> surfaceSubject;
    String complementiser;
    ClauseStatus status;
    boolean suppressComp;
    boolean expletiveSubject;
    boolean suppressGenitiveInGerund;
    boolean interrogative;
    InterrogativeType interrogType;
    DiscourseFunction whArgument;
    char terminator;
    boolean suppressPunctuationDefault;

    public SPhraseSpec() {
        this.verbPhrase.setParentSpec(this);
        this.subjects = new ArrayList<Phrase>();
        this.frontModifiers = new ArrayList<Phrase>();
        this.surfaceSubject = new CoordinatePhraseSet<SPhraseSpec>(this);
        this.passiveComplement = null;
        this.status = ClauseStatus.MATRIX;
        this.category = Category.CLAUSE;
        this.complementiser = "that";
        this.suppressComp = false;
        this.expletiveSubject = false;
        this.interrogative = false;
        this.interrogType = null;
        this.whArgument = null;
        this.suppressGenitiveInGerund = false;
        this.terminator = (char)46;
        this.suppressPunctuationDefault = false;
    }

    public SPhraseSpec(Object subject, Object verb, Object complement) {
        this(subject, verb);
        this.addComplement(complement);
    }

    public boolean isExistential() {
        boolean ex = false;
        if (this.subjects.size() == 1) {
            String string;
            Phrase subj = this.subjects.get(0);
            if (subj instanceof NPPhraseSpec) {
                Noun head = (Noun)((NPPhraseSpec)subj).getHead();
                if (head != null) {
                    ex = head.getBaseForm().equals("there");
                }
            } else if (subj instanceof StringPhraseSpec && (string = ((StringPhraseSpec)subj).getString()) != null) {
                ex = string.equals("there");
            }
        }
        return ex;
    }

    public SPhraseSpec(Object subject, Object verb) {
        this();
        if (verb instanceof String) {
            this.setHead((String)verb);
        } else if (verb instanceof Verb) {
            this.setHead((Verb)verb);
        } else {
            throw new SimplenlgException("Verb argument to SPhraseSpec constructor must be Verb or String");
        }
        this.addSubject(subject);
    }

    public void setVerb(Object verb) {
        if (verb instanceof Verb) {
            this.setHead((Verb)verb);
        } else if (verb instanceof String) {
            this.setHead((String)verb);
        } else {
            throw new SimplenlgException("Argument to SPhraseSpec.setVerb(Object) must be a Verb or String");
        }
    }

    public void setVerbPhrase(VPPhraseSpec vp) {
        boolean perf = this.isPerfect();
        boolean prog = this.isProgressive();
        boolean pass = this.isPassive();
        Tense t = this.getTense();
        vp.setParentSpec(this);
        this.verbPhrase = vp;
        this.verbPhrase.setTense(t);
        this.verbPhrase.setPerfect(perf);
        this.verbPhrase.setProgressive(prog);
        this.verbPhrase.setPassive(pass);
    }

    public void addVerbPhrase(VPPhraseSpec vp) {
        this.verbPhrase = this.verbPhrase.coordinate(new Phrase[]{vp});
        this.verbPhrase.setParentSpec(this);
    }

    public VPPhraseSpec getVerbPhrase() {
        return this.verbPhrase;
    }

    @Override
    public void setHead(Verb head) {
        this.verbPhrase.setHead(head);
    }

    @Override
    public void setHead(String head) {
        this.verbPhrase.setHead(head);
    }

    @Override
    public Verb getHead() {
        return (Verb)this.verbPhrase.getHead();
    }

    @Deprecated
    public Verb getVerb() {
        return this.getHead();
    }

    @Override
    public String getHeadAsString() {
        Verb v = this.getHead();
        if (v != null) {
            return v.getBaseForm();
        }
        return null;
    }

    @Deprecated
    public String getVerbAsString() {
        return this.getHeadAsString();
    }

    public void addVerb(Object verb) {
        VPPhraseSpec newVP = new VPPhraseSpec();
        if (verb instanceof String) {
            newVP.setHead((String)verb);
        } else if (verb instanceof Verb) {
            newVP.setHead((Verb)verb);
        } else {
            throw new SimplenlgException("Can only add String or Verb as head of SPhraseSpec.");
        }
        newVP = this.fixAllFeatures(newVP);
        if (this.verbPhrase.hasHead()) {
            if (this.verbPhrase.isCoordinate()) {
                ((CoordinateVPPhraseSpec)this.verbPhrase).addCoordinates(newVP);
            } else {
                this.verbPhrase = this.verbPhrase.coordinate(new Phrase[]{newVP});
            }
        } else {
            this.verbPhrase = newVP;
        }
    }

    public String getVerbParticle() {
        if (this.verbPhrase.hasHead()) {
            return ((Verb)this.verbPhrase.getHead()).getParticle();
        }
        return null;
    }

    public void setVerbParticle(String particle) {
        if (this.verbPhrase.hasHead()) {
            this.verbPhrase.setParticle(particle);
        }
    }

    public void suppressGenitiveInGerund(boolean suppress) {
        this.suppressGenitiveInGerund = suppress;
    }

    public void addModifier(SModifierPosition position, Object modifier) {
        switch (position) {
            case FRONT: {
                this.frontModifiers.add(this.makeConstituent(modifier, DiscourseFunction.PREMODIFIER));
                break;
            }
            case PRE_VERB: {
                this.verbPhrase.addPremodifier(modifier);
                break;
            }
            case POST_VERB: {
                this.verbPhrase.addPostmodifier(modifier);
            }
        }
    }

    public void setModifier(SModifierPosition position, Object modifier) {
        switch (position) {
            case FRONT: {
                this.frontModifiers.clear();
                this.frontModifiers.add(this.makeConstituent(modifier, DiscourseFunction.FRONT_MODIFIER));
                break;
            }
            case PRE_VERB: {
                this.verbPhrase.setPremodifier(modifier);
                break;
            }
            case POST_VERB: {
                this.verbPhrase.setPostmodifier(modifier);
            }
        }
    }

    @Override
    public void addPremodifier(Object mod) {
        this.verbPhrase.addPremodifier(mod);
    }

    @Override
    public void setPremodifier(Object mod) {
        this.verbPhrase.setPremodifier(mod);
    }

    @Override
    public void addPostmodifier(Object mod) {
        this.verbPhrase.addPostmodifier(mod);
    }

    @Override
    public void setPostmodifier(Object mod) {
        this.verbPhrase.setPostmodifier(mod);
    }

    public List<Phrase> getSubjects() {
        return this.subjects;
    }

    public List<Phrase> getSurfaceSubjects() {
        return this.verbPhrase.getPassiveRaisingComplements();
    }

    public void addSubject(Object sub) {
        Phrase subjectPhrase = this.makeConstituent(sub, DiscourseFunction.SUBJECT);
        this.subjects.add(subjectPhrase);
    }

    public void setSubject(Object sub) {
        this.subjects.clear();
        this.addSubject(sub);
    }

    public boolean hasSubject() {
        return this.subjects.size() > 0;
    }

    public List<Phrase> getModifiers(SModifierPosition position) {
        switch (position) {
            case FRONT: {
                return this.frontModifiers;
            }
            case PRE_VERB: {
                return this.verbPhrase.getPremodifiers();
            }
            case POST_VERB: {
                return this.verbPhrase.getPostmodifiers();
            }
        }
        return null;
    }

    @Override
    public void addComplement(Object comp) {
        this.verbPhrase.addComplement(comp);
    }

    @Override
    public void setComplement(Object comp) {
        this.verbPhrase.setComplement(comp);
    }

    public void setComplement(Object comp, DiscourseFunction function) {
        this.verbPhrase.setComplement(comp, function);
    }

    public void addComplement(DiscourseFunction func, Object comp) {
        this.verbPhrase.addComplement(comp, func);
    }

    @Override
    public List<Phrase> getComplements() {
        return this.verbPhrase.getComplements();
    }

    public List<Phrase> getComplements(DiscourseFunction func) {
        return this.verbPhrase.getComplements(func);
    }

    @Deprecated
    public List<Phrase> getIndirectObjects() {
        return this.verbPhrase.getComplements(DiscourseFunction.INDIRECT_OBJECT);
    }

    public void setCuePhrase(Object cue) {
        this.cuePhrase = this.makeConstituent(cue, DiscourseFunction.CUE_PHRASE);
    }

    public Phrase getCuePhrase() {
        return this.cuePhrase;
    }

    public void setDefaultComplementiser(String comp) {
        this.complementiser = comp;
    }

    public String getDefaultComplementiser() {
        return this.complementiser;
    }

    @Override
    public boolean hasPremodifiers() {
        return this.verbPhrase.hasPremodifiers();
    }

    @Override
    public boolean hasComplements() {
        return this.verbPhrase.hasComplements();
    }

    @Override
    public boolean hasPostmodifiers() {
        return this.verbPhrase.hasPostmodifiers();
    }

    public boolean hasFrontModifiers() {
        return !this.frontModifiers.isEmpty();
    }

    public List<Phrase> getFrontModifiers() {
        return this.frontModifiers;
    }

    public void addIndirectObject(Object indirectObject) {
        this.verbPhrase.addComplement(indirectObject, DiscourseFunction.INDIRECT_OBJECT);
    }

    public void setIndirectObject(Object indirectObject) {
        this.verbPhrase.setComplement(indirectObject, DiscourseFunction.INDIRECT_OBJECT);
    }

    public void addFrontModifier(Object modifier) {
        if (modifier != null) {
            PhraseSpec spec = this.makePhraseSpec(modifier);
            spec.setDiscourseFunction(DiscourseFunction.FRONT_MODIFIER);
            this.frontModifiers.add(0, spec);
        }
    }

    public boolean hasCuePhrase() {
        return this.cuePhrase != null;
    }

    public boolean isSubordinateClause() {
        return this.status.equals(ClauseStatus.SUBORDINATE);
    }

    public boolean isMainClause() {
        return this.status.equals(ClauseStatus.MATRIX);
    }

    public void suppressComplementiser(boolean suppress) {
        this.suppressComp = suppress;
    }

    void setClauseStatus(ClauseStatus type) {
        this.status = type;
    }

    public void setInterrogative(InterrogativeType type) {
        if (type == null) {
            this.interrogative = false;
            this.interrogType = null;
            this.whArgument = null;
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)46;
            }
        } else {
            this.interrogType = type;
            this.interrogative = true;
            this.whArgument = type.equals(InterrogativeType.YES_NO) || type.equals(InterrogativeType.HOW) ? null : DiscourseFunction.SUBJECT;
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)63;
            }
        }
    }

    public void setInterrogative(InterrogativeType type, DiscourseFunction func) {
        if (!(func.equals(DiscourseFunction.SUBJECT) || func.equals(DiscourseFunction.OBJECT) || func.equals(DiscourseFunction.INDIRECT_OBJECT))) {
            throw new SimplenlgException("Only SUBJECT, OBJECT or INDIRECT_OBJECT are covered by WH questions");
        }
        this.setInterrogative(type);
        if (type.isWhQuestion()) {
            this.whArgument = func;
        }
    }

    public boolean isInterrogative() {
        return this.interrogative;
    }

    public InterrogativeType getInterrogativeType() {
        return this.interrogType;
    }

    public DiscourseFunction getWhArgument() {
        return this.whArgument;
    }

    public void setSentenceTerminator(char terminator) {
        this.terminator = terminator;
        this.suppressPunctuationDefault = true;
    }

    public char getSentenceTerminator() {
        return this.terminator;
    }

    public void setTense(Tense t) {
        this.verbPhrase.setTense(t);
    }

    public Tense getTense() {
        return this.verbPhrase.getTense();
    }

    public String getModal() {
        return this.verbPhrase.getModal();
    }

    public void setModal(String modal) {
        this.verbPhrase.setModal(modal);
    }

    public void setForm(Form f) {
        this.verbPhrase.setForm(f);
    }

    public Form getForm() {
        return this.verbPhrase.getForm();
    }

    public void setPerfect(boolean perf) {
        this.verbPhrase.setPerfect(perf);
    }

    public boolean isPerfect() {
        return this.verbPhrase.isPerfect();
    }

    public void setProgressive(boolean prog) {
        this.verbPhrase.setProgressive(prog);
    }

    public boolean isProgressive() {
        return this.verbPhrase.isProgressive();
    }

    public void setNegated(boolean neg) {
        this.verbPhrase.setNegated(neg);
    }

    public boolean isNegated() {
        return this.verbPhrase.isNegated();
    }

    public boolean isPassive() {
        return this.verbPhrase.isPassive();
    }

    public void setPassive(boolean pass) {
        this.verbPhrase.setPassive(pass);
    }

    public SPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateSPhraseSpec csp = new CoordinateSPhraseSpec(this);
        try {
            Phrase[] phraseArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Phrase p = phraseArray[n2];
                csp.addCoordinates((SPhraseSpec)p);
                ++n2;
            }
            return csp;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof SPhraseSpec) {
            SPhraseSpec s = (SPhraseSpec)o;
            eq = !(this.cuePhrase != s.cuePhrase && !this.cuePhrase.equals(s.cuePhrase) || this.verbPhrase != s.verbPhrase && !this.verbPhrase.equals(s.verbPhrase) || !this.frontModifiers.equals(s.frontModifiers) || !this.subjects.equals(s.subjects));
        }
        return eq;
    }

    boolean isBeVerb(String verb) {
        return verb.equalsIgnoreCase("be") || verb.equalsIgnoreCase("am") || verb.equalsIgnoreCase("are") || verb.equalsIgnoreCase("is") || verb.equalsIgnoreCase("was") || verb.equalsIgnoreCase("were");
    }

    @Override
    String realise(Realiser r) {
        String result;
        this.verbPhrase.initialiseArgs();
        this.computeSurfaceArgs();
        this.computeForm();
        this.computeVPAgreement();
        String cuePhraseText = r.realise(this.cuePhrase);
        String frontModifierText = r.realiseConjunctList(this.frontModifiers, ",");
        String verbText = this.verbPhrase.realise(r, this.needsFrontAuxiliary());
        String frontedElements = this.getFrontedElements(r);
        String compText = r.realise(this.passiveComplement);
        String mainSent = "";
        if (this.interrogative) {
            mainSent = r.appendSpace(cuePhraseText, frontedElements, this.surfaceSubject.realise(r), verbText, compText, frontModifierText);
        } else {
            String frontSeparator = frontModifierText.length() == 0 || cuePhraseText != null && cuePhraseText.endsWith(",") ? "" : ",";
            mainSent = r.appendSpace(cuePhraseText, frontModifierText, frontSeparator, this.surfaceSubject.realise(r), verbText, compText);
        }
        if (this.isSubordinateClause() && !this.suppressComp) {
            mainSent = r.appendSpace(this.complementiser, mainSent);
        }
        if (this.parentSpec != null) {
            if (this.parentSpec instanceof TextSpec && ((TextSpec)this.parentSpec).hasDefaultCaps()) {
                ((TextSpec)this.parentSpec).setDefaultCaps(this.canCapitaliseFirstChar());
            }
            result = mainSent;
        } else {
            result = r.applySentenceOrthography(mainSent, this.terminator, this.canCapitaliseFirstChar());
        }
        return result;
    }

    boolean canCapitaliseFirstChar() {
        Phrase first;
        List<Phrase> subjects = this.surfaceSubject.getCoordinates();
        boolean capitalise = true;
        if (!subjects.isEmpty() && (first = subjects.get(0)) instanceof NPPhraseSpec) {
            NPPhraseSpec np = (NPPhraseSpec)first;
            capitalise = !np.isAcronym() || np.hasSpecifier();
        }
        return capitalise;
    }

    boolean needsFrontAuxiliary() {
        if (this.interrogative) {
            if (this.interrogType.isWhQuestion()) {
                return !this.whArgument.equals(DiscourseFunction.SUBJECT) || this.isPassive();
            }
            return true;
        }
        return false;
    }

    String getFrontedElements(Realiser r) {
        String fronted = "";
        if (this.interrogative && !this.isSubordinateClause()) {
            if (!this.interrogType.equals(InterrogativeType.YES_NO)) {
                fronted = this.interrogType.toString().toLowerCase();
            }
            if (this.needsFrontAuxiliary()) {
                fronted = r.appendSpace(fronted, this.verbPhrase.getInterrogativeFrontedElement(r.getLexicon()));
            }
        }
        return fronted;
    }

    void buildPassiveComplement(boolean comps) {
        List<Phrase> actualSubjects = this.getNonElidedSubjects();
        if (!actualSubjects.isEmpty()) {
            this.passiveComplement = new PPPhraseSpec("by");
            if (comps) {
                for (Phrase p : actualSubjects) {
                    p.setDiscourseFunction(DiscourseFunction.PREP_OBJECT);
                    this.passiveComplement.addComplement(p);
                }
            }
        }
    }

    List<Phrase> getNonElidedSubjects() {
        ArrayList<Phrase> subjects = new ArrayList<Phrase>();
        for (Phrase p : this.subjects) {
            if (p.isElided()) continue;
            subjects.add(p);
        }
        return subjects;
    }

    protected void computeSurfaceArgs() {
        this.surfaceSubject.clearCoordinates();
        this.passiveComplement = null;
        if (this.isPassive()) {
            if (this.interrogative && this.interrogType.isWhQuestion()) {
                switch (this.whArgument) {
                    case SUBJECT: {
                        this.buildPassiveComplement(false);
                        this.surfaceSubject.addCoordinates(this.verbPhrase.getPassiveRaisingComplements());
                        break;
                    }
                    case INDIRECT_OBJECT: {
                        this.verbPhrase.suppressArg(DiscourseFunction.INDIRECT_OBJECT);
                        break;
                    }
                    case OBJECT: {
                        this.buildPassiveComplement(true);
                    }
                }
            } else {
                this.surfaceSubject.addCoordinates(this.verbPhrase.getPassiveRaisingComplements());
                this.buildPassiveComplement(true);
            }
        } else if (this.interrogative && this.interrogType.isWhQuestion()) {
            switch (this.whArgument) {
                case SUBJECT: {
                    break;
                }
                case OBJECT: 
                case INDIRECT_OBJECT: {
                    this.verbPhrase.suppressArg(this.whArgument);
                    this.surfaceSubject.addCoordinates(this.subjects);
                }
            }
        } else {
            this.surfaceSubject.addCoordinates(this.subjects);
        }
    }

    protected void computeForm() {
        switch (this.getForm()) {
            case IMPERATIVE: {
                this.surfaceSubject.clearCoordinates();
                break;
            }
            case GERUND: {
                if (this.isSubordinateClause()) {
                    this.suppressComplementiser(true);
                }
                if (this.suppressGenitiveInGerund) break;
                for (Phrase p : this.surfaceSubject.coordinates) {
                    if (!(p instanceof NPPhraseSpec)) continue;
                    ((NPPhraseSpec)p).setPossessive(true);
                }
                break;
            }
            case INFINITIVE: {
                this.surfaceSubject.clearCoordinates();
                for (Phrase p : this.frontModifiers) {
                    this.verbPhrase.addPostmodifier(p);
                }
                this.frontModifiers.clear();
                break;
            }
        }
    }

    protected void computeVPAgreement() {
        Verb head = (Verb)this.verbPhrase.getHead();
        boolean copular = head == null ? false : head.isCopular();
        boolean expletiveSubj = this.isExpletiveSubject();
        boolean passive = this.isPassive();
        List<Phrase> agreeNP = null;
        agreeNP = copular && expletiveSubj && !passive ? this.verbPhrase.getComplements(DiscourseFunction.OBJECT) : this.surfaceSubject.getCoordinates();
        if (!this.verbPhrase.getForm().equals(Form.IMPERATIVE)) {
            this.verbPhrase.setPerson(this.getPersonFeature(agreeNP));
        }
        this.verbPhrase.setNumber(this.getNumberFeature(agreeNP));
        this.verbPhrase.setPerson(this.getPersonFeature(agreeNP));
    }

    protected Person getPersonFeature(List<Phrase> agreeNP) {
        Phrase agr;
        if (agreeNP.size() == 1 && (agr = agreeNP.get(0)) instanceof NPPhraseSpec) {
            return ((NPPhraseSpec)agr).getPerson();
        }
        return Person.THIRD;
    }

    protected NumberAgr getNumberFeature(List<Phrase> agreeNP) {
        if (agreeNP.size() == 1) {
            Phrase agr = agreeNP.get(0);
            if (agr instanceof NPPhraseSpec) {
                return ((NPPhraseSpec)agr).getNumber();
            }
            if (agr instanceof StringPhraseSpec && ((StringPhraseSpec)agr).isPlural()) {
                return NumberAgr.PLURAL;
            }
            if (agr.isCoordinate()) {
                return NumberAgr.PLURAL;
            }
        } else if (agreeNP.size() > 1) {
            return NumberAgr.PLURAL;
        }
        return NumberAgr.SINGULAR;
    }

    protected VPPhraseSpec fixAllFeatures(VPPhraseSpec newVP) {
        newVP.setForm(this.getForm());
        newVP.setModal(this.getModal());
        newVP.setNegated(this.isNegated());
        newVP.setTense(this.getTense());
        newVP.setPerfect(this.isPerfect());
        newVP.setPassive(this.isPassive());
        newVP.setProgressive(this.isProgressive());
        return newVP;
    }

    protected boolean isExpletiveSubject() {
        if (this.subjects.size() > 1) {
            return false;
        }
        if (this.subjects.size() == 1) {
            Phrase subjectNP = this.subjects.get(0);
            if (subjectNP instanceof NPPhraseSpec) {
                return ((NPPhraseSpec)subjectNP).isExpletive();
            }
            if (subjectNP instanceof StringPhraseSpec) {
                return ((StringPhraseSpec)subjectNP).getString().equals("there");
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SENTENCE: [");
        builder.append("Verb = ");
        if (this.verbPhrase != null) {
            Verb head = (Verb)this.verbPhrase.getHead();
            builder.append(head == null ? "null" : head.getBaseForm());
        }
        builder.append("]");
        return builder.toString();
    }
}

