/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.features.Category;
import simplenlg.features.Feature;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateAdjPhraseSpec;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.CoordinatePPPhraseSpec;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.CoordinateStringPhraseSpec;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;

public class PhraseFactory {
    public static StringPhraseSpec makeStringPhraseSpec(Category cat, String string) {
        StringPhraseSpec s = new StringPhraseSpec(string);
        if (cat != null) {
            s.setCategory(cat);
        }
        return s;
    }

    public static NPPhraseSpec makeNP(Object det, Object head, Object premodifier, Object postmodifier, Object complement) {
        NPPhraseSpec np = (NPPhraseSpec)PhraseFactory.makePhrase(Category.NOUN, head);
        if (np == null) {
            return np;
        }
        if (det != null) {
            np.setSpecifier(det);
        }
        np = (NPPhraseSpec)PhraseFactory.preModify(np, premodifier);
        np = (NPPhraseSpec)PhraseFactory.postModify(np, premodifier);
        np = (NPPhraseSpec)PhraseFactory.setComplement(np, premodifier);
        return np;
    }

    public static VPPhraseSpec makeVP(String head, Object premodifier, Object postmodifier, Object complement) {
        VPPhraseSpec vp = (VPPhraseSpec)PhraseFactory.makePhrase(Category.VERB, head);
        if (vp == null) {
            return vp;
        }
        vp = (VPPhraseSpec)PhraseFactory.preModify(vp, premodifier);
        vp = (VPPhraseSpec)PhraseFactory.postModify(vp, postmodifier);
        vp = (VPPhraseSpec)PhraseFactory.setComplement(vp, complement);
        return vp;
    }

    public static AdjPhraseSpec makeAdjP(String head, Object premodifier, Object postmodifier, Object complement) {
        AdjPhraseSpec phrase = (AdjPhraseSpec)PhraseFactory.makePhrase(Category.ADJECTIVE, head);
        if (phrase == null) {
            return phrase;
        }
        phrase = (AdjPhraseSpec)PhraseFactory.preModify(phrase, premodifier);
        phrase = (AdjPhraseSpec)PhraseFactory.postModify(phrase, postmodifier);
        phrase = (AdjPhraseSpec)PhraseFactory.setComplement(phrase, complement);
        return phrase;
    }

    public static PPPhraseSpec makePP(String head, Object complement) {
        PPPhraseSpec phrase = (PPPhraseSpec)PhraseFactory.makePhrase(Category.PREPOSITION, head);
        if (phrase == null) {
            return phrase;
        }
        phrase = (PPPhraseSpec)PhraseFactory.setComplement(phrase, complement);
        return phrase;
    }

    public static Phrase coordinate(Phrase phrase1, Phrase phrase2, Conjunction conj) {
        if (phrase1 == null) {
            return phrase2;
        }
        if (phrase2 == null) {
            return phrase1;
        }
        CoordinatePhrase result = null;
        if (PhraseFactory.areSameCategory(phrase1, phrase2)) {
            if (phrase1 instanceof NPPhraseSpec) {
                result = new CoordinateNPPhraseSpec((NPPhraseSpec)phrase1, (NPPhraseSpec)phrase2);
            } else if (phrase1 instanceof VPPhraseSpec) {
                result = new CoordinateVPPhraseSpec((VPPhraseSpec)phrase1, (VPPhraseSpec)phrase2);
            } else if (phrase1 instanceof PPPhraseSpec) {
                result = new CoordinatePPPhraseSpec((PPPhraseSpec)phrase1, (PPPhraseSpec)phrase2);
            } else if (phrase1 instanceof SPhraseSpec) {
                result = new CoordinateSPhraseSpec((SPhraseSpec)phrase1, (SPhraseSpec)phrase2);
            } else if (phrase1 instanceof AdjPhraseSpec) {
                result = new CoordinateAdjPhraseSpec((AdjPhraseSpec)phrase1, (AdjPhraseSpec)phrase2);
            } else if (phrase1 instanceof StringPhraseSpec) {
                result = new CoordinateStringPhraseSpec((StringPhraseSpec)phrase1, (StringPhraseSpec)phrase2);
            }
        }
        if (conj != null && result != null) {
            result.setConjunction(conj);
        }
        return result;
    }

    private static Phrase makePhrase(Category cat, Object head) {
        switch (cat) {
            case NOUN: {
                if (head instanceof Noun) {
                    return new NPPhraseSpec((Noun)head);
                }
                if (head instanceof String) {
                    return new NPPhraseSpec(new Noun((String)head));
                }
                return null;
            }
            case VERB: {
                if (head instanceof Verb) {
                    return new VPPhraseSpec((Verb)head);
                }
                if (head instanceof String) {
                    return new VPPhraseSpec(new Verb((String)head));
                }
                return null;
            }
            case ADJECTIVE: {
                if (head instanceof Adjective) {
                    return new AdjPhraseSpec((Adjective)head);
                }
                if (head instanceof String) {
                    return new AdjPhraseSpec(new Adjective((String)head));
                }
                return null;
            }
            case PREPOSITION: {
                if (head instanceof Preposition) {
                    return new PPPhraseSpec((Preposition)head);
                }
                if (head instanceof String) {
                    return new PPPhraseSpec(new Preposition((String)head));
                }
                return null;
            }
            case CLAUSE: {
                SPhraseSpec s = new SPhraseSpec();
                if (head instanceof Verb) {
                    s.setHead((Verb)head);
                    return s;
                }
                if (head instanceof String) {
                    s.setHead((String)head);
                    return s;
                }
                return null;
            }
        }
        return null;
    }

    private static HeadedPhraseSpec<?> preModify(HeadedPhraseSpec<?> spec, Object premodifier) {
        if (premodifier != null) {
            spec.setPremodifier(PhraseFactory.castToPhrase(premodifier));
        }
        return spec;
    }

    private static HeadedPhraseSpec<?> postModify(HeadedPhraseSpec<?> spec, Object postmodifier) {
        if (postmodifier != null) {
            spec.setPostmodifier(PhraseFactory.castToPhrase(postmodifier));
        }
        return spec;
    }

    private static HeadedPhraseSpec<?> setComplement(HeadedPhraseSpec<?> spec, Object complement) {
        if (complement != null) {
            spec.setComplement(PhraseFactory.castToPhrase(complement));
        }
        return spec;
    }

    private static boolean areSameCategory(Phrase phrase1, Phrase phrase2) {
        if (phrase1.getCategory() != phrase2.getCategory()) {
            return false;
        }
        return !(phrase1 instanceof SPhraseSpec) || phrase2 instanceof SPhraseSpec;
    }

    private static Phrase apply(Phrase spec, Feature f) {
        if (spec instanceof NPPhraseSpec) {
            NPPhraseSpec np = (NPPhraseSpec)spec;
            if (f instanceof NumberAgr) {
                np.setNumber((NumberAgr)f);
            } else if (f instanceof Gender) {
                np.setGender((Gender)f);
            } else if (f instanceof Person) {
                np.setPerson((Person)f);
            }
        } else if (spec instanceof VPPhraseSpec) {
            VPPhraseSpec vp = (VPPhraseSpec)spec;
            if (f instanceof NumberAgr) {
                vp.setNumber((NumberAgr)f);
            } else if (f instanceof Person) {
                vp.setPerson((Person)f);
            } else if (f instanceof Tense) {
                vp.setTense((Tense)f);
            }
        }
        return spec;
    }

    private static Phrase applyFeature(Phrase phrase, Feature ... feature) {
        Feature[] featureArray = feature;
        int n = feature.length;
        int n2 = 0;
        while (n2 < n) {
            Feature f = featureArray[n2];
            if (f.appliesTo(phrase.getCategory())) {
                phrase = PhraseFactory.apply(phrase, f);
            }
            ++n2;
        }
        return phrase;
    }

    private static PhraseSpec castToPhrase(Object o) {
        if (o instanceof String) {
            return new StringPhraseSpec((String)o);
        }
        return (PhraseSpec)o;
    }
}

