/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

public enum DocStructure {
    PHRASE,
    PHRASESET,
    SENTENCE,
    SENTENCESET,
    PARAGRAPH,
    PARAGRAPHSET,
    SUBSECTION,
    SECTION,
    DOCUMENT;


    public boolean isSentence() {
        return this == SENTENCE;
    }

    public boolean isParagraph() {
        return this == PARAGRAPH;
    }

    public boolean isSentenceOrLower() {
        return this.compareTo(SENTENCE) <= 0;
    }

    public boolean isSentenceComponent() {
        return this.compareTo(SENTENCE) < 0;
    }

    public DocStructure max(DocStructure d2) {
        if (this.compareTo(d2) > 0) {
            return this;
        }
        return d2;
    }

    public DocStructure next() {
        switch (this) {
            case PHRASE: {
                return PHRASESET;
            }
            case PHRASESET: {
                return SENTENCE;
            }
            case SENTENCE: {
                return SENTENCESET;
            }
            case SENTENCESET: {
                return PARAGRAPH;
            }
            case PARAGRAPH: {
                return PARAGRAPHSET;
            }
            case PARAGRAPHSET: {
                return SUBSECTION;
            }
            case SUBSECTION: {
                return SECTION;
            }
            case SECTION: {
                return DOCUMENT;
            }
            case DOCUMENT: {
                return DOCUMENT;
            }
        }
        return DOCUMENT;
    }

    public DocStructure previous() {
        switch (this) {
            case PHRASE: {
                return PHRASE;
            }
            case PHRASESET: {
                return PHRASE;
            }
            case SENTENCE: {
                return PHRASESET;
            }
            case SENTENCESET: {
                return SENTENCE;
            }
            case PARAGRAPH: {
                return SENTENCESET;
            }
            case PARAGRAPHSET: {
                return PARAGRAPH;
            }
            case SUBSECTION: {
                return PARAGRAPHSET;
            }
            case SECTION: {
                return SUBSECTION;
            }
            case DOCUMENT: {
                return SECTION;
            }
        }
        return PHRASE;
    }

    public DocStructure lowestParent() {
        switch (this) {
            case PHRASESET: {
                return PHRASESET;
            }
            case SENTENCESET: {
                return SENTENCESET;
            }
        }
        return this.next();
    }
}

