/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.Spec;

public class CoordinatePhraseSet<T extends Phrase> {
    List<T> coordinates = new ArrayList<T>();
    Conjunction conjunction = Constants.AND;
    Phrase parentPhrase;

    public CoordinatePhraseSet(T parent) {
        this.parentPhrase = parent;
    }

    public CoordinatePhraseSet(T parent, T ... coords) {
        this(parent);
        this.addCoordinates((Phrase[])coords);
    }

    public List<T> getCoordinates() {
        return this.coordinates;
    }

    public T getCoordinate(int index) {
        Iterator<T> iter = this.coordinates.iterator();
        int i = -1;
        Phrase result = null;
        while (iter.hasNext() && i <= index) {
            if (++i != index) continue;
            result = (Phrase)iter.next();
        }
        return (T)result;
    }

    public boolean hasCoordinates() {
        return !this.coordinates.isEmpty();
    }

    public void clearCoordinates() {
        this.coordinates.clear();
    }

    public void setCoordinates(T ... coords) {
        this.coordinates.clear();
        this.addCoordinates((Phrase[])coords);
    }

    public void addCoordinates(T ... coords) {
        T[] TArray = coords;
        int n = coords.length;
        int n2 = 0;
        while (n2 < n) {
            T coord = TArray[n2];
            ((Spec)coord).setParentSpec((Spec)((Object)this.parentPhrase));
            this.coordinates.add(coord);
            ++n2;
        }
    }

    public void addCoordinates(List<T> coords) {
        for (Phrase coord : coords) {
            if (this.coordinates.contains(coord)) continue;
            ((Spec)((Object)coord)).setParentSpec((Spec)((Object)this.parentPhrase));
            this.coordinates.add(coord);
        }
    }

    public void setConjunction(Conjunction c) {
        this.conjunction = c;
    }

    public void setConjunction(String c) {
        this.conjunction = Constants.getConjunction(c);
        if (this.conjunction == null) {
            this.conjunction = new Conjunction(c);
        }
    }

    public Conjunction getConjunction() {
        return this.conjunction;
    }

    public String getConjunctionAsString() {
        return this.conjunction.getBaseForm();
    }

    public int getCoordinateCount() {
        return this.coordinates.size();
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof CoordinatePhraseSet) {
            CoordinatePhraseSet c = (CoordinatePhraseSet)o;
            eq = c.conjunction.equals(this.conjunction) && c.coordinates.equals(this.coordinates);
        }
        return eq;
    }

    String realise(Realiser r) {
        return r.realiseConjunctList(this.getCoordinates(), this.conjunction.getBaseForm());
    }
}

