/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.List;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;

public class CoordinateNPPhraseSpec
extends NPPhraseSpec
implements CoordinatePhrase<NPPhraseSpec> {
    private CoordinatePhraseSet<NPPhraseSpec> coordinator;
    boolean containsPronoun = false;
    boolean wideScopeSpecifier = false;

    public CoordinateNPPhraseSpec(NPPhraseSpec ... coords) {
        this.coordinator = new CoordinatePhraseSet((Phrase)this, (Phrase[])coords);
    }

    @Override
    public void setConjunction(Conjunction coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public void setConjunction(String coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public Conjunction getConjunction() {
        return this.coordinator.getConjunction();
    }

    @Override
    public String getConjunctionAsString() {
        return this.coordinator.getConjunctionAsString();
    }

    public void addCoordinates(NPPhraseSpec ... coords) {
        this.coordinator.addCoordinates(coords);
    }

    public void setCoordinates(NPPhraseSpec ... coords) {
        this.coordinator.clearCoordinates();
        this.addCoordinates(coords);
    }

    @Override
    public List<NPPhraseSpec> getCoordinates() {
        return this.coordinator.getCoordinates();
    }

    @Override
    public boolean setSpecifier(Object spec) {
        return super.setSpecifier(spec);
    }

    public boolean setWideScopeSpecifier(boolean wideScope) {
        if (this.specifier != null) {
            this.wideScopeSpecifier = wideScope;
            return true;
        }
        return false;
    }

    public boolean raiseSpecifier() {
        List<NPPhraseSpec> coords = this.coordinator.getCoordinates();
        Object spec = coords.get(0).getSpecifier();
        if (spec == null) {
            return false;
        }
        int i = 1;
        while (i < this.coordinator.coordinates.size()) {
            NPPhraseSpec np = coords.get(i);
            Object nextSpec = np.getSpecifier();
            if (nextSpec == null || !nextSpec.equals(spec)) {
                return false;
            }
            ++i;
        }
        return this.setSpecifier(spec) && this.setWideScopeSpecifier(true);
    }

    @Override
    public Person getPerson() {
        return Person.THIRD;
    }

    private void checkPronoun(NPPhraseSpec ... coords) {
        this.containsPronoun = false;
        for (NPPhraseSpec np : this.coordinator.coordinates) {
            if (!np.isPronominal()) continue;
            this.containsPronoun = true;
            break;
        }
    }

    private void calculateNumber() {
        if (this.coordinator.getCoordinateCount() == 1) {
            this.setNumber(this.coordinator.getCoordinate(0).getNumber());
        } else if (!this.coordinator.getConjunction().getBaseForm().equalsIgnoreCase("or")) {
            this.setNumber(NumberAgr.PLURAL);
        } else {
            NumberAgr number = NumberAgr.SINGULAR;
            for (NPPhraseSpec np : this.coordinator.getCoordinates()) {
                if (!np.isPlural()) continue;
                number = NumberAgr.PLURAL;
                break;
            }
            this.setNumber(number);
        }
    }

    private void checkPossessive() {
        if (!this.possessive) {
            return;
        }
        if (this.containsPronoun) {
            for (NPPhraseSpec child : this.coordinator.coordinates) {
                child.setPossessive(true);
                this.possessive = false;
            }
        } else {
            for (NPPhraseSpec child : this.coordinator.coordinates) {
                child.setPossessive(false);
            }
        }
    }

    void checkSpecifiers() {
        if (this.specifier != null) {
            if (this.wideScopeSpecifier && !this.containsPronoun) {
                this.setChildSpecifier(null);
            } else {
                this.setChildSpecifier(this.specifier);
                this.wideScopeSpecifier = false;
            }
        }
    }

    private void setChildSpecifier(Object spec) {
        for (NPPhraseSpec child : this.coordinator.getCoordinates()) {
            child.setSpecifier(spec);
        }
    }

    @Override
    String realiseSpec(Realiser r, String agreementString) {
        if (this.wideScopeSpecifier) {
            return super.realiseSpec(r, agreementString);
        }
        return "";
    }

    @Override
    String realise(Realiser r) {
        this.checkPronoun(new NPPhraseSpec[0]);
        this.calculateNumber();
        this.checkPossessive();
        this.checkSpecifiers();
        return super.realise(r);
    }

    @Override
    String realiseHead(Realiser r) {
        String coord = this.coordinator.realise(r);
        return coord;
    }
}

