/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.realiser.CoordinateAdjPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.Phrase;

public class AdjPhraseSpec
extends HeadedPhraseSpec<Adjective> {
    NumberAgr number;

    public AdjPhraseSpec() {
        this.head = new Adjective("");
        this.number = NumberAgr.SINGULAR;
        this.category = Category.ADJECTIVE;
    }

    public AdjPhraseSpec(String adj) {
        this();
        this.setHead(adj);
    }

    public AdjPhraseSpec(Adjective adj) {
        this();
        this.setHead(adj);
    }

    public void setPlural(boolean plur) {
        this.number = plur ? NumberAgr.PLURAL : NumberAgr.SINGULAR;
    }

    public void setNumber(NumberAgr n) {
        this.number = n;
    }

    public boolean isPlural() {
        return this.number.equals(NumberAgr.PLURAL);
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    @Override
    public void setHead(String adj) {
        this.head = new Adjective(adj);
    }

    public AdjPhraseSpec coordinate(Phrase ... coords) {
        CoordinateAdjPhraseSpec coord = new CoordinateAdjPhraseSpec(this);
        if (coords.length == 0) {
            return this;
        }
        try {
            Phrase[] phraseArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Phrase p = phraseArray[n2];
                coord.addCoordinates((AdjPhraseSpec)p);
                ++n2;
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }
}

