/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import simplenlg.exception.LexiconException;
import simplenlg.features.Category;
import simplenlg.features.InflectionType;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.DerivationalRelation;
import simplenlg.lexicon.lexicalitems.LexicalItem;

public abstract class Word
implements LexicalItem,
Cloneable {
    String baseForm = "";
    String citationForm = "";
    String id;
    Category category;
    LexiconInterface parentLexicon = null;
    InflectionType inflectionType;
    Set<String> variants = new HashSet<String>();
    Map<DerivationalRelation, Set<LexicalItem>> derivations = new HashMap<DerivationalRelation, Set<LexicalItem>>();

    Word() {
    }

    public Word(String baseform) {
        this();
        if (baseform != null) {
            this.variants.add(baseform);
            this.citationForm = this.baseForm = baseform;
        }
    }

    public Word(String id, String baseform, String citationform) {
        this(baseform);
        this.id = id;
        this.citationForm = citationform;
    }

    @Deprecated
    public Word(String baseform, LexiconInterface lexicon) {
        this(baseform);
        this.parentLexicon = lexicon;
        this.parentLexicon.addItem(this);
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean hasID() {
        return this.id != null;
    }

    @Override
    public String getBaseForm() {
        return this.baseForm;
    }

    @Override
    public void setCitationForm(String s) {
        this.citationForm = s;
    }

    @Override
    public String getCitationForm() {
        return this.citationForm;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setParentLexicon(LexiconInterface lex) {
        this.parentLexicon = lex;
        this.parentLexicon.addItem(this);
    }

    @Override
    public LexiconInterface getParentLexicon() {
        return this.parentLexicon;
    }

    @Override
    public boolean hasInflectionType() {
        return this.inflectionType != null;
    }

    @Override
    public InflectionType getInflectionType() {
        return this.inflectionType;
    }

    @Override
    public void setInflectionType(InflectionType inflectionType) {
        if (inflectionType == null) {
            this.inflectionType = null;
        } else if (inflectionType.appliesTo(this.category)) {
            this.inflectionType = inflectionType;
        } else {
            throw new LexiconException("InflectionType " + inflectionType + " cannot apply to Lexical Items of category " + (Object)((Object)this.category));
        }
    }

    @Override
    public boolean isDLRegular() {
        return this.inflectionType == InflectionType.REG_DOUBLING;
    }

    @Override
    public boolean isRegular() {
        return this.inflectionType == InflectionType.REGULAR;
    }

    @Override
    public boolean isGLRegular() {
        return this.inflectionType == InflectionType.GL_REGULAR;
    }

    @Override
    public boolean isInvariant() {
        return this.inflectionType == InflectionType.INVARIANT;
    }

    public boolean isPeriphrastic() {
        return this.inflectionType == InflectionType.PERIPHRASTIC;
    }

    @Override
    public void addVariant(String variant) {
        this.variants.add(variant);
    }

    @Override
    public boolean hasVariant(String variant) {
        return this.variants.contains(variant);
    }

    @Override
    public Collection<String> getVariants() {
        return this.variants;
    }

    @Override
    public void addDerivationalRelation(DerivationalRelation rel, LexicalItem lex) {
        if (this.derivations.containsKey(rel)) {
            this.derivations.get(rel).add(lex);
        } else if (rel.appliesTo(this.category)) {
            HashSet<LexicalItem> set = new HashSet<LexicalItem>();
            set.add(lex);
            this.derivations.put(rel, set);
        } else {
            throw new LexiconException("Relation " + rel + " cannot apply to items of category " + (Object)((Object)this.category));
        }
    }

    @Override
    public boolean hasDerivationalRelation(DerivationalRelation rel) {
        return this.derivations.containsKey(rel);
    }

    @Override
    public boolean hasDerivationalRelation(DerivationalRelation rel, LexicalItem lex) {
        if (this.hasDerivationalRelation(rel)) {
            return this.derivations.get(rel).contains(lex);
        }
        return false;
    }

    @Override
    public Collection<LexicalItem> getDerivations(DerivationalRelation rel) {
        if (this.derivations.containsKey(rel)) {
            return this.derivations.get(rel);
        }
        return Collections.emptySet();
    }

    public String toString() {
        return String.valueOf(this.category.toString()) + "(" + this.baseForm + ")";
    }

    public Word clone() {
        try {
            return (Word)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof Word) {
            Word cw = (Word)o;
            if (this.baseForm != null && cw.baseForm != null) {
                eq = this.baseForm.equals(cw.baseForm) && this.category == cw.category;
            }
        }
        return eq;
    }
}

