/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.HashSet;
import java.util.Set;
import simplenlg.exception.LexiconException;
import simplenlg.features.Category;
import simplenlg.features.ComplementFrame;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.VerbType;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.morph.VerbInflection;
import simplenlg.lexicon.verbnet.VerbnetClass;
import simplenlg.lexicon.verbnet.VerbnetFrame;

public class Verb
extends ContentWord {
    String presentParticipleForm;
    String present_3SG;
    String pastTenseForm;
    String pastParticipleForm;
    String particle;
    VerbType type;
    Set<VerbnetClass> verbnetClasses;
    boolean allowsPassive;
    boolean allowsDative;
    boolean monotrans;
    boolean ditrans;
    boolean cplxtrans;
    boolean link;

    public Verb(String baseform) {
        if (baseform.indexOf(" ") > 0) {
            int spaceIndex = baseform.indexOf(" ");
            String p = baseform.substring(spaceIndex + 1);
            if (p.length() == 0 || baseform.length() == 0 || p.indexOf(" ") > 0) {
                throw new LexiconException("Impossible verb: " + baseform);
            }
            if (!p.equals("")) {
                this.setParticle(p);
            }
            this.baseForm = baseform.substring(0, spaceIndex);
        } else {
            this.baseForm = baseform;
        }
        this.setCitationForm(this.baseForm);
        this.category = Category.VERB;
        this.type = VerbType.MAIN;
        this.verbnetClasses = new HashSet<VerbnetClass>();
        this.allowsDative = false;
        this.allowsPassive = false;
        this.monotrans = false;
        this.ditrans = false;
        this.cplxtrans = false;
        this.link = false;
    }

    public Verb(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Verb(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    @Deprecated
    public Verb(String baseform, LexiconInterface lex) {
        this(baseform);
        this.parentLexicon = lex;
    }

    public void addVerbnetClass(VerbnetClass vnClass) {
    }

    public boolean hasVerbnetClass() {
        return !this.verbnetClasses.isEmpty();
    }

    public Set<VerbnetFrame> getVerbnetFrames() {
        HashSet<VerbnetFrame> frames = new HashSet<VerbnetFrame>();
        for (VerbnetClass vnClass : this.verbnetClasses) {
            frames.addAll(vnClass.getFrames());
        }
        return frames;
    }

    @Override
    public void addComplementFrame(ComplementFrame frame) {
        super.addComplementFrame(frame);
        if (frame.allowsDativeShift()) {
            this.allowsDative = true;
        }
        if (frame.allowsPassive()) {
            this.allowsPassive = true;
        }
        switch (frame.getTransitivity()) {
            case MONOTRANS: {
                this.monotrans = true;
                break;
            }
            case DITRANS: {
                this.ditrans = true;
                break;
            }
            case COMPLEX_TRANS: {
                this.cplxtrans = true;
                break;
            }
            case LINKING: {
                this.link = true;
            }
        }
    }

    public boolean allowsPassiveRaising() {
        return this.allowsPassive;
    }

    public boolean allowsDativeShift() {
        return this.allowsDative;
    }

    public void setParticle(String part) {
        this.particle = part;
    }

    public void setParticle(LexicalItem part) {
        this.particle = part.getBaseForm();
    }

    public String getParticle() {
        return this.particle;
    }

    @Override
    public String getBaseForm() {
        return this.render(this.baseForm);
    }

    public String getBaseform(boolean includeParticle) {
        if (includeParticle) {
            return this.render(this.baseForm);
        }
        return this.baseForm;
    }

    public boolean isPhrasalVerb() {
        return this.particle != null;
    }

    public boolean isCopular() {
        return this.baseForm.equalsIgnoreCase("be");
    }

    @Deprecated
    public void setIsNullAffixVerb(boolean neverInflected) {
        if (neverInflected) {
            this.pastParticipleForm = this.baseForm;
            this.pastTenseForm = this.baseForm;
            this.present_3SG = this.baseForm;
            this.presentParticipleForm = this.baseForm;
        }
        this.inflectionType = InflectionType.INVARIANT;
    }

    @Deprecated
    public boolean isNullAffixVerb() {
        return this.inflectionType == InflectionType.INVARIANT;
    }

    @Override
    public void setInflectionType(InflectionType t) {
        super.setInflectionType(t);
        if (t.equals(InflectionType.INVARIANT)) {
            this.pastParticipleForm = this.baseForm;
            this.pastTenseForm = this.baseForm;
            this.present_3SG = this.baseForm;
            this.presentParticipleForm = this.baseForm;
        }
    }

    public void setVerbType(VerbType type) {
        this.type = type;
        if (this.type == VerbType.MODAL) {
            this.setInflectionType(InflectionType.INVARIANT);
        }
    }

    public VerbType getVerbType() {
        return this.type;
    }

    public boolean isModalVerb() {
        return this.type.equals(VerbType.MODAL);
    }

    public boolean isAuxiliaryVerb() {
        return this.type.equals(VerbType.AUX);
    }

    public String getPastParticiple() {
        if (this.pastParticipleForm == null) {
            this.pastParticipleForm = VerbInflection.PAST_PARTICIPLE.apply(this);
        }
        return this.render(this.pastParticipleForm);
    }

    public void setPastParticiple(String ppart) {
        this.pastParticipleForm = ppart;
    }

    public String getPresentParticiple() {
        if (this.presentParticipleForm == null) {
            this.presentParticipleForm = VerbInflection.ING_FORM.apply(this);
        }
        return this.render(this.presentParticipleForm);
    }

    public void setPresentParticiple(String presPart) {
        this.presentParticipleForm = presPart;
    }

    public String getPast() {
        if (this.pastTenseForm == null) {
            this.pastTenseForm = VerbInflection.PAST_TENSE.apply(this);
        }
        return this.render(this.pastTenseForm);
    }

    public void setPast(String pst) {
        this.pastTenseForm = pst;
    }

    public String getPresent3SG() {
        if (this.present_3SG == null) {
            this.present_3SG = VerbInflection.PRESENT_TENSE.apply(this);
        }
        return this.render(this.present_3SG);
    }

    public void setPresent3SG(String pres) {
        this.present_3SG = pres;
    }

    public String getPresent(Person p, NumberAgr n) {
        if (p == Person.THIRD && n == NumberAgr.SINGULAR) {
            return this.getPresent3SG();
        }
        if (this.baseForm.equalsIgnoreCase("be")) {
            if (n == NumberAgr.SINGULAR) {
                switch (p) {
                    case FIRST: {
                        return this.render("am");
                    }
                    case SECOND: {
                        return this.render("are");
                    }
                    case THIRD: {
                        return this.render("is");
                    }
                }
                return "";
            }
            return this.render("are");
        }
        return this.render(this.baseForm);
    }

    public String getPast(Person p, NumberAgr n) {
        if (this.baseForm.equalsIgnoreCase("be")) {
            switch (n) {
                case SINGULAR: {
                    switch (p) {
                        case FIRST: 
                        case THIRD: {
                            return this.render("was");
                        }
                        case SECOND: {
                            return this.render("were");
                        }
                    }
                    return "";
                }
            }
            return this.render("were");
        }
        return this.getPast();
    }

    public String getSubjunctive() {
        if (this.baseForm.equalsIgnoreCase("be")) {
            return this.render("were");
        }
        return this.getPast();
    }

    public String getInfinitive() {
        return "to " + this.render(this.baseForm);
    }

    public boolean isIntransitive() {
        return !this.monotrans && !this.ditrans && !this.cplxtrans;
    }

    public boolean isMonotransitive() {
        return this.monotrans;
    }

    public boolean isDitransitive() {
        return this.ditrans;
    }

    public boolean isComplextransitive() {
        return this.cplxtrans;
    }

    public boolean isLinkingVerb() {
        return this.link;
    }

    public int getNumComplements() {
        return this.complementationFrames.size();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            Verb v = (Verb)o;
            return this.particle == v.particle || this.particle.equals(v.particle);
        }
        return false;
    }

    private String render(String morphForm) {
        return this.isPhrasalVerb() ? String.valueOf(morphForm) + " " + this.particle : morphForm;
    }
}

