/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Deixis;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Polarity;
import simplenlg.features.Possession;
import simplenlg.features.Quantification;
import simplenlg.features.Reflexivity;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Noun;

public class Pronoun
extends Noun {
    Polarity polarity;
    Quantification quantification;
    Possession possession;
    Reflexivity reflexivity;
    Deixis deixis;
    Case caseValue;
    Person person = Person.THIRD;
    NumberAgr number = NumberAgr.SINGULAR;
    Gender gender = null;
    String objectForm;
    boolean expletive;

    public Pronoun(String base) {
        super(base);
        this.category = Category.PRONOUN;
        this.expletive = false;
        this.inflectionType = InflectionType.INVARIANT;
        this.agreement = Agreement.COUNT;
        this.caseValue = Case.NOM_ACC;
        this.possession = null;
        this.reflexivity = Reflexivity.NON_REFLEXIVE;
        this.quantification = Quantification.DEFINITE;
        this.deixis = Deixis.NON_DEMONSTRATIVE;
    }

    public Pronoun(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Pronoun(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    @Deprecated
    public Pronoun(String base, LexiconInterface lex) {
        this(base);
        this.parentLexicon = lex;
    }

    public Pronoun(String base, Person p, NumberAgr n, Gender g) {
        this(base);
        this.person = p;
        this.number = n;
        this.gender = g;
    }

    public Pronoun(String base, Case c, Person p, NumberAgr n, Gender g) {
        this(base);
        this.caseValue = c;
        this.person = p;
        this.number = n;
        this.gender = g;
    }

    @Deprecated
    public Pronoun(String base, String objform, Person p, NumberAgr n, Gender g) {
        this(base, p, n, g);
        this.objectForm = objform;
    }

    public Pronoun(String base, Person p, NumberAgr n, Gender g, boolean expl) {
        this(base, p, n, g);
        this.expletive = expl;
    }

    @Deprecated
    public Pronoun(String base, String objform, Person p, NumberAgr n, Gender g, boolean expl) {
        this(base, objform, p, n, g);
        this.expletive = expl;
    }

    public Person getPerson() {
        return this.person;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    @Deprecated
    public String getForm(DiscourseFunction function) {
        switch (function) {
            case OBJECT: 
            case INDIRECT_OBJECT: 
            case PREP_OBJECT: {
                if (this.objectForm == null) break;
                return this.objectForm;
            }
        }
        return this.baseForm;
    }

    public String getPredicativeForm() {
        return this.objectForm;
    }

    @Deprecated
    public static Pronoun getPersonalPronoun(Person p, NumberAgr n, Gender g) {
        return Constants.getPersonalPronoun(p, n, g);
    }

    @Deprecated
    public static Pronoun getPossessivePronoun(Person p, NumberAgr n, Gender g) {
        return Constants.getPossessivePronoun(p, n, g);
    }

    @Deprecated
    public static Pronoun getPronoun(String baseform) {
        return Constants.getPronoun(baseform);
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
    }

    public Quantification getQuantification() {
        return this.quantification;
    }

    public void setQuantification(Quantification quantification) {
        this.quantification = quantification;
    }

    public Possession getPossession() {
        return this.possession;
    }

    public void setPossession(Possession possession) {
        this.possession = possession;
    }

    public Reflexivity getReflexivity() {
        return this.reflexivity;
    }

    public void setReflexivity(Reflexivity reflexivity) {
        this.reflexivity = reflexivity;
    }

    public Deixis getDeixis() {
        return this.deixis;
    }

    public void setDeixis(Deixis deixis) {
        this.deixis = deixis;
    }

    public Case getCaseValue() {
        return this.caseValue;
    }

    public void setCaseValue(Case caseValue) {
        this.caseValue = caseValue;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setExpletive(boolean expletive) {
        this.expletive = expletive;
    }

    public boolean isExpletive() {
        return this.expletive;
    }
}

