/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.exception.LexiconException;
import simplenlg.features.Agreement;
import simplenlg.features.Category;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.morph.NounInflection;

public class Noun
extends ContentWord {
    String pluralForm;
    Agreement agreement;

    public Noun(String baseform) {
        super(baseform);
        this.category = Category.NOUN;
        this.agreement = null;
    }

    public Noun(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Noun(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public String getPlural() {
        if (this.pluralForm == null) {
            this.pluralForm = NounInflection.PLURAL.apply(this.baseForm);
        }
        return this.pluralForm;
    }

    public void setPlural(String plur) {
        this.pluralForm = plur;
    }

    public Agreement getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Agreement agr) {
        if (!agr.appliesTo(this.category)) {
            throw new LexiconException(agr + " cannot be applied to category NOUN");
        }
        this.agreement = agr;
    }

    public boolean isCountNoun() {
        return this.agreement == Agreement.COUNT;
    }

    public boolean isMassNoun() {
        return this.agreement == Agreement.MASS;
    }

    public boolean isGroupNoun() {
        return this.agreement == Agreement.GROUP;
    }

    public boolean isFixedPluralNoun() {
        return this.agreement == Agreement.FIXED_PLUR;
    }

    public boolean isFixedSingularNoun() {
        return this.agreement == Agreement.FIXED_SING;
    }
}

