/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Agreement;
import simplenlg.features.Category;
import simplenlg.features.Deixis;
import simplenlg.features.Quantification;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Word;

public class Determiner
extends Word {
    private static final String ACRONYM_AN_LETTERS = "AEFHILMNORSX";
    Deixis deixis;
    Quantification quantification;
    Agreement agreement;

    public Determiner(String baseform) {
        super(baseform);
        this.category = Category.DETERMINER;
    }

    public Determiner(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Determiner(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    @Deprecated
    public Determiner(String baseform, boolean definite) {
        this(baseform);
    }

    public boolean isDefinite() {
        return this.quantification == Quantification.DEFINITE;
    }

    public Deixis getDeixis() {
        return this.deixis;
    }

    public void setDeixis(Deixis deixis) {
        this.deixis = deixis;
    }

    public Quantification getQuantification() {
        return this.quantification;
    }

    public void setQuantification(Quantification quantification) {
        this.quantification = quantification;
    }

    public Agreement getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Agreement agreement) {
        this.agreement = agreement;
    }

    public String getForm(String phonAgreementString) {
        if (this.baseForm.equals("a")) {
            char firstChar = phonAgreementString.charAt(0);
            if (Character.isLowerCase(firstChar)) {
                if (firstChar == 'a' || firstChar == 'e' || firstChar == 'i' || firstChar == 'o' || firstChar == 'u') {
                    return "an";
                }
                if (firstChar == 'x' && phonAgreementString.charAt(1) == '-') {
                    return "an";
                }
            } else if (ACRONYM_AN_LETTERS.indexOf(firstChar) >= 0) {
                return "an";
            }
        }
        return this.baseForm;
    }

    @Deprecated
    public static Determiner getDeterminer(String word) {
        return Constants.getDeterminer(word);
    }
}

