/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Case;
import simplenlg.features.ConjunctionType;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;

public class Constants {
    public static final Conjunction AND = new Conjunction("and", ConjunctionType.COORDINATING);
    public static final Conjunction OR = new Conjunction("or", ConjunctionType.COORDINATING);
    public static final Conjunction BUT = new Conjunction("but", ConjunctionType.SUBORDINATING);
    public static final Conjunction BECAUSE = new Conjunction("because", ConjunctionType.SUBORDINATING);
    public static final Conjunction[] ALL_CONJUNCTIONS = new Conjunction[]{AND, OR, BUT, BECAUSE};
    public static final Pronoun PRO_1SG_NOM = new Pronoun("I", Case.NOMINATIVE, Person.FIRST, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_1SG_ACC = new Pronoun("me", Case.ACCUSATIVE, Person.FIRST, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_2SG_NOM = new Pronoun("you", Case.NOMINATIVE, Person.SECOND, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_2SG_ACC = new Pronoun("you", Case.ACCUSATIVE, Person.SECOND, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_3SGM_NOM = new Pronoun("he", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun PRO_3SGM_ACC = new Pronoun("him", Case.ACCUSATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun PRO_3SGF_NOM = new Pronoun("she", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun PRO_3SGF_ACC = new Pronoun("her", Case.ACCUSATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun PRO_1PL_NOM = new Pronoun("we", Case.NOMINATIVE, Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun PRO_1PL_ACC = new Pronoun("us", Case.ACCUSATIVE, Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun PRO_2PL = new Pronoun("you", Case.NOM_ACC, Person.SECOND, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun PRO_3SG_NOM = new Pronoun("it", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_3SG_ACC = new Pronoun("it", Case.ACCUSATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_3PL_NOM = new Pronoun("they", Case.NOMINATIVE, Person.THIRD, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun PRO_3PL_ACC = new Pronoun("them", Case.ACCUSATIVE, Person.THIRD, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_1SG = new Pronoun("my", Case.NOMINATIVE, Person.FIRST, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun POSS_2SG = new Pronoun("your", Case.NOMINATIVE, Person.SECOND, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun POSS_3SGM = new Pronoun("his", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun POSS_3SGF = new Pronoun("her", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun POSS_1PL = new Pronoun("our", Case.NOMINATIVE, Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_2PL = new Pronoun("your", Case.NOMINATIVE, Person.SECOND, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_3PL = new Pronoun("their", Case.NOMINATIVE, Person.THIRD, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_3SG = new Pronoun("its", Case.NOMINATIVE, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun POSS_1SG_NOM_ACC = new Pronoun("mine", Case.NOM_ACC, Person.FIRST, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun POSS_2SG_NOM_ACC = new Pronoun("yours", Case.NOM_ACC, Person.SECOND, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun POSS_3SGM_NOM_ACC = new Pronoun("his", Case.NOM_ACC, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun POSS_3SGF_NOM_ACC = new Pronoun("hers", Case.NOM_ACC, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun POSS_1PL_NOM_ACC = new Pronoun("ours", Case.NOM_ACC, Person.FIRST, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_2PL_NOM_ACC = new Pronoun("yours", Case.NOM_ACC, Person.SECOND, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_3PL_NOM_ACC = new Pronoun("theirs", Case.NOM_ACC, Person.THIRD, NumberAgr.PLURAL, Gender.NEUTER);
    public static final Pronoun POSS_3SG_NOM_ACC = new Pronoun("its", Case.NOM_ACC, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun EXPLETIVE_THERE = new Pronoun("there", Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER, true);
    public static final Pronoun EXPLETIVE_IT = new Pronoun("it", Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER, true);
    public static final Pronoun[] PERSONAL_PRONOUNS = new Pronoun[]{PRO_1SG_NOM, PRO_1SG_ACC, PRO_2SG_NOM, PRO_2SG_ACC, PRO_3SG_NOM, PRO_3SG_ACC, PRO_3SGF_NOM, PRO_3SGF_ACC, PRO_3SGM_NOM, PRO_3SGM_ACC, PRO_1PL_NOM, PRO_1PL_ACC, PRO_2PL, PRO_3PL_NOM, PRO_3PL_ACC};
    public static final Pronoun[] POSSESSIVE_PRONOUNS = new Pronoun[]{POSS_1SG, POSS_2SG, POSS_3SG, POSS_3SGF, POSS_3SGM, POSS_1PL, POSS_2PL, POSS_3PL, POSS_1SG_NOM_ACC, POSS_2SG_NOM_ACC, POSS_3SG_NOM_ACC, POSS_3SGF_NOM_ACC, POSS_3SGM_NOM_ACC, POSS_1PL_NOM_ACC, POSS_2PL_NOM_ACC, POSS_3PL_NOM_ACC};
    public static final Pronoun[] ALL_PRONOUNS = new Pronoun[]{PRO_1SG_NOM, PRO_1SG_ACC, PRO_2SG_NOM, PRO_2SG_ACC, PRO_3SG_NOM, PRO_3SG_ACC, PRO_3SGF_NOM, PRO_3SGF_ACC, PRO_3SGM_NOM, PRO_3SGM_ACC, PRO_1PL_NOM, PRO_1PL_ACC, PRO_2PL, PRO_3PL_NOM, PRO_3PL_ACC, POSS_1SG, POSS_2SG, POSS_3SG, POSS_3SGF, POSS_3SGM, POSS_1PL, POSS_2PL, POSS_2SG_NOM_ACC, POSS_3SG_NOM_ACC, POSS_3SGF_NOM_ACC, POSS_3SGM_NOM_ACC, POSS_1PL_NOM_ACC, POSS_2PL_NOM_ACC, POSS_3PL_NOM_ACC, POSS_3PL, EXPLETIVE_THERE, EXPLETIVE_IT};
    public static Determiner DEFINITE = new Determiner("the");
    public static Determiner INDEFINITE_SG = new Determiner("a");
    public static Determiner INDEFINITE_PL = new Determiner("some");
    public static final Determiner[] ALL_DETERMINERS = new Determiner[]{DEFINITE, INDEFINITE_SG, INDEFINITE_PL};
    public static final Preposition IN = new Preposition("in");
    public static final Preposition ON = new Preposition("on");
    public static final Preposition INTO = new Preposition("into");
    public static final Preposition TO = new Preposition("to");
    public static final Preposition FROM = new Preposition("from");
    public static final Preposition WITH = new Preposition("with");
    public static final Preposition FOR = new Preposition("for");
    public static final Preposition[] ALL_PREPS = new Preposition[]{IN, ON, INTO, TO, FROM, WITH, FOR};

    public static Pronoun getPersonalPronoun(Person p, NumberAgr n, Gender g) {
        Pronoun[] pronounArray = ALL_PRONOUNS;
        int n2 = ALL_PRONOUNS.length;
        int n3 = 0;
        while (n3 < n2) {
            Pronoun pro = pronounArray[n3];
            if (pro.getGender() == g && pro.getNumber() == n && pro.getPerson() == p && (pro.getCaseValue() == Case.NOMINATIVE || pro.getCaseValue() == Case.NOM_ACC)) {
                return pro;
            }
            ++n3;
        }
        return null;
    }

    public static Pronoun getPersonalPronoun(Person p, NumberAgr n, Gender g, Case c) {
        Pronoun[] pronounArray = ALL_PRONOUNS;
        int n2 = ALL_PRONOUNS.length;
        int n3 = 0;
        while (n3 < n2) {
            Pronoun pro = pronounArray[n3];
            if (pro.getGender() == g && pro.getNumber() == n && pro.getPerson() == p && pro.getCaseValue() == c) {
                return pro;
            }
            ++n3;
        }
        return null;
    }

    public static Pronoun getPossessivePronoun(Person p, NumberAgr n, Gender g) {
        Pronoun[] pronounArray = POSSESSIVE_PRONOUNS;
        int n2 = POSSESSIVE_PRONOUNS.length;
        int n3 = 0;
        while (n3 < n2) {
            Pronoun pro = pronounArray[n3];
            if (pro.getPerson() == p && pro.getGender() == g && pro.getNumber() == n) {
                return pro;
            }
            ++n3;
        }
        return null;
    }

    public static Pronoun getPossessivePronoun(Person p, NumberAgr n, Gender g, Case c) {
        Pronoun[] pronounArray = POSSESSIVE_PRONOUNS;
        int n2 = POSSESSIVE_PRONOUNS.length;
        int n3 = 0;
        while (n3 < n2) {
            Pronoun pro = pronounArray[n3];
            if (pro.getPerson() == p && pro.getGender() == g && pro.getNumber() == n && pro.getCaseValue() == c) {
                return pro;
            }
            ++n3;
        }
        return null;
    }

    public static Pronoun getPronoun(String baseform) {
        if (baseform != null) {
            Pronoun[] pronounArray = ALL_PRONOUNS;
            int n = ALL_PRONOUNS.length;
            int n2 = 0;
            while (n2 < n) {
                Pronoun p = pronounArray[n2];
                if (baseform.equalsIgnoreCase(p.baseForm)) {
                    return p;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Pronoun getPronoun(Person p, NumberAgr n, Gender g, Case c, boolean possessive) {
        if (possessive) {
            if (c == Case.ACCUSATIVE) {
                return Constants.getPossessivePronoun(p, n, g, Case.NOM_ACC);
            }
            return Constants.getPossessivePronoun(p, n, g, c);
        }
        return Constants.getPersonalPronoun(p, n, g, c);
    }

    public static Conjunction getConjunction(String s) {
        if (s.equalsIgnoreCase("and")) {
            return AND;
        }
        if (s.equalsIgnoreCase("or")) {
            return OR;
        }
        if (s.equalsIgnoreCase("but")) {
            return BUT;
        }
        if (s.equalsIgnoreCase("because")) {
            return BECAUSE;
        }
        return null;
    }

    public static Determiner getDeterminer(String word) {
        if (word.equalsIgnoreCase("the")) {
            return DEFINITE;
        }
        if (word.equalsIgnoreCase("a") || word.equalsIgnoreCase("an")) {
            return INDEFINITE_SG;
        }
        if (word.equalsIgnoreCase("some")) {
            return INDEFINITE_PL;
        }
        return null;
    }

    public static Preposition getPreposition(String baseform) {
        Preposition[] prepositionArray = ALL_PREPS;
        int n = ALL_PREPS.length;
        int n2 = 0;
        while (n2 < n) {
            Preposition p = prepositionArray[n2];
            if (p.baseForm.equalsIgnoreCase(baseform)) {
                return p;
            }
            ++n2;
        }
        return null;
    }
}

