/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.db;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import simplenlg.exception.LexiconException;
import simplenlg.features.AdjectivePosition;
import simplenlg.features.AdjectiveType;
import simplenlg.features.AdverbPosition;
import simplenlg.features.AdverbType;
import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.ComplementFrame;
import simplenlg.features.ComplementSlot;
import simplenlg.features.ComplementType;
import simplenlg.features.ConjunctionType;
import simplenlg.features.Deixis;
import simplenlg.features.Gender;
import simplenlg.features.InflectionType;
import simplenlg.features.InterpretationCode;
import simplenlg.features.Polarity;
import simplenlg.features.Possession;
import simplenlg.features.Quantification;
import simplenlg.features.Reflexivity;
import simplenlg.features.Transitivity;
import simplenlg.features.VerbType;
import simplenlg.lexicon.DatabaseBackedLexicon;
import simplenlg.lexicon.db.DBAccessor;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Adverb;
import simplenlg.lexicon.lexicalitems.Complementiser;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.DerivationalRelation;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.verbnet.VerbnetClass;
import simplenlg.lexicon.verbnet.VerbnetFrame;
import simplenlg.lexicon.verbnet.VerbnetSlotType;

public class SQLAccessor
implements DBAccessor {
    private Connection con;
    private String url;
    private String username;
    private String password;
    private String driver;
    String ppRegex = "pphr\\((\\w+),np(\\([\\w\\s]+\\))?\\)";
    String cppRegex = "^pphr\\((\\w+),np(\\([\\w\\s]+\\))?," + this.ppRegex + "\\)$";
    private Matcher cppMatcher;
    private boolean connected;
    private DatabaseBackedLexicon lexicon;
    PreparedStatement reset;
    PreparedStatement getEntryByCatBaseform;
    PreparedStatement getEntryByID;
    PreparedStatement getEntryByBaseform;
    PreparedStatement getAllEntries;
    PreparedStatement getEntriesByCategory;
    PreparedStatement getDerivations;
    PreparedStatement complement;
    PreparedStatement adjFeature;
    PreparedStatement advFeature;
    PreparedStatement detFeature;
    PreparedStatement conjFeature;
    PreparedStatement proFeature;
    PreparedStatement getVerbFrames;
    DocumentBuilder builder;
    XPath xpath;

    public SQLAccessor() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xpath = XPathFactory.newInstance().newXPath();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Could not instantiate an XML document builder!");
        }
        this.con = null;
        this.url = null;
        this.username = null;
        this.password = null;
        this.driver = null;
        this.connected = false;
        this.lexicon = null;
        this.cppMatcher = Pattern.compile(this.cppRegex).matcher("");
    }

    public SQLAccessor(String driver, String url, String user, String pw) {
        this();
        this.setDriver(driver);
        this.setUrl(url);
        this.setUsername(user);
        this.setPassword(pw);
    }

    @Override
    public void setLexicon(DatabaseBackedLexicon lex) {
        this.lexicon = lex;
    }

    @Override
    public boolean hasLexicon() {
        return this.lexicon != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driverClass) {
        this.driver = driverClass;
    }

    @Override
    public void connect() throws ClassNotFoundException, SQLException {
        Class.forName(this.driver);
        this.con = DriverManager.getConnection(this.url, this.username, this.password);
        this.connected = true;
        this.getEntryByID = this.con.prepareStatement("select e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.euid=?");
        this.getEntryByBaseform = this.con.prepareStatement("select e.euid, e.category, e.hasComp, e.infl, e.agr from entries e where e.baseform=?");
        this.getAllEntries = this.con.prepareStatement("select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e");
        this.complement = this.con.prepareStatement("select c.transitivity, c.comp1, c.comp1Restr, c.comp2, c.comp2Restr, c.gRestr1, c.gRestr2 from complements c where c.euid=?");
        this.adjFeature = this.con.prepareStatement("select a.positions, a.stative from adjectives a where a.euid=?");
        this.advFeature = this.con.prepareStatement("select a.positions, a.polarity from adverbs a where a.euid=?");
        this.detFeature = this.con.prepareStatement("select d.detType from determiners d where d.euid=?");
        this.conjFeature = this.con.prepareStatement("select c.conjType, c.argType from conjunctions c where c.euid=?");
        this.proFeature = this.con.prepareStatement("select p.gender, p.case1, p.possession, p.quantification, p.pronType from pronouns p where p.euid=?");
        this.getEntryByCatBaseform = this.con.prepareStatement("select e.euid, e.hasComp, e.infl, e.agr from entries e where e.category=? and e.baseform=?");
        this.getDerivations = this.con.prepareStatement("select neuid, relation from derivations d where d.euid=?");
        this.getVerbFrames = this.con.prepareStatement("select r.euid, c.class, c.superclass, d.frameid, d.description1, d.description2, d.syntax from vnframeref r left join vnclass c on (c.classid = r.classid) left join vnframedef d on(r.frameid = d.frameid) where r.quality = 1 order by c.classid");
    }

    public void disconnect() throws SQLException {
        this.con.close();
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void loadData() throws SQLException, ClassNotFoundException {
        this.loadData(Category.values());
    }

    @Override
    public void loadData(Category ... categories) throws SQLException, ClassNotFoundException {
        this.checkConnection();
        Category[] categoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Category c = categoryArray[n2];
            switch (c) {
                case NOUN: {
                    this.loadNouns();
                    break;
                }
                case VERB: {
                    this.loadVerbs();
                    break;
                }
                case ADJECTIVE: {
                    this.loadAdjectives();
                    break;
                }
                case ADVERB: {
                    this.loadAdverbs();
                    break;
                }
                case COMPLEMENTISER: {
                    this.loadComplementisers();
                    break;
                }
                case CONJUNCTION: {
                    this.loadConjunctions();
                    break;
                }
                case DETERMINER: {
                    this.loadDeterminers();
                    break;
                }
                case PREPOSITION: {
                    this.loadPrepositions();
                    break;
                }
                case PRONOUN: {
                    this.loadPronouns();
                }
            }
            ++n2;
        }
    }

    public void loadVerbs() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where( e.category=\"verb\" or e.category=\"aux\" or e.category=\"modal\" )";
        PreparedStatement verbs = this.con.prepareStatement(query);
        if (verbs.execute()) {
            ResultSet results = verbs.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                boolean hasComp = results.getBoolean("hasComp");
                Verb v = null;
                if (this.lexicon.hasItemID(id)) {
                    v = (Verb)this.lexicon.getItemByID(id);
                }
                if (v == null) {
                    String baseform = results.getString("baseform");
                    v = new Verb(id, baseform);
                    v.setVerbType(this.getVerbType(results.getString("category")));
                    v.setInflectionType(this.getInflectionCode(results.getString("infl")));
                }
                if (hasComp) {
                    v = (Verb)this.addComplements(v);
                }
                this.lexicon.addItem(v);
            }
        }
    }

    public void loadNouns() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where( e.category=\"noun\" );";
        PreparedStatement nouns = this.con.prepareStatement(query);
        if (nouns.execute()) {
            ResultSet results = nouns.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                boolean hasComp = results.getBoolean("hasComp");
                Noun n = null;
                if (this.lexicon.hasItemID(id)) {
                    n = (Noun)this.lexicon.getItemByID(id);
                }
                if (n == null) {
                    String baseform = results.getString("baseform");
                    n = new Noun(id, baseform);
                    n.setInflectionType(this.getInflectionCode(results.getString("infl")));
                    n.setAgreement(this.getAgreementCode(results.getString("agr")));
                }
                if (hasComp) {
                    n = (Noun)this.addComplements(n);
                }
                this.loadDerivations(n);
                this.lexicon.addItem(n);
            }
        }
    }

    public void loadAdjectives() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where( e.category=\"adj\" );";
        PreparedStatement adjectives = this.con.prepareStatement(query);
        if (adjectives.execute()) {
            ResultSet results = adjectives.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                boolean hasComp = results.getBoolean("hasComp");
                Adjective a = null;
                if (this.lexicon.hasItemID(id)) {
                    a = (Adjective)this.lexicon.getItemByID(id);
                }
                if (a == null) {
                    String baseform = results.getString("baseform");
                    InflectionType infl = this.getInflectionCode(results.getString("infl"));
                    a = new Adjective(id, baseform);
                    a.setInflectionType(infl);
                    a = this.addAdjFeatures(a);
                }
                if (hasComp) {
                    a = (Adjective)this.addComplements(a);
                }
                this.lexicon.addItem(a);
            }
        }
    }

    public void loadAdverbs() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where( e.category=\"adv\" );";
        PreparedStatement adverbs = this.con.prepareStatement(query);
        if (adverbs.execute()) {
            ResultSet results = adverbs.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                boolean hasComp = results.getBoolean("hasComp");
                Adverb a = null;
                if (this.lexicon.hasItemID(id)) {
                    a = (Adverb)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString("baseform");
                    a = new Adverb(id, baseform);
                    a.setInflectionType(this.getInflectionCode(results.getString("infl")));
                    a = this.addAdverbFeatures(a);
                }
                if (hasComp) {
                    a = (Adverb)this.addComplements(a);
                }
                this.lexicon.addItem(a);
            }
        }
    }

    public void loadPrepositions() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.category=\"prep\";";
        PreparedStatement prepositions = this.con.prepareStatement(query);
        if (prepositions.execute()) {
            ResultSet results = prepositions.getResultSet();
            while (results.next()) {
                String id = results.getString(1);
                Preposition p = null;
                if (this.lexicon.hasItemID(id)) {
                    p = (Preposition)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString(2);
                    p = new Preposition(id, baseform);
                    p.setInflectionType(this.getInflectionCode(results.getString("infl")));
                }
                this.lexicon.addItem(p);
            }
        }
    }

    public void loadComplementisers() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.category=\"compl\";";
        PreparedStatement complementisers = this.con.prepareStatement(query);
        if (complementisers.execute()) {
            ResultSet results = complementisers.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                Complementiser c = null;
                if (this.lexicon.hasItemID(id)) {
                    c = (Complementiser)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString("baseform");
                    c = new Complementiser(id, baseform);
                    c.setInflectionType(this.getInflectionCode(results.getString("infl")));
                }
                this.lexicon.addItem(c);
            }
        }
    }

    public void loadDeterminers() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.category=\"det\";";
        PreparedStatement determiners = this.con.prepareStatement(query);
        if (determiners.execute()) {
            ResultSet results = determiners.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                Determiner d = null;
                if (this.lexicon.hasItemID(id)) {
                    d = (Determiner)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString("baseform");
                    d = new Determiner(id, baseform);
                    d.setInflectionType(this.getInflectionCode(results.getString("infl")));
                    d.setAgreement(this.getAgreementCode(results.getString("agr")));
                    d = this.addDetFeatures(d);
                }
                this.lexicon.addItem(d);
            }
        }
    }

    public void loadConjunctions() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.category=\"conj\";";
        PreparedStatement conjunctions = this.con.prepareStatement(query);
        if (conjunctions.execute()) {
            ResultSet results = conjunctions.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                Conjunction c = null;
                if (this.lexicon.hasItemID(id)) {
                    c = (Conjunction)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString("baseform");
                    c = new Conjunction(id, baseform);
                    c.setInflectionType(this.getInflectionCode(results.getString("infl")));
                    c = this.addConjFeatures(c);
                }
                this.lexicon.addItem(c);
            }
        }
    }

    public void loadPronouns() throws SQLException {
        String query = "select e.euid, e.baseform, e.category, e.hasComp, e.infl, e.agr from entries e where e.category=\"pron\";";
        PreparedStatement pronouns = this.con.prepareStatement(query);
        if (pronouns.execute()) {
            ResultSet results = pronouns.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                Pronoun p = null;
                if (this.lexicon.hasItemID(id)) {
                    p = (Pronoun)this.lexicon.getItemByID(id);
                } else {
                    String baseform = results.getString("baseform");
                    p = new Pronoun(id, baseform);
                    p.setInflectionType(this.getInflectionCode(results.getString("infl")));
                    p.setAgreement(this.getAgreementCode(results.getString("agr")));
                    p = this.addPronounFeatures(p);
                }
                this.lexicon.addItem(p);
            }
        }
    }

    @Override
    public void loadItemByID(String id) throws SQLException, ClassNotFoundException {
        ResultSet results;
        this.checkConnection();
        this.getEntryByID.setString(1, id);
        if (this.getEntryByID.execute() && (results = this.getEntryByID.getResultSet()).next()) {
            String baseform = results.getString("baseform");
            String category = results.getString("category");
            String infl = results.getString("infl");
            String agr = results.getString("agr");
            Boolean hasComp = results.getBoolean("hasComp");
            LexicalItem item = this.constructItem(id, baseform, hasComp, category, infl, agr);
            if (item != null) {
                this.lexicon.addItem(item);
                this.loadDerivations(item);
            }
        }
    }

    @Override
    public void loadItem(Category cat, String baseform) throws SQLException, ClassNotFoundException {
        ResultSet results;
        String c;
        this.checkConnection();
        switch (cat) {
            case NOUN: 
            case VERB: {
                c = cat.toString().toLowerCase();
                break;
            }
            case PRONOUN: {
                c = "pron";
                break;
            }
            case DETERMINER: {
                c = "det";
                break;
            }
            case COMPLEMENTISER: {
                c = "comp";
                break;
            }
            case CONJUNCTION: {
                c = "conj";
                break;
            }
            case ADJECTIVE: {
                c = "adj";
                break;
            }
            case ADVERB: {
                c = "adv";
                break;
            }
            case PREPOSITION: {
                c = "prep";
                break;
            }
            default: {
                return;
            }
        }
        this.getEntryByCatBaseform.setString(1, c);
        this.getEntryByCatBaseform.setString(2, baseform);
        if (this.getEntryByCatBaseform.execute() && (results = this.getEntryByCatBaseform.getResultSet()).next()) {
            String id = results.getString("euid");
            String infl = results.getString("infl");
            String agr = results.getString("agr");
            Boolean hasComp = results.getBoolean("hasComp");
            LexicalItem item = this.constructItem(id, baseform, hasComp, c, infl, agr);
            this.loadDerivations(item);
            this.lexicon.addItem(item);
        }
    }

    @Override
    public void loadItemsByBaseform(String baseform) throws SQLException, ClassNotFoundException {
        this.checkConnection();
        this.getEntryByBaseform.setString(1, baseform);
        if (this.getEntryByBaseform.execute()) {
            ResultSet results = this.getEntryByBaseform.getResultSet();
            while (results.next()) {
                String id = results.getString("euid");
                String category = results.getString("category");
                String infl = results.getString("infl");
                String agr = results.getString("agr");
                Boolean hasComp = results.getBoolean("hasComp");
                LexicalItem item = this.constructItem(id, baseform, hasComp, category, infl, agr);
                this.loadDerivations(item);
                this.lexicon.addItem(item);
            }
        }
    }

    public void loadVerbnetData() throws SQLException, ClassNotFoundException {
        this.checkConnection();
        ResultSet result = this.getVerbFrames.executeQuery();
        if (result == null) {
            return;
        }
        HashMap<Integer, VerbnetFrame> seenFrames = new HashMap<Integer, VerbnetFrame>();
        while (result.next()) {
            VerbnetFrame frame;
            VerbnetClass vnClass;
            String verbID = result.getString(1);
            Verb verb = (Verb)this.lexicon.getItemByID(verbID);
            if (verb == null) continue;
            String className = result.getString(2);
            String superclassName = result.getString(3);
            if (this.lexicon.hasLexicalClass(className)) {
                vnClass = (VerbnetClass)this.lexicon.getLexicalClass(className);
            } else {
                VerbnetClass vnSuperClass;
                vnClass = new VerbnetClass(className);
                this.lexicon.addLexicalClass(vnClass);
                if (superclassName != null && (vnSuperClass = (VerbnetClass)this.lexicon.getLexicalClass(superclassName)) != null) {
                    vnSuperClass.addSubclass(vnClass);
                }
            }
            int frameid = result.getInt(4);
            if (seenFrames.containsKey(frameid)) {
                frame = (VerbnetFrame)seenFrames.get(frameid);
            } else {
                String syntax = result.getString(7);
                frame = this.parseVerbframeSyntax(syntax);
                String desc1 = result.getString(5);
                String desc2 = result.getString(6);
                frame.setMainDescription(desc1);
                frame.setSubDescription(desc2);
                seenFrames.put(frameid, frame);
            }
            vnClass.addFrame(frame);
            vnClass.addMember(verb);
        }
    }

    private void checkConnection() throws ClassNotFoundException, SQLException {
        if (!this.hasLexicon()) {
            throw new LexiconException("Cannot load data: the lexicon has not been set");
        }
        if (!this.connected) {
            this.connect();
        }
    }

    private VerbnetFrame parseVerbframeSyntax(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            InputSource source = new InputSource(reader);
            VerbnetFrame frame = new VerbnetFrame();
            NodeList nodeset = (NodeList)this.xpath.evaluate("SYNTAX/*", source, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeset.getLength()) {
                Node node = nodeset.item(i);
                String name = node.getNodeName();
                NamedNodeMap attributes = node.getAttributes();
                VerbnetSlotType type = VerbnetSlotType.valueOf(name);
                Node content = attributes.getNamedItem("value");
                if (content != null) {
                    String cont = content.getNodeValue();
                    String[] contents = cont.split(" ");
                    frame.addSlot(type, contents);
                } else {
                    frame.addSlot(type, new String[0]);
                }
                ++i;
            }
            return frame;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private LexicalItem constructItem(String id, String baseform, boolean hasComp, String category, String infl, String agr) throws SQLException {
        Word item = null;
        if (category.equals("noun")) {
            item = new Noun(id, baseform);
            item.setAgreement(this.getAgreementCode(agr));
        } else if (category.equals("verb")) {
            item = new Verb(id, baseform);
            ((Verb)item).setVerbType(VerbType.MAIN);
        } else if (category.equals("aux")) {
            item = new Verb(id, baseform);
            ((Verb)item).setVerbType(VerbType.AUX);
        } else if (category.equals("modal")) {
            item = new Verb(id, baseform);
            ((Verb)item).setVerbType(VerbType.MODAL);
        } else if (category.equals("adj")) {
            item = new Adjective(id, baseform);
            item = this.addAdjFeatures((Adjective)item);
        } else if (category.equals("adv")) {
            item = new Adverb(id, baseform);
            item = this.addAdverbFeatures((Adverb)item);
        } else if (category.equals("prep")) {
            item = new Preposition(id, baseform);
        } else if (category.equals("pron")) {
            item = new Pronoun(id, baseform);
            ((Pronoun)item).setAgreement(this.getAgreementCode(agr));
            item = this.addPronounFeatures((Pronoun)item);
        } else if (category.equals("det")) {
            item = new Determiner(id, baseform);
            ((Determiner)item).setAgreement(this.getAgreementCode(agr));
            item = this.addDetFeatures((Determiner)item);
        } else if (category.equals("comp")) {
            item = new Complementiser(id, baseform);
        } else if (category.equals("conj")) {
            item = new Conjunction(id, baseform);
            item = this.addConjFeatures((Conjunction)item);
        }
        if (item != null) {
            item.setInflectionType(this.getInflectionCode(infl));
        }
        if (hasComp) {
            item = this.addComplements((ContentWord)item);
        }
        return item;
    }

    private VerbType getVerbType(String category) {
        if (category.indexOf("aux") > -1) {
            return VerbType.AUX;
        }
        if (category.indexOf("modal") > -1) {
            return VerbType.MODAL;
        }
        return VerbType.MAIN;
    }

    private Agreement getAgreementCode(String agr) {
        if (agr.indexOf("plur") > -1) {
            return Agreement.FIXED_PLUR;
        }
        if (agr.indexOf("sing") > -1) {
            return Agreement.FIXED_SING;
        }
        if (agr.indexOf("group") > -1) {
            return Agreement.GROUP;
        }
        if (agr.indexOf("uncount") > -1) {
            return Agreement.MASS;
        }
        return Agreement.COUNT;
    }

    private InflectionType getInflectionCode(String infl) {
        if (infl.indexOf("glreg") > -1) {
            return InflectionType.GL_REGULAR;
        }
        if (infl.indexOf("regd") > -1) {
            return InflectionType.REG_DOUBLING;
        }
        if (infl.indexOf("irreg") > -1) {
            return InflectionType.IRREGULAR;
        }
        if (infl.indexOf("reg") > -1) {
            return InflectionType.REGULAR;
        }
        if (infl.indexOf("inv") > -1) {
            return InflectionType.INVARIANT;
        }
        if (infl.indexOf("periph") > -1) {
            return InflectionType.PERIPHRASTIC;
        }
        return null;
    }

    private ContentWord addComplements(ContentWord word) throws SQLException {
        String id = word.getID();
        this.complement.setString(1, id);
        if (this.complement.execute()) {
            ResultSet results = this.complement.getResultSet();
            while (results.next()) {
                String r2;
                String r1;
                String cr2;
                String c2;
                String cr1;
                String c1 = results.getString("comp1");
                ComplementFrame frame = this.makeFrame(c1, cr1 = results.getString("comp1Restr"), c2 = results.getString("comp2"), cr2 = results.getString("comp2Restr"), r1 = results.getString("gRestr1"), r2 = results.getString("gRestr2"));
                if (frame == null) continue;
                frame.setTransitivity(this.getTrans(results.getString("transitivity")));
                word.addComplementFrame(frame);
            }
        }
        return word;
    }

    private Transitivity getTrans(String t) {
        if (t == null) {
            return null;
        }
        if (t.indexOf("cplxtran") > -1) {
            return Transitivity.COMPLEX_TRANS;
        }
        if (t.indexOf("ditran") > -1) {
            return Transitivity.DITRANS;
        }
        if (t.indexOf("intran") > -1) {
            return Transitivity.INTRANS;
        }
        if (t.indexOf("tran") > -1) {
            return Transitivity.MONOTRANS;
        }
        if (t.indexOf("link") > -1) {
            return Transitivity.LINKING;
        }
        return Transitivity.INTRANS;
    }

    private ComplementFrame makeFrame(String c1, String cr1, String c2, String cr2, String r1, String r2) {
        String[] passDat;
        if (c1 == null) {
            return null;
        }
        ComplementFrame frame = new ComplementFrame();
        String[] stringArray = passDat = new String[]{r1, r2};
        int n = passDat.length;
        int n2 = 0;
        while (n2 < n) {
            String pd = stringArray[n2];
            if (pd != null) {
                if (pd.indexOf("nopass") > -1) {
                    frame.setAllowsPassive(false);
                } else if (pd.indexOf("datmvt") > 1) {
                    frame.setAllowsDativeShift(true);
                }
            }
            ++n2;
        }
        this.cppMatcher.reset(c1);
        if (this.cppMatcher.matches()) {
            String restr1 = this.cppMatcher.group(1);
            String restr2 = this.cppMatcher.group(3);
            Preposition[] heads = new Preposition[2];
            heads[0] = new Preposition(restr1);
            if (restr2 != null) {
                heads[1] = new Preposition(restr2);
            }
            Preposition[] prepositionArray = heads;
            int n3 = heads.length;
            int n4 = 0;
            while (n4 < n3) {
                Preposition p = prepositionArray[n4];
                ComplementSlot slot = new ComplementSlot(ComplementType.PP, null, p);
                frame.addComplement(slot);
                ++n4;
            }
        } else {
            ComplementSlot slot1 = this.parseCompType(c1);
            ComplementSlot slot2 = this.parseCompType(c2);
            InterpretationCode code1 = this.parseCode(cr1);
            InterpretationCode code2 = this.parseCode(cr2);
            if (slot1 != null) {
                if (code1 != null) {
                    slot1.setCode(code1);
                }
                frame.addComplement(slot1);
            }
            if (slot2 != null) {
                if (code2 != null) {
                    slot2.setCode(code2);
                }
                frame.addComplement(slot2);
            }
        }
        return frame;
    }

    private ComplementSlot parseCompType(String c) {
        if (c == null) {
            return null;
        }
        if (c.indexOf("np") > -1) {
            return new ComplementSlot(ComplementType.NP);
        }
        if (c.indexOf("ingcomp") > -1) {
            return new ComplementSlot(ComplementType.ING);
        }
        if (c.indexOf("binfcomp") > -1) {
            return new ComplementSlot(ComplementType.BARE_INF);
        }
        if (c.indexOf("infcomp") > -1) {
            return new ComplementSlot(ComplementType.INF);
        }
        if (c.indexOf("ascomp") > -1) {
            return new ComplementSlot(ComplementType.AS_COMP);
        }
        if (c.indexOf("edcomp") > -1) {
            return new ComplementSlot(ComplementType.ED);
        }
        if (c.indexOf("whfincomp") > -1) {
            return new ComplementSlot(ComplementType.WHFINCOMP);
        }
        if (c.indexOf("whinfcomp") > -1) {
            return new ComplementSlot(ComplementType.WHINFCOMP);
        }
        if (c.indexOf("adj") > -1) {
            return new ComplementSlot(ComplementType.ADJP);
        }
        if (c.indexOf("advbl") > -1) {
            return new ComplementSlot(ComplementType.ADVP);
        }
        if (c.indexOf("fincomp") > -1) {
            return new ComplementSlot(ComplementType.FINCOMP);
        }
        return null;
    }

    private InterpretationCode parseCode(String code) {
        if (code == null) {
            return null;
        }
        if (code.indexOf("arbc") > -1) {
            return InterpretationCode.ARB_CONTROL;
        }
        if (code.indexOf("nsr") > -1) {
            return InterpretationCode.NON_SUBJ_CONTROL;
        }
        if (code.indexOf("subjr") > -1) {
            return InterpretationCode.SUBJ_RAISING;
        }
        if (code.indexOf("subjc") > -1) {
            return InterpretationCode.SUBJ_CONTROL;
        }
        if (code.indexOf("objr") > -1) {
            return InterpretationCode.OBJ_RAISING;
        }
        if (code.indexOf("objc") > -1) {
            return InterpretationCode.OBJ_CONTROL;
        }
        if (code.indexOf("tp") > -1) {
            return InterpretationCode.REQ_THAT_PRO;
        }
        if (code.indexOf("tsp") > -1) {
            return InterpretationCode.SUBJUNCTIVE_REQ_THAT_PRO;
        }
        if (code.indexOf("ts") > -1) {
            return InterpretationCode.SUBJUNCTIVE_REQ_THAT;
        }
        if (code.indexOf("o") > -1) {
            return InterpretationCode.OPT_THAT;
        }
        if (code.indexOf("t") > -1) {
            return InterpretationCode.REQ_THAT;
        }
        if (code.indexOf("p") > -1) {
            return InterpretationCode.OPT_THAT_PRO;
        }
        if (code.indexOf("s") > -1) {
            return InterpretationCode.SUBJUNCTIVE_OPT_THAT;
        }
        return null;
    }

    private Category getCatRestriction(String catRestr) {
        try {
            return Category.valueOf(catRestr.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    private ConjunctionType getConjType(String type) {
        try {
            return ConjunctionType.valueOf(type.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    private AdverbPosition getAdvPos(String pos) {
        if (pos == null) {
            return null;
        }
        if (pos.indexOf("verb") > -1) {
            return AdverbPosition.VERBAL;
        }
        if (pos.indexOf("sentence") > -1) {
            return AdverbPosition.SENTENTIAL;
        }
        if (pos.indexOf("particle") > -1) {
            return AdverbPosition.VERB_PARTICLE;
        }
        return null;
    }

    private AdverbType getAdvType(String pos) {
        if (pos == null) {
            return null;
        }
        if (pos.indexOf("temporal") > -1) {
            return AdverbType.TEMPORAL;
        }
        if (pos.indexOf("manner") > -1) {
            return AdverbType.MANNER;
        }
        if (pos.indexOf("locative") > -1) {
            return AdverbType.LOCATIVE;
        }
        if (pos.indexOf("intensifier") > -1) {
            return AdverbType.INTENSIFIER;
        }
        return null;
    }

    private List<AdjectivePosition> getAdjPos(String posString) {
        String[] values;
        ArrayList<AdjectivePosition> positions = new ArrayList<AdjectivePosition>();
        String[] stringArray = values = posString.split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            if (pos != null) {
                if (pos.indexOf("post") > -1) {
                    positions.add(AdjectivePosition.POST_NOMINAL);
                } else if (pos.indexOf("pred") > -1) {
                    positions.add(AdjectivePosition.PREDICATIVE);
                } else if (pos.indexOf("attribc") > -1) {
                    positions.add(AdjectivePosition.ATTRIB_C);
                } else if (pos.indexOf("attrib(1)") > -1) {
                    positions.add(AdjectivePosition.ATTRIB_1);
                } else if (pos.indexOf("attrib(2)") > -1) {
                    positions.add(AdjectivePosition.ATTRIB_2);
                } else if (pos.indexOf("attrib(3)") > -1) {
                    positions.add(AdjectivePosition.ATTRIB_3);
                }
            }
            ++n2;
        }
        return positions;
    }

    private Adjective addAdjFeatures(Adjective a) throws SQLException {
        ResultSet results;
        String id = a.getID();
        this.adjFeature.setString(1, id);
        if (this.adjFeature.execute() && (results = this.adjFeature.getResultSet()).next()) {
            String positions = results.getString("positions");
            boolean stat = results.getBoolean("stative");
            for (AdjectivePosition p : this.getAdjPos(positions)) {
                a.addPosition(p);
            }
            if (stat) {
                a.setType(AdjectiveType.STATIVE);
            } else {
                a.setType(AdjectiveType.NON_STATIVE);
            }
        }
        return a;
    }

    private Adverb addAdverbFeatures(Adverb a) throws SQLException {
        ResultSet results;
        String id = a.getID();
        this.advFeature.setString(1, id);
        if (this.advFeature.execute() && (results = this.advFeature.getResultSet()).next()) {
            String positions = results.getString("positions");
            String polarity = results.getString("polarity");
            String[] stringArray = positions.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                AdverbPosition p = this.getAdvPos(s);
                AdverbType t = this.getAdvType(s);
                if (p != null) {
                    a.addPosition(p);
                }
                if (t != null) {
                    a.addAdverbType(t);
                }
                ++n2;
            }
            a.setPolarity(this.getPolarity(polarity));
        }
        return a;
    }

    private Gender getGender(String gend) {
        if (gend == null) {
            return null;
        }
        if (gend.indexOf("pers(masc)") > -1) {
            return Gender.MASCULINE;
        }
        if (gend.indexOf("pers(fem)") > -1) {
            return Gender.FEMININE;
        }
        return Gender.NEUTER;
    }

    private Case getCase(String cas) {
        if (cas == null) {
            return null;
        }
        if (cas.indexOf("subj_obj") > -1) {
            return Case.NOM_ACC;
        }
        if (cas.indexOf("subj") > -1) {
            return Case.NOMINATIVE;
        }
        if (cas.indexOf("obj") > -1) {
            return Case.ACCUSATIVE;
        }
        return null;
    }

    private Possession getPoss(String pos) {
        if (pos == null) {
            return null;
        }
        if (pos.indexOf("poss_possnom") > -1) {
            return Possession.ANY;
        }
        if (pos.indexOf("possnom") > -1) {
            return Possession.POSSESSIVE_NOMINATIVE;
        }
        if (pos.indexOf("poss") > -1) {
            return Possession.POSSESSIVE;
        }
        return Possession.NON_POSSESSIVE;
    }

    private Quantification getQuant(String quant) {
        if (quant == null) {
            return null;
        }
        if (quant.indexOf("univ") > -1) {
            return Quantification.UNIVERSAL;
        }
        if (quant.indexOf("indef(nonassert)") > -1) {
            return Quantification.INDEF_NON_ASSERT;
        }
        if (quant.indexOf("indef(assert)") > -1) {
            return Quantification.INDEF_ASSERT;
        }
        if (quant.indexOf("indef(neg)") > -1) {
            return Quantification.INDEF_NEGATIVE;
        }
        return Quantification.DEFINITE;
    }

    private Reflexivity getRefl(String t) {
        if (t != null && t.indexOf("reflexive") > -1) {
            return Reflexivity.REFLEXIVE;
        }
        return Reflexivity.NON_REFLEXIVE;
    }

    private Deixis getDeixis(String t) {
        if (t != null && t.indexOf("demonstrative") > -1) {
            return Deixis.DEMONSTRATIVE;
        }
        return Deixis.NON_DEMONSTRATIVE;
    }

    private Polarity getPolarity(String t) {
        if (t == null) {
            return Polarity.POSITIVE;
        }
        if (t.indexOf("broad_negative") > -1) {
            return Polarity.BROAD_NEGATIVE;
        }
        if (t.indexOf("negative") > -1) {
            return Polarity.NEGATIVE;
        }
        return Polarity.POSITIVE;
    }

    private Determiner addDetFeatures(Determiner d) throws SQLException {
        ResultSet results;
        this.detFeature.setString(1, d.getID());
        if (this.detFeature.execute() && (results = this.detFeature.getResultSet()).next()) {
            d.setDeixis(this.getDeixis(results.getString("detType")));
        }
        return d;
    }

    private Conjunction addConjFeatures(Conjunction c) throws SQLException {
        ResultSet results;
        this.conjFeature.setString(1, c.getID());
        if (this.conjFeature.execute() && (results = this.conjFeature.getResultSet()).next()) {
            String ctype = results.getString("conjType");
            String atype = results.getString("argType");
            c.setConjType(this.getConjType(ctype));
            c.setCategoryRestriction(this.getCatRestriction(atype));
        }
        return c;
    }

    private Pronoun addPronounFeatures(Pronoun p) throws SQLException {
        ResultSet results;
        this.proFeature.setString(1, p.getID());
        if (this.proFeature.execute() && (results = this.proFeature.getResultSet()).next()) {
            String gender = results.getString("gender");
            String cse = results.getString("case1");
            String poss = results.getString("possession");
            String quant = results.getString("quantification");
            String type = results.getString("pronType");
            p.setGender(this.getGender(gender));
            p.setCaseValue(this.getCase(cse));
            p.setPossession(this.getPoss(poss));
            p.setQuantification(this.getQuant(quant));
            p.setReflexivity(this.getRefl(type));
            p.setDeixis(this.getDeixis(type));
            p.setPolarity(this.getPolarity(type));
        }
        return p;
    }

    private void loadDerivations(LexicalItem lex) throws SQLException {
        this.getDerivations.setString(1, lex.getID());
        if (this.getDerivations.execute()) {
            ResultSet results = this.getDerivations.getResultSet();
            while (results.next()) {
                String relatedItemID = results.getString(1);
                String relation = results.getString(2);
                DerivationalRelation dr = this.parseDerivRelation(relation);
                if (dr == null) continue;
                LexicalItem relatedItem = this.lexicon.getItemByID(relatedItemID);
                lex.addDerivationalRelation(dr, relatedItem);
                DerivationalRelation inv = dr.getInverse();
                if (inv == null) continue;
                relatedItem.addDerivationalRelation(inv, lex);
            }
        }
    }

    private DerivationalRelation parseDerivRelation(String rel) {
        DerivationalRelation[] derivationalRelationArray = DerivationalRelation.values();
        int n = derivationalRelationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DerivationalRelation dr = derivationalRelationArray[n2];
            if (dr.toString().equalsIgnoreCase(rel)) {
                return dr;
            }
            ++n2;
        }
        return null;
    }
}

