/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import simplenlg.exception.LexiconException;
import simplenlg.features.Category;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Quantification;
import simplenlg.features.Tense;
import simplenlg.features.VerbType;
import simplenlg.lexicon.LexicalClass;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Symbol;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.AdjectiveInflection;
import simplenlg.lexicon.morph.MorphologicalRule;
import simplenlg.lexicon.morph.NounInflection;
import simplenlg.lexicon.morph.VerbInflection;
import simplenlg.lexicon.morph.WordLists;

public class Lexicon
implements LexiconInterface {
    TreeMap<String, LexicalItem> itemsByID = new TreeMap();
    TreeMap<String, Set<String>> itemsByBaseform = new TreeMap();
    TreeMap<Category, Set<String>> itemsByCategory = new TreeMap();
    TreeMap<String, MorphologicalRule<?>> rules = new TreeMap();
    TreeMap<String, LexicalClass<?>> lexicalClasses = new TreeMap();
    String idPrefix = "I";

    public Lexicon() {
        this.addAuxVerbs();
        this.addModals();
        this.addConsDoublingVerbs();
        this.addSymbols();
        this.addRules();
        this.addInvariantNouns();
        this.addDeterminers();
        this.addConjunctions();
        this.addPronouns();
        this.addPrepositions();
    }

    public static LexicalItem makeLexicalItem(Category c, String w) {
        switch (c) {
            case NOUN: {
                return new Noun(w);
            }
            case VERB: {
                return new Verb(w);
            }
            case PRONOUN: {
                return new Pronoun(w);
            }
            case PREPOSITION: {
                return new Preposition(w);
            }
            case CONJUNCTION: {
                return new Conjunction(w);
            }
            case DETERMINER: {
                return new Determiner(w);
            }
            case SYMBOL: {
                return new Symbol(w);
            }
        }
        return null;
    }

    @Override
    public void addItem(Category cat, String word) {
        LexicalItem lex = Lexicon.makeLexicalItem(cat, word);
        this.addItem(lex);
    }

    @Override
    public void addItem(LexicalItem lex) {
        String word = lex.getBaseForm();
        String id = lex.getID();
        if (id == null) {
            id = this.makeID();
            lex.setID(id);
        }
        this.itemsByID.put(id, lex);
        if (this.itemsByBaseform.containsKey(word)) {
            this.itemsByBaseform.get(word).add(id);
        } else {
            HashSet<String> ids = new HashSet<String>();
            ids.add(id);
            this.itemsByBaseform.put(word, ids);
        }
        Category cat = lex.getCategory();
        if (this.itemsByCategory.containsKey((Object)cat)) {
            this.itemsByCategory.get((Object)lex.getCategory()).add(id);
        } else {
            HashSet<String> items = new HashSet<String>();
            items.add(id);
            this.itemsByCategory.put(cat, items);
        }
    }

    public void addNoun(String noun, String plural) {
        if (this.hasItem(Category.NOUN, noun)) {
            Noun n = (Noun)this.getItem(Category.NOUN, noun);
            n.setPlural(plural);
        } else {
            Noun n = new Noun(noun);
            n.setPlural(plural);
            this.addItem(n);
        }
    }

    public void addVerb(String verb, String past, String pastParticiple, String presentParticiple) {
        if (this.hasItem(Category.VERB, verb)) {
            Verb v = (Verb)this.getItem(Category.VERB, verb);
            v.setPast(past);
            v.setPastParticiple(pastParticiple);
            v.setPresentParticiple(presentParticiple);
        } else {
            Verb v = new Verb(verb);
            v.setPast(past);
            v.setPastParticiple(pastParticiple);
            v.setPresentParticiple(presentParticiple);
            this.addItem(v);
        }
    }

    @Override
    public Collection<LexicalItem> getItems(String base) {
        ArrayList<LexicalItem> items = new ArrayList<LexicalItem>();
        if (this.itemsByBaseform.containsKey(base)) {
            for (String id : this.itemsByBaseform.get(base)) {
                items.add(this.itemsByID.get(id));
            }
        }
        return items;
    }

    @Override
    public LexicalItem getItem(Category cat, String base) {
        if (cat == null || base == null) {
            return null;
        }
        if (this.itemsByBaseform.containsKey(base)) {
            for (String id : this.itemsByBaseform.get(base)) {
                LexicalItem lex = this.itemsByID.get(id);
                if (!lex.getCategory().equals((Object)cat)) continue;
                return lex;
            }
        }
        return null;
    }

    public List<LexicalItem> getItems(Category cat) {
        ArrayList<LexicalItem> items = new ArrayList<LexicalItem>();
        if (this.itemsByCategory.containsKey((Object)cat)) {
            for (String id : this.itemsByCategory.get((Object)cat)) {
                items.add(this.itemsByID.get(id));
            }
        }
        return items;
    }

    @Override
    public LexicalItem getItemByID(String id) {
        return this.itemsByID.get(id);
    }

    @Override
    public boolean hasItem(Category cat, String word) {
        return this.getItem(cat, word) != null;
    }

    @Override
    public boolean hasItem(String word) {
        for (String baseform : this.itemsByBaseform.keySet()) {
            if (!baseform.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItemID(String id) {
        return this.itemsByID.containsKey(id);
    }

    @Override
    public int getNumberOfItems() {
        return this.itemsByID.keySet().size();
    }

    @Override
    public int getNumberOfItems(Category cat) {
        if (this.itemsByCategory.containsKey((Object)cat)) {
            return this.itemsByCategory.get((Object)cat).size();
        }
        return 0;
    }

    public int getNumberOfEntries(String baseform) {
        if (this.itemsByBaseform.containsKey(baseform)) {
            return this.itemsByBaseform.get(baseform).size();
        }
        return 0;
    }

    public String getPlural(String word) {
        Noun n = (Noun)this.getItem(Category.NOUN, word);
        if (n == null) {
            n = new Noun(word);
            this.addItem(n);
        }
        return n.getPlural();
    }

    public String getComparative(String word) {
        Adjective a = (Adjective)this.getItem(Category.ADJECTIVE, word);
        if (a == null) {
            a = new Adjective(word);
            this.addItem(a);
        }
        return a.getComparative();
    }

    public String getSuperlative(String word) {
        Adjective a = (Adjective)this.getItem(Category.ADJECTIVE, word);
        if (a == null) {
            a = new Adjective(word);
            this.addItem(a);
        }
        return a.getSuperlative();
    }

    public String getPast(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPast();
    }

    public String getPastParticiple(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPastParticiple();
    }

    public String getPresent3SG(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPresent3SG();
    }

    public String getPresentParticiple(String word) {
        Verb v = (Verb)this.getItem(Category.VERB, word);
        if (v == null) {
            v = new Verb(word);
            this.addItem(v);
        }
        return v.getPresentParticiple();
    }

    public String getContinuous(String word) {
        return this.getPresentParticiple(word);
    }

    public String getIngForm(String word) {
        return this.getPresentParticiple(word);
    }

    @Override
    public <T extends LexicalItem> void addRule(MorphologicalRule<T> rule) {
        if (!rule.hasName()) {
            throw new LexiconException("Cannot add unnamed morphological rule to the Lexicon.");
        }
        if (this.rules == null) {
            this.rules = new TreeMap();
        }
        this.rules.put(rule.getName(), rule);
    }

    @Override
    public Collection<MorphologicalRule<?>> getRules() {
        return this.rules.values();
    }

    @Override
    public String applyRule(String ruleName, String word) {
        try {
            return this.rules.get(ruleName).apply(word);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public <T extends LexicalItem> String applyRule(String ruleName, T lex) {
        if (this.rules.containsKey(ruleName)) {
            try {
                return this.rules.get(ruleName).apply(lex);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getVerbForm(String v, Tense t, Person p, NumberAgr n) {
        Verb verb;
        if (this.hasItem(Category.VERB, v)) {
            verb = (Verb)this.getItem(Category.VERB, v);
        } else {
            verb = new Verb(v);
            this.addItem(verb);
        }
        switch (t) {
            case PRESENT: {
                return verb.getPresent(p, n);
            }
            case PAST: {
                return verb.getPast(p, n);
            }
        }
        return verb.getBaseForm();
    }

    public String getBeSubjunctive() {
        return "were";
    }

    @Override
    public void reset() {
        this.itemsByBaseform.clear();
        this.itemsByID.clear();
        this.itemsByCategory.clear();
    }

    @Override
    public void addLexicalClass(LexicalClass<?> lexClass) {
        lexClass.setParentLexicon(this);
        this.lexicalClasses.put(lexClass.getID(), lexClass);
    }

    @Override
    public boolean hasLexicalClass(String classID) {
        return this.lexicalClasses.containsKey(classID);
    }

    @Override
    public LexicalClass<?> getLexicalClass(String classID) {
        return this.lexicalClasses.get(classID);
    }

    private void addSymbols() {
        for (String symb : WordLists.SYMBOLS) {
            this.addItem(Category.SYMBOL, symb);
        }
    }

    private void addAuxVerbs() {
        for (String v : WordLists.AUXILIARIES) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.AUX);
            this.addItem(verb);
        }
    }

    private void addModals() {
        for (String v : WordLists.MODALS) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.MODAL);
            verb.setInflectionType(InflectionType.INVARIANT);
            this.addItem(verb);
        }
    }

    private void addConsDoublingVerbs() {
        for (String v : WordLists.VERB_CONS_DOUBLING) {
            Verb verb = new Verb(v);
            verb.setVerbType(VerbType.MAIN);
            this.addItem(verb);
        }
    }

    private void addInvariantNouns() {
        for (String n : WordLists.NULL_PLURAL) {
            Noun noun = new Noun(n);
            noun.setInflectionType(InflectionType.INVARIANT);
            this.addItem(noun);
        }
    }

    private void addRules() {
        this.rules.put("plural", NounInflection.PLURAL);
        this.rules.put("comparative", AdjectiveInflection.COMPARATIVE);
        this.rules.put("superlative", AdjectiveInflection.SUPERLATIVE);
        this.rules.put("presentTense", VerbInflection.PRESENT_TENSE);
        this.rules.put("pastTense", VerbInflection.PAST_TENSE);
        this.rules.put("pastParticiple", VerbInflection.PAST_PARTICIPLE);
        this.rules.put("presentParticiple", VerbInflection.ING_FORM);
    }

    private void addDeterminers() {
        Determiner[] determinerArray = Constants.ALL_DETERMINERS;
        int n = Constants.ALL_DETERMINERS.length;
        int n2 = 0;
        while (n2 < n) {
            Determiner d = determinerArray[n2];
            if (d == Constants.DEFINITE) {
                d.setQuantification(Quantification.DEFINITE);
            } else {
                d.setQuantification(Quantification.INDEF_ASSERT);
            }
            ++n2;
        }
    }

    private void addConjunctions() {
        Conjunction[] conjunctionArray = Constants.ALL_CONJUNCTIONS;
        int n = Constants.ALL_CONJUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Conjunction c = conjunctionArray[n2];
            this.addItem(c);
            ++n2;
        }
    }

    private void addPronouns() {
        Pronoun[] pronounArray = Constants.ALL_PRONOUNS;
        int n = Constants.ALL_PRONOUNS.length;
        int n2 = 0;
        while (n2 < n) {
            Pronoun p = pronounArray[n2];
            this.addItem(p);
            ++n2;
        }
    }

    private void addPrepositions() {
        Preposition[] prepositionArray = Constants.ALL_PREPS;
        int n = Constants.ALL_PREPS.length;
        int n2 = 0;
        while (n2 < n) {
            Preposition p = prepositionArray[n2];
            this.addItem(p);
            ++n2;
        }
    }

    private String makeID() {
        String number = String.valueOf(this.getNumberOfItems());
        return String.valueOf(this.idPrefix) + number;
    }
}

