/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import simplenlg.exception.LexiconException;
import simplenlg.features.Category;
import simplenlg.lexicon.DatabaseBackedLexicon;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.db.DBAccessor;
import simplenlg.lexicon.db.SQLAccessor;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.verbnet.VerbnetClass;

public class DBLexicon
extends Lexicon
implements DatabaseBackedLexicon {
    DBAccessor accessor;
    boolean allDataLoaded;
    Map<String, VerbnetClass> verbnetClasses = new TreeMap<String, VerbnetClass>();

    public DBLexicon() {
        this.itemsByID = new TreeMap();
        this.itemsByBaseform = new TreeMap();
        this.itemsByCategory = new TreeMap();
        this.idPrefix = "I";
        this.allDataLoaded = false;
    }

    public DBLexicon(DBAccessor accessor) {
        this();
        this.setAccessor(accessor);
    }

    public DBLexicon(String driver, String url, String user, String pw) {
        this();
        this.setAccessor(new SQLAccessor(driver, url, user, pw));
    }

    @Override
    public void setAccessor(DBAccessor dbAccessor) {
        this.accessor = dbAccessor;
        dbAccessor.setLexicon(this);
    }

    @Override
    public boolean hasAccessor() {
        return this.accessor != null;
    }

    @Override
    public DBAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void loadData() throws LexiconException {
        if (!this.hasAccessor()) {
            throw new LexiconException("Cannot load data: No accessor set");
        }
        try {
            this.accessor.loadData();
            this.allDataLoaded = true;
        }
        catch (Exception e) {
            LexiconException le = new LexiconException("Cannot load data. DBAccessor threw the following exception: " + e.getClass() + " with message: " + e.getMessage());
            le.setStackTrace(e.getStackTrace());
            throw le;
        }
    }

    @Override
    public void loadItemByID(String id) throws LexiconException {
        try {
            this.accessor.loadItemByID(id);
        }
        catch (Exception e) {
            LexiconException ex = new LexiconException("Failed to retrieve item. DBAccessor threw exception: " + e.getClass() + " with message: " + e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    @Override
    public void loadItemsByBaseform(String baseform) throws LexiconException {
        try {
            this.accessor.loadItemsByBaseform(baseform);
        }
        catch (Exception e) {
            LexiconException ex = new LexiconException("Failed to retrieve item. DBAccessor threw exception: " + e.getClass() + " with message: " + e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    @Override
    public LexicalItem getItemByID(String id) throws LexiconException {
        LexicalItem item = super.getItemByID(id);
        if (item == null && !this.allDataLoaded) {
            try {
                this.loadItemByID(id);
                if (this.itemsByID.containsKey(id)) {
                    item = (LexicalItem)this.itemsByID.get(id);
                }
            }
            catch (Exception e) {
                LexiconException ex = new LexiconException("Failed to retrieve item. Database access resulted in exception: " + e.getClass() + " with message: " + e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
        return item;
    }

    @Override
    public Collection<LexicalItem> getItems(String baseform) throws LexiconException {
        Collection<LexicalItem> items = super.getItems(baseform);
        if (items.isEmpty() && !this.allDataLoaded) {
            try {
                this.loadItemsByBaseform(baseform);
                if (this.itemsByBaseform.containsKey(baseform)) {
                    for (String id : (Set)this.itemsByBaseform.get(baseform)) {
                        items.add((LexicalItem)this.itemsByID.get(id));
                    }
                }
            }
            catch (Exception e) {
                LexiconException ex = new LexiconException("Failed to retrieve item. Database access resulted in exception: " + e.getClass() + " with message: " + e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
        return items;
    }

    @Override
    public LexicalItem getItem(Category cat, String baseform) throws LexiconException {
        if (cat == null || baseform == null) {
            return null;
        }
        LexicalItem item = super.getItem(cat, baseform);
        if (item == null && !this.allDataLoaded) {
            try {
                this.accessor.loadItem(cat, baseform);
                if (this.itemsByBaseform.containsKey(baseform)) {
                    for (String id : (Set)this.itemsByBaseform.get(baseform)) {
                        if (((LexicalItem)this.itemsByID.get(id)).getCategory() != cat) continue;
                        item = (LexicalItem)this.itemsByID.get(id);
                    }
                }
            }
            catch (Exception e) {
                LexiconException ex = new LexiconException("Failed to retrieve item. Database access resulted in exception: " + e.getClass() + " with message: " + e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
        return item;
    }

    public void loadVerbnetData() throws LexiconException {
        if (this.accessor instanceof SQLAccessor) {
            try {
                ((SQLAccessor)this.accessor).loadVerbnetData();
            }
            catch (Exception e) {
                LexiconException ex = new LexiconException("Failed to load verbnet data: " + e.getClass() + " with message: " + e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        } else {
            throw new LexiconException("Cannot load verbnet data: DBAccessor is not instance of SQLAccessor");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.allDataLoaded = false;
    }
}

