/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.kb;

import java.util.HashMap;
import java.util.Map;
import simplenlg.exception.SimplenlgException;
import simplenlg.kb.KBEntity;

public class SimpleKBClass
implements KBEntity {
    String name;
    SimpleKBClass parent;
    Map<String, Object> featureValues;

    public SimpleKBClass(String name) {
        this.name = name;
        this.featureValues = new HashMap<String, Object>();
    }

    public SimpleKBClass(String name, SimpleKBClass parent) {
        this(name);
        this.parent = parent;
    }

    public SimpleKBClass(SimpleKBClass parent) {
        this(null, parent);
    }

    public void setFeatureValue(String featureName, Object value) {
        this.featureValues.put(featureName, value);
    }

    @Override
    public String getType() {
        SimpleKBClass c = this;
        while (c != null) {
            if (c.getName() != null) {
                return c.getName();
            }
            c = c.getParent();
        }
        throw new SimplenlgException("SimpleKBClass - class does not have a named parent");
    }

    @Override
    public Object getValue(String featureName) {
        SimpleKBClass c = this;
        while (c != null) {
            Object value = c.getFeatureValue(featureName);
            if (value != null) {
                return value;
            }
            c = c.getParent();
        }
        return null;
    }

    public Object getFeatureValue(String featureName) {
        return this.featureValues.get(featureName);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SimpleKBClass " + this.name;
    }

    SimpleKBClass getParent() {
        return this.parent;
    }
}

