/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.kb;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import simplenlg.exception.SimplenlgException;
import simplenlg.kb.KBEntity;
import simplenlg.kb.NLGKB;
import simplenlg.kb.ProtegeClass;

public class ProtegeKB
implements NLGKB {
    KnowledgeBase kb;
    private Map<String, ProtegeClass> lookupClass;

    public ProtegeKB(String filename) {
        ArrayList errors = new ArrayList();
        Project project = new Project(filename, errors);
        this.lookupClass = new HashMap<String, ProtegeClass>();
        if (errors.size() != 0) {
            this.kb = null;
            throw new SimplenlgException("Protege KB: " + ((Object)errors).toString());
        }
        this.kb = project.getKnowledgeBase();
    }

    public ProtegeKB(KnowledgeBase kb) {
        this.lookupClass = new HashMap<String, ProtegeClass>();
        this.kb = kb;
    }

    @Override
    public KBEntity getClass(String className) {
        if (this.lookupClass.containsKey(className)) {
            return this.lookupClass.get(className);
        }
        Frame c = this.kb.getFrame(className);
        if (c != null) {
            ProtegeClass pc = new ProtegeClass(this, c);
            this.lookupClass.put(className, pc);
            return pc;
        }
        this.lookupClass.put(className, null);
        return null;
    }

    @Override
    public boolean isAncestor(String className, String ancestorName) {
        Cls ancestor;
        Cls c = this.kb.getCls(className);
        return c == (ancestor = this.kb.getCls(ancestorName)) || c.hasSuperclass(ancestor);
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase kb) {
        this.lookupClass = new HashMap<String, ProtegeClass>();
        this.kb = kb;
    }

    public ProtegeClass getInstanceOfClass(String className) {
        Cls c = this.kb.getCls(className);
        Frame instance = (Frame)this.getFirstInCollection(c.getInstances());
        if (instance != null) {
            return new ProtegeClass(this, instance);
        }
        return null;
    }

    Object getFirstInCollection(Collection coll) {
        Iterator it = coll.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Set<String> getSubclassNames(String className) {
        Cls c = this.kb.getCls(className);
        Iterator it = c.getSubclasses().iterator();
        HashSet<String> result = new HashSet<String>();
        while (it.hasNext()) {
            Cls subclass = (Cls)it.next();
            String subclassName = subclass.getName();
            if (subclassName.equalsIgnoreCase(className)) continue;
            result.add(subclassName);
        }
        return result;
    }
}

