/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.kb;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import simplenlg.exception.SimplenlgException;
import simplenlg.kb.KBEntity;
import simplenlg.kb.ProtegeKB;

public class ProtegeClass
implements KBEntity {
    private Frame frame;
    private ProtegeKB kb;
    private Map<String, Object> featureValues;

    public ProtegeClass(ProtegeKB kb, Frame frame) {
        this.frame = frame;
        this.kb = kb;
        this.featureValues = new HashMap<String, Object>();
    }

    @Override
    public String getType() {
        if (this.frame instanceof Cls) {
            return this.frame.getName();
        }
        if (this.frame instanceof Instance) {
            return ((Instance)this.frame).getDirectType().getName();
        }
        throw new SimplenlgException("Impossible Protege object");
    }

    @Override
    public Object getValue(String featureName) {
        Object result;
        Cls cframe;
        if (this.featureValues.containsKey(featureName)) {
            return this.featureValues.get(featureName);
        }
        Slot slot = this.kb.getKB().getSlot(featureName);
        if (slot == null) {
            this.featureValues.put(featureName, null);
            return null;
        }
        Collection value = null;
        if (this.frame instanceof Cls && ((value = (cframe = (Cls)this.frame).getTemplateSlotValues(slot)) == null || value.isEmpty())) {
            value = cframe.getTemplateSlotDefaultValues(slot);
        }
        if (value == null || value.isEmpty()) {
            value = this.frame.getOwnSlotValues(slot);
        }
        if (value == null || value.isEmpty()) {
            value = this.frame.getOwnSlotDefaultValues(slot);
        }
        if (value == null || value.isEmpty()) {
            result = null;
        } else if (value.size() == 1) {
            result = this.convert(this.kb.getFirstInCollection(value));
        } else {
            result = new ArrayList();
            for (Object o : value) {
                ((ArrayList)result).add(this.convert(o));
            }
        }
        this.featureValues.put(featureName, result);
        return result;
    }

    private Object convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return new Double(((Float)value).floatValue());
        }
        if (value instanceof Cls) {
            return this.kb.getClass(((Cls)value).getName());
        }
        if (value instanceof Frame) {
            return new ProtegeClass(this.kb, (Frame)value);
        }
        return value;
    }
}

