/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.kb;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import java.lang.reflect.Method;
import java.util.Collection;
import simplenlg.exception.SimplenlgException;
import simplenlg.kb.KBEntity;
import simplenlg.kb.NLGKB;
import simplenlg.kb.ProtegeKB;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.StringPhraseSpec;

public class Lexicaliser {
    NLGKB kb;
    public static final String TEMPLATE_FEATURE = "template";
    public static final String VERB_FEATURE = "verb";
    public static final String SUBJECT_FEATURE = "subject";
    public static final String COMPLEMENT_FEATURE = "complement";
    public static final String MODIFIER_FEATURE = "modifier";
    public static final String REFERENCE_FEATURE = "reference";
    public static final char START_BRACKET = '[';
    public static final char END_BRACKET = ']';
    public static final char START_FORMAT = '|';
    public static final char LITERAL_FORMAT = '%';
    public static final char FEATURE_CHAR = '.';
    public static final char CLASS_CHAR = '$';
    public static final char METHOD_CHAR = '#';

    public Lexicaliser(NLGKB kb) {
        this.kb = kb;
    }

    public PhraseSpec lexicalise(KBEntity entity) {
        String template = (String)entity.getValue(TEMPLATE_FEATURE);
        if (template != null) {
            return this.expandString(template, entity);
        }
        String verb = (String)entity.getValue(VERB_FEATURE);
        if (verb != null) {
            Object modifiers;
            Object complements;
            SPhraseSpec spec = new SPhraseSpec();
            verb = this.forceHeadString(this.expandString(verb, entity));
            spec.setVerb(verb);
            Object subjects = entity.getValue(SUBJECT_FEATURE);
            if (subjects != null) {
                if (subjects instanceof Collection) {
                    for (Object subject : (Collection)subjects) {
                        spec.addSubject(this.expandString((String)subject, entity));
                    }
                } else {
                    spec.addSubject(this.expandString((String)subjects, entity));
                }
            }
            if ((complements = entity.getValue(COMPLEMENT_FEATURE)) != null) {
                if (complements instanceof Collection) {
                    for (Object complement : (Collection)complements) {
                        spec.addComplement(this.expandString((String)complement, entity));
                    }
                } else {
                    spec.addComplement(this.expandString((String)complements, entity));
                }
            }
            if ((modifiers = entity.getValue(MODIFIER_FEATURE)) != null) {
                if (modifiers instanceof Collection) {
                    for (Object modifier : (Collection)modifiers) {
                        spec.addModifier(this.expandString((String)modifier, entity));
                    }
                } else {
                    spec.addModifier(this.expandString((String)modifiers, entity));
                }
            }
            return spec;
        }
        return null;
    }

    private PhraseSpec expandString(String template, KBEntity entity) {
        int startBracketPos;
        if (template == null || template.length() == 0) {
            return null;
        }
        if (template.charAt(0) == '[' && template.indexOf(93) == template.length() - 1) {
            Object result = this.realiseParameter(template.substring(1, template.indexOf(93)), entity);
            if (result instanceof String) {
                result = new StringPhraseSpec((String)result);
            }
            return (PhraseSpec)result;
        }
        int currentPos = 0;
        StringBuilder result = new StringBuilder();
        while ((startBracketPos = template.indexOf(91, currentPos)) >= 0) {
            int endBracketPos = template.indexOf(93, startBracketPos);
            if (endBracketPos < 0) {
                throw new SimplenlgException("Impossible nlgbase template: " + template);
            }
            if (currentPos < startBracketPos) {
                result.append(template.substring(currentPos, startBracketPos));
            }
            Object value = this.realiseParameter(template.substring(startBracketPos + 1, endBracketPos), entity);
            result.append((String)value);
            currentPos = endBracketPos + 1;
        }
        result.append(template.substring(currentPos));
        return new StringPhraseSpec(result.toString());
    }

    private Object realiseParameter(String parameterString, KBEntity entity) {
        Object value;
        String featureSpec = parameterString;
        String formatSpec = null;
        int formatPos = parameterString.indexOf(124);
        if (formatPos >= 0) {
            featureSpec = parameterString.substring(0, formatPos);
            formatSpec = parameterString.substring(formatPos + 1);
        }
        if ((value = this.forceKBEntity(this.getValue(featureSpec, entity))) == null) {
            throw new SimplenlgException("Simplenlg: No value for feature " + featureSpec + " in entity of type " + entity.getType());
        }
        if (formatSpec != null) {
            String format = (String)this.getValue(formatSpec, entity);
            return String.format(format, value);
        }
        if (value instanceof KBEntity) {
            return this.simpleReferringExpression((KBEntity)value);
        }
        return value.toString();
    }

    public String simpleReferringExpression(KBEntity entity) {
        String ref = (String)entity.getValue(REFERENCE_FEATURE);
        if (ref != null) {
            return ref;
        }
        return entity.getType().toLowerCase();
    }

    private Object forceKBEntity(Object e) {
        if (e instanceof KBEntity) {
            return e;
        }
        if (e instanceof Cls) {
            return this.kb.getClass(((Cls)e).getName());
        }
        if (e instanceof Instance) {
            return this.kb.getClass(((Instance)e).getDirectType().getName());
        }
        return e;
    }

    private Object getValue(String featureSpec, KBEntity message) {
        if (featureSpec == null || featureSpec.length() == 0) {
            return message;
        }
        if (featureSpec.charAt(0) == '%') {
            return featureSpec;
        }
        int dotPos = featureSpec.indexOf(46);
        String featureName = featureSpec;
        if (dotPos >= 0) {
            featureName = featureSpec.substring(0, dotPos);
        }
        Object value = message;
        if (featureName.charAt(0) == '$') {
            value = this.kb.getClass(featureName.substring(1));
        } else if (featureName.charAt(0) == '#') {
            try {
                Class<?> c = message.getClass();
                Method m = c.getMethod(featureName.substring(1), new Class[0]);
                value = m.invoke((Object)message, new Object[0]);
            }
            catch (Exception ex) {
                throw new SimplenlgException("Simplenlg: Cannot invoke method " + featureName.substring(1) + " in entity of type " + message.getType());
            }
        } else {
            value = this.forceKBEntity(message.getValue(featureName));
        }
        if (dotPos >= 0) {
            if (value instanceof String) {
                value = this.kb.getClass((String)value);
            }
            if (this.kb instanceof ProtegeKB && value instanceof Instance) {
                value = this.kb.getClass(((Instance)value).getName());
            }
            if (value == null || !(value instanceof KBEntity)) {
                throw new SimplenlgException("entity of type " + message.getType() + " does not have class-valued feature " + featureName + " in featurespec " + featureSpec);
            }
            return this.getValue(featureSpec.substring(dotPos + 1), (KBEntity)value);
        }
        return value;
    }

    private String forceHeadString(PhraseSpec p) {
        if (p instanceof StringPhraseSpec) {
            return ((StringPhraseSpec)p).getString();
        }
        if (p instanceof HeadedPhraseSpec) {
            return ((HeadedPhraseSpec)p).getHeadAsString();
        }
        throw new SimplenlgException("Impossible phrase spec");
    }
}

