/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.kb;

import java.util.HashMap;
import java.util.Map;
import simplenlg.exception.SimplenlgException;
import simplenlg.kb.KBEntity;
import simplenlg.kb.NLGKB;

public class JavaKB
implements NLGKB {
    String packageName;
    protected Map<String, Class> lookupClass;

    public JavaKB(String packageName) {
        this.packageName = packageName.length() > 0 && !packageName.endsWith(".") ? String.valueOf(packageName) + "." : packageName;
        this.lookupClass = new HashMap<String, Class>();
    }

    protected Class getJavaClass(String className) {
        if (this.lookupClass.containsKey(className)) {
            return this.lookupClass.get(className);
        }
        try {
            Class<?> c = Class.forName(String.valueOf(this.packageName) + className);
            this.lookupClass.put(className, c);
            return c;
        }
        catch (Exception ex) {
            this.lookupClass.put(className, null);
            return null;
        }
    }

    @Override
    public boolean isAncestor(String className, String ancestorName) {
        Class c = this.getJavaClass(className);
        Class ancestor = this.getJavaClass(ancestorName);
        if (c == null || ancestor == null) {
            return false;
        }
        return c.isAssignableFrom(ancestor);
    }

    @Override
    public KBEntity getClass(String className) {
        Class c = this.getJavaClass(className);
        if (c == null) {
            return null;
        }
        try {
            return (KBEntity)c.newInstance();
        }
        catch (Exception ex) {
            throw new SimplenlgException("JavaKB error: class " + className + " : " + ex.toString());
        }
    }
}

