/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.features;

import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Feature;

public enum DiscourseFunction implements Feature
{
    SUBJECT(6.0),
    OBJECT(5.0),
    INDIRECT_OBJECT(4.0),
    PREDICATIVE_COMPLEMENT(3.5),
    PREP_OBJECT(3.0),
    PREMODIFIER(2.0),
    POSTMODIFIER(2.0),
    FRONT_MODIFIER(2.0),
    MODIFIER(2.0),
    CUE_PHRASE(1.0),
    NULL(-1.0);

    private Double salience;

    private DiscourseFunction(double sal) {
        this.salience = new Double(sal);
    }

    public double getSalience() {
        return this.salience;
    }

    public void setSalience(double sal) {
        this.salience = new Double(sal);
    }

    public DiscourseFunction nextUp() {
        switch (this) {
            case OBJECT: {
                return SUBJECT;
            }
            case INDIRECT_OBJECT: {
                return OBJECT;
            }
        }
        return null;
    }

    public DiscourseFunction nextDown() {
        switch (this) {
            case SUBJECT: {
                return OBJECT;
            }
            case OBJECT: {
                return INDIRECT_OBJECT;
            }
        }
        return null;
    }

    @Override
    public boolean appliesTo(Category cat) {
        return cat.equals((Object)Category.NOUN);
    }

    public int compareSalience(DiscourseFunction f) {
        return -this.salience.compareTo(f.getSalience());
    }

    public Case getCaseValue() {
        switch (this) {
            case SUBJECT: 
            case PREMODIFIER: 
            case POSTMODIFIER: 
            case FRONT_MODIFIER: {
                return Case.NOMINATIVE;
            }
            case OBJECT: 
            case PREP_OBJECT: {
                return Case.ACCUSATIVE;
            }
        }
        return null;
    }
}

