/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import simplenlg.aggregation.EllipsisRule;
import simplenlg.features.DiscourseFunction;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.StringPhraseSpec;

public class PhraseSet {
    private DiscourseFunction function;
    private List<Phrase> phrases;
    List<EllipsisRule> leftMarkers;
    List<EllipsisRule> rightMarkers;

    public PhraseSet(DiscourseFunction function, Phrase ... phrases) {
        this.function = function;
        this.phrases = new ArrayList<Phrase>(Arrays.asList(phrases));
    }

    public void addPhrase(Phrase phrase) {
        this.phrases.add(phrase);
    }

    public void addPhrases(Collection<Phrase> phrases) {
        this.phrases.addAll(phrases);
    }

    public DiscourseFunction getFunction() {
        return this.function;
    }

    public void elideRightmost() {
        int i = 1;
        while (i < this.phrases.size()) {
            Phrase phrase = this.phrases.get(i);
            if (phrase != null) {
                phrase.setElided(true);
            }
            ++i;
        }
    }

    public void elideLeftmost() {
        int i = this.phrases.size() - 2;
        while (i >= 0) {
            Phrase phrase = this.phrases.get(i);
            if (phrase != null) {
                phrase.setElided(true);
            }
            --i;
        }
    }

    public boolean lemmaIdentical() {
        boolean ident = !this.phrases.isEmpty();
        int i = 1;
        while (i < this.phrases.size() && ident) {
            Phrase left = this.phrases.get(i - 1);
            Phrase right = this.phrases.get(i);
            if (left != null && right != null) {
                if (left instanceof StringPhraseSpec) {
                    ident = ((StringPhraseSpec)left).getString().equals(((StringPhraseSpec)right).getString());
                } else if (left instanceof HeadedPhraseSpec) {
                    ident = ((HeadedPhraseSpec)left).getHead().equals(((HeadedPhraseSpec)right).getHead());
                }
            }
            ++i;
        }
        return ident;
    }

    public boolean formIdentical() {
        boolean ident = !this.phrases.isEmpty();
        int i = 1;
        while (i < this.phrases.size() && ident) {
            Phrase left = this.phrases.get(i - 1);
            Phrase right = this.phrases.get(i);
            if (left != null && right != null) {
                if (left instanceof StringPhraseSpec) {
                    ident = ((StringPhraseSpec)left).getString().equals(((StringPhraseSpec)right).getString());
                } else if (left instanceof HeadedPhraseSpec) {
                    ident = ((HeadedPhraseSpec)left).equals(right);
                }
            }
            ++i;
        }
        return ident;
    }
}

