/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.aggregation.PhraseSet;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;

public abstract class PhraseChecker {
    public static boolean sameSentences(SPhraseSpec ... sentences) {
        boolean equal = false;
        if (sentences.length >= 2) {
            int i = 1;
            while (i < sentences.length) {
                equal = sentences[i - 1].equals(sentences[i]);
                ++i;
            }
        }
        return equal;
    }

    public static boolean areNotCoordinate(SPhraseSpec ... sentences) {
        boolean notCoord = true;
        int i = 0;
        while (i < sentences.length) {
            notCoord = !sentences[i].isCoordinate();
            ++i;
        }
        return notCoord;
    }

    public static boolean sameFrontMods(SPhraseSpec ... sentences) {
        boolean equal = true;
        if (sentences.length >= 2) {
            int i = 1;
            while (i < sentences.length && equal) {
                equal = !sentences[i - 1].hasCuePhrase() && !sentences[i].hasCuePhrase() ? sentences[i - 1].getFrontModifiers().equals(sentences[i].getFrontModifiers()) : (sentences[i - 1].hasCuePhrase() && sentences[i].hasCuePhrase() ? sentences[i - 1].getFrontModifiers().equals(sentences[i].getFrontModifiers()) && sentences[i].getCuePhrase().equals(sentences[i - 1].getCuePhrase()) : false);
                ++i;
            }
        }
        return equal;
    }

    public static boolean sameSubjects(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && equal) {
            equal = sentences[i - 1].getSubjects().equals(sentences[i].getSubjects());
            ++i;
        }
        return equal;
    }

    public static boolean samePassiveRaisingSubjects(SPhraseSpec ... sentences) {
        boolean samePassiveSubjects = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && samePassiveSubjects) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            samePassiveSubjects = vp1.getPassiveRaisingComplements().equals(vp2.getPassiveRaisingComplements());
            ++i;
        }
        return samePassiveSubjects;
    }

    public static boolean allPassive(SPhraseSpec ... sentences) {
        boolean passive = true;
        int i = 0;
        while (i < sentences.length && passive) {
            passive = sentences[i].isPassive();
            ++i;
        }
        return passive;
    }

    public static boolean allActive(SPhraseSpec ... sentences) {
        boolean active = true;
        int i = 0;
        while (i < sentences.length && active) {
            active = !sentences[i].isPassive();
            ++i;
        }
        return active;
    }

    public static boolean sameSurfaceSubjects(SPhraseSpec ... sentences) {
        return PhraseChecker.allActive(sentences) && PhraseChecker.sameSubjects(sentences) || PhraseChecker.allPassive(sentences) && PhraseChecker.samePassiveRaisingSubjects(sentences);
    }

    public static boolean sameVPHead(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && equal) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            if (vp1 != null && vp2 != null) {
                Verb h1 = (Verb)vp1.getHead();
                Verb h2 = (Verb)vp2.getHead();
                equal = h1 != null && h2 != null ? h1.equals(h2) : false;
            } else {
                equal = false;
            }
            ++i;
        }
        return equal;
    }

    public static boolean haveSameVoice(SPhraseSpec ... sentences) {
        boolean samePassive = true;
        boolean prevIsPassive = false;
        if (sentences.length > 1) {
            prevIsPassive = sentences[0].isPassive();
            int i = 1;
            while (i < sentences.length && samePassive) {
                samePassive = sentences[i].isPassive() == prevIsPassive;
                ++i;
            }
        }
        return samePassive;
    }

    public static boolean areNotExistential(SPhraseSpec ... sentences) {
        boolean notex = true;
        int i = 0;
        while (i < sentences.length && notex) {
            notex = !sentences[i].isExistential();
            ++i;
        }
        return notex;
    }

    public static boolean sameVP(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && equal) {
            equal = sentences[i - 1].getVerbPhrase().equals(sentences[i].getVerbPhrase());
            ++i;
        }
        return equal;
    }

    public static boolean sameVPArgs(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && equal) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            equal = vp1.getComplements().equals(vp2.getComplements());
            ++i;
        }
        return equal;
    }

    public static boolean sameVPModifiers(SPhraseSpec ... sentences) {
        boolean equal = sentences.length >= 2;
        int i = 1;
        while (i < sentences.length && equal) {
            VPPhraseSpec vp1 = sentences[i - 1].getVerbPhrase();
            VPPhraseSpec vp2 = sentences[i].getVerbPhrase();
            equal = vp1.getPostmodifiers().equals(vp2.getPostmodifiers()) && vp1.getPremodifiers().equals(vp2.getPremodifiers()) && vp1.getAttributivePostmodifiers().equals(vp2.getAttributivePostmodifiers());
            ++i;
        }
        return equal;
    }

    public static List<PhraseSet> leftPeriphery(SPhraseSpec ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet cue = new PhraseSet(DiscourseFunction.CUE_PHRASE, new Phrase[0]);
        PhraseSet front = new PhraseSet(DiscourseFunction.FRONT_MODIFIER, new Phrase[0]);
        PhraseSet subj = new PhraseSet(DiscourseFunction.SUBJECT, new Phrase[0]);
        SPhraseSpec[] sPhraseSpecArray = sentences;
        int n = sentences.length;
        int n2 = 0;
        while (n2 < n) {
            SPhraseSpec s = sPhraseSpecArray[n2];
            if (s.hasCuePhrase()) {
                cue.addPhrase(s.getCuePhrase());
            }
            if (s.hasFrontModifiers()) {
                front.addPhrases(s.getFrontModifiers());
            }
            if (s.hasSubject()) {
                subj.addPhrases(s.getSubjects());
            }
            ++n2;
        }
        funcsets.add(cue);
        funcsets.add(front);
        funcsets.add(subj);
        return funcsets;
    }

    public static List<PhraseSet> rightPeriphery(SPhraseSpec ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet comps = new PhraseSet(DiscourseFunction.OBJECT, new Phrase[0]);
        new PhraseSet(DiscourseFunction.INDIRECT_OBJECT, new Phrase[0]);
        PhraseSet pmods = new PhraseSet(DiscourseFunction.POSTMODIFIER, new Phrase[0]);
        SPhraseSpec[] sPhraseSpecArray = sentences;
        int n = sentences.length;
        int n2 = 0;
        while (n2 < n) {
            SPhraseSpec s = sPhraseSpecArray[n2];
            if (s.hasComplements()) {
                comps.addPhrases(s.getComplements());
            }
            if (s.hasPostmodifiers()) {
                pmods.addPhrases(s.getPostmodifiers());
            }
            ++n2;
        }
        funcsets.add(comps);
        funcsets.add(pmods);
        return funcsets;
    }
}

