"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("@aws-solutions-constructs/core");
const cdk = require("aws-cdk-lib");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class EventbridgeToSns extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the EventbridgeToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToSnsProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckSnsProps(props);
        defaults.CheckEventBridgeProps(props);
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the sns topic.
        const buildTopicResponse = defaults.buildTopic(this, id, {
            existingTopicObj: props.existingTopicObj,
            topicProps: props.topicProps,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.snsTopic = buildTopicResponse.topic;
        this.encryptionKey = buildTopicResponse.key;
        // Setup the event rule target as sns topic.
        // The CDK generally avoids resource names that are too long, but in this case the maximum SNS topic name is 256 characters and the maximum
        // binding id is 64 characters, so a long SNS topic name (driven by Stack id, Construct id, etc.) breaks upon launch. Because of this, we take
        // control of the physical name ourselves.
        const maxBindingIdLength = 64;
        const nameParts = [
            cdk.Stack.of(scope).stackName, // Name of the stack
            id, // Construct ID
        ];
        const generatedTopicName = defaults.generatePhysicalName("", nameParts, maxBindingIdLength);
        const topicEventTarget = {
            bind: () => ({
                id: generatedTopicName,
                arn: this.snsTopic.topicArn
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        // Setup up the event rule property.
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([topicEventTarget], this.eventBus);
        const eventsRuleProps = (0, core_1.overrideProps)(defaultEventsRuleProps, props.eventRuleProps, true);
        // Setup up the event rule.
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        // Setup up the grant policy for event to be able to publish to the sns topic.
        this.snsTopic.grantPublish(new aws_iam_1.ServicePrincipal('events.amazonaws.com'));
        // Grant EventBridge service access to the SNS Topic encryption key
        this.encryptionKey?.grant(new aws_iam_1.ServicePrincipal('events.amazonaws.com'), "kms:Decrypt", "kms:Encrypt", "kms:ReEncrypt*", "kms:GenerateDataKey*");
    }
}
exports.EventbridgeToSns = EventbridgeToSns;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToSns[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-sns.EventbridgeToSns", version: "2.64.0" };
//# sourceMappingURL=data:application/json;base64,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