"""
    Staging API reference

    Service name    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.api_status import ApiStatus
from pensando_dss.psm.model.staging_buffer import StagingBuffer
from pensando_dss.psm.model.staging_buffer_list import StagingBufferList
from pensando_dss.psm.model.staging_bulk_edit_action import StagingBulkEditAction
from pensando_dss.psm.model.staging_clear_action import StagingClearAction
from pensando_dss.psm.model.staging_commit_action import StagingCommitAction


class StagingV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_buffer(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_buffer(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (StagingBuffer):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_buffer = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers',
                'operation_id': 'add_buffer',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (StagingBuffer,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_buffer
        )

        def __add_buffer1(
            self,
            body,
            **kwargs
        ):
            """Create Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_buffer1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (StagingBuffer):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_buffer1 = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers',
                'operation_id': 'add_buffer1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (StagingBuffer,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_buffer1
        )

        def __bulkedit(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create/Update/Delete multiple objects as part of a single request  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulkedit(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (StagingBulkEditAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBulkEditAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.bulkedit = _Endpoint(
            settings={
                'response_type': (StagingBulkEditAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers/{O.Name}/bulkedit',
                'operation_id': 'bulkedit',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (StagingBulkEditAction,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bulkedit
        )

        def __bulkedit1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Create/Update/Delete multiple objects as part of a single request  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulkedit1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (StagingBulkEditAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBulkEditAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.bulkedit1 = _Endpoint(
            settings={
                'response_type': (StagingBulkEditAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers/{O.Name}/bulkedit',
                'operation_id': 'bulkedit1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (StagingBulkEditAction,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__bulkedit1
        )

        def __clear(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Clear operations from a configuration buffer  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.clear(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (StagingClearAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingClearAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.clear = _Endpoint(
            settings={
                'response_type': (StagingClearAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers/{O.Name}/clear',
                'operation_id': 'clear',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (StagingClearAction,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__clear
        )

        def __clear1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Clear operations from a configuration buffer  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.clear1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (StagingClearAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingClearAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.clear1 = _Endpoint(
            settings={
                'response_type': (StagingClearAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers/{O.Name}/clear',
                'operation_id': 'clear1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (StagingClearAction,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__clear1
        )

        def __commit(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Commit a staged configuration buffer  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.commit(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (StagingCommitAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingCommitAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.commit = _Endpoint(
            settings={
                'response_type': (StagingCommitAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers/{O.Name}/commit',
                'operation_id': 'commit',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (StagingCommitAction,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__commit
        )

        def __commit1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Commit a staged configuration buffer  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.commit1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (StagingCommitAction):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingCommitAction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.commit1 = _Endpoint(
            settings={
                'response_type': (StagingCommitAction,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers/{O.Name}/commit',
                'operation_id': 'commit1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (StagingCommitAction,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__commit1
        )

        def __delete_buffer(
            self,
            o_tenant,
            **kwargs
        ):
            """Delete Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_buffer(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.delete_buffer = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers/{O.Name}',
                'operation_id': 'delete_buffer',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_buffer
        )

        def __delete_buffer1(
            self,
            o_name,
            **kwargs
        ):
            """Delete Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_buffer1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_buffer1 = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers/{O.Name}',
                'operation_id': 'delete_buffer1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_buffer1
        )

        def __get_buffer(
            self,
            o_tenant,
            **kwargs
        ):
            """Get Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_buffer(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                spec_contact (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.get_buffer = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers/{O.Name}',
                'operation_id': 'get_buffer',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    't_kind',
                    'meta_creation_time',
                    'spec_contact',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'spec_contact':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                    'spec_contact': 'spec.Contact',
                },
                'location_map': {
                    'o_tenant': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                    'spec_contact': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_buffer
        )

        def __get_buffer1(
            self,
            o_name,
            **kwargs
        ):
            """Get Buffer object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_buffer1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                spec_contact (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBuffer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_buffer1 = _Endpoint(
            settings={
                'response_type': (StagingBuffer,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers/{O.Name}',
                'operation_id': 'get_buffer1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    'meta_creation_time',
                    'spec_contact',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'spec_contact':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                    'spec_contact': 'spec.Contact',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                    'spec_contact': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_buffer1
        )

        def __list_buffer(
            self,
            o_tenant,
            **kwargs
        ):
            """List Buffer objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_buffer(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBufferList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_buffer = _Endpoint(
            settings={
                'response_type': (StagingBufferList,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/tenant/{O.Tenant}/buffers',
                'operation_id': 'list_buffer',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_buffer
        )

        def __list_buffer1(
            self,
            **kwargs
        ):
            """List Buffer objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_buffer1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingBufferList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_buffer1 = _Endpoint(
            settings={
                'response_type': (StagingBufferList,),
                'auth': [],
                'endpoint_path': '/configs/staging/v1/buffers',
                'operation_id': 'list_buffer1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_buffer1
        )
