"""
    Routing API reference

       # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.routing_health import RoutingHealth
from pensando_dss.psm.model.routing_neighbor_list import RoutingNeighborList
from pensando_dss.psm.model.routing_route_filter import RoutingRouteFilter
from pensando_dss.psm.model.routing_route_list import RoutingRouteList


class RoutingV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_health_z(
            self,
            instance,
            **kwargs
        ):
            """get_health_z  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_health_z(instance, async_req=True)
            >>> result = thread.get()

            Args:
                instance (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoutingHealth
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.get_health_z = _Endpoint(
            settings={
                'response_type': (RoutingHealth,),
                'auth': [],
                'endpoint_path': '/routing/v1/{Instance}/health',
                'operation_id': 'get_health_z',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance',
                ],
                'required': [
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance':
                        (str,),
                },
                'attribute_map': {
                    'instance': 'Instance',
                },
                'location_map': {
                    'instance': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_health_z
        )

        def __get_list_neighbors(
            self,
            instance,
            **kwargs
        ):
            """get_list_neighbors  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_list_neighbors(instance, async_req=True)
            >>> result = thread.get()

            Args:
                instance (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                neighbor (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoutingNeighborList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.get_list_neighbors = _Endpoint(
            settings={
                'response_type': (RoutingNeighborList,),
                'auth': [],
                'endpoint_path': '/routing/v1/{Instance}/neighbors',
                'operation_id': 'get_list_neighbors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance',
                    't_kind',
                    'meta_creation_time',
                    'neighbor',
                ],
                'required': [
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'neighbor':
                        (str,),
                },
                'attribute_map': {
                    'instance': 'Instance',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                    'neighbor': 'neighbor',
                },
                'location_map': {
                    'instance': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                    'neighbor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_list_neighbors
        )

        def __get_list_routes1(
            self,
            instance,
            **kwargs
        ):
            """get_list_routes1  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_list_routes1(instance, async_req=True)
            >>> result = thread.get()

            Args:
                instance (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                ipaddress (str): [optional]
                page_number (int): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoutingRouteList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance'] = \
                instance
            return self.call_with_http_info(**kwargs)

        self.get_list_routes1 = _Endpoint(
            settings={
                'response_type': (RoutingRouteList,),
                'auth': [],
                'endpoint_path': '/routing/v1/{Instance}/routes',
                'operation_id': 'get_list_routes1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance',
                    't_kind',
                    'meta_creation_time',
                    'ipaddress',
                    'page_number',
                ],
                'required': [
                    'instance',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'ipaddress':
                        (str,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'instance': 'Instance',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                    'ipaddress': 'ipaddress',
                    'page_number': 'page-number',
                },
                'location_map': {
                    'instance': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                    'ipaddress': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_list_routes1
        )

        def __post_list_routes(
            self,
            instance,
            body,
            **kwargs
        ):
            """post_list_routes  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_list_routes(instance, body, async_req=True)
            >>> result = thread.get()

            Args:
                instance (str):
                body (RoutingRouteFilter):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoutingRouteList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance'] = \
                instance
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.post_list_routes = _Endpoint(
            settings={
                'response_type': (RoutingRouteList,),
                'auth': [],
                'endpoint_path': '/routing/v1/{Instance}/routes',
                'operation_id': 'post_list_routes',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance',
                    'body',
                ],
                'required': [
                    'instance',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance':
                        (str,),
                    'body':
                        (RoutingRouteFilter,),
                },
                'attribute_map': {
                    'instance': 'Instance',
                },
                'location_map': {
                    'instance': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_list_routes
        )
