# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05b_data.gym.ipynb (unless otherwise specified).

__all__ = ['ReturnHistory', 'TstCallback', 'np_type_cast', 'GymLoop', 'FirstLastTfm', 'FirstLast', 'show_source',
           'ResReduce', 'Reward', 'NEpisodes', 'fake_gym_learner']

# Cell
# Python native modules
import os
from collections import deque
from copy import deepcopy
from time import sleep
from typing import *
from warnings import warn
# Third party libs
from fastcore.all import *
from fastai.torch_basics import *
from fastai.data.all import *
from fastai.basics import *
from fastai.callback.all import *
from torch.utils.data import Dataset
from torch import nn
import torch
import gym
try:
    import pybulletgym
except ModuleNotFoundError as e:pass
import numpy as np
from torch.utils.tensorboard import SummaryWriter
# Local modules
from ..core import *
from ..callback.core import *
from .block import *
from ..agent import *

# Cell
class ReturnHistory(Transform):
    def encodes(self,o:dict):
        source,data=o['source'],o['history']
        history=sum(source.histories)
        if len(source.histories)==1 and sum(history['done'])>0:
            source.all_done=TensorBatch([[True]])
            history['all_done']=TensorBatch([[True]])
        source.histories.popleft()
        return {'source':source,'history':history}

# Cell
class TstCallback(AgentCallback):
    def __init__(self,action_space=None,constant=None):
        store_attr()
        self.action_executions=0

    def before_noise(self):
        bs=self.experience['state'].shape[0]
        self.agent.action=Tensor([[self.constant] if self.constant is not None else
                                   self.action_space.sample()
                                   for _ in range(bs)])
        self.agent.experience=D(merge(self.experience,{'random_action':np.random.randint(0,3,(bs,1))}))

        self.action_executions+=1

def np_type_cast(a,dtype): return a.astype(dtype)

class GymLoop(LoopCallback):
    _methods=source_events
    _default='source'
    def __init__(self,env_name:str,agent=None,mode=None,
                 steps_count:int=1,steps_delta:int=1,seed:int=None,
                 worker_id:int=0,dtype=None):
        store_attr()

    def initialize(self):
        self.source.histories=deque(maxlen=self.steps_count)
        self.source.return_fn=Pipeline([ReturnHistory])
        if self.mode!='rgb_array': self.source.ignore_fields.append('image')
        self.source.worker_id=get_worker_info()
        self.source.worker_id=TensorBatch(np.array([[getattr(self.worker_id,'id',0)]]))

        self.source.env=gym.make(self.env_name)
        if isinstance(self.env.action_space,gym.spaces.Discrete):
            self.dtype=int
        elif isinstance(self.env.action_space,gym.spaces.Box):
            if issubclass(self.env.action_space.dtype.type,(float,np.floating)):
                self.dtype=partial(np_type_cast,dtype=float)
            if issubclass(self.env.action_space.dtype.type,(int,np.integer)):
                self.dtype=partial(np_type_cast,dtype=int)
        else:
            self.dtype=float

        self.agent=ifnone(self.agent,Agent(cbs=TstCallback(action_space=self.env.action_space)))
        self.source.episode_id=TensorBatch(np.array([[0]]))
        self.source.done=TensorBatch(np.array([[True]]))
        self.source.all_done=TensorBatch(np.array([[True]]))

    def reset(self):
        if len(self.histories)==0 and sum(self.all_done)>=1:
            self.source.env_id=TensorBatch(np.array([[0]]))
            self.source.reward=TensorBatch(np.array([[0.0]]))
            self.source.episode_id+=1
            self.source.accum_rewards=TensorBatch(np.array([[0.0]]))
            self.source.step=TensorBatch(np.array([[0]]))
            self.source.env_id=TensorBatch(np.array([[0]]))
            self.source.done=TensorBatch(np.array([[False]]))
            self.source.all_done=TensorBatch(np.array([[False]]))
            self.source.env.seed(self.seed)
            self.source.state=TensorBatch(self.env.reset()).unsqueeze(0)
            if self.mode=='rgb_array':
                self.source.image=TensorBatch(np.expand_dims(self.env.render(self.mode).copy(),0))

    def before_episodes(self): self('initialize')

    def do_step(self):
        action,experience=self.agent.do_action(**self.data())
        for k,v in experience.items():
            if v is not None: setattr(self.source,k,TensorBatch(v))
        self.source.action=TensorBatch(action)
        step_action=self.action.numpy()[0]
        next_state,reward,done,_=self.env.step(self.dtype(step_action))
        self.source.next_state=TensorBatch(next_state).unsqueeze(0)
        self.source.reward=TensorBatch(np.expand_dims(reward,(0,1)))
        self.source.accum_rewards+=reward
        self.source.done=TensorBatch(np.expand_dims(done,(0,1)))
        if self.mode=='rgb_array':
            self.source.image=TensorBatch(np.expand_dims(self.env.render(self.mode).copy(),0))
        self.source.step+=1

    def before_history(self):
        self.source.skip_history_return=False
        self.histories.append(deepcopy(self.data()))

        if self.done.sum().item()<1:
            self.source.skip_history_return=len(self.histories)<self.steps_count or \
                                            int(self.step.item())%self.steps_delta!=0

    def history(self):
        if sum(self.done)>0 and len(self.histories)>1 and self.steps_count>1:
            self.source.loop_history_yield=True

    def after_history(self):
        self.source.state=self.source.next_state


add_docs(GymLoop,"Handles iterating through single openai gym (and varients).",
         before_history="""Primarily appends `self.data()` to `self.histories` however it also...

         If the number of elements in `self.histories` is empty, or about to be empty, and
         `self.done==True` it sets the `self.all_done` field.

         If `self.done==True` also determine if we should skip returning a history.
         Mainly if we need to accumulate the histories first.
         """,
         initialize="Sets up most of the needed fields as well as the environment itself.",
         reset="Resets the env and fields if the histories have been emptied.",
         before_episodes="Call the initialization method again.",
         do_step="Get actions from the agent and take a step through the env.",
         history="If the environment is done, we want to loop through the histories and empty them.",
         after_history="Once everything is processed, we set the next state to the current state for the next loop.")

# Cell
class FirstLastTfm(Transform):
    def __init__(self,gamma):
        store_attr()
        super().__init__()


    def encodes(self,o):
#         print('encoding')
        source,history=o['source'],o['history']
#         print(source,history,o)
        element=history[0]
        if history.bs()!=1:
            remainder=history[1:]
            reward=element['reward']
            for e in reversed(remainder['reward']):
                reward*=self.gamma
                reward+=e
            element['reward']=reward
            element['next_state']=history[-1]['next_state']
            element['done']=history[-1]['done']

#         print(source,element)
        return {'source':source,'history':element}

class FirstLast(LoopCallback):
    _methods=source_events
    _default='source'

    def __init__(self,gamma=0.99): store_attr()
    def before_episodes(self): self('initialize')
    def initialize(self):
        if isinstance(self.source.return_fn,Pipeline):
            self.source.return_fn.add(FirstLastTfm(self.gamma))
        else:
            self.source.return_fn=Pipeline([self.source.return_fn,FirstLastTfm(self.gamma)])

# Cell
def show_source(src,iters=50):
    from IPython import display
    import PIL.Image

    for x,_ in zip(iter(src),range(iters)):
        for _img in x['image'].numpy():
            display.clear_output(wait=True)
            display.display(PIL.Image.fromarray(_img))



# Cell
class ResReduce(LoopCallback):
    _methods=source_events
    _default='source'

    def __init__(self,
                 reduce_by=2 # The amount to reduce the `image` resolution by e.g.: 400x400 -> 200x200 if default is used.
                ):
        "Reduces the image field in a loop by `reduce_by` and assumes image is format BxWxHxC or BxHxWxC"
        store_attr()
    def before_episodes(self): self('initialize')
    def initialize(self):
        if 'image' not in self.data_fields:
            warn('Since `image` not in self.data_fields, no image reduction will be attempted!')

    def do_step(self):
        if 'image' in self.data_fields:
            self.source.image=self.source.image[:,::self.reduce_by,::self.reduce_by,:]

# Cell
class Reward(Metric):
    order=30
    reward=None
    rolling_reward_n=100
    keep_rewards=False
    counter=0

    def __init__(self,writer:SummaryWriter=None): store_attr()

    def reset(self):
        if self.reward is None: self.reward=deque(maxlen=self.rolling_reward_n)

    def accumulate(self,learn):
        xb=learn.xb[0]
        self.counter+=1
        if xb['all_done'].sum()>0:
            final_rewards=to_detach(xb['accum_rewards'][xb['all_done']]).reshape(-1,).numpy().tolist()

            for r in final_rewards:
                self.reward.append(r)
                if self.writer is not None: self.writer.add_scalar('reward',r,self.counter)

    @property
    def value(self): return np.average(self.reward) if len(self.reward)>0 else 0

# Cell
class NEpisodes(Metric):
    order=30
    n_episodes=None

    def reset(self):
        if self.n_episodes is None: self.n_episodes=0

    def accumulate(self,learn):
        xb=learn.xb[0]
        if xb['all_done'].sum()>0:
            new_episodes=torch.unique(to_detach(xb['episode_id'][xb['all_done']]))
            self.n_episodes+=len(new_episodes)


    @property
    def value(self): return self.n_episodes

# Cell
def fake_gym_learner(source,n=1000,bs=1,num_workers=0,**kwargs):
    from torch.nn import Linear

    class FakeModel(Module):
        def __init__(self):  self.fc=Linear(5,5)
        def forward(self,x): return x

    block=SourceDataBlock()
    dls=block.dataloaders([source],n=n,bs=bs,num_workers=num_workers,verbose=False)
    return Learner(dls,FakeModel(),metrics=[Reward,NEpisodes],loss_func=lambda o: 0.5,**kwargs)