#!/usr/bin/env python
# coding: utf-8

# Copyright (c) Jupyter Development Team.
# Distributed under the terms of the Modified BSD License.

from setuptools import setup
from jupyter_packaging import create_cmdclass
from pathlib import Path
import json
import sys
import os

HERE = Path(__file__).parent.resolve()

# Get the package info from package.json
pkg_json = json.loads((HERE / "package.json").read_bytes())

lab_path = (HERE / pkg_json["jupyterlab"]["outputDir"])

# Representative files that should exist after a successful build
ensured_targets = [
    str(lab_path / "package.json"),
    str(lab_path / "static/style.js")
]

labext_name = pkg_json["name"]

data_files_spec = [
    # labextension installation
    ("etc/jupyter/jupyter_server_config.d", "etc/jupyter/jupyter_server_config.d/", "*.json"),
    # For backward compatibility with notebook server
    ("etc/jupyter", "etc/jupyter/", "*.json"),
    # labextension files
    ("share/jupyter/labextensions/%s" % labext_name, str(lab_path.relative_to(HERE)), "**"),
    ("share/jupyter/labextensions/%s" % labext_name, str("."), "install.json"),
]

setup_args = dict()

if not os.getenv("NBGRADER_NO_LAB"):
    try:
        from jupyter_packaging import (
            wrap_installers,
            npm_builder,
            get_data_files
        )

        post_develop = npm_builder(
            build_cmd="install:labextension", source_dir="src", build_dir=lab_path, npm="jlpm"
        )
        setup_args["cmdclass"] = wrap_installers(post_develop=post_develop, ensured_targets=ensured_targets)
        setup_args["data_files"] = get_data_files(data_files_spec)
    except ImportError as e:
        import logging
        logging.basicConfig(format="%(levelname)s: %(message)s")
        logging.warning("Build tool `jupyter-packaging` is missing. Install it with pip or conda.")
        if not ("--name" in sys.argv or "--version" in sys.argv):
            raise e

if __name__ == "__main__":
    setup(**setup_args)
