import numpy as np
from .misc import parseAtom, roman_to_int
from glob import glob
import pyneb as pn
from copy import deepcopy

class CST(object):
    BOLTZMANN = 1.3806488e-16 # erg/K - NIST 2010
    CLIGHT = 2.99792458e10 # cm/s - NIST 2010
    HPLANCK = 6.62606957e-27 # erg s - NIST 2010
    EMASS = 9.10938291e-28 # g - NIST 2010
    ECHARGE = 1.602176565e-19 # Electron charge in Coulomb - NIST 2010
    PI = 3.141592653589793238462643
    BOLTZMANN_ANGK = (BOLTZMANN) / (HPLANCK * CLIGHT * 1.e8) # Boltzmann constant in (Ang * Kelvin) ** -1
    RYD = 109737.31568539 # Rydberg constant in cm^-1 - NIST 2010 
    RYD_EV = HPLANCK * CLIGHT * RYD * 1.e-7 / ECHARGE # infinite mass Rydberg in eV
    RYD_ANG = 1.e8 / RYD # infinite mass Rydberg in A
    RYD2ERG = HPLANCK * CLIGHT * RYD
    KCOLLRATE = np.sqrt(2 * PI / BOLTZMANN) * (HPLANCK / (2 * PI))**2 / EMASS**1.5 # constant of collisional rate equation
    BOLTZMANN_eVK = 8.617343e-5 # Boltzmann constant in eV/K
    RYD_erg =  2.179872325e-11 # HPLANCK * CLIGHT * RYD
    HBETA = 4861.3316598713955

Z = {}
Z["H"] = 1
Z['D'] = 1
Z["He"] = 2
#Z["3He"] = 2
Z["Li"] = 3
Z["Be"] = 4
Z["B"] = 5
Z["C"] = 6
Z["N"] = 7
Z["O"] = 8
Z["F"] = 9
Z["Ne"] = 10
Z["Na"] = 11
Z["Mg"] = 12
Z["Al"] = 13
Z["Si"] = 14
Z["P"] = 15
Z["S"] = 16
Z["Cl"] = 17
Z["Ar"] = 18
Z["K"] = 19
Z["Ca"] = 20
Z["Sc"] = 21
Z["Ti"] = 22
Z["V"] = 23
Z["Cr"] = 24
Z["Mn"] = 25
Z["Fe"] = 26
Z["Co"] = 27
Z["Ni"] = 28
Z["Cu"] = 29
Z["Zn"] = 30
Z["Ga"] = 31
Z["Ge"] = 32
Z["As"] = 33
Z["Se"] = 34
Z["Br"] = 35
Z["Kr"] = 36
Z["Rb"] = 37
Z["Sr"] = 38
Z["Y"] = 39
Z["Zr"] = 40
Z["Nb"] = 41
Z["Mo"] = 42
Z["Tc"] = 43
Z["Ru"] = 44
Z["Rh"] = 45
Z["Pd"] = 46
Z["Ag"] = 47
Z["Cd"] = 48
Z["In"] = 49
Z["Sn"] = 50
Z["Sb"] = 51
Z["Te"] = 52
Z["I"] = 53
Z["Xe"] = 54
Z["Cs"] = 55
Z["Ba"] = 56
Z["La"] = 57
Z["Ce"] = 58
Z["Pr"] = 59
Z["Nd"] = 60
Z["Pm"] = 61
Z["Sm"] = 62
Z["Eu"] = 63
Z["Gd"] = 64
Z["Tb"] = 65
Z["Dy"] = 66
Z["Ho"] = 67
Z["Er"] = 68
Z["Tm"] = 69
Z["Yb"] = 70
Z["Lu"] = 71
Z["Hf"] = 72
Z["Ta"] = 73
Z["W"] = 74
Z["Re"] = 75
Z["Os"] = 76
Z["Ir"] = 77
Z["Pt"] = 78
Z["Au"] = 79
Z["Hg"] = 80
Z["Tl"] = 81
Z["Pb"] = 82
Z["Bi"] = 83
Z["Po"] = 84
Z["At"] = 85
Z["Rn"] = 86
Z["Fr"] = 87
Z["Ra"] = 88
Z["Ac"] = 89
Z["Th"] = 90
Z["Pa"] = 91
Z["U"] = 92
Z["Np"] = 93
Z["Pu"] = 94
Z["Am"] = 95
Z["Cm"] = 96
Z["Bk"] = 97
Z["Cf"] = 98
Z["Es"] = 99
Z["Fm"] = 100
Z["Md"] = 101
Z["No"] = 102
Z["Lr"] = 103
Z["Rf"] = 104
Z["Db"] = 105
Z["Sg"] = 106
Z["Bh"] = 107
Z["Hs"] = 108
Z["Mt"] = 109
Z["Ds"] = 110

Z_inv = {}
for k in Z.keys():
    Z_inv[Z[k]] = k

"""
def make_IPs():
    import mendeleev
    for i in np.arange(117):
        a = mendeleev.element(i+1)
        to_print = 'IP["{}"] = ['.format(a.symbol)
        to_print += ', '.join(str(v) for v in a.ionenergies.values())
        to_print += ']'
        print(to_print)
"""

IP = {}
IP["H"] = [13.5984340051]
IP["He"] = [24.587387936, 54.41776311]
IP["Li"] = [5.391714761, 75.6400937, 122.4543538]
IP["Be"] = [9.322699, 18.211153, 153.896198, 217.7185766]
IP["B"] = [8.298019, 25.15483, 37.93058, 259.3715, 340.226008]
IP["C"] = [11.260296, 24.3845, 47.88778, 64.49358, 392.0905, 489.993177]
IP["N"] = [14.53413, 29.60125, 47.4453, 77.4735, 97.89013, 552.06731, 667.04609]
IP["O"] = [13.618054, 35.12111, 54.93554, 77.4135, 113.8989, 138.1189, 739.32679, 871.40985]
IP["F"] = [17.42282, 34.97081, 62.708, 87.175, 114.249, 157.1631, 185.1868, 953.898, 1103.11743]
IP["Ne"] = [21.56454, 40.96296, 63.42331, 97.19, 126.247, 157.934, 207.271, 239.0969, 1195.80779, 1362.1991]
IP["Na"] = [5.1390767, 47.28636, 71.62, 98.936, 138.4, 172.228, 208.5, 264.192, 299.86, 1465.13444, 1648.702]
IP["Mg"] = [7.646235, 15.035267, 80.1436, 109.2654, 141.335, 186.76, 225.015, 265.924, 327.985, 367.5, 1761.80481, 1962.664]
IP["Al"] = [5.9857684, 18.82855, 28.44764, 119.9924, 153.8252, 190.49, 241.76, 284.638, 330.212, 398.65, 442.005, 2085.97693, 2304.14]
IP["Si"] = [8.151683, 16.345845, 33.493, 45.14179, 166.767, 205.267, 246.32, 303.66, 351.1, 401.38, 476.18, 523.415, 2437.65804, 2673.1774]
IP["P"] = [10.486686, 19.76949, 30.20264, 51.44387, 65.02511, 220.4304, 263.57, 309.6, 372.31, 424.4, 479.441, 560.62, 611.74, 2816.90867, 3069.8414]
IP["S"] = [10.36001, 23.33788, 34.856, 47.222, 72.59449, 88.05292, 280.954, 328.79, 379.84, 447.74, 504.55, 564.407, 651.96, 706.994, 3223.78059, 3494.1877]
IP["Cl"] = [12.96763, 23.81364, 39.8, 53.24, 67.68, 96.94, 114.2013, 348.306, 400.851, 456.68, 529.97, 591.58, 656.3, 750.2, 809.198, 3658.34362, 3946.2908]
IP["Ar"] = [15.7596112, 27.62967, 40.735, 59.58, 74.84, 91.29, 124.412, 143.4567, 422.598, 479.76, 540.43, 618.95, 685.47, 755.13, 855.47, 918.374, 4120.6655, 4426.2227]
IP["K"] = [4.34066354, 31.625, 45.8031, 60.917, 82.66, 99.4, 117.56, 154.87, 175.8174, 503.67, 565.6, 631.0, 714.71, 786.26, 860.92, 967.66, 1034.541, 4610.86998, 4934.0482]
IP["Ca"] = [6.1131552, 11.871718, 50.91315, 67.2732, 84.338, 108.78, 127.2, 147.24, 188.535, 211.2751, 591.6, 658.24, 728.6, 817.22, 893.98, 973.7, 1086.8, 1157.726, 5128.8576, 5469.8614]
IP["Sc"] = [6.56149, 12.79977, 24.756838, 73.4894, 91.949, 110.68, 138.0, 158.1, 180.0, 225.18, 249.798, 687.36, 757.7, 833.0, 926.48, 1008.62, 1093.48, 1213.1, 1287.956, 5674.9034, 6033.754]
IP["Ti"] = [6.82812, 13.5755, 27.49171, 43.26717, 99.3, 119.53, 140.68, 170.47, 192.1, 215.92, 265.07, 291.5004, 787.7, 864.0, 944.5, 1042.48, 1130.2, 1220.3, 1346.33, 1425.257, 6249.0223, 6625.807]
IP["V"] = [6.746187, 14.62, 29.311, 46.709, 65.28165, 128.13, 150.72, 173.55, 205.96, 230.5, 254.8, 308.5, 336.274, 896.0, 977.2, 1062.9, 1165.2, 1258.86, 1354.17, 1486.67, 1569.656, 6851.3106, 7246.122]
IP["Cr"] = [6.76651, 16.486305, 30.96, 49.16, 69.46, 90.635, 160.29, 184.76, 209.54, 244.52, 270.8, 296.74, 354.66, 384.163, 1011.62, 1097.2, 1188.0, 1294.8, 1394.5, 1495.1, 1634.0, 1721.183, 7481.8625, 7894.799]
IP["Mn"] = [7.434018, 15.63999, 33.668, 51.2, 72.4, 95.6, 119.203, 195.47, 221.89, 248.64, 286.14, 314.4, 343.6, 403.0, 435.17, 1133.72, 1224.1, 1320.3, 1430.9, 1537.22, 1643.21, 1788.7, 1879.87, 8140.7869, 8571.948]
IP["Fe"] = [7.9024678, 16.1992, 30.651, 54.91, 75.0, 98.985, 125.0, 151.06, 233.6, 262.1, 290.9, 330.81, 361.0, 392.2, 456.2, 489.312, 1262.7, 1357.8, 1460.0, 1575.6, 1687.0, 1798.43, 1950.4, 2045.759, 8828.1875, 9277.681]
IP["Co"] = [7.88101, 17.0844, 33.5, 51.27, 79.5, 102.0, 129.0, 157.8, 186.14, 275.4, 305.32, 336.15, 378.55, 410.0, 441.1, 511.96, 546.588, 1397.2, 1504.5, 1606.0, 1724.0, 1844.0, 1960.83, 2119.4, 2218.876, 9544.183, 10012.122]
IP["Ni"] = [7.639877, 18.168837, 35.19, 54.9, 76.06, 108.0, 132.0, 162.0, 193.2, 224.7, 319.53, 351.63, 384.55, 429.32, 462.8, 495.4, 571.1, 607.02, 1541.05, 1646.0, 1758.0, 1880.0, 2008.1, 2130.46, 2295.6, 2399.259, 10288.8858, 10775.386]
IP["Cu"] = [7.72638, 20.29239, 36.841, 57.38, 79.8, 103.0, 139.0, 166.0, 198.0, 232.2, 265.0, 367.03, 400.98, 436.04, 483.13, 518.7, 552.8, 632.48, 670.608, 1690.5, 1800.0, 1918.0, 2044.0, 2179.4, 2307.0, 2479.1, 2586.954, 11062.4309, 11567.612]
IP["Zn"] = [9.394199, 17.96439, 39.723, 59.573, 82.6, 108.0, 134.0, 173.9, 203.0, 238.0, 274.4, 310.8, 417.6, 453.37, 490.63, 540.0, 577.8, 613.3, 697.51, 737.366, 1846.8, 1961.0, 2085.0, 2214.0, 2358.0, 2491.5, 2669.9, 2781.996, 11864.9394, 12388.928]
IP["Ga"] = [5.9993018, 20.51514, 30.726, 63.241, 86.01, 112.7, 140.8, 170.0, 211.0, 244.0, 280.0, 319.0, 356.0, 471.2, 508.82, 548.31, 599.8, 640.0, 677.0, 765.7, 807.308, 2010.0, 2129.0, 2258.0, 2391.0, 2543.9, 2683.0, 2868.0, 2984.426, 12696.5569, 13239.488]
IP["Ge"] = [7.899435, 15.93461, 34.0576, 45.715, 90.5, 115.9, 144.9, 176.4, 212.5, 252.1, 286.0, 326.0, 367.0, 407.0, 527.9, 567.29, 609.06, 662.8, 710.0, 744.0, 837.1, 880.444, 2180.1, 2304.0, 2439.0, 2575.0, 2737.2, 2881.9, 3074.0, 3194.293, 13557.4202, 14119.429]
IP["As"] = [9.789, 18.5892, 28.349, 50.15, 62.767, 121.19, 147.0, 180.0, 213.0, 247.0, 296.0, 333.0, 375.0, 418.0, 460.0, 587.6, 628.82, 672.9, 728.9, 774.0, 814.0, 911.7, 956.791, 2357.0, 2486.0, 2626.0, 2766.0, 2938.0, 3088.1, 3287.0, 3411.643, 14447.6778, 15028.906]
IP["Se"] = [9.752392, 21.196, 31.697, 42.947, 68.3, 81.827, 155.33, 184.0, 219.0, 255.0, 291.0, 342.9, 383.0, 426.0, 473.0, 517.0, 650.5, 693.38, 739.8, 798.0, 845.8, 887.0, 989.6, 1036.362, 2540.7, 2674.0, 2820.0, 2964.0, 3146.0, 3301.8, 3507.0, 3636.526, 15367.4907, 15968.083]
IP["Br"] = [11.81381, 21.591, 35.0, 47.78, 59.595, 85.1, 103.0, 192.61, 224.0, 261.0, 301.0, 338.0, 393.0, 436.0, 481.0, 530.0, 577.0, 716.3, 760.99, 809.8, 870.0, 920.8, 963.0, 1070.6, 1119.169, 2731.0, 2870.0, 3020.0, 3169.0, 3361.0, 3523.1, 3735.0, 3868.986, 16317.01, 16937.126]
IP["Kr"] = [13.9996049, 24.35984, 35.67, 50.85, 64.69, 78.49, 109.13, 125.8024, 233.0, 268.0, 308.0, 350.0, 391.0, 446.0, 492.0, 540.0, 591.0, 640.0, 785.0, 831.64, 882.8, 945.0, 999.0, 1042.0, 1155.0, 1205.233, 2928.9, 3072.0, 3228.0, 3380.0, 3584.0, 3752.0, 3971.0, 4109.083, 17296.42, 17936.208]
IP["Rb"] = [4.177128, 27.28954, 39.247, 52.2, 68.4, 82.9, 98.67, 132.8, 150.63, 277.12, 313.1, 356.0, 400.0, 443.0, 502.0, 550.0, 601.0, 654.0, 706.0, 857.0, 905.3, 958.9, 1024.0, 1080.0, 1125.0, 1242.5, 1294.567, 3133.3, 3281.0, 3442.0, 3600.0, 3815.0, 3988.0, 4214.0, 4356.865, 18305.883, 18965.51]
IP["Sr"] = [5.6948672, 11.030276, 42.88353, 56.28, 71.0, 88.0, 104.0, 121.21, 158.3, 177.0, 324.07, 362.0, 408.0, 454.0, 499.0, 562.0, 612.0, 665.0, 722.0, 774.0, 932.0, 982.1, 1038.0, 1105.0, 1165.0, 1211.0, 1333.4, 1387.19, 3344.7, 3497.0, 3664.0, 3830.0, 4053.0, 4232.0, 4465.0, 4612.397, 19345.587, 20025.23]
IP["Y"] = [6.21726, 12.224, 20.52441, 60.607, 74.97, 91.39, 110.02, 127.0, 145.64, 185.7, 206.0, 374.04, 414.0, 463.0, 512.0, 559.0, 624.0, 677.0, 733.0, 790.0, 847.0, 1010.0, 1061.9, 1120.2, 1190.0, 1253.0, 1300.0, 1427.6, 1483.118, 3562.9, 3720.0, 3892.0, 4060.0, 4299.0, 4484.0, 4724.0, 4875.73, 20415.716, 21115.55]
IP["Zr"] = [6.6339, 13.13, 23.17, 34.41836, 80.348, 96.27, 112.0, 133.7, 153.0, 172.02, 214.9, 236.25, 426.0, 470.0, 520.0, 573.0, 622.0, 690.0, 745.0, 803.0, 863.0, 922.0, 1092.0, 1144.7, 1205.4, 1277.0, 1344.0, 1392.0, 1525.1, 1582.371, 3788.0, 3950.0, 4127.0, 4300.0, 4553.0, 4744.0, 4991.0, 5146.935, 21516.469, 22236.68]
IP["Nb"] = [6.75885, 14.32, 25.0, 37.611, 50.5728, 102.069, 119.14, 136.0, 159.2, 180.0, 200.28, 246.1, 268.59, 482.5, 530.0, 581.0, 636.0, 688.0, 758.0, 816.0, 877.0, 940.0, 1000.0, 1176.0, 1230.6, 1293.7, 1368.0, 1439.0, 1500.0, 1625.9, 1684.969, 4020.1, 4187.0, 4369.0, 4540.0, 4815.0, 5011.0, 5265.0, 5426.065, 22648.045, 23388.8]
IP["Mo"] = [7.09243, 16.16, 27.13, 40.33, 54.485, 68.82704, 125.638, 143.6, 164.12, 186.3, 209.3, 230.28, 279.1, 302.6, 544.0, 591.0, 646.0, 702.0, 758.0, 829.0, 890.0, 953.0, 1019.0, 1082.0, 1263.0, 1319.6, 1385.1, 1462.0, 1537.0, 1587.0, 1730.1, 1790.932, 4259.0, 4430.0, 4618.0, 4800.0, 5084.0, 5287.0, 5548.0, 5713.194, 23810.653, 24572.15]
IP["Tc"] = [7.119381, 15.26, 29.55, 41.0, 57.0, 72.0, 88.0, 150.0, 169.0, 189.9, 214.0, 239.0, 262.08, 311.0, 338.55, 604.0, 655.0, 713.0, 773.0, 829.0, 904.0, 968.0, 1032.0, 1102.0, 1166.0, 1354.0, 1411.6, 1479.5, 1559.0, 1638.0, 1689.0, 1838.0, 1900.28, 4505.0, 4681.0, 4874.0, 5060.0, 5361.0, 5570.0, 5838.0, 6008.391, 25004.532, 25786.99]
IP["Ru"] = [7.3605, 16.76, 28.47, 45.0, 59.0, 76.0, 93.0, 110.0, 178.4, 198.0, 219.9, 245.0, 271.0, 295.9, 348.0, 376.25, 670.0, 723.0, 784.0, 845.0, 905.0, 981.0, 1048.0, 1115.0, 1187.0, 1253.0, 1447.0, 1506.7, 1577.0, 1659.0, 1743.0, 1794.0, 1949.0, 2013.037, 4758.0, 4939.0, 5136.0, 5330.0, 5647.0, 5862.0, 6137.0, 6311.72, 26229.894, 27033.5]
IP["Rh"] = [7.4589, 18.08, 31.06, 42.0, 63.0, 80.0, 97.0, 115.1, 135.0, 207.51, 228.0, 252.1, 277.0, 306.0, 331.58, 389.0, 416.0, 739.0, 794.0, 857.0, 921.0, 984.0, 1061.0, 1131.0, 1202.0, 1274.0, 1344.0, 1544.0, 1604.9, 1677.6, 1763.0, 1851.0, 1903.0, 2063.0, 2129.224, 5018.0, 5203.0, 5406.0, 5600.0, 5940.0, 6161.0, 6444.0, 6623.262, 27486.982, 28311.96]
IP["Pd"] = [8.33686, 19.43, 32.93, 46.0, 61.0, 84.1, 101.0, 120.0, 141.0, 160.0, 238.57, 260.0, 286.0, 311.0, 342.0, 369.1, 427.0, 458.0, 810.0, 869.0, 933.0, 1000.0, 1065.0, 1145.0, 1218.0, 1290.0, 1366.0, 1438.0, 1644.0, 1706.2, 1781.3, 1869.0, 1962.0, 2016.0, 2181.0, 2248.867, 5284.0, 5475.0, 5683.0, 5880.0, 6242.0, 6469.0, 6759.0, 6943.096, 28776.033, 29622.6]
IP["Ag"] = [7.576234, 21.4844, 34.83, 49.0, 65.0, 82.0, 106.0, 125.0, 145.0, 167.0, 188.0, 271.46, 294.0, 321.0, 347.0, 381.0, 408.43, 469.0, 500.87, 885.0, 946.0, 1013.0, 1082.0, 1149.0, 1231.0, 1308.0, 1382.0, 1460.0, 1535.0, 1747.0, 1810.5, 1888.0, 1979.0, 2077.0, 2131.0, 2302.0, 2371.989, 5558.0, 5753.0, 5966.0, 6170.0, 6551.0, 6784.0, 7082.0, 7271.297, 30097.317, 30965.7]
IP["Cd"] = [8.993822, 16.908312, 37.47, 51.0, 67.9, 87.0, 105.0, 130.1, 150.0, 173.0, 195.0, 218.0, 305.0, 329.0, 358.0, 385.0, 421.0, 452.55, 513.0, 546.19, 963.0, 1026.0, 1095.0, 1167.0, 1237.0, 1320.0, 1400.0, 1477.0, 1558.0, 1635.0, 1852.0, 1917.9, 1997.9, 2091.0, 2195.0, 2250.0, 2427.0, 2498.615, 5839.0, 6039.0, 6257.0, 6460.0, 6870.0, 7109.0, 7414.0, 7607.945, 31451.06, 32341.49]
IP["In"] = [5.7863552, 18.870407, 28.04415, 55.45, 69.3, 90.0, 109.0, 130.1, 156.0, 178.0, 201.0, 226.0, 249.0, 341.0, 368.0, 396.0, 425.0, 462.0, 497.11, 560.0, 593.38, 1043.0, 1109.0, 1181.0, 1255.0, 1328.0, 1413.0, 1496.0, 1575.0, 1659.0, 1738.0, 1961.0, 2028.5, 2111.0, 2207.0, 2317.0, 2373.0, 2555.0, 2628.774, 6126.0, 6331.0, 6554.0, 6770.0, 7196.0, 7442.0, 7754.0, 7953.137, 32837.59, 33750.31]
IP["Sn"] = [7.343917, 14.63224, 30.50259, 40.735, 77.03, 94.0, 112.9, 135.0, 156.0, 184.0, 208.0, 232.0, 258.0, 282.0, 379.0, 407.0, 437.0, 466.0, 506.0, 537.0, 608.0, 642.35, 1127.0, 1195.0, 1269.0, 1347.0, 1421.0, 1508.0, 1596.0, 1676.0, 1763.0, 1844.0, 2074.0, 2142.1, 2227.0, 2326.0, 2443.0, 2499.0, 2687.0, 2762.5, 6421.0, 6631.0, 6859.0, 7080.0, 7531.0, 7790.0, 8103.0, 8306.95, 34257.141, 35192.39]
IP["Sb"] = [8.608389, 16.63, 25.3235, 43.8, 55.0, 99.51, 117.0, 139.0, 162.0, 185.0, 214.0, 238.0, 265.0, 292.0, 317.0, 420.0, 447.0, 479.0, 510.0, 552.0, 584.0, 657.0, 693.26, 1214.0, 1285.0, 1360.0, 1441.0, 1518.0, 1606.0, 1698.0, 1781.0, 1869.0, 1954.0, 2190.0, 2266.0, 2349.0, 2428.0, 2567.0, 2654.0, 2815.0, 2900.0, 6714.0, 6929.0, 7167.0, 7390.0, 7887.0, 8140.0, 8455.0, 8669.48, 35710.03, 36668.05]
IP["Te"] = [9.00966, 19.0, 27.838, 37.4155, 59.25, 69.1, 124.201, 143.0, 167.0, 191.1, 215.0, 245.0, 272.0, 299.0, 328.0, 354.0, 461.0, 491.0, 522.0, 555.0, 599.0, 633.0, 709.0, 746.12, 1304.0, 1377.0, 1455.0, 1538.0, 1618.0, 1707.0, 1803.0, 1889.0, 1979.0, 2066.0, 2309.0, 2386.0, 2472.0, 2552.0, 2700.0, 2788.0, 2954.0, 3041.0, 7022.0, 7243.0, 7485.0, 7714.0, 8240.0, 8499.0, 8821.0, 9040.83, 37196.52, 38177.56]
IP["I"] = [10.45126, 19.13126, 29.57, 40.36, 51.517, 74.37, 87.61, 150.81, 171.0, 197.0, 220.9, 247.0, 279.0, 307.0, 335.0, 365.0, 393.0, 505.0, 535.0, 569.0, 601.0, 649.0, 683.0, 762.0, 800.76, 1397.0, 1472.0, 1553.0, 1639.0, 1720.0, 1812.0, 1911.0, 1999.0, 2093.0, 2181.0, 2431.0, 2510.0, 2598.0, 2680.0, 2836.0, 2930.0, 3096.0, 3185.5, 7337.0, 7600.0, 7800.0, 8044.0, 8601.0, 8867.0, 9196.0, 9421.1, 38716.994, 39721.41]
IP["Xe"] = [12.1298431, 20.975, 31.05, 42.2, 54.14, 66.703, 91.6, 105.9778, 179.84, 202.0, 229.02, 255.0, 281.0, 314.0, 343.0, 374.0, 404.0, 430.0, 549.0, 582.0, 616.0, 650.0, 700.0, 736.0, 818.0, 857.03, 1493.0, 1571.0, 1653.0, 1742.0, 1826.0, 1919.0, 2023.0, 2113.0, 2209.0, 2300.0, 2556.0, 2637.0, 2726.0, 2811.0, 2975.0, 3068.0, 3243.0, 3333.8, 7660.0, 7889.0, 8144.0, 8382.0, 8971.0, 9243.0, 9581.0, 9810.4, 40271.722, 41299.71]
IP["Cs"] = [3.893905548, 23.15745, 33.195, 43.0, 56.0, 69.1, 82.9, 110.09, 125.61, 213.3, 233.0, 261.0, 289.0, 316.0, 352.0, 382.0, 413.0, 445.0, 476.0, 597.0, 629.0, 666.0, 700.0, 753.0, 791.0, 875.0, 916.07, 1592.0, 1672.0, 1757.0, 1848.0, 1936.0, 2029.0, 2137.0, 2230.0, 2329.0, 2422.0, 2683.0, 2767.0, 2859.0, 2945.0, 3118.0, 3214.0, 3392.0, 3485.0, 7989.0, 8224.0, 8484.0, 8726.0, 9350.0, 9629.0, 9974.0, 10208.78, 41861.073, 42912.99]
IP["Ba"] = [5.211664, 10.003826, 35.84, 47.03, 58.0, 71.0, 86.0, 101.0, 130.53, 146.52, 241.0, 267.1, 296.0, 325.0, 354.0, 390.0, 422.0, 455.0, 488.0, 520.0, 646.0, 679.0, 717.0, 752.0, 809.0, 846.0, 935.0, 976.6, 1695.0, 1776.0, 1864.0, 1958.0, 2047.0, 2142.0, 2256.0, 2349.0, 2452.0, 2547.0, 2814.0, 2901.0, 2994.0, 3081.0, 3266.0, 3363.0, 3550.0, 3640.0, 8326.0, 8565.0, 8831.0, 9077.0, 9739.0, 10023.0, 10376.0, 10616.42, 43485.364, 44561.47]
IP["La"] = [5.5769, 11.18492, 19.1773, 49.95, 61.6, 74.0, 88.0, 105.0, 119.0, 151.42, 168.77, 275.0, 303.0, 332.0, 364.0, 393.0, 431.0, 464.0, 498.0, 533.0, 566.0, 696.0, 731.0, 770.0, 806.0, 865.0, 906.0, 995.0, 1039.09, 1800.0, 1884.0, 1974.0, 2069.0, 2162.0, 2259.0, 2377.0, 2473.0, 2577.0, 2674.0, 2950.0, 3036.0, 3133.0, 3222.0, 3416.0, 3515.0, 3704.0, 3800.0, 8669.0, 8914.0, 9184.0, 9437.0, 10136.0, 10426.0, 10789.0, 11033.4, 45144.994, 46245.6]
IP["Ce"] = [5.5386, 10.85, 20.1974, 36.906, 65.55, 77.6, 91.0, 106.0, 125.0, 140.0, 172.0, 192.24, 312.0, 340.0, 371.0, 403.0, 435.0, 472.0, 509.0, 543.0, 579.0, 613.0, 749.0, 785.0, 824.0, 862.0, 924.0, 965.0, 1060.0, 1103.53, 1908.0, 1994.0, 2087.0, 2185.0, 2280.0, 2378.0, 2500.0, 2600.0, 2706.0, 2806.0, 3087.0, 3176.0, 3274.0, 3366.0, 3570.0, 3672.0, 3865.0, 3963.0, 9020.0, 9269.0, 9545.0, 9803.0, 10542.0, 10840.0, 11210.0, 11459.85, 46840.304, 47965.72]
IP["Pr"] = [5.473, 10.55, 21.6237, 38.98, 57.5, 82.0, 97.0, 112.0, 131.0, 148.0, 162.0, 196.0, 217.02, 350.0, 378.0, 412.0, 445.0, 478.0, 516.0, 554.0, 590.0, 627.0, 663.0, 803.0, 840.0, 880.0, 920.0, 985.0, 1028.0, 1124.0, 1169.94, 2019.0, 2108.0, 2202.0, 2304.0, 2400.0, 2501.0, 2628.0, 2729.0, 2838.0, 2941.0, 3227.0, 3319.0, 3419.0, 3512.0, 3729.0, 3832.0, 4030.0, 4130.0, 9378.0, 9632.0, 9913.0, 10175.0, 10959.0, 11262.0, 11641.0, 11895.89, 48571.71, 49722.2]
IP["Nd"] = [5.525, 10.72, 22.14, 40.4, 60.0, 84.0, 99.0, 114.0, 136.0, 152.0, 168.0, 195.0, 221.0, 243.0, 389.0, 420.0, 453.0, 489.0, 522.0, 562.0, 602.0, 638.0, 678.0, 714.0, 859.0, 896.0, 939.0, 978.0, 1049.0, 1092.0, 1191.0, 1238.42, 2134.0, 2224.0, 2321.0, 2425.0, 2525.0, 2627.0, 2758.0, 2861.0, 2974.0, 3078.0, 3371.0, 3465.0, 3567.0, 3662.0, 3891.0, 3997.0, 4198.0, 4302.0, 9742.0, 10002.0, 10288.0, 10555.0, 11384.0, 11694.0, 12082.0, 12341.66, 50339.587, 51515.58]
IP["Pm"] = [5.582, 10.9, 22.0, 41.0, 61.69, 85.0, 101.0, 116.0, 138.0, 155.0, 174.0, 202.0, 229.0, 200.0, 269.0, 430.0, 462.0, 497.0, 534.0, 569.0, 609.0, 651.0, 689.0, 730.0, 767.0, 916.0, 956.0, 998.0, 1040.0, 1113.0, 1158.0, 1261.0, 1308.7, 2251.0, 2344.0, 2443.0, 2549.0, 2652.0, 2755.0, 2892.0, 2997.0, 3110.0, 3219.0, 3519.0, 3613.0, 3718.0, 3816.0, 4056.0, 4166.0, 4371.0, 4476.0, 10115.0, 10378.0, 10671.0, 10942.0, 11819.0, 12136.0, 12532.0, 12797.26, 52144.29, 53346.1]
IP["Sm"] = [5.64371, 11.07, 23.4, 41.4, 62.66, 90.0, 103.0, 118.0, 141.0, 158.0, 179.0, 208.0, 237.0, 257.0, 276.0, 306.5, 474.0, 506.0, 543.0, 581.0, 617.0, 658.0, 702.0, 742.0, 782.0, 822.0, 976.0, 1016.0, 1060.0, 1103.0, 1180.0, 1226.0, 1332.0, 1381.6, 2371.0, 2466.0, 2569.0, 2676.0, 2782.0, 2887.0, 3028.0, 3137.0, 3253.0, 3363.0, 3669.0, 3766.0, 3873.0, 3971.0, 4227.0, 4337.0, 4548.0, 4655.0, 10494.0, 10762.0, 11060.0, 11337.0, 12264.0, 12588.0, 12992.0, 13262.85, 53986.11, 55214.23]
IP["Eu"] = [5.670385, 11.241, 24.9, 42.7, 63.0, 88.0, 105.0, 120.0, 144.0, 161.0, 183.0, 213.0, 243.0, 263.0, 281.0, 311.0, 344.4, 518.0, 553.0, 590.0, 630.0, 667.0, 709.0, 755.0, 795.0, 838.0, 879.0, 1037.0, 1078.0, 1124.0, 1167.0, 1249.0, 1296.0, 1406.0, 1456.06, 2495.0, 2591.0, 2697.0, 2807.0, 2914.0, 3022.0, 3168.0, 3279.0, 3398.0, 3510.0, 3823.0, 3921.0, 4031.0, 4131.0, 4400.0, 4510.0, 4729.0, 4838.0, 10880.0, 11153.0, 11457.0, 11739.0, 12718.0, 13050.0, 13462.0, 13738.58, 55865.9, 57120.6]
IP["Gd"] = [6.149796, 12.09, 20.63, 44.0, 64.76, 89.0, 106.0, 123.0, 144.0, 165.0, 183.0, 213.0, 246.0, 268.0, 288.0, 319.0, 352.0, 380.0, 565.0, 601.0, 639.0, 680.0, 719.0, 761.0, 810.0, 851.0, 895.0, 937.0, 1100.0, 1142.0, 1189.0, 1233.0, 1321.0, 1368.0, 1481.0, 1532.35, 2621.0, 2720.0, 2827.0, 2941.0, 3050.0, 3160.0, 3312.0, 3424.0, 3550.0, 3660.0, 3980.0, 4080.0, 4191.0, 4294.0, 4578.0, 4693.0, 4914.0, 5025.0, 11273.0, 11552.0, 11861.0, 12147.0, 13183.0, 13521.0, 13943.0, 14224.57, 57783.9, 59065.52]
IP["Tb"] = [5.8638, 11.52, 21.91, 39.36, 66.5, 90.0, 108.0, 125.0, 143.0, 168.0, 186.0, 216.0, 250.0, 270.0, 294.0, 325.0, 358.0, 393.0, 426.6, 613.0, 651.0, 690.0, 732.0, 772.0, 816.0, 866.0, 909.0, 954.0, 997.0, 1165.0, 1208.0, 1256.0, 1301.0, 1393.0, 1443.0, 1559.0, 1610.38, 2750.0, 2852.0, 2961.0, 3078.0, 3189.0, 3300.0, 3458.0, 3573.0, 3698.0, 3814.0, 4139.0, 4242.0, 4355.0, 4460.0, 4760.0, 4877.0, 5103.0, 5217.0, 11673.0, 11957.0, 12272.0, 12563.0, 13658.0, 14003.0, 14434.0, 14721.0, 59739.25, 61049.64]
IP["Dy"] = [5.93905, 11.67, 22.93, 41.4, 62.08, 93.0, 110.0, 127.0, 152.0, 170.0, 192.0, 224.0, 259.0, 279.0, 300.0, 332.0, 366.0, 399.0, 431.0, 465.0, 664.0, 702.0, 743.0, 786.0, 827.0, 872.0, 924.0, 969.0, 1014.0, 1059.0, 1232.0, 1275.0, 1325.0, 1371.0, 1468.0, 1520.0, 1638.0, 1691.74, 2882.0, 2987.0, 3098.0, 3217.0, 3331.0, 3445.0, 3607.0, 3725.0, 3852.0, 3970.0, 4303.0, 4407.0, 4523.0, 4629.0, 4945.0, 5066.0, 5296.0, 5412.0, 12081.0, 12370.0, 12690.0, 12986.0, 14144.0, 14495.0, 14936.0, 15228.06, 61736.55, 63073.5]
IP["Ho"] = [6.0215, 11.8, 22.84, 42.5, 63.93, 95.0, 112.0, 129.0, 155.0, 174.0, 196.0, 229.0, 263.0, 284.0, 305.0, 340.0, 373.0, 408.0, 441.0, 475.0, 510.0, 715.0, 755.0, 797.0, 842.0, 885.0, 929.0, 985.0, 1029.0, 1077.0, 1122.0, 1300.0, 1346.0, 1395.0, 1443.0, 1545.0, 1598.0, 1719.0, 1773.57, 3018.0, 3125.0, 3238.0, 3359.0, 3476.0, 3592.0, 3760.0, 3880.0, 4009.0, 4131.0, 4469.0, 4576.0, 4693.0, 4802.0, 5135.0, 5258.0, 5494.0, 5611.0, 12495.0, 12790.0, 13116.0, 13417.0, 14639.0, 14998.0, 15448.0, 15745.77, 63772.42, 65136.8]
IP["Er"] = [6.1077, 11.93, 22.74, 42.7, 65.1, 96.0, 114.0, 131.0, 158.0, 177.0, 201.0, 235.0, 268.0, 290.0, 311.0, 345.0, 381.0, 415.0, 450.0, 486.0, 520.0, 555.0, 770.0, 810.0, 853.0, 899.0, 943.0, 989.0, 1046.0, 1092.0, 1142.0, 1188.0, 1370.0, 1416.0, 1468.0, 1516.0, 1625.0, 1678.0, 1803.0, 1859.0, 3157.0, 3265.0, 3381.0, 3505.0, 3624.0, 3742.0, 3916.0, 4038.0, 4170.0, 4294.0, 4639.0, 4748.0, 4866.0, 4978.0, 5329.0, 5455.0, 5695.0, 5815.0, 12918.0, 13217.0, 13548.0, 13855.0, 15146.0, 15511.0, 15971.0, 16274.56, 65848.24, 67241.85]
IP["Tm"] = [6.18431, 12.05, 23.7, 42.7, 65.43, 98.0, 116.0, 133.0, 160.0, 180.0, 205.0, 239.0, 274.0, 295.0, 317.0, 352.0, 387.0, 424.0, 460.0, 500.0, 530.0, 570.0, 603.0, 825.0, 866.0, 911.0, 958.0, 1004.0, 1050.0, 1110.0, 1157.0, 1207.0, 1255.0, 1442.0, 1490.0, 1542.0, 1591.0, 1706.0, 1761.0, 1889.0, 1945.2, 3300.0, 3409.0, 3528.0, 3653.0, 3775.0, 3895.0, 4075.0, 4199.0, 4335.0, 4461.0, 4812.0, 4922.0, 5044.0, 5157.0, 5527.0, 5656.0, 5901.0, 6023.0, 13347.0, 13651.0, 13988.0, 14300.0, 15663.0, 16036.0, 16500.0, 16814.34, 67965.26, 69387.34]
IP["Yb"] = [6.25416, 12.179184, 25.053, 43.56, 65.58, 99.0, 117.0, 135.0, 163.0, 182.0, 209.0, 244.0, 279.0, 301.0, 324.0, 360.0, 396.0, 431.0, 469.0, 505.0, 540.0, 580.0, 620.0, 651.0, 882.0, 924.0, 971.0, 1019.0, 1065.0, 1114.0, 1175.0, 1224.0, 1275.0, 1324.0, 1516.0, 1564.0, 1618.0, 1668.0, 1789.0, 1845.0, 1978.0, 2036.4, 3443.0, 3555.0, 3677.0, 3805.0, 3929.0, 4051.0, 4238.0, 4364.0, 4502.0, 4630.0, 4988.0, 5101.0, 5224.0, 5339.0, 5731.0, 5860.0, 6111.0, 6236.0, 13784.0, 14093.0, 14435.0, 14752.0, 16191.0, 16570.0, 17050.0, 17365.44, 70123.04, 71574.79]
IP["Lu"] = [5.425871, 13.9, 20.9551, 45.249, 66.79, 98.0, 117.0, 136.0, 159.0, 185.0, 205.0, 238.0, 276.0, 305.0, 328.0, 361.0, 399.0, 438.0, 476.0, 520.0, 560.0, 600.0, 640.0, 670.0, 713.0, 941.0, 985.0, 1032.0, 1081.0, 1130.0, 1178.0, 1242.0, 1292.0, 1345.0, 1395.0, 1591.0, 1641.0, 1696.0, 1747.0, 1875.0, 1933.0, 2067.0, 2125.5, 3590.0, 3706.0, 3828.0, 3960.0, 4086.0, 4211.0, 4403.0, 4532.0, 4673.0, 4803.0, 5168.0, 5282.0, 5408.0, 5525.0, 5937.0, 6070.0, 6326.0, 6452.0, 14228.0, 14542.0, 14890.0, 15211.0, 16730.0, 17120.0, 17610.0, 17928.05, 72322.91, 73804.8]
IP["Hf"] = [6.82507, 15.0, 23.28, 33.37, 68.375, 98.0, 118.0, 138.0, 157.0, 187.0, 209.0, 230.0, 270.0, 310.0, 334.0, 359.0, 399.0, 440.0, 481.0, 520.0, 560.0, 610.0, 650.0, 690.0, 730.0, 772.0, 1002.0, 1047.0, 1094.0, 1146.0, 1195.0, 1245.0, 1311.0, 1362.0, 1417.0, 1467.0, 1669.0, 1719.0, 1776.0, 1827.0, 1963.0, 2022.0, 2159.0, 2218.9, 3741.0, 3858.0, 3984.0, 4118.0, 4246.0, 4372.0, 4573.0, 4703.0, 4846.0, 4980.0, 5350.0, 5468.0, 5595.0, 5713.0, 6149.0, 6284.0, 6545.0, 6674.0, 14678.0, 14999.0, 15351.0, 15680.0, 17280.0, 17680.0, 18180.0, 18502.32, 74565.93, 76077.8]
IP["Ta"] = [7.54957, 16.2, 23.1, 35.0, 48.272, 94.011, 119.0, 139.0, 159.0, 180.0, 213.0, 235.0, 262.0, 304.0, 338.0, 363.0, 396.0, 439.0, 482.0, 530.0, 570.0, 620.0, 660.0, 700.0, 740.0, 790.0, 832.0, 1064.0, 1110.0, 1160.0, 1211.0, 1262.0, 1313.0, 1382.0, 1434.0, 1490.0, 1542.0, 1748.0, 1799.0, 1857.0, 1910.0, 2053.0, 2113.0, 2254.0, 2314.7, 3898.7, 4014.0, 4143.0, 4278.0, 4410.0, 4537.0, 4745.0, 4877.0, 5024.0, 5159.0, 5537.0, 5655.0, 5785.0, 5907.0, 6364.0, 6502.0, 6769.0, 6900.0, 15137.0, 15461.0, 15820.0, 16150.0, 17840.0, 18250.0, 18760.0, 19088.51, 76852.02, 78394.7]
IP["W"] = [7.86403, 16.4, 26.02, 38.21, 51.59, 64.766, 122.01, 141.2, 160.2, 179.0, 208.9, 231.6, 258.3, 290.7, 325.3, 361.9, 387.9, 420.7, 462.1, 502.6, 543.4, 594.5, 640.6, 686.0, 734.1, 784.4, 833.4, 881.4, 1132.2, 1180.0, 1230.4, 1283.4, 1335.1, 1386.8, 1459.9, 1512.4, 1569.1, 1622.0, 1829.8, 1882.9, 1940.6, 1994.8, 2149.1, 2210.0, 2354.0, 2414.11, 4057.0, 4180.0, 4309.0, 4446.0, 4578.0, 4709.0, 4927.0, 5063.0, 5209.0, 5348.0, 5719.0, 5840.0, 5970.0, 6093.0, 6600.0, 6735.0, 7000.0, 7130.0, 15566.0, 15896.0, 16252.0, 16588.0, 18476.0, 18872.0, 19362.0, 19686.74, 79181.93, 80755.6]
IP["Re"] = [7.83352, 16.6, 27.0, 39.1, 51.9, 67.0, 82.71, 144.4, 165.0, 187.0, 208.0, 236.0, 268.0, 291.0, 330.0, 377.0, 403.0, 429.0, 476.0, 520.0, 570.0, 620.0, 670.0, 720.0, 760.0, 810.0, 860.0, 910.0, 953.0, 1194.0, 1242.0, 1294.0, 1349.0, 1402.0, 1454.0, 1530.0, 1583.0, 1641.0, 1696.0, 1912.0, 1966.0, 2025.0, 2080.0, 2240.0, 2302.0, 2450.0, 2514.54, 4214.0, 4335.0, 4468.0, 4609.0, 4745.0, 4877.0, 5099.0, 5236.0, 5388.0, 5528.0, 5919.0, 6042.0, 6176.0, 6300.0, 6810.0, 6952.0, 7230.0, 7366.0, 16080.0, 16410.0, 16780.0, 17120.0, 19000.0, 19420.0, 19950.0, 20297.4, 81556.9, 83162.3]
IP["Os"] = [8.43823, 17.0, 25.0, 41.0, 55.0, 70.1, 85.1, 102.024, 168.7, 190.0, 213.0, 235.0, 269.0, 300.0, 320.0, 367.0, 410.0, 436.0, 470.0, 520.0, 570.0, 620.0, 670.0, 720.0, 770.0, 820.0, 870.0, 920.0, 970.0, 1015.0, 1262.0, 1311.0, 1364.0, 1420.0, 1474.0, 1528.0, 1606.0, 1660.0, 1720.0, 1776.0, 1996.0, 2052.0, 2112.0, 2168.0, 2336.0, 2400.0, 2552.0, 2615.5, 4374.0, 4501.0, 4635.0, 4779.0, 4917.0, 5052.0, 5280.0, 5421.0, 5575.0, 5717.0, 6115.0, 6240.0, 6376.0, 6503.0, 7039.0, 7185.0, 7468.0, 7610.0, 16560.0, 16900.0, 17270.0, 17620.0, 19600.0, 20030.0, 20570.0, 20920.6, 83976.2, 85614.4]
IP["Ir"] = [8.96702, 17.0, 28.0, 40.0, 57.0, 72.0, 89.0, 105.0, 123.0, 194.8, 217.0, 240.0, 264.0, 303.0, 329.0, 356.0, 407.0, 445.0, 472.0, 510.0, 560.0, 610.0, 670.0, 720.0, 770.0, 820.0, 870.0, 920.0, 980.0, 1030.0, 1080.0, 1331.0, 1381.0, 1436.0, 1493.0, 1548.0, 1603.0, 1684.0, 1739.0, 1801.0, 1857.0, 2083.0, 2139.0, 2201.0, 2258.0, 2435.0, 2500.0, 2656.0, 2720.4, 4540.0, 4668.0, 4806.0, 4952.0, 5092.0, 5229.0, 5466.0, 5609.0, 5765.0, 5910.0, 6315.0, 6441.0, 6580.0, 6708.0, 7274.0, 7421.0, 7710.0, 7850.0, 17040.0, 17390.0, 17770.0, 18120.0, 20210.0, 20650.0, 21200.0, 21556.6, 86438.9, 88113.3]
IP["Pt"] = [8.95883, 18.56, 29.0, 43.0, 56.0, 75.0, 91.0, 109.0, 126.0, 144.9, 220.4, 245.0, 269.0, 293.0, 332.0, 358.0, 392.0, 445.0, 479.0, 507.0, 550.0, 610.0, 660.0, 710.0, 760.0, 820.0, 870.0, 930.0, 980.0, 1040.0, 1090.0, 1140.0, 1402.0, 1454.0, 1509.0, 1567.0, 1624.0, 1680.0, 1763.0, 1821.0, 1883.0, 1941.0, 2171.0, 2228.0, 2291.0, 2350.0, 2536.0, 2603.0, 2762.0, 2827.8, 4715.0, 4839.0, 4980.0, 5128.0, 5270.0, 5410.0, 5654.0, 5800.0, 5959.0, 6106.0, 6517.0, 6646.0, 6787.0, 6918.0, 7512.0, 7660.0, 7960.0, 8100.0, 17540.0, 17890.0, 18280.0, 18630.0, 20840.0, 21280.0, 21840.0, 22205.7, 88955.17, 90660.0]
IP["Au"] = [9.225553, 20.203, 30.0, 45.0, 60.0, 74.0, 94.0, 112.0, 130.1, 149.0, 168.2, 200.0, 275.0, 299.0, 324.0, 365.0, 392.0, 433.0, 487.0, 520.0, 550.0, 600.0, 650.0, 710.0, 760.0, 820.0, 870.0, 930.0, 990.0, 1040.0, 1100.0, 1150.0, 1210.0, 1475.0, 1527.0, 1584.0, 1644.0, 1702.0, 1758.0, 1845.0, 1904.0, 1967.0, 2026.0, 2261.0, 2320.0, 2383.0, 2443.0, 2640.0, 2708.0, 2870.0, 2941.0, 4888.0, 5013.0, 5156.0, 5307.0, 5452.0, 5594.0, 5846.0, 5994.0, 6156.0, 6305.0, 6724.0, 6854.0, 6997.0, 7130.0, 7760.0, 7910.0, 8210.0, 8360.0, 18040.0, 18400.0, 18790.0, 19150.0, 21470.0, 21920.0, 22500.0, 22868.12, 91515.82, 93254.3]
IP["Hg"] = [10.437504, 18.75687, 34.46, 48.55, 61.2, 76.6, 93.0, 113.9, 134.0, 153.0, 173.0, 192.7, 276.9, 307.0, 332.0, 357.0, 402.0, 429.0, 477.0, 530.0, 560.0, 590.0, 650.0, 710.0, 760.0, 820.0, 880.0, 930.0, 990.0, 1050.0, 1110.0, 1160.0, 1220.0, 1280.0, 1549.0, 1603.0, 1661.0, 1723.0, 1780.0, 1839.0, 1928.0, 1989.0, 2052.0, 2113.0, 2354.0, 2412.0, 2478.0, 2539.0, 2745.0, 2815.0, 2981.0, 3049.9, 5055.0, 5191.0, 5335.0, 5490.0, 5636.0, 5780.0, 6041.0, 6192.0, 6356.0, 6508.0, 6933.0, 7066.0, 7211.0, 7350.0, 8000.0, 8160.0, 8470.0, 8620.0, 18550.0, 18910.0, 19310.0, 19680.0, 22120.0, 22580.0, 23170.0, 23544.1, 94124.7, 95897.7]
IP["Tl"] = [6.108287, 20.4283, 29.852, 51.14, 62.6, 80.0, 98.0, 116.0, 135.0, 158.0, 177.0, 198.0, 218.3, 306.9, 340.0, 366.0, 392.0, 439.0, 467.0, 520.0, 570.0, 600.0, 640.0, 700.0, 760.0, 820.0, 880.0, 930.0, 990.0, 1060.0, 1110.0, 1170.0, 1230.0, 1290.0, 1350.0, 1625.0, 1681.0, 1740.0, 1802.0, 1862.0, 1920.0, 2014.0, 2075.0, 2140.0, 2202.0, 2447.0, 2508.0, 2574.0, 2635.0, 2854.0, 2925.0, 3094.0, 3164.7, 5234.0, 5371.0, 5518.0, 5674.0, 5824.0, 5969.0, 6241.0, 6392.0, 6560.0, 6714.0, 7146.0, 7281.0, 7430.0, 7560.0, 8260.0, 8420.0, 8730.0, 8880.0, 19070.0, 19440.0, 19840.0, 20210.0, 22780.0, 23260.0, 23850.0, 24234.1, 96783.2, 98591.6]
IP["Pb"] = [7.4166796, 15.032498, 31.9373, 42.33256, 68.8, 82.9, 100.1, 120.0, 138.0, 158.0, 182.0, 203.0, 224.0, 245.1, 338.1, 374.0, 401.0, 428.0, 478.0, 507.0, 570.0, 610.0, 650.0, 690.0, 750.0, 810.0, 870.0, 930.0, 990.0, 1050.0, 1120.0, 1180.0, 1000.0, 1300.0, 1400.0, 1430.0, 1704.0, 1760.0, 1819.0, 1884.0, 1945.0, 2004.0, 2101.0, 2163.0, 2230.0, 2292.0, 2543.0, 2605.0, 2671.0, 2735.0, 2965.0, 3036.0, 3211.0, 3282.1, 5414.0, 5555.0, 5703.0, 5862.0, 6015.0, 6160.0, 6442.0, 6597.0, 6767.0, 6924.0, 7362.0, 7500.0, 7650.0, 7790.0, 8520.0, 8680.0, 9000.0, 9150.0, 19590.0, 19970.0, 20380.0, 20750.0, 23460.0, 23940.0, 24550.0, 24938.0, 99491.85, 101336.4]
IP["Bi"] = [7.285516, 16.703, 25.563, 45.37, 54.85, 88.4, 103.0, 122.0, 143.0, 161.1, 183.0, 208.0, 229.0, 252.0, 272.6, 370.2, 409.0, 436.0, 464.0, 520.0, 550.0, 620.0, 660.0, 690.0, 750.0, 810.0, 870.0, 930.0, 990.0, 1060.0, 1120.0, 1180.0, 1250.0, 1310.0, 1380.0, 1440.0, 1500.0, 1784.0, 1840.0, 1902.0, 1967.0, 2029.0, 2090.0, 2190.0, 2253.0, 2321.0, 2385.0, 2641.0, 2703.0, 2771.0, 2835.0, 3078.0, 3151.0, 3329.0, 3401.8, 5599.0, 5740.0, 5892.0, 6054.0, 6208.0, 6358.0, 6648.0, 6804.0, 6977.0, 7137.0, 7580.0, 7720.0, 7870.0, 8010.0, 8780.0, 8950.0, 9270.0, 9430.0, 20130.0, 20500.0, 20920.0, 21300.0, 24150.0, 24640.0, 25260.0, 25656.9, 102251.76, 104132.8]
IP["Po"] = [8.414, 19.3, 27.0, 36.0, 57.0, 69.1, 108.0, 125.0, 146.1, 166.0, 190.0, 209.0, 235.0, 257.0, 281.0, 304.0, 416.0, 444.0, 473.0, 502.0, 560.0, 590.0, 670.0, 700.0, 740.0, 800.0, 860.0, 930.0, 990.0, 1060.0, 1120.0, 1180.0, 1250.0, 1320.0, 1380.0, 1440.0, 1510.0, 1570.0, 1865.0, 1923.0, 1986.0, 2052.0, 2115.0, 2177.0, 2281.0, 2345.0, 2414.0, 2480.0, 2740.0, 2803.0, 2873.0, 2938.0, 3194.0, 3268.0, 3450.0, 3524.2, 5785.0, 5930.0, 6084.0, 6248.0, 6405.0, 6557.0, 6856.0, 7015.0, 7191.0, 7350.0, 7810.0, 7940.0, 8100.0, 8240.0, 9050.0, 9220.0, 9550.0, 9710.0, 20670.0, 21050.0, 21470.0, 21860.0, 24860.0, 25360.0, 25990.0, 26390.4, 105064.3, 106982.7]
IP["At"] = [9.31751, 17.88, 26.58, 39.65, 50.39, 72.0, 85.1, 130.1, 149.0, 169.0, 192.1, 212.0, 236.0, 263.0, 287.0, 311.0, 335.0, 452.0, 481.0, 510.0, 540.0, 600.0, 630.0, 720.0, 750.0, 790.0, 860.0, 920.0, 990.0, 1050.0, 1120.0, 1180.0, 1250.0, 1320.0, 1380.0, 1450.0, 1510.0, 1590.0, 1650.0, 1948.0, 2007.0, 2071.0, 2139.0, 2203.0, 2266.0, 2373.0, 2439.0, 2510.0, 2576.0, 2841.0, 2905.0, 2977.0, 3042.0, 3312.0, 3388.0, 3573.0, 3649.0, 5980.0, 6122.0, 6279.0, 6445.0, 6604.0, 6759.0, 7068.0, 7230.0, 7410.0, 7570.0, 8030.0, 8180.0, 8330.0, 8480.0, 9330.0, 9500.0, 9830.0, 9990.0, 21210.0, 21600.0, 22030.0, 22420.0, 25580.0, 26080.0, 26730.0, 27139.0, 107923.4, 109886.0]
IP["Rn"] = [10.7485, 21.4, 29.4, 36.9, 52.9, 64.0, 88.0, 102.0, 154.0, 173.9, 195.0, 218.0, 240.0, 264.0, 293.0, 317.0, 342.0, 367.0, 488.0, 520.0, 550.0, 580.0, 640.0, 680.0, 760.0, 800.0, 850.0, 920.0, 980.0, 1050.0, 1120.0, 1180.0, 1250.0, 1310.0, 1390.0, 1460.0, 1520.0, 1590.0, 1660.0, 1720.0, 2033.0, 2094.0, 2158.0, 2227.0, 2293.0, 2357.0, 2467.0, 2535.0, 2606.0, 2674.0, 2944.0, 3010.0, 3082.0, 3149.0, 3433.0, 3510.0, 3699.0, 3777.0, 6169.0, 6318.0, 6476.0, 6646.0, 6807.0, 6964.0, 7283.0, 7450.0, 7630.0, 7800.0, 8260.0, 8410.0, 8570.0, 8710.0, 9610.0, 9780.0, 10120.0, 10290.0, 21770.0, 22160.0, 22600.0, 23000.0, 26310.0, 26830.0, 27490.0, 27903.1, 110842.0, 112843.7]
IP["Fr"] = [4.0727409, 22.4, 33.0, 39.1, 50.0, 67.0, 80.0, 106.0, 120.0, 179.0, 200.0, 222.1, 245.0, 269.0, 293.0, 324.0, 349.0, 375.0, 400.0, 530.0, 560.0, 590.0, 620.0, 690.0, 720.0, 820.0, 850.0, 910.0, 980.0, 1040.0, 1110.0, 1180.0, 1250.0, 1320.0, 1380.0, 1460.0, 1530.0, 1600.0, 1670.0, 1700.0, 1810.0, 2119.0, 2182.0, 2247.0, 2317.0, 2384.0, 2450.0, 2564.0, 2631.0, 2706.0, 2774.0, 3049.0, 3115.0, 3190.0, 3257.0, 3556.0, 3635.0, 3828.0, 3907.0, 6365.0, 6516.0, 6678.0, 6849.0, 7013.0, 7172.0, 7500.0, 7670.0, 7850.0, 8020.0, 8500.0, 8640.0, 8800.0, 8950.0, 9890.0, 10070.0, 10420.0, 10580.0, 22330.0, 22730.0, 23170.0, 23570.0, 27060.0, 27590.0, 28260.0, 28683.4, 113817.2, 115859.0]
IP["Ra"] = [5.278424, 10.147153, 31.0, 41.0, 52.9, 64.0, 82.0, 97.0, 100.0, 140.0, 204.9, 227.0, 250.0, 274.0, 299.0, 324.0, 356.0, 382.0, 409.0, 435.0, 570.0, 600.0, 630.0, 660.0, 740.0, 770.0, 860.0, 900.0, 970.0, 1040.0, 1110.0, 1180.0, 1250.0, 1320.0, 1390.0, 1460.0, 1530.0, 1610.0, 1680.0, 1750.0, 1820.0, 1880.0, 2208.0, 2271.0, 2338.0, 2409.0, 2477.0, 2544.0, 2662.0, 2731.0, 2806.0, 2876.0, 3155.0, 3224.0, 3300.0, 3368.0, 3682.0, 3762.0, 3959.0, 4040.0, 6565.0, 6718.0, 6881.0, 7056.0, 7222.0, 7380.0, 7720.0, 7890.0, 8080.0, 8250.0, 8730.0, 8880.0, 9040.0, 9200.0, 10190.0, 10360.0, 10720.0, 10890.0, 22900.0, 23300.0, 23750.0, 24160.0, 27830.0, 28370.0, 29050.0, 29479.8, 116848.7, 118931.3]
IP["Ac"] = [5.380226, 11.75, 17.431, 44.8, 55.0, 67.0, 79.0, 98.9, 113.9, 143.9, 161.1, 233.0, 255.0, 279.0, 305.0, 330.0, 355.0, 390.0, 416.0, 444.0, 470.0, 610.0, 640.0, 670.0, 710.0, 780.0, 820.0, 920.0, 950.0, 1030.0, 1100.0, 1170.0, 1240.0, 1310.0, 1380.0, 1460.0, 1530.0, 1610.0, 1680.0, 1750.0, 1820.0, 1900.0, 1970.0, 2298.0, 2362.0, 2430.0, 2503.0, 2572.0, 2639.0, 2762.0, 2833.0, 2908.0, 2980.0, 3264.0, 3334.0, 3409.0, 3479.0, 3811.0, 3893.0, 4093.0, 4175.0, 6767.0, 6923.0, 7088.0, 7265.0, 7430.0, 7600.0, 7950.0, 8120.0, 8310.0, 8480.0, 8970.0, 9120.0, 9290.0, 9440.0, 10480.0, 10660.0, 11030.0, 11200.0, 23480.0, 23890.0, 24340.0, 24760.0, 28610.0, 29160.0, 29850.0, 30293.0, 119939.0, 122062.9]
IP["Th"] = [6.3067, 11.9, 18.32, 28.648, 58.0, 69.1, 82.0, 95.0, 118.0, 133.0, 165.0, 181.0, 262.0, 285.0, 310.0, 336.0, 362.0, 389.0, 424.0, 451.0, 480.0, 508.0, 650.0, 680.0, 720.0, 750.0, 830.0, 900.0, 970.0, 1010.0, 1090.0, 1160.0, 1240.0, 1310.0, 1380.0, 1460.0, 1530.0, 1600.0, 1680.0, 1760.0, 1830.0, 1910.0, 2000.0, 2060.0, 2390.0, 2455.0, 2524.0, 2598.0, 2669.0, 2737.0, 2860.0, 2935.0, 3013.0, 3086.0, 3375.0, 3445.0, 3522.0, 3593.0, 3943.0, 4025.0, 4230.0, 4313.0, 6972.0, 7130.0, 7299.0, 7480.0, 7650.0, 7820.0, 8180.0, 8350.0, 8550.0, 8720.0, 9220.0, 9370.0, 9540.0, 9690.0, 10790.0, 10970.0, 11340.0, 11510.0, 24060.0, 24480.0, 24940.0, 25360.0, 29410.0, 29970.0, 30680.0, 31122.8, 123086.4, 125253.4]
IP["Pa"] = [5.89, 11.9, 19.0, 30.9, 44.3, 72.0, 85.1, 98.9, 111.0, 137.0, 153.0, 187.0, 203.0, 292.0, 316.0, 342.0, 369.0, 395.0, 423.0, 460.0, 488.0, 518.0, 546.0, 690.0, 720.0, 760.0, 790.0, 880.0, 920.0, 1020.0, 1060.0, 1150.0, 1220.0, 1300.0, 1370.0, 1450.0, 1520.0, 1600.0, 1670.0, 1760.0, 1830.0, 1910.0, 2000.0, 2060.0, 2130.0, 2483.0, 2550.0, 2620.0, 2696.0, 2766.0, 2837.0, 2968.0, 3040.0, 3119.0, 3193.0, 3488.0, 3558.0, 3637.0, 3709.0, 4077.0, 4161.0, 4370.0, 4454.0, 7181.0, 7341.0, 7510.0, 7690.0, 7870.0, 8040.0, 8410.0, 8590.0, 8780.0, 8960.0, 9460.0, 9620.0, 9790.0, 9950.0, 11100.0, 11280.0, 11660.0, 11840.0, 24660.0, 25080.0, 25540.0, 25970.0, 30230.0, 30800.0, 31520.0, 31971.6, 126296.6, 128507.0]
IP["U"] = [6.19405, 11.59, 19.8, 36.7, 46.0, 60.0, 89.0, 101.0, 116.0, 129.0, 158.0, 173.0, 210.0, 227.0, 323.0, 348.0, 375.0, 402.0, 431.0, 458.0, 497.0, 525.0, 557.0, 585.0, 730.0, 770.0, 800.0, 840.0, 930.0, 970.0, 1070.0, 1110.0, 1210.0, 1290.0, 1360.0, 1440.0, 1520.0, 1590.0, 1670.0, 1750.0, 1830.0, 1910.0, 1990.0, 2070.0, 2140.0, 2220.0, 2578.0, 2646.0, 2718.0, 2794.0, 2867.0, 2938.0, 3073.0, 3147.0, 3228.0, 3301.0, 3602.0, 3675.0, 3753.0, 3827.0, 4214.0, 4299.0, 4510.0, 4598.0, 7393.0, 7550.0, 7730.0, 7910.0, 8090.0, 8260.0, 8650.0, 8830.0, 9030.0, 9210.0, 9720.0, 9870.0, 10040.0, 10200.0, 11410.0, 11600.0, 11990.0, 12160.0, 25260.0, 25680.0, 26150.0, 26590.0, 31060.0, 31640.0, 32400.0, 32836.5, 129570.3, 131821.0]
IP["Np"] = [6.2655, 11.5, 19.7, 33.8, 48.0, 65.0, 92.0, 107.0, 121.0, 136.0, 151.0, 179.0, 196.0, 233.0, 252.0, 355.0, 382.0, 408.0, 438.0, 466.0, 495.0, 535.0, 565.0, 596.0, 626.0, 770.0, 810.0, 850.0, 880.0, 980.0, 1020.0, 1130.0, 1170.0, 1280.0, 1360.0, 1430.0, 1510.0, 1590.0, 1670.0, 1740.0, 1820.0, 1910.0, 1990.0, 2070.0, 2140.0, 2200.0, 2310.0, 2675.0, 2745.0, 2817.0, 2894.0, 2969.0, 3041.0, 3181.0, 3255.0, 3338.0, 3413.0, 3718.0, 3792.0, 3872.0, 3947.0, 4353.0, 4441.0, 4658.0, 4744.0, 7610.0, 7770.0, 7950.0, 8130.0, 8310.0, 8480.0, 8890.0, 9070.0, 9270.0, 9450.0, 9970.0, 10130.0, 10300.0, 10460.0, 11740.0, 11930.0, 12320.0, 12500.0, 25870.0, 26300.0, 26770.0, 27210.0, 31910.0, 32500.0, 33300.0, 33722.2, 132901.8, 135202.0]
IP["Pu"] = [6.0258, 11.5, 21.0, 35.0, 49.0, 80.0, 95.0, 109.0, 124.0, 139.0, 159.0, 179.0, 200.0, 219.0, 258.0, 278.0, 389.0, 416.0, 444.0, 474.0, 503.0, 532.0, 575.0, 605.0, 637.0, 668.0, 820.0, 850.0, 890.0, 930.0, 1030.0, 1070.0, 1180.0, 1220.0, 1340.0, 1420.0, 1500.0, 1580.0, 1660.0, 1700.0, 1820.0, 1890.0, 1990.0, 2070.0, 2150.0, 2200.0, 2310.0, 2390.0, 2774.0, 2844.0, 2918.0, 2997.0, 3072.0, 3146.0, 3290.0, 3366.0, 3449.0, 3527.0, 3836.0, 3911.0, 3993.0, 4068.0, 4496.0, 4585.0, 4807.0, 4890.0, 7820.0, 7990.0, 8170.0, 8360.0, 8540.0, 8720.0, 9130.0, 9310.0, 9520.0, 9700.0, 10230.0, 10390.0, 10570.0, 10730.0, 12060.0, 12260.0, 12660.0, 12840.0, 26480.0, 26920.0, 27400.0, 27840.0, 32800.0, 33400.0, 34100.0, 34625.8, 136299.2, 138646.0]
IP["Am"] = [5.9738, 11.7, 21.7, 36.8, 50.0, 67.9, 95.0, 110.0, 126.0, 141.0, 162.0, 184.0, 206.0, 225.0, 242.0, 284.0, 305.0, 424.0, 451.0, 481.0, 511.0, 541.0, 571.0, 616.0, 646.0, 680.0, 711.0, 860.0, 900.0, 940.0, 980.0, 1090.0, 1130.0, 1240.0, 1280.0, 1410.0, 1490.0, 1570.0, 1650.0, 1740.0, 1820.0, 1900.0, 1980.0, 2070.0, 2160.0, 2240.0, 2320.0, 2410.0, 2000.0, 2874.0, 2946.0, 3021.0, 3101.0, 3178.0, 3251.0, 3402.0, 3479.0, 3563.0, 3641.0, 3956.0, 4033.0, 4115.0, 4191.0, 4642.0, 4733.0, 4960.0, 5050.0, 8040.0, 8210.0, 8400.0, 8590.0, 8770.0, 8950.0, 9380.0, 9560.0, 9770.0, 9960.0, 10490.0, 10650.0, 10830.0, 11000.0, 12400.0, 12600.0, 13000.0, 13190.0, 27110.0, 27550.0, 28040.0, 28500.0, 33700.0, 34300.0, 35100.0, 35549.4, 139769.5, 142161.0]
IP["Cm"] = [5.9914, 10.0, 20.1, 37.7, 51.0, 69.1, 97.0, 112.0, 128.0, 144.0, 167.0, 190.0, 212.0, 235.0, 253.0, 272.0, 311.0, 332.0, 460.0, 489.0, 518.0, 550.0, 580.0, 611.0, 657.0, 689.0, 723.0, 755.0, 910.0, 950.0, 990.0, 1030.0, 1140.0, 1180.0, 1300.0, 1340.0, 1480.0, 1560.0, 1640.0, 1730.0, 1810.0, 1890.0, 1980.0, 2060.0, 2160.0, 2240.0, 2320.0, 2410.0, 2490.0, 2580.0, 2976.0, 3050.0, 3125.0, 3207.0, 3284.0, 3360.0, 3515.0, 3593.0, 3679.0, 3758.0, 4078.0, 4156.0, 4239.0, 4317.0, 4791.0, 4880.0, 5110.0, 5200.0, 8270.0, 8440.0, 8620.0, 8820.0, 9000.0, 9180.0, 9630.0, 9820.0, 10020.0, 10220.0, 10760.0, 10920.0, 11100.0, 11270.0, 12740.0, 12950.0, 13360.0, 13550.0, 27740.0, 28180.0, 28700.0, 29100.0, 34600.0, 35200.0, 36000.0, 36493.0, 143299.6, 145743.0]
IP["Bk"] = [6.1978, 11.9, 21.6, 36.0, 56.0, 70.1, 90.0, 114.0, 130.0, 147.0, 171.0, 195.0, 218.0, 240.0, 259.0, 279.0, 303.0, 339.0, 361.0, 497.0, 526.0, 557.0, 590.0, 621.0, 652.0, 700.0, 733.0, 768.0, 800.0, 960.0, 1000.0, 1040.0, 1080.0, 1200.0, 1240.0, 1360.0, 1410.0, 1550.0, 1630.0, 1720.0, 1800.0, 1890.0, 1970.0, 2050.0, 2140.0, 2240.0, 2320.0, 2410.0, 2490.0, 2580.0, 2670.0, 3080.0, 3154.0, 3232.0, 3315.0, 3393.0, 3469.0, 3630.0, 3709.0, 3797.0, 3877.0, 4202.0, 4281.0, 4365.0, 4445.0, 4940.0, 5040.0, 5270.0, 5360.0, 8500.0, 8670.0, 8850.0, 9050.0, 9240.0, 9420.0, 9880.0, 10070.0, 10280.0, 10480.0, 11020.0, 11190.0, 11380.0, 11540.0, 13090.0, 13300.0, 13720.0, 13910.0, 28380.0, 28800.0, 29300.0, 29800.0, 35500.0, 36200.0, 37000.0, 37457.6, 146904.7, 149398.0]
IP["Cf"] = [6.2817, 12.0, 22.4, 37.7, 51.9, 75.0, 91.0, 112.9, 133.0, 152.0, 178.0, 202.0, 225.0, 247.0, 265.0, 286.0, 310.0, 334.0, 368.0, 390.0, 536.0, 566.0, 597.0, 630.0, 662.0, 695.0, 744.0, 778.0, 814.0, 847.0, 1010.0, 1050.0, 1090.0, 1120.0, 1250.0, 1300.0, 1420.0, 1460.0, 1620.0, 1700.0, 1790.0, 1880.0, 1960.0, 2050.0, 2130.0, 2220.0, 2320.0, 2410.0, 2490.0, 2580.0, 2670.0, 2750.0, 3186.0, 3261.0, 3340.0, 3424.0, 3503.0, 3581.0, 3747.0, 3828.0, 3915.0, 3998.0, 4329.0, 4407.0, 4494.0, 4570.0, 5100.0, 5190.0, 5430.0, 5520.0, 8730.0, 8900.0, 9090.0, 9290.0, 9480.0, 9660.0, 10140.0, 10330.0, 10550.0, 10740.0, 11300.0, 11470.0, 11650.0, 11820.0, 13450.0, 13660.0, 14080.0, 14280.0, 29000.0, 29500.0, 30000.0, 30500.0, 36500.0, 37100.0, 37900.0, 38443.5, 150579.3, 153124.0]
IP["Es"] = [6.3676, 12.2, 22.7, 38.8, 54.1, 71.0, 97.0, 112.9, 137.0, 157.0, 180.0, 206.0, 231.0, 252.0, 270.0, 294.0, 317.0, 342.0, 367.0, 398.0, 421.0, 576.0, 606.0, 638.0, 672.0, 705.0, 738.0, 790.0, 824.0, 861.0, 895.0, 1060.0, 1100.0, 1140.0, 1180.0, 1310.0, 1360.0, 1480.0, 1530.0, 1690.0, 1780.0, 1870.0, 1950.0, 2040.0, 2130.0, 2220.0, 2300.0, 2410.0, 2490.0, 2580.0, 2680.0, 2760.0, 2900.0, 3294.0, 3370.0, 3449.0, 3535.0, 3616.0, 3694.0, 3866.0, 3947.0, 4038.0, 4120.0, 4456.0, 4537.0, 4620.0, 4700.0, 5260.0, 5350.0, 5600.0, 5690.0, 8960.0, 9140.0, 9330.0, 9530.0, 9720.0, 9910.0, 10400.0, 10590.0, 10810.0, 11010.0, 11570.0, 11740.0, 11930.0, 12110.0, 13810.0, 14030.0, 14460.0, 14700.0, 29700.0, 30100.0, 30700.0, 31100.0, 37400.0, 38100.0, 38900.0, 39451.4, 154328.0, 156926.0]
IP["Fm"] = [6.5, 10.0, 23.2, 39.3, 55.0, 74.0, 93.0, 120.0, 136.0, 162.0, 185.0, 209.0, 237.0, 257.0, 276.0, 300.0, 326.0, 351.0, 377.0, 402.0, 430.0, 453.0, 616.0, 647.0, 680.0, 716.0, 749.0, 782.0, 837.0, 871.0, 909.0, 944.0, 1110.0, 1150.0, 1190.0, 1230.0, 1370.0, 1420.0, 1550.0, 1600.0, 1770.0, 1860.0, 1940.0, 2030.0, 2120.0, 2210.0, 2300.0, 2390.0, 2490.0, 2590.0, 2680.0, 2760.0, 2900.0, 2950.0, 3403.0, 3480.0, 3561.0, 3647.0, 3730.0, 3810.0, 3986.0, 4070.0, 4160.0, 4245.0, 4586.0, 4670.0, 4760.0, 4840.0, 5420.0, 5510.0, 5760.0, 5860.0, 9200.0, 9370.0, 9570.0, 9770.0, 9970.0, 10160.0, 10660.0, 10860.0, 11080.0, 11280.0, 11850.0, 12020.0, 12220.0, 12390.0, 14180.0, 14400.0, 14800.0, 15000.0, 30300.0, 30800.0, 31300.0, 31800.0, 38400.0, 39100.0, 40000.0, 40482.2, 158152.5, 160804.0]
IP["Md"] = [6.58, 10.0, 24.3, 40.0, 54.1, 76.0, 96.0, 115.1, 143.9, 162.0, 187.0, 215.0, 240.0, 260.0, 282.0, 307.0, 334.0, 360.0, 386.0, 412.0, 438.0, 462.0, 486.0, 659.0, 690.0, 723.0, 760.0, 794.0, 828.0, 885.0, 920.0, 958.0, 994.0, 1160.0, 1200.0, 1250.0, 1290.0, 1430.0, 1480.0, 1620.0, 1660.0, 1840.0, 1930.0, 2020.0, 2110.0, 2200.0, 2290.0, 2380.0, 2000.0, 2580.0, 2680.0, 2760.0, 2860.0, 2950.0, 3050.0, 3513.0, 3592.0, 3675.0, 3762.0, 3845.0, 3926.0, 4109.0, 4194.0, 4286.0, 4371.0, 4720.0, 4800.0, 4890.0, 4970.0, 5580.0, 5680.0, 5930.0, 6030.0, 9430.0, 9620.0, 9810.0, 10020.0, 10220.0, 10410.0, 10930.0, 11130.0, 11360.0, 11560.0, 12140.0, 12310.0, 12500.0, 12680.0, 14560.0, 14800.0, 15200.0, 15400.0, 31000.0, 31500.0, 32000.0, 32500.0, 39500.0, 40100.0, 41000.0, 41548.0, 164764.0]
IP["No"] = [6.65, 12.5, 25.8, 41.5, 60.0, 74.0, 97.0, 119.0, 140.0, 170.0, 187.0, 216.0, 246.0, 267.0, 290.0, 312.0, 341.0, 367.0, 394.0, 420.0, 448.0, 475.0, 496.0, 520.0, 701.0, 734.0, 768.0, 805.0, 840.0, 875.0, 934.0, 969.0, 1010.0, 1045.0, 1220.0, 1260.0, 1300.0, 1340.0, 1500.0, 1550.0, 1680.0, 1730.0, 1920.0, 2010.0, 2100.0, 2200.0, 2290.0, 2380.0, 2470.0, 2570.0, 2680.0, 2760.0, 2860.0, 2950.0, 3050.0, 3140.0, 3627.0, 3705.0, 3790.0, 3878.0, 3962.0, 4045.0, 4234.0, 4320.0, 4413.0, 4500.0, 4850.0, 4930.0, 5030.0, 5110.0, 5750.0, 5850.0, 6110.0, 6210.0, 9680.0, 9860.0, 10060.0, 10270.0, 10470.0, 10660.0, 11200.0, 11410.0, 11630.0, 11840.0, 12420.0, 12600.0, 12800.0, 12980.0, 15000.0, 15200.0, 15600.0, 15800.0, 31700.0, 32200.0, 32700.0, 33200.0, 40500.0, 41200.0, 42100.0, 42632.0, 168806.0]
IP["Lr"] = [4.9, 14.3, 21.4, 43.6, 56.0, 80.0, 96.0, 121.0, 143.0, 165.0, 197.0, 216.0, 244.0, 269.0, 290.0, 320.0, 344.0, 374.0, 403.0, 431.0, 460.0, 487.0, 510.0, 540.0, 560.0, 745.0, 779.0, 814.0, 852.0, 888.0, 922.0, 985.0, 1020.0, 1061.0, 1098.0, 1280.0, 1320.0, 1360.0, 1410.0, 1570.0, 1620.0, 1760.0, 1810.0, 2010.0, 2100.0, 2190.0, 2290.0, 2380.0, 2470.0, 2570.0, 2670.0, 2780.0, 2860.0, 2960.0, 3060.0, 3150.0, 3250.0, 3741.0, 3821.0, 3906.0, 3996.0, 4082.0, 4165.0, 4360.0, 4448.0, 4540.0, 4630.0, 4990.0, 5070.0, 5160.0, 5250.0, 5920.0, 6030.0, 6290.0, 6390.0, 9920.0, 10110.0, 10310.0, 10520.0, 10720.0, 10920.0, 11480.0, 11680.0, 11910.0, 12120.0, 12710.0, 12890.0, 13090.0, 13300.0, 15300.0, 15600.0, 16000.0, 16200.0, 32400.0, 32900.0, 33400.0, 33900.0, 41600.0, 42300.0, 43200.0, 43759.0, 172930.0]
IP["Rf"] = [6.01, 14.7, 23.9, 31.7, 64.0, 77.0, 102.0, 119.0, 146.1, 169.0, 193.0, 225.0, 244.0, 275.0, 791.0, 825.0, 860.0, 899.0, 936.0, 972.0, 1036.0, 1073.0, 1114.0, 1151.0, 3857.0, 3938.0, 4025.0, 4116.0, 4203.0, 4287.0, 4489.0, 4580.0, 4670.0, 4760.0, 5120.0, 5210.0, 5300.0, 5390.0, 6100.0, 6200.0, 6470.0, 6570.0, 10170.0, 10360.0, 10560.0, 10780.0, 10980.0, 11180.0, 11750.0, 11960.0, 12200.0, 12410.0, 13010.0, 13190.0, 13400.0, 13600.0, 15800.0, 16000.0, 16400.0, 16700.0, 33100.0, 33600.0, 34100.0, 34600.0, 42700.0, 43400.0, 44300.0, 177148.0]
IP["Db"] = [6.8, 14.0, 23.1, 33.0, 43.0, 86.0, 98.9, 126.0, 145.0, 172.0, 196.0, 220.9, 254.0, 274.0, 307.0, 838.0, 872.0, 908.0, 948.0, 985.0, 1022.0, 1089.0, 1126.0, 1168.0, 1207.0, 3975.0, 4057.0, 4145.0, 4237.0, 4326.0, 4411.0, 4620.0, 4710.0, 4810.0, 4900.0, 5260.0, 5350.0, 5450.0, 5530.0, 6280.0, 6380.0, 6650.0, 6760.0, 10420.0, 10610.0, 10820.0, 11040.0, 11240.0, 11440.0, 12040.0, 12250.0, 12480.0, 12700.0, 13300.0, 13500.0, 13700.0, 13900.0, 16200.0, 16400.0, 16900.0, 17100.0, 33800.0, 34300.0, 34800.0, 35300.0, 43800.0, 44500.0, 45400.0, 181444.0]
IP["Sg"] = [7.8, 17.1, 25.8, 35.5, 47.2, 59.3, 109.0, 122.0, 152.0, 170.0, 200.0, 224.0, 251.0, 285.0, 306.0, 339.0, 885.0, 921.0, 958.0, 998.0, 1036.0, 1073.0, 1143.0, 1181.0, 1223.0, 1263.0, 4095.0, 4178.0, 4267.0, 4360.0, 4450.0, 4540.0, 4750.0, 4840.0, 4940.0, 5030.0, 5410.0, 5490.0, 5590.0, 5680.0, 6460.0, 6570.0, 6840.0, 6950.0, 10680.0, 10870.0, 11080.0, 11300.0, 11510.0, 11710.0, 12320.0, 12540.0, 12780.0, 12990.0, 13600.0, 13800.0, 14000.0, 14200.0, 16600.0, 16800.0, 17300.0, 17500.0, 34500.0, 35000.0, 35600.0, 36100.0, 44900.0, 45700.0, 46600.0, 185839.0]
IP["Bh"] = [7.7, 17.5, 26.7, 37.3, 49.0, 62.1, 74.9, 134.0, 148.0, 178.0, 198.0, 228.0, 255.0, 281.0, 318.0, 337.0, 374.0, 934.0, 969.0, 1008.0, 1049.0, 1088.0, 1126.0, 1197.0, 1237.0, 1280.0, 1320.0, 4216.0, 4301.0, 4390.0, 4486.0, 4580.0, 4660.0, 4890.0, 4980.0, 5080.0, 5170.0, 5550.0, 5640.0, 5740.0, 5830.0, 6650.0, 6760.0, 7040.0, 7140.0, 10930.0, 11130.0, 11340.0, 11560.0, 11780.0, 11980.0, 12610.0, 12830.0, 13070.0, 13300.0, 13900.0, 14100.0, 14300.0, 14500.0, 17000.0, 17300.0, 17700.0, 18000.0, 35200.0, 35700.0, 36300.0, 36800.0, 46100.0, 46900.0, 47800.0, 190331.0]
IP["Hs"] = [7.6, 18.2, 29.3, 37.7, 51.2, 64.0, 78.0, 92.0, 160.0, 173.9, 206.1, 227.0, 258.0, 285.0, 314.0, 351.0, 371.0, 409.0, 984.0, 1020.0, 1060.0, 1101.0, 1140.0, 1180.0, 1253.0, 1294.0, 1338.0, 1379.0, 4339.0, 4425.0, 4516.0, 4610.0, 4700.0, 4790.0, 5020.0, 5120.0, 5220.0, 5310.0, 5700.0, 5780.0, 5880.0, 5980.0, 6840.0, 6950.0, 7230.0, 7340.0, 11200.0, 11390.0, 11600.0, 11830.0, 12040.0, 12250.0, 12900.0, 13130.0, 13400.0, 13600.0, 14200.0, 14400.0, 14600.0, 14800.0, 17500.0, 17700.0, 18200.0, 18400.0, 35900.0, 36400.0, 37000.0, 37500.0, 47300.0, 48100.0, 49000.0, 194917.0]
IP["Mt"] = [50.0, 94.0, 109.0, 187.0, 202.0, 235.9, 257.0, 289.0, 318.0, 346.0, 386.0, 406.0, 445.0, 1035.0, 1072.0, 1112.0, 1154.0, 1195.0, 1234.0, 1311.0, 1352.0, 1397.0, 1439.0, 4464.0, 4551.0, 4640.0, 4740.0, 4830.0, 4920.0, 5160.0, 5250.0, 5360.0, 5450.0, 5840.0, 5930.0, 6030.0, 6130.0, 7040.0, 7150.0, 7440.0, 7550.0, 11460.0, 11660.0, 11870.0, 12100.0, 12320.0, 12530.0, 13200.0, 13400.0, 13700.0, 13900.0, 14500.0, 14700.0, 14900.0, 15100.0, 17900.0, 18200.0, 18700.0, 18900.0, 36700.0, 37200.0, 37800.0, 38300.0, 48500.0, 49400.0, 50300.0, 199606.0]
IP["Ds"] = [65.0, 112.9, 128.0, 216.0, 231.0, 266.0, 288.0, 322.0, 352.0, 380.0, 422.0, 442.0, 483.0, 1087.0, 1125.0, 1165.0, 1208.0, 1250.0, 1290.0, 1369.0, 1412.0, 1457.0, 1500.0, 4590.0, 4680.0, 4770.0, 4870.0, 4960.0, 5060.0, 5300.0, 5400.0, 5500.0, 5600.0, 5990.0, 6080.0, 6190.0, 6280.0, 7230.0, 7350.0, 7640.0, 7750.0, 11730.0, 11930.0, 12140.0, 12380.0, 12600.0, 12810.0, 13500.0, 13700.0, 14000.0, 14200.0, 14800.0, 15000.0, 15300.0, 15500.0, 18400.0, 18600.0, 19100.0, 19400.0, 37400.0, 37900.0, 38500.0, 39100.0, 49800.0, 50700.0, 51600.0, 204400.0]

IP_tmp = IP.copy()

for elem in IP_tmp:
    IP[elem+'1'] = 0.0
    for ion, ip in enumerate(IP[elem]):
        IP['{}{}'.format(elem,ion+2)] = ip

IP['H2'] = 13.59844
IP['He1'] = 0.0
IP['He2'] = 24.58741
IP['He3'] = 54.41778
IP['H1r'] = 13.59844
IP['He1r'] = 24.58741
IP['He2r'] = 54.41778

sym2name = {
            'H': 'hydrogen',
            '3He': 'helium',
            'D': 'deuterium',
            'He': 'helium',
            'Li': 'lithium',
            'Be': 'beryllium',
            'B': 'boron',
            'C': 'carbon',
            'N': 'nitrogen',
            'O': 'oxygen',
            'F': 'fluorine',
            'Ne': 'neon',
            'Na': 'sodium',
            'Mg': 'magnesium',
            'Al': 'aluminium',
            'Si': 'silicon',
            'P': 'phosphorus',
            'S': 'sulfur',
            'Cl': 'chlorine',
            'Ar': 'argon',
            'K': 'potassium',
            'Ca': 'calcium',
            'Sc': 'scandium',
            'Ti': 'titanium',
            'V': 'vanadium',
            'Cr': 'chromium',
            'Mn': 'manganese',
            'Fe': 'iron',
            'Co': 'cobalt',
            'Ni': 'nickel',
            'Cu': 'copper',
            'Zn': 'zinc',
            'Ga': 'gallium',
            'Ge': 'germanium',
            'As': 'arsenic',
            'Se': 'selenium',
            'Br': 'bromine',
            'Kr': 'krypton',
            'Rb': 'rubidium',
            'Sr': 'strontium',
            'Y': 'yttrium',
            'Zr': 'zirconium',
            'Nb': 'niobium',
            'Mo': 'molybdenum',
            'Tc': 'technetium',
            'Ru': 'ruthenium',
            'Rh': 'rhodium',
            'Pd': 'palladium',
            'Ag': 'silver',
            'Cd': 'cadmium',
            'In': 'indium',
            'Sn': 'tin',
            'Sb': 'antimony',
            'Te': 'tellurium',
            'I': 'iodine',
            'Xe': 'xenon',
            'Cs': 'cesium',
            'Ba': 'barium',
            'La': 'lanthanum',
            'Ce': 'cerium',
            'Pr': 'praseodymium',
            'Nd': 'neodymium',
            'Pm': 'promethium',
            'Sm': 'samarium',
            'Eu': 'europium',
            'Gd': 'gadolinium',
            'Tb': 'terbium',
            'Dy': 'dysprosium',
            'Ho': 'holmium',
            'Er': 'erbium',
            'Tm': 'thulium',
            'Yb': 'ytterbium',
            'Lu': 'lutetium',
            'Hf': 'hafnium',
            'Ta': 'tantalum',
            'W': 'tungsten',
            'Re': 'rhenium',
            'Os': 'osmium',
            'Ir': 'iridium',
            'Pt': 'platinum',
            'Au': 'gold',
            'Hg': 'mercury',
            'Tl': 'thallium',
            'Pb': 'lead',
            'Bi': 'bismuth',
            'Po': 'polonium',
            'At': 'astatine',
            'Rn': 'radon',
            'Fr': 'francium',
            'Ra': 'radium',
            'Ac': 'actinium',
            'Th': 'thorium',
            'Pa': 'protactinium',
            'U': 'uranium',
            'Np': 'neptunium',
            'Pu': 'plutonium',
            'Am': 'americium',
            'Cm': 'curium',
            'Bk': 'berkelium',
            'Cf': 'californium',
            'Es': 'einsteinium',
            'Fm': 'fermium',
            'Md': 'mendelevium',
            'No': 'nobelium',
            'Lr': 'lawrencium',
            'Rf': 'rutherfordium',
            'Db': 'dubnium',
            'Sg': 'seaborgium',
            'Bh': 'bohrium',
            'Hs': 'hassium',
            'Mt': 'meitnerium',
            'Ds': 'darmstadtium'
            }
"""
gsDict = {
            'p1': ['C2', 'N3', 'O4', 'F5', 'Al1', 'Si2', 'P3', 'S4', 'Ar6', 'Se4', 'Ga1', 'Ge2', 'As3', 'Se4',
                   'K7', 'Ca8', 'Fe14', 'Ni16', 'In1', 'Sn2', 'Sb3', 'Te4', 'I5', 'Xe6'],
            'p2': ['C1', 'N2', 'O3', 'Ne5', 'S3', 'Cl4', 'Ar5', 'Se3', 'Kr5', 'Xe5', 'Rb6'],
            'p3': ['N1', 'O2', 'Ne4', 'Na5', 'S2', 'Cl3', 'Ar4', 'K5', 'Se2', 'Kr4', 'Xe4', 'Rb5', 'Br3'],
            'p4': ['O1', 'Ne3', 'Na4', 'Mg5', 'Cl2', 'Ar3', 'K4', 'Ca5', 'Kr3', 'Xe3', 'Rb4'],
            'p5': ['Ne2', 'Na3', 'Si6', 'Cl1', 'Ar2', 'K3', 'Ba4'],
            's1': ['C4', 'N5', 'O6', 'Ba2', 'Na1', 'S6', 'Ga3', 'Ge4', 'As5', 'Ag1', 'Cd2', 'In3', 'Sn4', 'Sb5', 'Te6'],
            's2': ['C3', 'N4', 'O5', 'Si3', 'Mg1', 'S5', 'Ga2', 'Ge3', 'As4', 'Cd1', 'In2', 'Sn3', 'Sb4', 'Te5', 'I6'],
            'd2': ['Fe7'],
            'd3': ['Fe6'],
            'd4': ['Fe5'],
            'd5': ['Fe4'],
            'd6': ['Fe3'],
            'd7': ['Fe2'],
            'd8': ['Ni3']
            }
"""

def print_IPs(N_elems=20, N_ions=8):
    for elem in sorted(IP_tmp, key= lambda x: Z[x])[0:N_elems]: 
        print('{:<5}'.format(elem), ' '.join(['{:6.2f}'.format(ip) for ip in IP[elem][0:N_ions]])) 

def gsFromAtom(atom, verbose=False):
    """
    atom: eg 'O3' for O++
    """
    """
    special_dict = {'Fe2': 'd7', 'Fe3': 'd6', 'Fe4': 'd5', 'Fe5': 'd4', 'Fe6': 'd3', 'Fe7': 'd2', 'Ni3': 'd8'
                    }
    if atom in special_dict:
        return special_dict[atom]
    """
    # The import needs to be here. If in the header, infinite loop occurs at start
    from .manage_atomic_data import getLevelsNIST

    if atom in pn.atomicData.gsconf:
        if verbose:
            print('Obtained from gsconfs.dat')
        return pn.atomicData.gsconf[atom]
        
    res = 'unknown'
    try:
        NIST_gsconf = getLevelsNIST(atom)[0][0].split('.')[-1]
        if NIST_gsconf[-1] in ('0123456789'):
            NIST_gsconf = NIST_gsconf[-2:]
        else:
            NIST_gsconf = NIST_gsconf[-1] + '1'
        res = NIST_gsconf
        if verbose:
            print('Obtained from NIST')
    except:
        elem, i_str = parseAtom(atom) # Tranform e.g. 'O3' into 'O', '3'
        try:
            z = Z[elem]
        except:
            if verbose:
                print('Unknown Z')
            return 'unknown'    
        
        # Z-I :     
        ZmI = z - int(i_str)
        conf = ('s1', 's2', 'p1', 'p2', 'p3', 'p4', 'p5', 'p6', 'd1', 'd2', 'd3', 'd4', 'd5', 'd6','d7', 'd8')
        cn = np.array([2, 10, 28, 46, 54, 78])
        #cn = np.array([2, 10, 18, 36, 54, 86])
        k = ZmI - cn
        try:
            k_res = np.min(k[k>=0])
            res = conf[k_res]
            if verbose:
                print('Obtained from formula')
        except:
            if verbose:
                print('Unknown conf')
            res = 'unknown'

    
    return res 

def make_gsconf_file(outfile='gsconfs.dat'):
    file_names = sorted(glob('*levels.dat'))
    with open(outfile, 'w') as of:
        for fname in file_names:
            elem, ion, foo = fname.split('_')
            elem = elem.capitalize()
            ion = int(roman_to_int(ion))
            with open(fname, 'r') as f:
                NIST_gsconf = f.readline().split('|')[0].strip()
                if NIST_gsconf[-1] in '>':
                    NIST_gsconf = NIST_gsconf.split('<')[-2]
                if NIST_gsconf[-1] in ')':
                    NIST_gsconf = NIST_gsconf.split('(')[-2][:-2]
                if NIST_gsconf[-1] in ('0123456789'):
                    if NIST_gsconf[-2] in ('0123456789'):
                        NIST_gsconf_red = NIST_gsconf[-3:]
                    else:
                        NIST_gsconf_red = NIST_gsconf[-2:]
                else:
                    NIST_gsconf_red = NIST_gsconf[-1] + '1'
                of.write('{}{} {}\n'.format(elem, ion, NIST_gsconf_red))
    
gsLevelDict = {
            'p1': ['$^2$P$_{1/2}$', '$^2$P$_{3/2}$', '$^4$P$_{1/2}$', '$^4$P$_{3/2}$', '$^4$P$_{5/2}$', '$^2$D$_{3/2}$', '$^2$D$_{5/2}$', '$^2$S$_{1/2}$'],
            'p2': ['$^3$P$_0$', '$^3$P$_1$', '$^3$P$_2$', '$^1$D$_2$', '$^1$S$_0$', '$^5$S$_2$'],
            'p3': ['$^4$S$_{3/2}$', '$^2$D$_{3/2}$', '$^2$D$_{5/2}$', '$^2$P$_{1/2}$', '$^2$P$_{3/2}$', '$^4$P$_{5/2}$', '$^4$P$_{3/2}$', '$^4$P$_{1/2}$'],
            'p4': ['$^3$P$_0$', '$^3$P$_1$', '$^3$P$_2$', '$^1$D$_2$', '$^1$S$_0$'],
            'p5': ['$^2$P$_{3/2}$', '$^2$P$_{1/2}$'],
            's1': ['$^2$S$_{1/2}$', '$^2$P$_{1/2}$', '$^2$P$_{3/2}$'],
            's2': ['$^1$S$_0$', '$^3$P$_0$', '$^3$P$_1$', '$^3$P$_2$', '$^1$P$_1$'],
            'd2': ['$^3$F$_{2}$', '$^3$F$_{3}$', '$^3$F$_{4}$','$^1$D$_{2}$', '$^3$P$_{0}$', '$^3$P$_{1}$', '$^3$P$_{2}$', '$^1$G$_{4}$', '$^1$S$_{0}$'], 
            'd3': ['$^4$F$_{3/2}$', '$^4$F$_{5/2}$', '$^4$F$_{7/2}$','$^4$F$_{9/2}$', '$^4$P$_{1/2}$', '$^4$P$_{3/2}$', '$^4$P$_{5/2}$', '$^2$G$_{7/2}$', '$^2$G$_{9/2}$', '$^2$P$_{3/2}$', '$^2$P$_{1/2}$', '$^2$D2$_{5/2}$', '$^2$D2$_{3/2}$', '$^2$H$_{9/2}$', '$^2$H$_{11/2}$', '$^2$F$_{7/2}$', '$^2$F$_{5/2}$', '$^2$D1$_{5/2}$', '$^2$D1$_{3/2}$'], 
            'd6': ['$^5$D$_4$', '$^5$D$_3$', '$^5$D$_2$', '$^5$D$_1$', '$^5$D$_0$', '$^3$P2$_2$', '$^3$H$_6$'], 
            'd8': ['$3$F$_4$', '$^3$F$_3$', '$^3$F$_2$', '$^1$D$_2$', '$^3$P$_2$', '$^3$P2$_1$', '$^3$P$_0$']
            }

_predefinedDataFileDict = {}
_predefinedDataFileDict['IRAF_09_orig']={
                            'Al2': {'atom': 'al_ii_atom.fits', 'coll': 'al_ii_coll.fits'},
                            'Ar2': {'atom': 'ar_ii_atom.fits', 'coll': 'ar_ii_coll.fits'},
                            'Ar3': {'atom': 'ar_iii_atom.fits', 'coll': 'ar_iii_coll.fits'},
                            'Ar4': {'atom': 'ar_iv_atom.fits', 'coll': 'ar_iv_coll.fits'},
                            'Ar5': {'atom': 'ar_v_atom.fits', 'coll': 'ar_v_coll.fits'},
                            'C1': {'atom': 'c_i_atom.fits', 'coll': 'c_i_coll.fits'},
                            'C2': {'atom': 'c_ii_atom.fits', 'coll': 'c_ii_coll.fits'},
                            'C3': {'atom': 'c_iii_atom.fits', 'coll': 'c_iii_coll.fits'},
                            'Ca5': {'atom': 'ca_v_atom.fits', 'coll': 'ca_v_coll.fits'},
                            'Cl3': {'atom': 'cl_iii_atom.fits', 'coll': 'cl_iii_coll.fits'},
                            'Cl4': {'atom': 'cl_iv_atom.fits', 'coll': 'cl_iv_coll.fits'},
                            'K4': {'atom': 'k_iv_atom.fits', 'coll': 'k_iv_coll.fits'},
                            'K5': {'atom': 'k_v_atom.fits', 'coll': 'k_v_coll.fits'},
                            'Mg5': {'atom': 'mg_v_atom.fits', 'coll': 'mg_v_coll.fits'},
                            'Mg7': {'atom': 'mg_vii_atom.fits', 'coll': 'mg_vii_coll.fits'},
                            'N1': {'atom': 'n_i_atom.fits', 'coll': 'n_i_coll.fits'},
                            'N2': {'atom': 'n_ii_atom.fits', 'coll': 'n_ii_coll.fits'},
                            'N3': {'atom': 'n_iii_atom.fits', 'coll': 'n_iii_coll.fits'},
                            'N4': {'atom': 'n_iv_atom.fits', 'coll': 'n_iv_coll.fits'},
                            'Na4': {'atom': 'na_iv_atom.fits', 'coll': 'na_iv_coll.fits'},
                            'Na6': {'atom': 'na_vi_atom.fits', 'coll': 'na_vi_coll.fits'},
                            'Ne2': {'atom': 'ne_ii_atom.fits', 'coll': 'ne_ii_coll.fits'},
                            'Ne3': {'atom': 'ne_iii_atom.fits', 'coll': 'ne_iii_coll.fits'},
                            'Ne4': {'atom': 'ne_iv_atom.fits', 'coll': 'ne_iv_coll.fits'},
                            'Ne5': {'atom': 'ne_v_atom.fits', 'coll': 'ne_v_coll.fits'},
                            'Ne6': {'atom': 'ne_vi_atom.fits', 'coll': 'ne_vi_coll.fits'},
                            'O1': {'atom': 'o_i_atom.fits', 'coll': 'o_i_coll.fits'},
                            'O2': {'atom': 'o_ii_atom.fits', 'coll': 'o_ii_coll.fits'},
                            'O3': {'atom': 'o_iii_atom.fits', 'coll': 'o_iii_coll.fits'},
                            'O4': {'atom': 'o_iv_atom.fits', 'coll': 'o_iv_coll.fits'},
                            'O5': {'atom': 'o_v_atom.fits', 'coll': 'o_v_coll.fits'},
                            'S2': {'atom': 's_ii_atom.fits', 'coll': 's_ii_coll.fits'},
                            'S3': {'atom': 's_iii_atom.fits', 'coll': 's_iii_coll.fits'},
                            'S4': {'atom': 's_iv_atom.fits', 'coll': 's_iv_coll.fits'},
                            'Si2': {'atom': 'si_ii_atom.fits', 'coll': 'si_ii_coll.fits'},
                            'Si3': {'atom': 'si_iii_atom.fits', 'coll': 'si_iii_coll.fits'},
                            }
_predefinedDataFileDict['IRAF_09']={
                            'H1': {'rec': 'h_i_rec_SH95.fits'},
                            'He1': {'rec': 'he_i_rec_Pal12-Pal13.fits'},
                            'He2': {'rec': 'he_ii_rec_SH95.fits'},
                            'Al2': {'atom': 'al_ii_atom_JSP86-HK87-VVF96-KS86.fits', 'coll': 'al_ii_coll_KHAF92-TBK85-TBK84.fits'},
                            'Ar2': {'atom': 'ar_ii_atom_Bal06.fits', 'coll': 'ar_ii_coll_PB95.fits'},
                            'Ar3': {'atom': 'ar_iii_atom_B60-M83-KS86.fits', 'coll': 'ar_iii_coll_GMZ95.fits'},
                            'Ar4': {'atom': 'ar_iv_atom_B60-MZ82a-KS86.fits', 'coll': 'ar_iv_coll_ZBL87.fits'},
                            'Ar5': {'atom': 'ar_v_atom_B60-LL93-MZ82-KS86.fits', 'coll': 'ar_v_coll_GMZ95.fits'},
                            'C1': {'atom': 'c_i_atom_B60-NS84-FFS85.fits', 'coll': 'c_i_coll_JBK87-PA76.fits'},
                            'C2': {'atom': 'c_ii_atom_MG93-PP95-NS81-GMZ98.fits', 'coll': 'c_ii_coll_BP92.fits'},
                            'C3': {'atom': 'c_iii_atom_BK93-G83-NS78-WFD96.fits', 'coll': 'c_iii_coll_Bal85.fits'},
                            'Ca5': {'atom': 'ca_v_atom_B60-M83-KS86.fits', 'coll': 'ca_v_coll_GMZ95.fits'},
                            'Cl3': {'atom': 'cl_iii_atom_M83-KS86.fits', 'coll': 'cl_iii_coll_BZ89.fits'},
                            'Cl4': {'atom': 'cl_iv_atom_B60-H85-KS86-MZ82-EM84.fits', 'coll': 'cl_iv_coll_GMZ95.fits'},
                            'K4': {'atom': 'k_iv_atom_B60-M83-KS86.fits', 'coll': 'k_iv_coll_GMZ95.fits'},
                            'K5': {'atom': 'k_v_atom_B60-M83-KS86.fits', 'coll': 'k_v_coll_BZL88.fits'},
                            'Mg5': {'atom': 'mg_v_atom_Bal06-B60-GMZ97.fits', 'coll': 'mg_v_coll_BZ94.fits'},
                            'Mg7': {'atom': 'mg_vii_atom_Bal06-B60-BD95-GMZ97.fits', 'coll': 'mg_vii_coll_LB94-U.fits'},
                            'N1': {'atom': 'n_i_atom_B60-KS86-F75-WFD96.fits', 'coll': 'n_i_coll_PA76-DMR76.fits'},
                            'N2': {'atom': 'n_ii_atom_MG93-B60-PP95-GMZ97-WFD96.fits', 'coll': 'n_ii_coll_LB94.fits'},
                            'N3': {'atom': 'n_iii_atom_MG93-BFFJ95-BP92-GMZ98.fits', 'coll': 'n_iii_coll_BP92.fits'},
                            'N4': {'atom': 'n_iv_atom_NS79-WFD96.fits', 'coll': 'n_iv_coll_RBHB94.fits'},
                            'Na4': {'atom': 'na_iv_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_iv_coll_BZ94.fits'},
                            'Na6': {'atom': 'na_vi_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_vi_coll_LB94.fits'},
                            'Ne2': {'atom': 'ne_ii_atom_Bal06.fits', 'coll': 'ne_ii_coll_GMB01.fits'},
                            'Ne3': {'atom': 'ne_iii_atom_Bal06-B60-GMZ97.fits', 'coll': 'ne_iii_coll_BZ94.fits'},
                            'Ne4': {'atom': 'ne_iv_atom_E84-BBZ89-BK88.fits', 'coll': 'ne_iv_coll_G81.fits'},
                            'Ne5': {'atom': 'ne_v_atom_Bal06-B60-M83-GMZ97-U-BD93.fits', 'coll': 'ne_v_coll_LB94.fits'},
                            'Ne6': {'atom': 'ne_vi_atom_Bal06-KS86-MVGK95.fits', 'coll': 'ne_vi_coll_ZGP94.fits'},
                            'O1': {'atom': 'o_i_atom_M83b-WFD96.fits', 'coll': 'o_i_coll_BK95.fits'},
                            'O2': {'atom': 'o_ii_atom_B60-KS86-F75-WFD96.fits', 'coll': 'o_ii_coll_P76-McLB93-v1.fits'},
                            'O3': {'atom': 'o_iii_atom_MG93-B60-M85-GMZ97-WFD96.fits', 'coll': 'o_iii_coll_LB94.fits'},
                            'O4': {'atom': 'o_iv_atom_U-U-GMZ98b.fits', 'coll': 'o_iv_coll_BP92.fits'},
                            'O5': {'atom': 'o_v_atom_BJ68-B80-H80-NS79.fits', 'coll': 'o_v_coll_BBDK85.fits'},
                            'S2': {'atom': 's_ii_atom_B60-VVF96-KHOC93.fits', 'coll': 's_ii_coll_RBS96.fits'},
                            'S3': {'atom': 's_iii_atom_B60-Sal84-LL93-HSC95-MZ82b-KS86.fits', 'coll': 's_iii_coll_GMZ95.fits'},
                            'S4': {'atom': 's_iv_atom_BDF80-JKD86-DHKD82.fits', 'coll': 's_iv_coll_DHKD82.fits'},
                            'Si2': {'atom': 'si_ii_atom_Dal91-BL93-CSB93-N77.fits', 'coll': 'si_ii_coll_DK91.fits'},
                            'Si3': {'atom': 'si_iii_atom_WL95-M83-OKH88-FW90-KS86.fits', 'coll': 'si_iii_coll_DK94.fits'},
                            }
_predefinedDataFileDict['PYNEB_13_01']={
                             'H1': {'rec': 'h_i_rec_SH95.fits'},
                             'He1': {'rec': 'he_i_rec_Pal12-Pal13.fits'},
                             'He2': {'rec': 'he_ii_rec_SH95.fits'},
                             'Al2': {'atom': 'al_ii_atom_JSP86-HK87-VVF96-KS86.fits', 'coll': 'al_ii_coll_KHAF92-TBK85-TBK84.fits'},
                             'Ar2': {'atom': 'ar_ii_atom_Bal06.fits', 'coll': 'ar_ii_coll_PB95.fits'},
                             'Ar3': {'atom': 'ar_iii_atom_B60-M83-KS86.fits', 'coll': 'ar_iii_coll_GMZ95.fits'},
                             'Ar4': {'atom': 'ar_iv_atom_MZ82.fits', 'coll': 'ar_iv_coll_RB97.fits'},
                             'Ar5': {'atom': 'ar_v_atom_B60-LL93-MZ82-KS86.fits', 'coll': 'ar_v_coll_GMZ95.fits'},
                             'Ba2': {'atom': 'ba_ii_atom_C04.fits', 'coll': 'ba_ii_coll_SB98.fits'},
                             'Ba4': {'atom': 'ba_iv_atom_SC10-BHQZ95.fits', 'coll': 'ba_iv_coll_SB98.fits'},
                             'C1': {'atom': 'c_i_atom_B60-NS84-FFS85.fits', 'coll': 'c_i_coll_JBK87-PA76.fits'},
                             'C2': {'atom': 'c_ii_atom_MG93-PP95-NS81-GMZ98.fits', 'coll': 'c_ii_coll_BP92.fits'},
                             'C3': {'atom': 'c_iii_atom_BK93-G83-NS78-WFD96.fits', 'coll': 'c_iii_coll_Bal85.fits'},
                             'C4': {'atom': 'c_iv_atom_M83-WFD96.fits', 'coll': 'c_iv_coll_AK04.fits'},
                             'Ca5': {'atom': 'ca_v_atom_B60-M83-KS86.fits', 'coll': 'ca_v_coll_GMZ95.fits'},
                             'Cl2': {'atom': 'cl_ii_atom_RK74-MZ83.fits', 'coll': 'cl_ii_coll_T04.fits'},
                             'Cl3': {'atom': 'cl_iii_atom_M83-KS86.fits', 'coll': 'cl_iii_coll_BZ89.fits'},
                             'Cl4': {'atom': 'cl_iv_atom_B60-H85-KS86-MZ82-EM84.fits', 'coll': 'cl_iv_coll_GMZ95.fits'},
                             'Fe3': {'atom': 'fe_iii_atom_Q96.fits', 'coll': 'fe_iii_coll_Q96.fits'},
                             'K4': {'atom': 'k_iv_atom_B60-M83-KS86.fits', 'coll': 'k_iv_coll_GMZ95.fits'},
                             'K5': {'atom': 'k_v_atom_B60-M83-KS86.fits', 'coll': 'k_v_coll_BZL88.fits'},
                             'Mg5': {'atom': 'mg_v_atom_Bal06-B60-GMZ97.fits', 'coll': 'mg_v_coll_BZ94.fits'},
                             'Mg7': {'atom': 'mg_vii_atom_Bal06-B60-BD95-GMZ97.fits', 'coll': 'mg_vii_coll_LB94-U.fits'},
                             'N1': {'atom': 'n_i_atom_B60-KS86-F75-WFD96.fits', 'coll': 'n_i_coll_PA76-DMR76.fits'},
                             'N2': {'atom': 'n_ii_atom_MG93-B60-PP95-GMZ97-WFD96.fits', 'coll': 'n_ii_coll_T11.fits'},
                             'N3': {'atom': 'n_iii_atom_MG93-BFFJ95-BP92-GMZ98.fits', 'coll': 'n_iii_coll_BP92.fits'},
                             'N4': {'atom': 'n_iv_atom_NS79-WFD96.fits', 'coll': 'n_iv_coll_RBHB94.fits'},
                             'Na4': {'atom': 'na_iv_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_iv_coll_BZ94.fits'},
                             'Na6': {'atom': 'na_vi_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_vi_coll_LB94.fits'},
                             'Ne2': {'atom': 'ne_ii_atom_Bal06.fits', 'coll': 'ne_ii_coll_GMB01.fits'},
                             'Ne3': {'atom': 'ne_iii_atom_Bal06-B60-GMZ97.fits', 'coll': 'ne_iii_coll_McLB00.fits'},
                             'Ne4': {'atom': 'ne_iv_atom_E84-BBZ89-BK88.fits', 'coll': 'ne_iv_coll_G81.fits'},
                             'Ne5': {'atom': 'ne_v_atom_Bal06-B60-M83-GMZ97-U-BD93.fits', 'coll': 'ne_v_coll_LB94.fits'},
                             'Ne6': {'atom': 'ne_vi_atom_Bal06-KS86-MVGK95.fits', 'coll': 'ne_vi_coll_ZGP94.fits'},
                             'O1': {'atom': 'o_i_atom_M83b-WFD96.fits', 'coll': 'o_i_coll_BK95.fits'},
                             'O2': {'atom': 'o_ii_atom_B60-KS86-F75-Z82-WFD96.fits', 'coll': 'o_ii_coll_P06-T07.fits'},
                             'O3': {'atom': 'o_iii_atom_B60-M85-WFD96-SZ00-WFD96.fits', 'coll': 'o_iii_coll_AK99.fits'},
                             'O4': {'atom': 'o_iv_atom_U-U-GMZ98b.fits', 'coll': 'o_iv_coll_BP92.fits'},
                             'O5': {'atom': 'o_v_atom_BJ68-B80-H80-NS79.fits', 'coll': 'o_v_coll_BBDK85.fits'},
                             'S2': {'atom': 's_ii_atom_B60-VVF96-PKW09.fits', 'coll': 's_ii_coll_TZ10.fits'},
                             'S3': {'atom': 's_iii_atom_B60-Sal84-PKW09.fits', 'coll': 's_iii_coll_GMZ95.fits'},
                             'S4': {'atom': 's_iv_atom_BDF80-JKD86-DHKD82.fits', 'coll': 's_iv_coll_DHKD82.fits'},
                             'Si2': {'atom': 'si_ii_atom_Dal91-BL93-CSB93-N77.fits', 'coll': 'si_ii_coll_DK91.fits'},
                             'Si3': {'atom': 'si_iii_atom_WL95-M83-OKH88-FW90-KS86.fits', 'coll': 'si_iii_coll_DK94.fits'},
                             'Xe3': {'atom': 'xe_iii_atom_M93-BHQZ95.fits', 'coll': 'xe_iii_coll_SB98.fits'},
                             'Xe4': {'atom': 'xe_iv_atom_S04-BHQZ95.fits', 'coll': 'xe_iv_coll_SB98.fits'}
                             }
_predefinedDataFileDict['PYNEB_14_01']={
                             'H1': {'rec': 'h_i_rec_SH95.fits'},
                             'He1': {'rec': 'he_i_rec_Pal12-Pal13.fits'},
                             'He2': {'rec': 'he_ii_rec_SH95.fits'},
                             'Al2': {'atom': 'al_ii_atom_JSP86-HK87-VVF96-KS86.fits', 'coll': 'al_ii_coll_KHAF92-TBK85-TBK84.fits'},
                             'Ar2': {'atom': 'ar_ii_atom_Bal06.fits', 'coll': 'ar_ii_coll_PB95.fits'},
                             'Ar3': {'atom': 'ar_iii_atom_B60-M83-KS86.fits', 'coll': 'ar_iii_coll_GMZ95.fits'},
                             'Ar4': {'atom': 'ar_iv_atom_MZ82.fits', 'coll': 'ar_iv_coll_RB97.fits'},
                             'Ar5': {'atom': 'ar_v_atom_B60-LL93-MZ82-KS86.fits', 'coll': 'ar_v_coll_GMZ95.fits'},
                             'C1': {'atom': 'c_i_atom_B60-NS84-FFS85.fits', 'coll': 'c_i_coll_JBK87-PA76.fits'},
                             'C2': {'atom': 'c_ii_atom_MG93-PP95-NS81-GMZ98.fits', 'coll': 'c_ii_coll_BP92.fits'},
                             'C3': {'atom': 'c_iii_atom_BK93-G83-NS78-WFD96.fits', 'coll': 'c_iii_coll_Bal85.fits'},
                             'C4': {'atom': 'c_iv_atom_M83-WFD96.fits', 'coll': 'c_iv_coll_AK04.fits'},
                             'Ca5': {'atom': 'ca_v_atom_B60-M83-KS86.fits', 'coll': 'ca_v_coll_GMZ95.fits'},
                             'Cl2': {'atom': 'cl_ii_atom_RK74-MZ83.fits', 'coll': 'cl_ii_coll_T04.fits'},
                             'Cl3': {'atom': 'cl_iii_atom_M83-KS86.fits', 'coll': 'cl_iii_coll_BZ89.fits'},
                             'Cl4': {'atom': 'cl_iv_atom_B60-H85-KS86-MZ82-EM84.fits', 'coll': 'cl_iv_coll_GMZ95.fits'},
                             'K4': {'atom': 'k_iv_atom_B60-M83-KS86.fits', 'coll': 'k_iv_coll_GMZ95.fits'},
                             'K5': {'atom': 'k_v_atom_B60-M83-KS86.fits', 'coll': 'k_v_coll_BZL88.fits'},
                             'Mg5': {'atom': 'mg_v_atom_Bal06-B60-GMZ97.fits', 'coll': 'mg_v_coll_BZ94.fits'},
                             'Mg7': {'atom': 'mg_vii_atom_Bal06-B60-BD95-GMZ97.fits', 'coll': 'mg_vii_coll_LB94-U.fits'},
                             'N1': {'atom': 'n_i_atom_B60-KS86-F75-WFD96.fits', 'coll': 'n_i_coll_PA76-DMR76.fits'},
                             'N2': {'atom': 'n_ii_atom_MG93-B60-PP95-GMZ97-WFD96.fits', 'coll': 'n_ii_coll_T11.fits'},
                             'N3': {'atom': 'n_iii_atom_MG93-BFFJ95-BP92-GMZ98.fits', 'coll': 'n_iii_coll_BP92.fits'},
                             'N4': {'atom': 'n_iv_atom_NS79-WFD96.fits', 'coll': 'n_iv_coll_RBHB94.fits'},
                             'Na4': {'atom': 'na_iv_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_iv_coll_BZ94.fits'},
                             'Na6': {'atom': 'na_vi_atom_Bal06-B60-GMZ97.fits', 'coll': 'na_vi_coll_LB94.fits'},
                             'Ne2': {'atom': 'ne_ii_atom_Bal06.fits', 'coll': 'ne_ii_coll_GMB01.fits'},
                             'Ne3': {'atom': 'ne_iii_atom_Bal06-B60-GMZ97.fits', 'coll': 'ne_iii_coll_McLB00.fits'},
                             'Ne4': {'atom': 'ne_iv_atom_E84-BBZ89-BK88.fits', 'coll': 'ne_iv_coll_G81.fits'},
                             'Ne5': {'atom': 'ne_v_atom_Bal06-B60-M83-GMZ97-U-BD93.fits', 'coll': 'ne_v_coll_LB94.fits'},
                             'Ne6': {'atom': 'ne_vi_atom_Bal06-KS86-MVGK95.fits', 'coll': 'ne_vi_coll_ZGP94.fits'},
                             'O1': {'atom': 'o_i_atom_M83b-WFD96.fits', 'coll': 'o_i_coll_BK95.fits'},
                             'O2': {'atom': 'o_ii_atom_B60-KS86-F75-Z82-WFD96.fits', 'coll': 'o_ii_coll_P06-T07.fits'},
                             'O3': {'atom': 'o_iii_atom_B60-M85-WFD96-SZ00-WFD96.fits', 'coll': 'o_iii_coll_AK99.fits'},
                             'O4': {'atom': 'o_iv_atom_U-U-GMZ98b.fits', 'coll': 'o_iv_coll_BP92.fits'},
                             'O5': {'atom': 'o_v_atom_BJ68-B80-H80-NS79.fits', 'coll': 'o_v_coll_BBDK85.fits'},
                             'S2': {'atom': 's_ii_atom_B60-VVF96-PKW09.fits', 'coll': 's_ii_coll_TZ10.fits'},
                             'S3': {'atom': 's_iii_atom_B60-Sal84-PKW09.fits', 'coll': 's_iii_coll_GMZ95.fits'},
                             'S4': {'atom': 's_iv_atom_BDF80-JKD86-DHKD82.fits', 'coll': 's_iv_coll_DHKD82.fits'},
                             'Si2': {'atom': 'si_ii_atom_Dal91-BL93-CSB93-N77.fits', 'coll': 'si_ii_coll_DK91.fits'},
                             'Si3': {'atom': 'si_iii_atom_WL95-M83-OKH88-FW90-KS86.fits', 'coll': 'si_iii_coll_DK94.fits'},
                             'Xe3': {'atom': 'xe_iii_atom_BHQZ95.dat', 'coll': 'xe_iii_coll_SB98.fits'},
                             'Xe4': {'atom': 'xe_iv_atom_BHQZ95.dat', 'coll': 'xe_iv_coll_SB98.fits'},
                             'Xe6': {'atom': 'xe_vi_atom_BHQZ95.dat', 'coll': 'xe_vi_coll_SB98.fits'},
                             'Kr3': {'atom': 'kr_iii_atom_BH86.dat', 'coll':'kr_iii_coll_S97.dat'},
                             'Kr4': {'atom': 'kr_iv_atom_BH86.dat', 'coll': 'kr_iv_coll_S97.dat'},
                             'Kr5': {'atom': 'kr_v_atom_BH86.dat', 'coll': 'kr_v_coll_S97.dat'},
                             'Se3': {'atom': 'se_iii_atom_BH86.dat', 'coll': 'se_iii_coll_S97.dat'},
                             'Se4': {'atom': 'se_iv_atom_B05.dat', 'coll': 'se_iv_coll_B05.dat'},
                             'Br3': {'atom': 'br_iii_atom_BH86.dat', 'coll': 'br_iii_coll_S97.dat'},
                             'Br4': {'atom': 'br_iv_atom_BH86.dat', 'coll': 'br_iv_coll_S97.dat'},
                             'Rb4': {'atom': 'rb_iv_atom_BH86.dat', 'coll': 'rb_iv_coll_S97.dat'},
                             'Rb5': {'atom': 'rb_v_atom_BH86.dat', 'coll': 'rb_v_coll_S97.dat'},
                             'Rb6': {'atom': 'rb_vi_atom_BH86.dat', 'coll': 'rb_vi_coll_S97.dat'}
                             }

_predefinedDataFileDict['PYNEB_14_02']={
                             'H1': {'rec': 'h_i_rec_SH95.fits'},
                             'He1': {'rec': 'he_i_rec_Pal12-Pal13.fits'},
                             'He2': {'rec': 'he_ii_rec_SH95.fits'},
                             'Al2': {'atom': 'al_ii_atom_JSP86-HK87-VVF96-KS86.dat', 'coll': 'al_ii_coll_KHAF92-TBK85-TBK84.dat'},
                             'Ar2': {'atom': 'ar_ii_atom_Bal06.dat', 'coll': 'ar_ii_coll_PB95.dat'},
                             'Ar3': {'atom': 'ar_iii_atom_M83-KS86.dat', 'coll': 'ar_iii_coll_GMZ95.dat'},
                             'Ar4': {'atom': 'ar_iv_atom_MZ82.dat', 'coll': 'ar_iv_coll_RB97.dat'},
                             'Ar5': {'atom': 'ar_v_atom_LL93-MZ82-KS86.dat', 'coll': 'ar_v_coll_GMZ95.dat'},
                             'Ba2': {'atom': 'ba_ii_atom_C04.dat', 'coll': 'ba_ii_coll_SB98.dat'},
                             'Ba4': {'atom': 'ba_iv_atom_BHQZ95.dat', 'coll': 'ba_iv_coll_SB98.dat'},
                             'C1': {'atom': 'c_i_atom_FFS85.dat', 'coll': 'c_i_coll_JBK87-PA76.dat'},
                             'C2': {'atom': 'c_ii_atom_GMZ98.dat', 'coll': 'c_ii_coll_BP92.dat'},
                             'C3': {'atom': 'c_iii_atom_G83-NS78-WFD96.dat', 'coll': 'c_iii_coll_Bal85.dat'},
                             'C4': {'atom': 'c_iv_atom_WFD96.dat', 'coll': 'c_iv_coll_AK04.dat'},
                             'Ca5': {'atom': 'ca_v_atom_M83-KS86.dat', 'coll': 'ca_v_coll_GMZ95.dat'},
                             'Cl2': {'atom': 'cl_ii_atom_MZ83.dat', 'coll': 'cl_ii_coll_T04.dat'},
                             'Cl3': {'atom': 'cl_iii_atom_M83-KS86.dat', 'coll': 'cl_iii_coll_BZ89.dat'},
                             'Cl4': {'atom': 'cl_iv_atom_KS86-MZ82-EM84.dat', 'coll': 'cl_iv_coll_GMZ95.dat'},
                             'Fe3': {'atom': 'fe_iii_atom_Q96_J00.dat', 'coll': 'fe_iii_coll_Z96.dat'},
                             'K4': {'atom': 'k_iv_atom_M83-KS86.dat', 'coll': 'k_iv_coll_GMZ95.dat'},
                             'K5': {'atom': 'k_v_atom_M83-KS86.dat', 'coll': 'k_v_coll_BZL88.dat'},
                             'Mg5': {'atom': 'mg_v_atom_GMZ97.dat', 'coll': 'mg_v_coll_BZ94.dat'},
                             'Mg7': {'atom': 'mg_vii_atom_GMZ97.dat', 'coll': 'mg_vii_coll_LB94-U.dat'},
                             'N1': {'atom': 'n_i_atom_KS86-WFD96.dat', 'coll': 'n_i_coll_PA76-DMR76.dat'},
                             'N2': {'atom': 'n_ii_atom_GMZ97-WFD96.dat', 'coll': 'n_ii_coll_T11.dat'},
                             'N3': {'atom': 'n_iii_atom_GMZ98.dat', 'coll': 'n_iii_coll_BP92.dat'},
                             'N4': {'atom': 'n_iv_atom_WFD96.dat', 'coll': 'n_iv_coll_RBHB94.dat'},
                             'Na4': {'atom': 'na_iv_atom_GMZ97.dat', 'coll': 'na_iv_coll_BZ94.dat'},
                             'Na6': {'atom': 'na_vi_atom_GMZ97.dat', 'coll': 'na_vi_coll_LB94.dat'},
                             'Ne2': {'atom': 'ne_ii_atom_Bal06.dat', 'coll': 'ne_ii_coll_GMB01.dat'},
                             'Ne3': {'atom': 'ne_iii_atom_GMZ97.dat', 'coll': 'ne_iii_coll_McLB00.dat'},
                             'Ne4': {'atom': 'ne_iv_atom_BBZ89-BK88.dat', 'coll': 'ne_iv_coll_G81.dat'},
                             'Ne5': {'atom': 'ne_v_atom_GMZ97-U-BD93.dat', 'coll': 'ne_v_coll_LB94.dat'},
                             'Ne6': {'atom': 'ne_vi_atom_GMZ98.dat', 'coll': 'ne_vi_coll_ZGP94.dat'},
                             'Ni3': {'atom': 'ni_iii_atom_B01.dat', 'coll': 'ni_iii_coll_B01.dat'},
                             'O1': {'atom': 'o_i_atom_WFD96.dat', 'coll': 'o_i_coll_BK95.dat'},
                             'O2': {'atom': 'o_ii_atom_Z82-WFD96.dat', 'coll': 'o_ii_coll_P06-T07.dat'},
                             'O3': {'atom': 'o_iii_atom_SZ00-WFD96.dat', 'coll': 'o_iii_coll_AK99.dat'},
                             'O4': {'atom': 'o_iv_atom_GMZ98.dat', 'coll': 'o_iv_coll_BP92.dat'},
                             'O5': {'atom': 'o_v_atom_H80-NS79.dat', 'coll': 'o_v_coll_BBDK85.dat'},
                             'S2': {'atom': 's_ii_atom_PKW09.dat', 'coll': 's_ii_coll_TZ10.dat'},
                             'S3': {'atom': 's_iii_atom_PKW09.dat', 'coll': 's_iii_coll_GMZ95.dat'},
                             'S4': {'atom': 's_iv_atom_JKD86-DHKD82.dat', 'coll': 's_iv_coll_DHKD82.dat'},
                             'Si2': {'atom': 'si_ii_atom_BL93-CSB93-N77.dat', 'coll': 'si_ii_coll_DK91.dat'},
                             'Si3': {'atom': 'si_iii_atom_M83-OKH88-FW90-KS86.dat', 'coll': 'si_iii_coll_DK94.dat'},
                             'Xe3': {'atom': 'xe_iii_atom_BHQZ95.dat', 'coll': 'xe_iii_coll_SB98.dat'},
                             'Xe4': {'atom': 'xe_iv_atom_BHQZ95.dat', 'coll': 'xe_iv_coll_SB98.dat'},
                             'Xe6': {'atom': 'xe_vi_atom_BHQZ95.dat', 'coll': 'xe_vi_coll_SB98.dat'},
                             'Kr3': {'atom': 'kr_iii_atom_BH86.dat', 'coll':'kr_iii_coll_S97.dat'},
                             'Kr4': {'atom': 'kr_iv_atom_BH86.dat', 'coll': 'kr_iv_coll_S97.dat'},
                             'Kr5': {'atom': 'kr_v_atom_BH86.dat', 'coll': 'kr_v_coll_S97.dat'},
                             'Se3': {'atom': 'se_iii_atom_BH86.dat', 'coll': 'se_iii_coll_S97.dat'},
                             'Se4': {'atom': 'se_iv_atom_B05.dat', 'coll': 'se_iv_coll_B05.dat'},
                             'Br3': {'atom': 'br_iii_atom_BH86.dat', 'coll': 'br_iii_coll_S97.dat'},
                             'Br4': {'atom': 'br_iv_atom_BH86.dat', 'coll': 'br_iv_coll_S97.dat'},
                             'Rb4': {'atom': 'rb_iv_atom_BH86.dat', 'coll': 'rb_iv_coll_S97.dat'},
                             'Rb5': {'atom': 'rb_v_atom_BH86.dat', 'coll': 'rb_v_coll_S97.dat'},
                             'Rb6': {'atom': 'rb_vi_atom_BH86.dat', 'coll': 'rb_vi_coll_S97.dat'}
                             }

_predefinedDataFileDict['PYNEB_14_03'] = deepcopy(_predefinedDataFileDict['PYNEB_14_02'])
_predefinedDataFileDict['PYNEB_14_03']['Fe4'] = {'atom': 'fe_iv_atom_FFRR08.dat', 'coll': 'fe_iv_coll_ZP97.dat'}
_predefinedDataFileDict['PYNEB_14_03']['Fe5'] = {'atom': 'fe_v_atom_Nal00.dat', 'coll': 'fe_v_coll_BGMcL07.dat'}
_predefinedDataFileDict['PYNEB_14_03']['Fe6'] = {'atom': 'fe_vi_atom_CP00.dat', 'coll': 'fe_vi_coll_CP99.dat'}
_predefinedDataFileDict['PYNEB_14_03']['Fe7'] = {'atom': 'fe_vii_atom_WB08.dat', 'coll': 'fe_vii_coll_WB08.dat'}
_predefinedDataFileDict['PYNEB_14_03']['3He2'] = {'atom': '3he_ii_atom_cloudy.dat', 'coll': '3he_ii_coll_cloudy.dat'}
_predefinedDataFileDict['PYNEB_14_03']['S3']['coll'] =  's_iii_coll_TG99.dat'

_predefinedDataFileDict['PYNEB_16_01'] = deepcopy(_predefinedDataFileDict['PYNEB_14_03'])
_predefinedDataFileDict['PYNEB_16_01']['Fe2'] = {'atom': 'fe_ii_atom_B15.dat', 'coll': 'fe_ii_coll_B15.dat'}
_predefinedDataFileDict['PYNEB_16_01']['P2'] = {'atom': 'p_ii_atom_MZ82.dat', 'coll': 'p_ii_coll_T04.dat'}

_predefinedDataFileDict['PYNEB_17_01'] = deepcopy(_predefinedDataFileDict['PYNEB_16_01'])
_predefinedDataFileDict['PYNEB_17_01']['H1']['rec'] = 'h_i_rec_SH95.hdf5'
_predefinedDataFileDict['PYNEB_17_01']['He1']['rec'] = 'he_i_rec_Pal12-Pal13.hdf5'
_predefinedDataFileDict['PYNEB_17_01']['He2']['rec'] = 'he_ii_rec_SH95.hdf5'
_predefinedDataFileDict['PYNEB_17_01']['C1']['rec'] = 'c_i_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['C2']['rec'] = 'c_ii_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['C3']['rec'] = 'c_iii_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['C4']['rec'] = 'c_iv_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['N1']['rec'] = 'n_i_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['N2']['rec'] = 'n_ii_rec_FSL11.func'
_predefinedDataFileDict['PYNEB_17_01']['N2']['atom'] = 'n_ii_atom_FFT04.dat' 
_predefinedDataFileDict['PYNEB_17_01']['N3']['rec'] = 'n_iii_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['N4']['rec'] = 'n_iv_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['N5'] = {'rec' : 'n_v_rec_P91.func'}
_predefinedDataFileDict['PYNEB_17_01']['O1']['rec'] = 'o_i_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['O2']['rec'] = 'o_ii_rec_SSB17-B-opt.hdf5'
_predefinedDataFileDict['PYNEB_17_01']['O2']['atom'] = 'o_ii_atom_FFT04.dat'
_predefinedDataFileDict['PYNEB_17_01']['O2']['coll'] = 'o_ii_coll_Kal09.dat'
_predefinedDataFileDict['PYNEB_17_01']['O3']['rec'] = 'o_iii_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['O3']['atom'] = 'o_iii_atom_FFT04-SZ00.dat'
_predefinedDataFileDict['PYNEB_17_01']['O3']['coll'] = 'o_iii_coll_SSB14.dat'
_predefinedDataFileDict['PYNEB_17_01']['O4']['rec'] = 'o_iv_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['O5']['rec'] = 'o_v_rec_P91.func'
_predefinedDataFileDict['PYNEB_17_01']['O6'] = {'rec' : 'o_vi_rec_P91.func'}
_predefinedDataFileDict['PYNEB_17_01']['Ar3']['atom'] = 'ar_iii_atom_MB09.dat'
_predefinedDataFileDict['PYNEB_17_01']['Ar3']['coll'] = 'ar_iii_coll_MB09.dat'
_predefinedDataFileDict['PYNEB_17_01']['Ne5']['coll'] = 'ne_v_coll_DPNP13.dat'

_predefinedDataFileDict['PYNEB_17_02'] = deepcopy(_predefinedDataFileDict['PYNEB_17_01'])
_predefinedDataFileDict['PYNEB_17_02']['Ne2']['rec'] = 'ne_ii_rec_KSDN98.func'

_predefinedDataFileDict['PYNEB_18_01'] = deepcopy(_predefinedDataFileDict['PYNEB_17_02'])
_predefinedDataFileDict['PYNEB_18_01']['Te3'] = {'atom' : 'te_iii_atom_M18.dat',
                                                 'coll': 'te_iii_coll_M18.dat'}


_predefinedDataFileDict['PYNEB_20_01'] = deepcopy(_predefinedDataFileDict['PYNEB_18_01'])
_predefinedDataFileDict['PYNEB_20_01']['Kr6'] = {'atom': 'kr_vi_atom_S17.dat',
                                                 'coll': 'kr_vi_coll_S17.dat'}
_predefinedDataFileDict['PYNEB_20_01']['Se3'] = {'atom': 'se_iii_atom_S17.dat',
                                                 'coll': 'se_iii_coll_S17.dat'}
_predefinedDataFileDict['PYNEB_20_01']['Rb4'] = {'atom': 'rb_iv_atom_S16.dat',
                                                 'coll': 'rb_iv_coll_S16.dat'}
_predefinedDataFileDict['PYNEB_20_01']['Br5'] = {'atom': 'br_v_atom_M18.dat',
                                                 'coll': 'br_v_coll_M18.dat'}
_predefinedDataFileDict['PYNEB_20_01']['S3']['atom'] = 's_iii_atom_FFTI06.dat'
_predefinedDataFileDict['PYNEB_20_01']['O2']['atom'] = 'o_ii_atom_Z82-WFD96.dat'
_predefinedDataFileDict['PYNEB_20_01']['Ne4']['atom'] = 'ne_iv_atom_GFF84.dat'
_predefinedDataFileDict['PYNEB_20_01']['S2']['atom'] = 's_ii_atom_RGJ19.dat'
_predefinedDataFileDict['PYNEB_20_01']['Cl3']['atom'] = 'cl_iii_atom_RGJ19.dat'
_predefinedDataFileDict['PYNEB_20_01']['Ar4']['atom'] = 'ar_iv_atom_RGJ19.dat'

_predefinedDataFileDict['PYNEB_21_01'] = deepcopy(_predefinedDataFileDict['PYNEB_20_01'])
_predefinedDataFileDict['PYNEB_21_01']['C2']['rec'] = 'c_ii_rec_D00.func'


def airtovac(wave):
    """
Convert air wavelengths to vacuum wavelengths
Parameters
----------
wave: float, array
The wavelength in air [Angstrom]
Returns
-------
Wavelength: array
Wavelength in vacuum [Angstrom]
Notes
-----

.. note:: This function was ported from the IDL Astronomy User's Library.
:IDL - Documentation:
NAME:
AIRTOVAC
PURPOSE:
Convert air wavelengths to vacuum wavelengths
EXPLANATION:
Wavelengths are corrected for the index of refraction of air under
standard conditions. Wavelength values below 2000 A will not be
altered. Uses the IAU standard for conversion given in Morton
(1991 Ap.J. Suppl. 77, 119)
CALLING SEQUENCE:
AIRTOVAC, WAVE
INPUT/OUTPUT:
WAVE - Wavelength in Angstroms, scalar or vector
WAVE should be input as air wavelength(s), it will be
returned as vacuum wavelength(s). WAVE is always converted to
double precision upon return.
EXAMPLE:
If the air wavelength is W = 6056.125 (a Krypton line), then
AIRTOVAC, W yields an vacuum wavelength of W = 6057.8019
METHOD:
See Morton (Ap. J. Suppl. 77, 119) for the formula used
REVISION HISTORY
Written W. Landsman November 1991
Converted to IDL V5.0 W. Landsman September 1997
Adding option to apply only between pn.config.vactoair_low_wl and pn.config.vactoair_high_wl
    """
    wave_arr = np.asarray(wave)
    sigma2 = (1.e4/wave_arr)**2. #Convert to wavenumber squared
    
    # Compute conversion factor
    
    fact = 1. + 6.4328e-5 + 2.94981e-2/(146.-sigma2) + 2.5540e-4/(41.-sigma2)
    
    mask_ok = (wave_arr >= pn.config.vactoair_low_wl) & (wave_arr <= pn.config.vactoair_high_wl)
    fact = np.ones_like(wave_arr)
    fact[mask_ok] = 1. + 6.4328e-5 + 2.94981e-2/(146.-sigma2[mask_ok]) + 2.5540e-4/(41.-sigma2[mask_ok])
    
    wave_arr = wave_arr*fact #Convert Wavelength
    
    return wave_arr



def vactoair(wave):
    """
Convert vacuum wavelengths to air wavelengths

Parameters
----------
wave: float, array
The wavelength in vacuum [Angstrom]
Returns
-------
Wavelength: array,
Wavelength in air [Angstrom]
Notes
-----

.. note:: This function was ported from the IDL Astronomy User's Library.
:IDL - Documentation:

NAME:
VACTOAIR
PURPOSE:
Convert vacuum wavelengths to air wavelengths
EXPLANATION:
Corrects for the index of refraction of air under standard conditions.
Wavelength values below 2000 A will not be altered. Accurate to
about 0.005 A

CALLING SEQUENCE:
VACTOAIR, WAVE

INPUT/OUTPUT:
WAVE - Wavelength in Angstroms, scalar or vector
WAVE should be input as vacuum wavelength(s), it will be
returned as air wavelength(s). WAVE is always converted to
double precision

EXAMPLE:
If the vacuum wavelength is W = 2000, then

IDL> VACTOAIR, W

yields an air wavelength of W = 1999.353 Angstroms

METHOD:
An approximation to the 4th power of inverse wavenumber is used
See IUE Image Processing Manual Page 6-15.

REVISION HISTORY
Written, D. Lindler 1982
Documentation W. Landsman Feb. 1989
Converted to IDL V5.0 W. Landsman September 1997
    """
    wave_arr = np.asarray(wave)

    wave2 = wave_arr**2.
    mask_ok = (wave_arr >= pn.config.vactoair_low_wl) & (wave_arr <= pn.config.vactoair_high_wl)
    fact = np.ones_like(wave_arr)

    fact[mask_ok] = 1. + 2.735182e-4 + 131.4182/wave2[mask_ok]  + 2.76249e8/wave2[mask_ok] **2.
    
    # Convert wavelengths
    
    wave_arr = wave_arr/fact
    
    return wave_arr

