"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * (deprecated) This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[], then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends core_1.Construct {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        cdk.Annotations.of(this).addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * (deprecated) Obtain tables deployed in other each region.
     *
     * @deprecated
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
_a = JSII_RTTI_SYMBOL_1;
GlobalTable[_a] = { fqn: "@aws-cdk/aws-dynamodb-global.GlobalTable", version: "1.110.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWR5bmFtb2RiLWdsb2JhbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF3cy1keW5hbW9kYi1nbG9iYWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxrREFBa0Q7QUFDbEQscUNBQXFDO0FBQ3JDLHlFQUFvRTtBQUVwRSxpR0FBaUc7QUFDakcsOERBQThEO0FBQzlELHdDQUEwQzs7Ozs7O0FBWTFDLE1BQWEsV0FBWSxTQUFRLGdCQUFTOzs7O0lBV3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQU5uQjs7V0FFRztRQUNjLG9CQUFlLEdBQUcsSUFBSSxLQUFLLEVBQWtCLENBQUM7UUFLN0QsR0FBRyxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsVUFBVSxDQUFDLHdIQUF3SCxDQUFDLENBQUM7UUFFOUosSUFBSSxDQUFDLGVBQWUsR0FBRyxFQUFFLENBQUM7UUFFMUIsSUFBSSxLQUFLLENBQUMsTUFBTSxJQUFJLElBQUksSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLFFBQVEsQ0FBQyxjQUFjLENBQUMsa0JBQWtCLEVBQUU7WUFDdkYsTUFBTSxJQUFJLEtBQUssQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO1NBQ2pHO1FBRUQsNEVBQTRFO1FBQzVFLG9EQUFvRDtRQUNwRCxNQUFNLGtCQUFrQixHQUF3QjtZQUM5QyxHQUFHLEtBQUs7WUFDUixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsTUFBTSxFQUFFLFFBQVEsQ0FBQyxjQUFjLENBQUMsa0JBQWtCO1NBQ25ELENBQUM7UUFFRixJQUFJLENBQUMsNEJBQTRCLEdBQUcsSUFBSSxpREFBc0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxHQUFHLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXJHLE1BQU0sVUFBVSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLCtDQUErQztRQUMvQyx3SEFBd0g7UUFDeEgsS0FBSyxNQUFNLE1BQU0sSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2xDLE1BQU0sYUFBYSxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxHQUFHLEdBQUcsR0FBRyxNQUFNLEVBQUUsRUFBRSxHQUFHLEVBQUUsRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLFVBQVUsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDL0csTUFBTSxhQUFhLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxHQUFHLEVBQUUsZ0JBQWdCLE1BQU0sRUFBRSxFQUFFLGtCQUFrQixDQUFDLENBQUM7WUFDM0csSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7WUFFekMsZ0VBQWdFO1lBQ2hFLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDaEU7SUFDSCxDQUFDOzs7Ozs7SUFHRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzFDLENBQUM7O0FBaERILGtDQWlEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGR5bmFtb2RiIGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBHbG9iYWxUYWJsZUNvb3JkaW5hdG9yIH0gZnJvbSAnLi9nbG9iYWwtdGFibGUtY29vcmRpbmF0b3InO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR2xvYmFsVGFibGVQcm9wcyBleHRlbmRzIGNkay5TdGFja1Byb3BzLCBkeW5hbW9kYi5UYWJsZU9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGFibGVOYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlZ2lvbnM6IHN0cmluZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBHbG9iYWxUYWJsZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIC8qKlxuICAgKiBDcmVhdGVzIHRoZSBjbG91ZGZvcm1hdGlvbiBjdXN0b20gcmVzb3VyY2UgdGhhdCBsYXVuY2hlcyBhIGxhbWJkYSB0byB0aWUgaXQgYWxsIHRvZ2V0aGVyXG4gICAqL1xuICBwcml2YXRlIGxhbWJkYUdsb2JhbFRhYmxlQ29vcmRpbmF0b3I6IEdsb2JhbFRhYmxlQ29vcmRpbmF0b3I7XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgZHluYW1vREIgdGFibGVzIGFjcm9zcyByZWdpb25zIHRoYXQgd2lsbCBiZSBhYmxlIHRvIGJlIGdsb2JiZWQgdG9nZXRoZXIgaW50byBhIGdsb2JhbCB0YWJsZVxuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSBfcmVnaW9uYWxUYWJsZXMgPSBuZXcgQXJyYXk8ZHluYW1vZGIuVGFibGU+KCk7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdsb2JhbFRhYmxlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY2RrLkFubm90YXRpb25zLm9mKHRoaXMpLmFkZFdhcm5pbmcoJ1RoZSBAYXdzLWNkay9hd3MtZHluYW1vZGItZ2xvYmFsIG1vZHVsZSBoYXMgYmVlbiBkZXByZWNhdGVkIGluIGZhdm9yIG9mIEBhd3MtY2RrL2F3cy1keW5hbW9kYi5UYWJsZS5yZXBsaWNhdGlvblJlZ2lvbnMnKTtcblxuICAgIHRoaXMuX3JlZ2lvbmFsVGFibGVzID0gW107XG5cbiAgICBpZiAocHJvcHMuc3RyZWFtICE9IG51bGwgJiYgcHJvcHMuc3RyZWFtICE9PSBkeW5hbW9kYi5TdHJlYW1WaWV3VHlwZS5ORVdfQU5EX09MRF9JTUFHRVMpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignZHluYW1vUHJvcHMuc3RyZWFtIE1VU1QgYmUgc2V0IHRvIGR5bmFtb2RiLlN0cmVhbVZpZXdUeXBlLk5FV19BTkRfT0xEX0lNQUdFUycpO1xuICAgIH1cblxuICAgIC8vIG5lZWQgdG8gc2V0IHRoaXMgc3RyZWFtIHNwZWNpZmljYXRpb24sIG90aGVyd2lzZSBnbG9iYWwgdGFibGVzIGRvbid0IHdvcmtcbiAgICAvLyBBbmQgbm8gd2F5IHRvIHNldCBhIGRlZmF1bHQgdmFsdWUgaW4gYW4gaW50ZXJmYWNlXG4gICAgY29uc3QgcmVnaW9uYWxUYWJsZVByb3BzOiBkeW5hbW9kYi5UYWJsZVByb3BzID0ge1xuICAgICAgLi4ucHJvcHMsXG4gICAgICByZW1vdmFsUG9saWN5OiBwcm9wcy5yZW1vdmFsUG9saWN5LFxuICAgICAgc3RyZWFtOiBkeW5hbW9kYi5TdHJlYW1WaWV3VHlwZS5ORVdfQU5EX09MRF9JTUFHRVMsXG4gICAgfTtcblxuICAgIHRoaXMubGFtYmRhR2xvYmFsVGFibGVDb29yZGluYXRvciA9IG5ldyBHbG9iYWxUYWJsZUNvb3JkaW5hdG9yKHNjb3BlLCBpZCArICctQ3VzdG9tUmVzb3VyY2UnLCBwcm9wcyk7XG5cbiAgICBjb25zdCBzY29wZVN0YWNrID0gY2RrLlN0YWNrLm9mKHNjb3BlKTtcbiAgICAvLyBoZXJlIHdlIGxvb3AgdGhyb3VnaCB0aGUgY29uZmlndXJlZCByZWdpb25zLlxuICAgIC8vIGluIGVhY2ggcmVnaW9uIHdlJ2xsIGRlcGxveSBhIHNlcGFyYXRlIHN0YWNrIHdpdGggYSBEeW5hbW9EQiBUYWJsZSB3aXRoIGlkZW50aWNhbCBwcm9wZXJ0aWVzIGluIHRoZSBpbmRpdmlkdWFsIHN0YWNrc1xuICAgIGZvciAoY29uc3QgcmVnaW9uIG9mIHByb3BzLnJlZ2lvbnMpIHtcbiAgICAgIGNvbnN0IHJlZ2lvbmFsU3RhY2sgPSBuZXcgY2RrLlN0YWNrKHRoaXMsIGlkICsgJy0nICsgcmVnaW9uLCB7IGVudjogeyByZWdpb24sIGFjY291bnQ6IHNjb3BlU3RhY2suYWNjb3VudCB9IH0pO1xuICAgICAgY29uc3QgcmVnaW9uYWxUYWJsZSA9IG5ldyBkeW5hbW9kYi5UYWJsZShyZWdpb25hbFN0YWNrLCBgJHtpZH0tR2xvYmFsVGFibGUtJHtyZWdpb259YCwgcmVnaW9uYWxUYWJsZVByb3BzKTtcbiAgICAgIHRoaXMuX3JlZ2lvbmFsVGFibGVzLnB1c2gocmVnaW9uYWxUYWJsZSk7XG5cbiAgICAgIC8vIGRlcGxveSB0aGUgcmVnaW9uYWwgc3RhY2sgYmVmb3JlIHRoZSBMYW1iZGEgY29vcmRpbmF0b3Igc3RhY2tcbiAgICAgIHRoaXMubGFtYmRhR2xvYmFsVGFibGVDb29yZGluYXRvci5hZGREZXBlbmRlbmN5KHJlZ2lvbmFsU3RhY2spO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCByZWdpb25hbFRhYmxlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVnaW9uYWxUYWJsZXMubWFwKHggPT4geCk7XG4gIH1cbn1cbiJdfQ==