"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const datahub_generated_1 = require("./datahub.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return datahub_generated_1.RosTopic; } });
/**
 * A ROS resource type:  `ALIYUN::DATAHUB::Topic`
 */
class Topic extends ros.Resource {
    /**
     * Create a new `ALIYUN::DATAHUB::Topic`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTopic = new datahub_generated_1.RosTopic(this, id, {
            comment: props.comment,
            recordType: props.recordType,
            projectName: props.projectName,
            lifecycle: props.lifecycle ? props.lifecycle : 3,
            recordSchema: props.recordSchema,
            shardCount: props.shardCount ? props.shardCount : 1,
            topicName: props.topicName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrProjectName = rosTopic.attrProjectName;
        this.attrTopicName = rosTopic.attrTopicName;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0b3BpYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsMkRBQStDO0FBRTFCLDhGQUZaLDRCQUFRLE9BRWlCO0FBMkNsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBaUJuQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlCLEVBQUUsbUNBQTJDLElBQUk7UUFDNUcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFFBQVEsR0FBRyxJQUFJLDRCQUFRLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNyQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNoRCxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDbkQsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1NBQzdCLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxlQUFlLEdBQUcsUUFBUSxDQUFDLGVBQWUsQ0FBQztRQUNoRCxJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUM7SUFDaEQsQ0FBQztDQUNKO0FBeENELHNCQXdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc1RvcGljIH0gZnJvbSAnLi9kYXRhaHViLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1RvcGljIGFzIFRvcGljUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkRBVEFIVUI6OlRvcGljYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRvcGljUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY29tbWVudDogVGhlIGNvbW1lbnQgb2YgdG9waWMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tbWVudDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJvamVjdE5hbWU6IFRoZSBuYW1lIG9mIHRoZSBwcm9qZWN0LiBMZW5ndGggWzMsIDMyXS4gQmVnaW5uaW5nIHdpdGggY2hhcmFjdGVycywgb25seSBjaGFyYWN0ZXJzLCBudW1iZXJzIGFuZCBfIGFyZSBhbGxvd2VkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByb2plY3ROYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByZWNvcmRUeXBlOiBSZWNvcmQgdHlwZS4gVFVQTEU6IHN0cnVjdHVyZWQgZGF0YSwgQkxPQjogdW5zdHJ1Y3R1cmVkIGRhdGEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVjb3JkVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdG9waWNOYW1lOiBUaGUgbmFtZSBvZiB0aGUgdG9waWMuIExlbmd0aCBbMywgNjRdLiBCZWdpbm5pbmcgd2l0aCBjaGFyYWN0ZXJzLCBvbmx5IGNoYXJhY3RlcnMsIG51bWJlcnMgYW5kIF8gYXJlIGFsbG93ZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdG9waWNOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsaWZlY3ljbGU6IERhdGEgc3RvcmFnZSBsaWZlIGN5Y2xlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxpZmVjeWNsZT86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJlY29yZFNjaGVtYTogV2hlbiBjcmVhdGluZyBhIFRVUExFIHR5cGUgdG9waWMsIHlvdSBuZWVkIHRvIHNwZWNpZnkgdGhlIHNjaGVtYSwgYnV0IHRoZSBCTE9CIHR5cGUgZG9lcyBub3QgcGFzcyB0aGlzIHBhcmFtZXRlci5cbiAgICAgKi9cbiAgICByZWFkb25seSByZWNvcmRTY2hlbWE/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzaGFyZENvdW50OiBJbml0aWFsIHNoYXJkIG51bWJlci5cbiAgICAgKi9cbiAgICByZWFkb25seSBzaGFyZENvdW50PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpEQVRBSFVCOjpUb3BpY2BcbiAqL1xuZXhwb3J0IGNsYXNzIFRvcGljIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBQcm9qZWN0TmFtZTogUHJvamVjdCBuYW1lXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJQcm9qZWN0TmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFRvcGljTmFtZTogVG9waWMgbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVG9waWNOYW1lOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6REFUQUhVQjo6VG9waWNgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRvcGljUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zVG9waWMgPSBuZXcgUm9zVG9waWModGhpcywgaWQsICB7XG4gICAgICAgICAgICBjb21tZW50OiBwcm9wcy5jb21tZW50LFxuICAgICAgICAgICAgcmVjb3JkVHlwZTogcHJvcHMucmVjb3JkVHlwZSxcbiAgICAgICAgICAgIHByb2plY3ROYW1lOiBwcm9wcy5wcm9qZWN0TmFtZSxcbiAgICAgICAgICAgIGxpZmVjeWNsZTogcHJvcHMubGlmZWN5Y2xlID8gcHJvcHMubGlmZWN5Y2xlIDogMyxcbiAgICAgICAgICAgIHJlY29yZFNjaGVtYTogcHJvcHMucmVjb3JkU2NoZW1hLFxuICAgICAgICAgICAgc2hhcmRDb3VudDogcHJvcHMuc2hhcmRDb3VudCA/IHByb3BzLnNoYXJkQ291bnQgOiAxLFxuICAgICAgICAgICAgdG9waWNOYW1lOiBwcm9wcy50b3BpY05hbWUsXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zVG9waWM7XG4gICAgICAgIHRoaXMuYXR0clByb2plY3ROYW1lID0gcm9zVG9waWMuYXR0clByb2plY3ROYW1lO1xuICAgICAgICB0aGlzLmF0dHJUb3BpY05hbWUgPSByb3NUb3BpYy5hdHRyVG9waWNOYW1lO1xuICAgIH1cbn1cbiJdfQ==